/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.Serializable;

public class Address
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String addr_type;
    public String domain;
    public String bus;
    public String slot;
    public String function;
    public String port;

    public Address() {
    }

    public Address(String domain, String bus, String slot, String function) {
        this.addr_type = "pci";
        this.domain = domain;
        this.bus = bus;
        this.slot = slot;
        this.function = function;
    }

    public Address(String bus, String port) {
        this.addr_type = "usb";
        this.bus = bus;
        this.port = port;
    }

    public String getAddressXML() {
        if (this.addr_type == null) {
            return "";
        }
        StringBuilder xml = new StringBuilder();
        switch (this.addr_type) {
            case "pci": {
                xml.append("<address type='" + this.addr_type + "' domain='" + this.domain + "' bus='" + this.bus + "' slot='" + this.slot + "' function='" + this.function + "'/>");
                break;
            }
            case "usb": {
                xml.append("<address type='" + this.addr_type + "' bus='" + this.bus + "' slot='" + this.slot + "'/>");
            }
        }
        return xml.toString();
    }
}

