/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Button;
import javaforce.webui.Component;
import javaforce.webui.PopupPanel;
import javaforce.webui.Table;
import javaforce.webui.TextComponent;
import javaforce.webui.event.Click;
import javaforce.webui.event.MouseEvent;

public class KeyPad
extends PopupPanel
implements Click {
    private TextComponent field;
    private Table table;
    private static String[][] cols = new String[][]{{"<", "/", "*", "-"}, {"7", "8", "9", "+"}, {"4", "5", "6", null}, {"1", "2", "3", "Ent"}, {"0", null, ".", null}};

    public KeyPad(String title, int px) {
        super(title);
        this.table = new Table(px, px, 4, 5);
        this.setTitleBarSize(px);
        this.add(this.table);
        for (int col = 0; col < cols.length; ++col) {
            String[] rowchs = cols[col];
            block10: for (int row = 0; row < rowchs.length; ++row) {
                String key = rowchs[row];
                if (key == null) continue;
                Button b = new Button(rowchs[row]);
                b.addClickListener(this);
                switch (key) {
                    case "0": {
                        b.setSize(px * 2, px);
                        this.table.add(b, row, col, 2, 1);
                        continue block10;
                    }
                    case "Ent": 
                    case "+": {
                        b.setSize(px, px * 2);
                        this.table.add(b, row, col, 1, 2);
                        continue block10;
                    }
                    default: {
                        b.setSize(px, px);
                        this.table.add(b, row, col);
                    }
                }
            }
        }
    }

    public void show(TextComponent field) {
        this.field = field;
        field.requestPos();
        field.addMovedListener((comp, x, y) -> {
            this.setPosition(field.x, field.y + field.height);
            this.setVisible(true);
        });
    }

    @Override
    public void onClick(MouseEvent e, Component c) {
        Button b = (Button)c;
        String txt = b.getText();
        if (txt.equals("Ent")) {
            this.setVisible(false);
            return;
        }
        if (txt.equals("<")) {
            String oldtxt = this.field.getText();
            if (oldtxt.length() == 0) {
                return;
            }
            this.field.setText(oldtxt.substring(0, oldtxt.length() - 1));
            return;
        }
        String newtxt = this.field.getText() + txt;
        this.field.setText(newtxt);
    }
}

