/*
 * Decompiled with CFR 0.152.
 */
package javaforce.controls.ab;

import javaforce.LE;

public class CIP_Request {
    public byte cmd = (byte)82;
    public byte count = (byte)2;
    public byte path_1 = (byte)32;
    public byte class_1 = (byte)6;
    public byte path_2 = (byte)36;
    public byte class_2 = 1;
    public byte ticktime = (byte)7;
    public byte ticktimeout = (byte)-7;
    public short len;
    public byte service;
    public byte tag_size;
    public TagSegment[] segments;
    public byte[] tagdata;
    public byte route_size = 1;
    public byte route_res = 0;
    public byte route_seg = 1;
    public byte route_addr = 0;
    public static final byte SERVICE_READTAG = 76;
    public static final byte SERVICE_WRITETAG = 77;

    public int size() {
        int segs_len = 0;
        for (int a = 0; a < this.segments.length; ++a) {
            segs_len += this.segments[a].size();
        }
        int size = 12 + segs_len + this.tagdata.length + 4;
        return size;
    }

    public void write(byte[] data, int offset) throws Exception {
        data[offset++] = this.cmd;
        data[offset++] = this.count;
        data[offset++] = this.path_1;
        data[offset++] = this.class_1;
        data[offset++] = this.path_2;
        data[offset++] = this.class_2;
        data[offset++] = this.ticktime;
        data[offset++] = this.ticktimeout;
        LE.setuint16(data, offset, this.len);
        offset += 2;
        data[offset++] = this.service;
        data[offset++] = this.tag_size;
        for (int a = 0; a < this.segments.length; ++a) {
            this.segments[a].write(data, offset);
            offset += this.segments[a].size();
        }
        System.arraycopy(this.tagdata, 0, data, offset, this.tagdata.length);
        offset += this.tagdata.length;
        data[offset++] = this.route_size;
        data[offset++] = this.route_res;
        data[offset++] = this.route_seg;
        data[offset++] = this.route_addr;
    }

    private void decodeTag(String tag) {
        String[] segs = tag.split("[.]");
        int len = segs.length;
        for (int a = 0; a < segs.length; ++a) {
            String seg = segs[a];
            if (!seg.endsWith("]")) continue;
            int i1 = seg.indexOf(91);
            int i2 = seg.indexOf(93);
            String[] idxes = seg.substring(i1 + 1, i2).split("[,]");
            len += idxes.length;
        }
        this.segments = new TagSegment[len];
        int pos = 0;
        for (int a = 0; a < segs.length; ++a) {
            String seg = segs[a];
            if (seg.endsWith("]")) {
                int i1 = seg.indexOf(91);
                int i2 = seg.indexOf(93);
                String name = seg.substring(0, i1);
                this.segments[pos++] = new TagName(name);
                String[] idxes = seg.substring(i1 + 1, i2).split("[,]");
                for (int b = 0; b < idxes.length; ++b) {
                    int idx = Integer.valueOf(idxes[b]);
                    this.segments[pos++] = idx < 256 ? new TagElement8((byte)idx) : (idx < 65536 ? new TagElement16((short)idx) : new TagElement32(idx));
                }
                continue;
            }
            this.segments[pos++] = new TagName(seg);
        }
    }

    public void setRead(String tag) {
        this.service = (byte)76;
        this.decodeTag(tag);
        this.tagdata = new byte[]{1, 0};
        this.setLengths();
    }

    public void setWrite(String tag, byte type, byte[] data) {
        this.service = (byte)77;
        this.decodeTag(tag);
        this.tagdata = new byte[4 + data.length];
        this.tagdata[0] = type;
        this.tagdata[1] = 0;
        this.tagdata[2] = 1;
        this.tagdata[3] = 0;
        System.arraycopy(data, 0, this.tagdata, 4, data.length);
        this.setLengths();
    }

    private void setLengths() {
        int segs_len = 0;
        for (int a = 0; a < this.segments.length; ++a) {
            segs_len += this.segments[a].size();
        }
        this.len = (short)(2 + segs_len + this.tagdata.length);
        this.tag_size = (byte)(segs_len >> 1);
    }

    private static abstract class TagSegment {
        public byte type;

        public TagSegment(byte type) {
            this.type = type;
        }

        public abstract int size();

        public abstract void write(byte[] var1, int var2);
    }

    private static class TagName
    extends TagSegment {
        public byte len = 0;
        public byte[] chars;

        public TagName(String name) {
            super((byte)-111);
            this.len = (byte)name.length();
            this.chars = name.getBytes();
        }

        @Override
        public int size() {
            int len = 2 + this.chars.length;
            if (len % 2 != 0) {
                ++len;
            }
            return len;
        }

        @Override
        public void write(byte[] data, int offset) {
            data[offset++] = this.type;
            data[offset++] = this.len;
            for (int a = 0; a < this.chars.length; ++a) {
                data[offset++] = this.chars[a];
            }
        }
    }

    private static class TagElement8
    extends TagSegment {
        public byte idx;

        public TagElement8(byte idx) {
            super((byte)40);
            this.idx = idx;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public void write(byte[] data, int offset) {
            data[offset++] = this.type;
            data[offset++] = this.idx;
        }
    }

    private static class TagElement16
    extends TagSegment {
        public byte pad;
        public short idx;

        public TagElement16(short idx) {
            super((byte)41);
            this.idx = idx;
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public void write(byte[] data, int offset) {
            data[offset++] = this.type;
            data[offset++] = this.pad;
            LE.setuint16(data, offset, this.idx);
        }
    }

    private static class TagElement32
    extends TagSegment {
        public byte pad;
        public int idx;

        public TagElement32(int idx) {
            super((byte)41);
            this.idx = idx;
        }

        @Override
        public int size() {
            return 6;
        }

        @Override
        public void write(byte[] data, int offset) {
            data[offset++] = this.type;
            data[offset++] = this.pad;
            LE.setuint32(data, offset, this.idx);
        }
    }
}

