/*
 * Decompiled with CFR 0.152.
 */
package javaforce.pi;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.pi.GPIO;
import javaforce.pi.I2C;

public class ModbusServer
extends Thread {
    public static String version = "0.3";
    public ServerSocket ss;
    public static int port = 502;
    public static int[] outs = new int[40];
    public static boolean[] coils = new boolean[40];
    public static int[] ins = new int[40];
    public static boolean invert = false;
    public static ArrayList<I2C_I> i2cins = new ArrayList();
    public static ArrayList<I2C_O> i2couts = new ArrayList();
    public static Object i2cslaveaddrlock = new Object();
    private static final int CS8flag = 256;
    private static final int IOflag = 512;

    public static void main(String[] args) {
        new ModbusServer().start();
    }

    @Override
    public void run() {
        String[] lns;
        JFLog.log("jfModbusServer/" + version);
        try {
            FileInputStream fis = new FileInputStream("modbus.cfg");
            lns = new String(JF.readAll(fis)).replaceAll("\r", "").split("\n");
            fis.close();
        }
        catch (Exception e) {
            JFLog.log(e);
            return;
        }
        boolean has_gpio = false;
        boolean has_i2c = false;
        block80: for (int a = 0; a < lns.length; ++a) {
            IO io;
            String ln = lns[a].toLowerCase().replaceAll(" ", "");
            if (ln.startsWith("gpio:")) {
                has_gpio = true;
                String[] fs = ln.substring(5).split(":");
                io = IO.unknown;
                int addr = -1;
                int bit = -1;
                block81: for (int b = 0; b < fs.length; ++b) {
                    ln = fs[b];
                    int idx = ln.indexOf(61);
                    if (idx == -1) {
                        switch (ln) {
                            case "i": {
                                io = IO.input;
                                break;
                            }
                            case "o": {
                                io = IO.output;
                            }
                        }
                        continue;
                    }
                    String key = ln.substring(0, idx).trim();
                    String value = ln.substring(idx + 1).trim();
                    switch (key) {
                        case "bit": {
                            bit = Integer.valueOf(value);
                            continue block81;
                        }
                        case "addr": {
                            addr = Integer.valueOf(value);
                        }
                    }
                }
                if (io == IO.unknown) {
                    JFLog.log("Error:Invalid GPIO:I/O not specified");
                    System.exit(0);
                }
                if (bit == -1) {
                    JFLog.log("Error:Invalid GPIO:bit not specified");
                    System.exit(0);
                }
                if (addr == -1) {
                    JFLog.log("Error:Invalid GPIO:addr not specified");
                    System.exit(0);
                }
                switch (io) {
                    case input: {
                        ModbusServer.ins[addr] = bit + 1;
                        break;
                    }
                    case output: {
                        ModbusServer.outs[addr] = bit + 1;
                    }
                }
                continue;
            }
            if (ln.startsWith("i2c:")) {
                has_i2c = true;
                String[] fs = ln.substring(4).split(":");
                io = IO.unknown;
                Value type = null;
                int addr = -1;
                int slaveaddr = -1;
                int avginterval = -1;
                int avgsamples = -1;
                int[] readBytes = null;
                int[] writeBytes = null;
                block82: for (int b = 0; b < fs.length; ++b) {
                    ln = fs[b];
                    int idx = ln.indexOf(61);
                    if (idx == -1) {
                        switch (ln) {
                            case "i": {
                                io = IO.input;
                                break;
                            }
                            case "o": {
                                io = IO.output;
                            }
                        }
                        continue;
                    }
                    String key = ln.substring(0, idx).trim();
                    String value = ln.substring(idx + 1).trim();
                    switch (key) {
                        case "addr": {
                            addr = Integer.valueOf(value);
                            continue block82;
                        }
                        case "slaveaddr": {
                            slaveaddr = Integer.valueOf(value, 16);
                            continue block82;
                        }
                        case "avg": {
                            String[] vs = value.split(",");
                            if (vs.length != 2) {
                                JFLog.log("Error:I2C avg=requires samples,interval");
                                System.exit(0);
                            }
                            if ((avgsamples = Integer.valueOf(vs[0].trim()).intValue()) < 10) {
                                avgsamples = 10;
                            }
                            if ((avginterval = Integer.valueOf(vs[1].trim()).intValue()) >= 100) continue block82;
                            avginterval = 100;
                            continue block82;
                        }
                        case "read": {
                            readBytes = this.decodeBytes(value.split(","), io == IO.input);
                            continue block82;
                        }
                        case "write": {
                            writeBytes = this.decodeBytes(value.split(","), io == IO.output);
                            continue block82;
                        }
                        case "type": {
                            switch (value) {
                                case "int8": {
                                    type = new int8();
                                    continue block82;
                                }
                                case "int16": {
                                    type = new int16();
                                    continue block82;
                                }
                                case "int24": {
                                    type = new int32();
                                    continue block82;
                                }
                                case "int32": {
                                    type = new int32();
                                    continue block82;
                                }
                                case "int64": {
                                    type = new int64();
                                    continue block82;
                                }
                                case "float32": {
                                    type = new float32();
                                    continue block82;
                                }
                                case "float64": {
                                    type = new float64();
                                    continue block82;
                                }
                            }
                            JFLog.log("Error:I2C data type unknown:" + value);
                            System.exit(0);
                        }
                    }
                }
                if (io == IO.unknown) {
                    JFLog.log("Error:Invalid I2C:I/O not specified");
                    System.exit(0);
                }
                if (addr == -1) {
                    JFLog.log("Error:Invalid I2C:addr not specified");
                    System.exit(0);
                }
                if (slaveaddr == -1) {
                    JFLog.log("Error:Invalid I2C:slaveaddr not specified");
                    System.exit(0);
                }
                if (type == null) {
                    JFLog.log("Error:Invalid I2C:type not specified");
                    System.exit(0);
                }
                switch (io) {
                    case input: {
                        if (readBytes == null) {
                            JFLog.log("Error:Invalid I2C:read not specified");
                            System.exit(0);
                        }
                        I2C_I i = new I2C_I();
                        i.addr = addr;
                        i.slaveaddr = slaveaddr;
                        i.type = type;
                        i.typeSize = type.getSize();
                        i.writeBytes = writeBytes;
                        i.readBytes = readBytes;
                        if (avginterval != -1) {
                            i.avg = true;
                            i.avginterval = avginterval;
                            i.avgsamples = avgsamples;
                            i.samples = type.newArray(avgsamples);
                            i.avg_lock = new Object();
                            i.startTimer();
                        }
                        i2cins.add(i);
                        break;
                    }
                    case output: {
                        if (writeBytes == null) {
                            JFLog.log("Error:Invalid I2C:write not specified");
                            System.exit(0);
                        }
                        I2C_O o = new I2C_O();
                        o.addr = addr;
                        o.slaveaddr = slaveaddr;
                        o.type = type;
                        o.typeSize = type.getSize();
                        o.readBytes = readBytes;
                        o.writeBytes = writeBytes;
                        i2couts.add(o);
                    }
                }
                continue;
            }
            int idx = ln.indexOf(61);
            if (idx == -1) continue;
            String key = ln.substring(0, idx).trim();
            String value = ln.substring(idx + 1).trim();
            switch (key) {
                case "port": {
                    port = Integer.valueOf(value);
                    continue block80;
                }
                case "invert": {
                    invert = Boolean.valueOf(value);
                }
            }
        }
        if (has_gpio && !GPIO.init()) {
            JFLog.log("Failed to init GPIO library");
            return;
        }
        if (has_i2c && !I2C.init()) {
            JFLog.log("Failed to init I2C library");
            return;
        }
        if (has_gpio) {
            for (int pos = 0; pos < 40; ++pos) {
                if (ins[pos] != 0) {
                    GPIO.configInput(ins[pos]);
                }
                if (outs[pos] == 0) continue;
                GPIO.configOutput(outs[pos]);
            }
        }
        try {
            this.ss = new ServerSocket(port);
        }
        catch (Exception e) {
            JFLog.log(e);
            return;
        }
        while (true) {
            try {
                while (true) {
                    Socket s = this.ss.accept();
                    Client c = new Client();
                    c.s = s;
                    c.start();
                }
            }
            catch (Exception e) {
                JFLog.log(e);
                continue;
            }
            break;
        }
    }

    public int[] decodeBytes(String[] fs, boolean allowIO) {
        int[] ret = new int[fs.length];
        block4: for (int a = 0; a < fs.length; ++a) {
            String f = fs[a].trim();
            if (f.equals("cs8")) {
                ret[a] = 256;
                continue;
            }
            switch (f.charAt(0)) {
                case 'i': {
                    if (!allowIO) {
                        JFLog.log("Error:bad I2C");
                        System.exit(0);
                    }
                    ret[a] = 0x200 | Integer.valueOf(f.substring(1));
                    continue block4;
                }
                case 'o': {
                    if (!allowIO) {
                        JFLog.log("Error:bad I2C");
                        System.exit(0);
                    }
                    ret[a] = 0x200 | Integer.valueOf(f.substring(1));
                    continue block4;
                }
                default: {
                    ret[a] = Integer.valueOf(f, 16) & 0xFF;
                }
            }
        }
        return ret;
    }

    public static byte checksum8(byte[] data, int start, int end) {
        byte ret = 0;
        for (int a = start; a <= end; ++a) {
            ret = (byte)(ret + data[a]);
        }
        return ret;
    }

    public static void printArray(String msg, byte[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        for (int a = 0; a < array.length; ++a) {
            if (a > 0) {
                sb.append(",");
            }
            sb.append(String.format("%02d", array[a]));
        }
        System.out.println(sb);
    }

    public static enum IO {
        input,
        output,
        unknown;

    }

    public static class int8
    extends Value {
        private byte value;

        @Override
        public void set(byte[] data) {
            this.value = data[0];
        }

        @Override
        public void add(Value o) {
            this.value = (byte)(this.value + ((int8)o).value);
        }

        @Override
        public void div(int divsor) {
            this.value = (byte)(this.value / divsor);
        }

        @Override
        public byte[] getBytes() {
            byte[] bytes = new byte[]{this.value};
            return bytes;
        }

        @Override
        public Value newInstance() {
            return new int8();
        }

        @Override
        public int getSize() {
            return 1;
        }
    }

    public static class int16
    extends Value {
        private short value;

        @Override
        public void set(byte[] data) {
            this.value = (short)BE.getuint16(data, 0);
        }

        @Override
        public void add(Value o) {
            this.value = (short)(this.value + ((int16)o).value);
        }

        @Override
        public void div(int divsor) {
            this.value = (short)(this.value / divsor);
        }

        @Override
        public byte[] getBytes() {
            byte[] bytes = new byte[2];
            BE.setuint16(bytes, 0, this.value);
            return bytes;
        }

        @Override
        public Value newInstance() {
            return new int16();
        }

        @Override
        public int getSize() {
            return 2;
        }
    }

    public static class int32
    extends Value {
        private int value;

        @Override
        public void set(byte[] data) {
            this.value = BE.getuint32(data, 0);
        }

        @Override
        public void add(Value o) {
            this.value += ((int32)o).value;
        }

        @Override
        public void div(int divsor) {
            this.value /= divsor;
        }

        @Override
        public byte[] getBytes() {
            byte[] bytes = new byte[4];
            BE.setuint32(bytes, 0, this.value);
            return bytes;
        }

        @Override
        public Value newInstance() {
            return new int32();
        }

        @Override
        public int getSize() {
            return 4;
        }
    }

    public static class int64
    extends Value {
        private long value;

        @Override
        public void set(byte[] data) {
            this.value = BE.getuint64(data, 0);
        }

        @Override
        public void add(Value o) {
            this.value += ((int64)o).value;
        }

        @Override
        public void div(int divsor) {
            this.value /= (long)divsor;
        }

        @Override
        public byte[] getBytes() {
            byte[] bytes = new byte[8];
            BE.setuint64(bytes, 0, this.value);
            return bytes;
        }

        @Override
        public Value newInstance() {
            return new int64();
        }

        @Override
        public int getSize() {
            return 8;
        }
    }

    public static class float32
    extends Value {
        private float value;

        @Override
        public void set(byte[] data) {
            this.value = Float.intBitsToFloat(BE.getuint32(data, 0));
        }

        @Override
        public void add(Value o) {
            this.value += ((float32)o).value;
        }

        @Override
        public void div(int divsor) {
            this.value /= (float)divsor;
        }

        @Override
        public byte[] getBytes() {
            byte[] bytes = new byte[4];
            BE.setuint32(bytes, 0, Float.floatToIntBits(this.value));
            return bytes;
        }

        @Override
        public Value newInstance() {
            return new float32();
        }

        @Override
        public int getSize() {
            return 4;
        }
    }

    public static class float64
    extends Value {
        private double value;

        @Override
        public void set(byte[] data) {
            this.value = Double.longBitsToDouble(BE.getuint64(data, 0));
        }

        @Override
        public void add(Value o) {
            this.value += ((float64)o).value;
        }

        @Override
        public void div(int divsor) {
            this.value /= (double)divsor;
        }

        @Override
        public byte[] getBytes() {
            byte[] bytes = new byte[8];
            BE.setuint64(bytes, 0, Double.doubleToLongBits(this.value));
            return bytes;
        }

        @Override
        public Value newInstance() {
            return new float64();
        }

        @Override
        public int getSize() {
            return 8;
        }
    }

    public static class I2C_I
    extends TimerTask {
        public int addr;
        public int slaveaddr;
        public Value type;
        public int typeSize;
        public int[] writeBytes;
        public int[] readBytes;
        public boolean avg;
        public int avginterval;
        public int avgsamples;
        public Value[] samples;
        public Object avg_lock;
        private Timer timer;

        public void startTimer() {
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate((TimerTask)this, this.avginterval, (long)this.avginterval);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Value value;
            Object object = i2cslaveaddrlock;
            synchronized (object) {
                I2C.setSlave(this.slaveaddr);
                if (this.writeBytes != null) {
                    this.write();
                }
                value = this.read();
            }
            object = this.avg_lock;
            synchronized (object) {
                System.arraycopy(this.samples, 1, this.samples, 0, this.avgsamples - 1);
                this.samples[this.avgsamples - 1] = value;
            }
        }

        private void write() {
            byte[] data = new byte[this.writeBytes.length];
            for (int a = 0; a < this.writeBytes.length; ++a) {
                if (this.writeBytes[a] > 255) {
                    if (this.writeBytes[a] != 256) continue;
                    data[a] = ModbusServer.checksum8(data, 0, a - 1);
                    continue;
                }
                data[a] = (byte)(this.writeBytes[a] & 0xFF);
            }
            I2C.write(data);
        }

        private Value read() {
            byte[] data = new byte[this.readBytes.length];
            I2C.read(data);
            Value value = this.type.newInstance();
            byte[] vs = new byte[value.getSize()];
            for (int a = 0; a < this.readBytes.length; ++a) {
                if ((this.readBytes[a] & 0x200) != 512) continue;
                vs[this.readBytes[a] & 0xFF] = data[a];
            }
            value.set(vs);
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void read(byte[] data, int start_addr, int offset) {
            int a;
            Object object;
            Value value;
            if (this.avg) {
                value = this.type.newInstance();
                object = this.avg_lock;
                synchronized (object) {
                    for (a = 0; a < this.avgsamples; ++a) {
                        value.add(this.samples[a]);
                    }
                    value.div(this.avgsamples);
                }
            }
            object = i2cslaveaddrlock;
            synchronized (object) {
                I2C.setSlave(this.slaveaddr);
                if (this.writeBytes != null) {
                    this.write();
                }
                value = this.read();
            }
            byte[] vb = value.getBytes();
            for (a = 0; a < this.typeSize; ++a) {
                data[(this.addr - start_addr) * 2 + a + offset] = vb[a];
            }
        }
    }

    public static abstract class Value {
        public abstract void set(byte[] var1);

        public abstract void add(Value var1);

        public abstract void div(int var1);

        public abstract byte[] getBytes();

        public abstract Value newInstance();

        public abstract int getSize();

        public Value[] newArray(int size) {
            Value[] ret = new Value[size];
            for (int a = 0; a < size; ++a) {
                ret[a] = this.newInstance();
            }
            return ret;
        }
    }

    public static class I2C_O {
        public int addr;
        public int slaveaddr;
        public Value type;
        public int typeSize;
        public int[] readBytes;
        public int[] writeBytes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] values, int start_idx, int start_offset) {
            byte[] data = new byte[this.writeBytes.length];
            for (int a = 0; a < this.writeBytes.length; ++a) {
                if (this.writeBytes[a] > 255) {
                    if (this.writeBytes[a] == 256) {
                        data[a] = ModbusServer.checksum8(data, 0, a - 1);
                        continue;
                    }
                    data[a] = values[start_offset + ((this.addr - start_idx) * 2 + (this.writeBytes[a] & 0xFF))];
                    continue;
                }
                data[a] = (byte)(this.writeBytes[a] & 0xFF);
            }
            Object object = i2cslaveaddrlock;
            synchronized (object) {
                I2C.setSlave(this.slaveaddr);
                I2C.write(data);
            }
        }
    }

    public static class Client
    extends Thread {
        public Socket s;
        public InputStream is;
        public OutputStream os;
        public byte[] data = new byte[1500];
        public int length;

        @Override
        public void run() {
            try {
                this.is = this.s.getInputStream();
                this.os = this.s.getOutputStream();
                while (this.s.isConnected()) {
                    int pos = 0;
                    while (pos != 6) {
                        int read = this.is.read(this.data, pos, 6 - pos);
                        if (read <= 0) continue;
                        pos += read;
                    }
                    this.getLength();
                    int toRead = this.length + 6;
                    while (pos != toRead) {
                        int read = this.is.read(this.data, pos, toRead - pos);
                        if (read <= 0) continue;
                        pos += read;
                    }
                    byte func = this.data[7];
                    switch (func) {
                        case 1: {
                            this.readCoils();
                            break;
                        }
                        case 2: {
                            this.readDiscreteInputs();
                            break;
                        }
                        case 3: {
                            this.readMultipleRegisters();
                            break;
                        }
                        case 4: {
                            this.readMultipleRegisters();
                            break;
                        }
                        case 5: {
                            this.writeCoilSingle();
                            break;
                        }
                        case 6: {
                            this.writeSingleRegister();
                            break;
                        }
                        case 15: {
                            this.writeCoilMulti();
                            break;
                        }
                        case 16: {
                            this.writeMultipleRegisters();
                            break;
                        }
                        default: {
                            JFLog.log("Unsupported func:" + func);
                            this.data[7] = (byte)(this.data[7] | 0x80);
                            this.data[8] = 1;
                            this.setLength(1);
                        }
                    }
                    this.reply();
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void getLength() {
            this.length = BE.getuint16(this.data, 4);
        }

        public void setLength(int length) {
            this.length = length;
            BE.setuint16(this.data, 4, 2 + length);
        }

        public void reply() {
            try {
                this.os.write(this.data, 0, 8 + this.length);
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void readCoils() {
            int coil_idx = BE.getuint16(this.data, 8);
            int num_coils = BE.getuint16(this.data, 10);
            int num_bytes = num_coils + 7 >> 3;
            this.setLength(1 + num_bytes);
            this.data[8] = (byte)num_bytes;
            int bytePos = 9;
            int bitPos = 1;
            this.data[bytePos] = 0;
            for (int cnt = 0; cnt < num_coils; ++cnt) {
                if (bitPos == 256) {
                    bitPos = 1;
                    this.data[++bytePos] = 0;
                }
                if (coils[coil_idx++]) {
                    int n = bytePos;
                    this.data[n] = (byte)(this.data[n] | bitPos);
                }
                bitPos <<= 1;
            }
        }

        public void readDiscreteInputs() {
            int coil_idx = BE.getuint16(this.data, 8);
            int num_coils = BE.getuint16(this.data, 10);
            int num_bytes = num_coils + 7 >> 3;
            this.setLength(1 + num_bytes);
            this.data[8] = (byte)num_bytes;
            int bytePos = 9;
            int bitPos = 1;
            this.data[bytePos] = 0;
            for (int cnt = 0; cnt < num_coils; ++cnt) {
                if (bitPos == 256) {
                    bitPos = 1;
                    this.data[++bytePos] = 0;
                }
                if (GPIO.read(ins[coil_idx++])) {
                    int n = bytePos;
                    this.data[n] = (byte)(this.data[n] | bitPos);
                }
                bitPos <<= 1;
            }
        }

        public void writeCoilSingle() {
            boolean state;
            int coil = BE.getuint16(this.data, 8);
            boolean bl = state = BE.getuint16(this.data, 10) == 65280;
            if (invert) {
                state = !state;
            }
            GPIO.write(outs[coil], state);
            ModbusServer.coils[coil] = state;
        }

        public void writeCoilMulti() {
            int coil_idx = BE.getuint16(this.data, 8);
            int num_coils = BE.getuint16(this.data, 10);
            byte num_bytes = this.data[12];
            int bytePos = 13;
            int bitPos = 1;
            for (int cnt = 0; cnt < num_coils; ++cnt) {
                boolean state;
                if (bitPos == 256) {
                    bitPos = 1;
                    ++bytePos;
                }
                boolean bl = state = (this.data[bytePos] & bitPos) != 0;
                if (invert) {
                    state = !state;
                }
                GPIO.write(outs[coil_idx], state);
                ModbusServer.coils[coil_idx] = state;
                ++coil_idx;
                bitPos <<= 1;
            }
            this.setLength(4);
        }

        public void readMultipleRegisters() {
            int a;
            int start_idx = BE.getuint16(this.data, 8);
            int num_registers = BE.getuint16(this.data, 10);
            int end_idx = start_idx + num_registers - 1;
            for (a = 0; a < num_registers * 2; ++a) {
                this.data[9 + a] = 0;
            }
            for (a = 0; a < i2cins.size(); ++a) {
                I2C_I i = i2cins.get(a);
                if (i.addr < start_idx || i.addr > end_idx) continue;
                i.read(this.data, start_idx, 9);
            }
            this.data[8] = (byte)(num_registers * 2);
            this.setLength(1 + num_registers * 2);
        }

        public void writeSingleRegister() {
            int start_idx;
            int end_idx = start_idx = BE.getuint16(this.data, 8);
            for (int a = 0; a < i2couts.size(); ++a) {
                I2C_O o = i2couts.get(a);
                if (o.addr < start_idx || o.addr > end_idx) continue;
                o.write(this.data, start_idx, 10);
            }
        }

        public void writeMultipleRegisters() {
            int start_idx = BE.getuint16(this.data, 8);
            int num_registers = BE.getuint16(this.data, 10);
            int end_idx = start_idx + num_registers - 1;
            for (int a = 0; a < i2couts.size(); ++a) {
                I2C_O o = i2couts.get(a);
                if (o.addr < start_idx || o.addr > end_idx) continue;
                o.write(this.data, start_idx, 13);
            }
            this.setLength(4);
        }
    }

    public static class Packet {
        public short id;
        public short res;
        public short length;
        public byte unit;
        public byte func;
    }
}

