/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Block;
import javaforce.webui.Panel;
import javaforce.webui.TitleBar;
import javaforce.webui.WebUIClient;

public class PopupPanel
extends Panel {
    private TitleBar titleBar;
    private Block block;
    private boolean modal;

    public PopupPanel(String title) {
        this.initInvisible();
        this.titleBar = new TitleBar(title, this);
        this.add(this.titleBar);
        this.setClass("popuppanel");
        super.setVisible(false);
        this.modal = false;
        this.block = new Block();
        this.block.setClass("modal");
        this.block.initInvisible();
        this.setPosition(0, 0);
    }

    public void setModal(boolean state) {
        this.modal = state;
    }

    public void setOnClose(Runnable onClose) {
        this.titleBar.setOnClose(onClose);
    }

    @Override
    public String html() {
        StringBuilder sb = new StringBuilder();
        if (this.modal) {
            sb.append(this.block.html());
        }
        sb.append("<div" + this.getAttrs() + "'>");
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            sb.append(this.get(a).html());
        }
        sb.append("</div>");
        return sb.toString();
    }

    @Override
    public void setVisible(boolean state) {
        if (this.modal) {
            if (state) {
                this.client.sendEvent(this.block.id, "setzindex", new String[]{"idx=" + this.getClient().getZIndex()});
            } else {
                this.getClient().releaseZIndex();
            }
            this.block.setVisible(state);
        }
        if (state) {
            this.sendEvent("setzindex", new String[]{"idx=" + this.getClient().getZIndex()});
        } else {
            this.getClient().releaseZIndex();
        }
        super.setVisible(state);
    }

    @Override
    public void setClient(WebUIClient client) {
        super.setClient(client);
        this.titleBar.setClient(client);
        this.block.setClient(client);
    }

    public void setTitleBarSize(int sz) {
        this.titleBar.setHeight(sz);
    }

    public void setTitle(String title) {
        this.titleBar.setText(title);
    }
}

