/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.Random;
import javaforce.Base64;
import javaforce.HMACT64;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.LE;
import javaforce.MD4;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class SMTP {
    private Socket s;
    private InputStream is;
    private OutputStream os;
    private BufferedReader br;
    private String host;
    private boolean log = false;
    private ArrayList<String> headers = new ArrayList();
    public boolean debug = false;
    public String[] response;
    public static final int PORT = 25;
    public static final int TLSPORT = 587;
    public static final int SSLPORT = 465;
    public static final String AUTH_LOGIN = "LOGIN";
    public static final String AUTH_NTLM = "NTLM";
    private static final String boundary_mixed = "javaforce_smtp__boundary_mixed";
    private static final String boundary_alt = "javaforce_smtp__boundary_alt";
    private static final int NTLMSSP_NEGOTIATE_UNICODE = 1;
    private static final int NTLMSSP_NEGOTIATE_OEM = 2;
    private static final int NTLMSSP_REQUEST_TARGET = 4;
    private static final int NTLMSSP_NEGOTIATE_SIGN = 16;
    private static final int NTLMSSP_NEGOTIATE_SEAL = 32;
    private static final int NTLMSSP_NEGOTIATE_DATAGRAM = 64;
    private static final int NTLMSSP_NEGOTIATE_LM_KEY = 128;
    private static final int NTLMSSP_NEGOTIATE_NTLM = 512;
    private static final int NTLMSSP_NEGOTIATE_OEM_DOMAIN_SUPPLIED = 4096;
    private static final int NTLMSSP_NEGOTIATE_OEM_WORKSTATION_SUPPLIED = 8192;
    private static final int NTLMSSP_NEGOTIATE_ALWAYS_SIGN = 32768;
    private static final int NTLMSSP_TARGET_TYPE_DOMAIN = 65536;
    private static final int NTLMSSP_TARGET_TYPE_SERVER = 131072;
    private static final int NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY = 524288;
    private static final int NTLMSSP_NEGOTIATE_IDENTIFY = 0x100000;
    private static final int NTLMSSP_REQUEST_NON_NT_SESSION_KEY = 0x400000;
    private static final int NTLMSSP_NEGOTIATE_TARGET_INFO = 0x800000;
    private static final int NTLMSSP_NEGOTIATE_VERSION = 0x2000000;
    private static final int NTLMSSP_NEGOTIATE_128 = 0x20000000;
    private static final int NTLMSSP_NEGOTIATE_KEY_EXCH = 0x40000000;
    private static final int NTLMSSP_NEGOTIATE_56 = Integer.MIN_VALUE;
    private static final byte RESPONSERVERSION = 1;
    private static final byte HIRESPONSERVERSION = 1;
    private static final byte[] Z6 = new byte[]{0, 0, 0, 0, 0, 0};
    private static final byte[] Z4 = new byte[]{0, 0, 0, 0};
    private static char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public boolean connect(String host, int port) throws Exception {
        this.s = new Socket(host, port);
        this.is = this.s.getInputStream();
        this.br = new BufferedReader(new InputStreamReader(this.is));
        this.os = this.s.getOutputStream();
        this.host = host;
        this.getResponse();
        if (this.response[this.response.length - 1].startsWith("220")) {
            return true;
        }
        this.disconnect();
        return false;
    }

    public boolean connectSSL(String host, int port) throws Exception {
        this.s = JF.connectSSL(host, port, KeyMgmt.getDefaultClient());
        this.is = this.s.getInputStream();
        this.br = new BufferedReader(new InputStreamReader(this.is));
        this.os = this.s.getOutputStream();
        this.host = host;
        this.getResponse();
        if (this.response[this.response.length - 1].startsWith("220")) {
            return true;
        }
        this.disconnect();
        return false;
    }

    public void disconnect() throws Exception {
        if (this.s != null) {
            this.s.close();
        }
        this.s = null;
        this.is = null;
        this.os = null;
        this.headers.clear();
    }

    public void setLogging(boolean state) {
        this.log = state;
    }

    public boolean login() throws Exception {
        this.cmd("HELO " + this.host);
        this.getResponse();
        return this.response[this.response.length - 1].startsWith("250");
    }

    public boolean auth(String user, String pass, String type) throws Exception {
        switch (type) {
            case "LOGIN": {
                this.cmd("AUTH LOGIN");
                break;
            }
            case "NTLM": {
                this.cmd("AUTH NTLM");
                break;
            }
            default: {
                JFLog.log("SMTP:Unknown auth type:" + type);
            }
        }
        this.getResponse();
        if (this.response[this.response.length - 1].startsWith("504")) {
            if (this.log) {
                JFLog.log("AUTH " + type + " not supported!");
            }
            return false;
        }
        if (!this.response[this.response.length - 1].startsWith("334")) {
            return false;
        }
        this.cmd(SMTP.encodeFirst(user, pass, type, this.response[this.response.length - 1].substring(4)));
        this.getResponse();
        if (!this.response[this.response.length - 1].startsWith("334")) {
            return false;
        }
        this.cmd(SMTP.encodeSecond(user, pass, type, this.response[this.response.length - 1].substring(4)));
        this.getResponse();
        return this.response[this.response.length - 1].startsWith("235");
    }

    public boolean auth(String user, String pass) throws Exception {
        return this.auth(user, pass, AUTH_LOGIN);
    }

    public void logout() throws Exception {
        this.cmd("quit");
        this.getResponse();
    }

    public void cmd(String cmd) throws Exception {
        if (this.s == null || this.s.isClosed()) {
            throw new Exception("not connected");
        }
        if (this.log) {
            if (((String)cmd).startsWith("pass ")) {
                JFLog.log("pass ****");
            } else {
                JFLog.log((String)cmd);
            }
        }
        cmd = (String)cmd + "\r\n";
        this.os.write(((String)cmd).getBytes());
    }

    public void starttls() throws Exception {
        this.cmd("STARTTLS");
        this.getResponse();
        if (!this.response[this.response.length - 1].startsWith("220")) {
            throw new Exception("STARTTLS failed!");
        }
        this.s = JF.connectSSL(this.s, KeyMgmt.getDefaultClient());
        this.is = this.s.getInputStream();
        this.os = this.s.getOutputStream();
    }

    public void from(String email) throws Exception {
        this.cmd("MAIL FROM:<" + email + ">");
        this.getResponse();
        this.headers.add("From: <" + email + ">\r\n");
    }

    public void to(String email) throws Exception {
        this.cmd("RCPT TO:<" + email + ">");
        this.getResponse();
        this.headers.add("To: <" + email + ">\r\n");
    }

    public void cc(String email) throws Exception {
        this.cmd("RCPT TO:<" + email + ">");
        this.getResponse();
        this.headers.add("To: <" + email + ">\r\n");
    }

    public void bcc(String email) throws Exception {
        this.cmd("RCPT TO:<" + email + ">");
        this.getResponse();
    }

    public boolean data(String msg) throws Exception {
        this.cmd("DATA");
        this.getResponse();
        if (!this.response[this.response.length - 1].startsWith("354")) {
            return false;
        }
        this.os.write(msg.getBytes());
        this.os.write("\r\n.\r\n".getBytes());
        this.getResponse();
        return this.response[this.response.length - 1].startsWith("250");
    }

    public void subject(String subject) {
        this.headers.add("Subject: " + subject + "\r\n");
    }

    public void setContentType(String type) {
        this.headers.add("Content-Type: " + type + "\r\n");
    }

    public void addDate(Calendar date) {
        this.headers.add("Date: " + date.toString() + "\r\n");
    }

    public void addHeader(String name, String value) {
        this.headers.add(name + ": " + value + "\r\n");
    }

    public boolean data(String body_text, String body_html, Attachment[] attachments) throws Exception {
        StringBuilder full = new StringBuilder();
        boolean has_attachments = attachments != null && attachments.length > 0;
        for (String header : this.headers) {
            full.append(header);
        }
        full.append("MIME-Version: 1.0\r\n");
        full.append("Content-Type: multipart/mixed; boundary=javaforce_smtp__boundary_mixed\r\n");
        full.append("\r\n");
        full.append("This is a multipart MIME message");
        full.append("\r\n");
        full.append("--javaforce_smtp__boundary_mixed\r\n");
        full.append("Content-Type: multipart/alternative; boundary=javaforce_smtp__boundary_alt\r\n");
        full.append("\r\n");
        if (body_text != null) {
            full.append("--javaforce_smtp__boundary_alt\r\n");
            full.append("Content-Type: text/plain\r\n");
            full.append("Content-Length: " + body_text.length() + "\r\n");
            full.append("\r\n");
            full.append(body_text);
            full.append("\r\n");
        }
        if (body_html != null) {
            full.append("--javaforce_smtp__boundary_alt\r\n");
            full.append("Content-Type: text/html\r\n");
            full.append("Content-Length: " + body_html.length() + "\r\n");
            full.append("\r\n");
            full.append(body_html);
            full.append("\r\n");
        }
        full.append("--javaforce_smtp__boundary_alt--\r\n");
        full.append("\r\n");
        if (has_attachments) {
            for (Attachment attach : attachments) {
                full.append("--javaforce_smtp__boundary_mixed\r\n");
                full.append("Content-Type: application/octet-stream\r\n");
                full.append("Content-Transfer-Encoding: base64\r\n");
                full.append("Content-Disposition: attachment; filename=\"" + SMTP.fileName(attach.name) + "\";\r\n");
                full.append("Content-Length: " + attach.data.length + "\r\n");
                full.append("\r\n");
                Base64 encoder = new Base64();
                byte[] b64 = Base64.encode(attach.data);
                String s64 = new String(b64, "UTF-8");
                full.append(s64);
                full.append("\r\n");
            }
        }
        full.append("--javaforce_smtp__boundary_mixed--\r\n");
        this.cmd("DATA");
        this.getResponse();
        if (!this.response[this.response.length - 1].startsWith("354")) {
            return false;
        }
        this.os.write(full.toString().getBytes());
        this.os.write("\r\n.\r\n".getBytes());
        this.getResponse();
        return this.response[this.response.length - 1].startsWith("250");
    }

    private void getResponse() throws Exception {
        ArrayList<String> tmp = new ArrayList<String>();
        while (!this.s.isClosed()) {
            String str = this.br.readLine();
            tmp.add(str);
            if (str.charAt(3) != ' ') continue;
        }
        int size = tmp.size();
        this.response = new String[size];
        for (int a = 0; a < size; ++a) {
            this.response[a] = (String)tmp.get(a);
            if (!this.debug) continue;
            System.out.println(this.response[a]);
        }
    }

    public String getLastResponse() {
        if (this.response == null) {
            return null;
        }
        return this.response[this.response.length - 1];
    }

    private static String extractEmail(String in) {
        int i1 = in.indexOf(60);
        int i2 = in.indexOf(62);
        return in.substring(i1 + 1, i2);
    }

    private static String fileName(String full) {
        int idx = full.lastIndexOf(47);
        if (idx != -1) {
            return full.substring(idx + 1);
        }
        idx = full.lastIndexOf(92);
        if (idx != -1) {
            return full.substring(idx + 1);
        }
        return full;
    }

    private static void usage() {
        System.out.println("Usage:SMTP --server=host[:port] --text=file --html=file --from=email --to=email --cc=email --bcc=email --subject=desc [--user=user] [--pass=pass] [--auth=type] [--file=filename]");
        System.out.println("  to,cc,bcc,file options can be repeated");
        System.out.println("  type=LOGIN(default) NTLM");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            SMTP.usage();
            return;
        }
        SMTP smtp = new SMTP();
        try {
            int idx;
            smtp.setLogging(true);
            smtp.debug = true;
            int port = 25;
            String host = null;
            String body_text_file = null;
            String body_html_file = null;
            String from = null;
            ArrayList<String> tos = new ArrayList<String>();
            ArrayList<String> ccs = new ArrayList<String>();
            ArrayList<String> bccs = new ArrayList<String>();
            String subject = null;
            String user = null;
            String pass = null;
            String auth = AUTH_LOGIN;
            ArrayList<String> files = new ArrayList<String>();
            block38: for (String arg : args) {
                int idx2;
                if (!arg.startsWith("--") || (idx2 = arg.indexOf("=")) == -1) continue;
                String key = arg.substring(2, idx2);
                String value = arg.substring(idx2 + 1);
                switch (key) {
                    case "server": {
                        host = value;
                        continue block38;
                    }
                    case "text": {
                        body_text_file = value;
                        continue block38;
                    }
                    case "html": {
                        body_html_file = value;
                        continue block38;
                    }
                    case "from": {
                        from = value;
                        continue block38;
                    }
                    case "to": {
                        tos.add(value);
                        continue block38;
                    }
                    case "cc": {
                        ccs.add(value);
                        continue block38;
                    }
                    case "bcc": {
                        bccs.add(value);
                        continue block38;
                    }
                    case "subject": {
                        subject = value;
                        continue block38;
                    }
                    case "user": {
                        user = value;
                        continue block38;
                    }
                    case "pass": {
                        pass = value;
                        continue block38;
                    }
                    case "auth": {
                        switch (value) {
                            case "LOGIN": {
                                auth = AUTH_LOGIN;
                                continue block38;
                            }
                            case "NTLM": {
                                auth = AUTH_NTLM;
                                continue block38;
                            }
                        }
                        System.out.println("auth not supported:" + value);
                        System.exit(1);
                        continue block38;
                    }
                    case "file": {
                        files.add(value);
                    }
                }
            }
            if (host == null) {
                SMTP.usage();
            }
            if (from == null) {
                SMTP.usage();
            }
            if (tos.size() == 0) {
                SMTP.usage();
            }
            if (body_text_file == null && body_html_file == null) {
                SMTP.usage();
            }
            if ((idx = host.indexOf(58)) != -1) {
                port = JF.atoi(host.substring(idx + 1));
                host = host.substring(0, idx);
            }
            if (port == 25 || port == 587) {
                smtp.connect(host, port);
            } else {
                smtp.connectSSL(host, port);
            }
            smtp.login();
            if (user != null && pass != null && !smtp.auth(args[2], args[3], auth)) {
                throw new Exception("Login failed!");
            }
            smtp.from(from);
            for (String to : tos) {
                smtp.to(to);
            }
            for (String cc : ccs) {
                smtp.cc(cc);
            }
            for (String bcc : bccs) {
                smtp.bcc(bcc);
            }
            String body_text = null;
            if (body_text_file != null) {
                FileInputStream fis = new FileInputStream(body_text_file);
                body_text = new String(JF.readAll(fis));
                fis.close();
            }
            String body_html = null;
            if (body_html_file != null) {
                FileInputStream fis = new FileInputStream(body_html_file);
                body_html = new String(JF.readAll(fis));
                fis.close();
            }
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            for (String file : files) {
                Attachment attach = new Attachment();
                attach.name = SMTP.fileName(file);
                FileInputStream fis = new FileInputStream(file);
                attach.data = JF.readAll(fis);
                fis.close();
                attachments.add(attach);
            }
            smtp.subject(subject);
            smtp.data(body_text, body_html, attachments.toArray(new Attachment[0]));
            System.out.println("Reply=" + smtp.getLastResponse());
            smtp.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static byte[] NEGOTIATE_MESSAGE() {
        byte[] workstation;
        byte[] domain;
        String domain_str = System.getenv("USERDOMAIN");
        if (domain_str == null) {
            JFLog.log("Error:USERDOMAIN==null");
            return null;
        }
        try {
            domain = domain_str.getBytes("iso-8859-1");
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
        int domain_len = domain.length;
        String workstation_str = System.getenv("COMPUTERNAME");
        if (workstation_str == null) {
            JFLog.log("Error:COMPUTERNAME==null");
            return null;
        }
        try {
            workstation = workstation_str.getBytes("iso-8859-1");
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
        int workstation_len = workstation.length;
        byte[] type1 = new byte[32 + domain_len + workstation_len];
        int flags = 569859;
        int off = 0;
        LE.setString(type1, off, 7, "NTLMSSP");
        LE.setuint32(type1, off += 8, 1);
        LE.setuint32(type1, off += 4, flags);
        LE.setuint16(type1, off += 4, domain_len);
        LE.setuint16(type1, off += 2, domain_len);
        LE.setuint32(type1, off += 2, 32);
        LE.setuint16(type1, off += 4, workstation_len);
        LE.setuint16(type1, off += 2, workstation_len);
        LE.setuint32(type1, off += 2, 32 + domain_len);
        System.arraycopy(domain, 0, type1, off += 4, domain.length);
        System.arraycopy(workstation, 0, type1, off += domain_len, workstation.length);
        return type1;
    }

    private static String encodeFirst(String user, String pass, String type, String response) {
        switch (type) {
            case "LOGIN": {
                return new String(Base64.encode(user.getBytes()));
            }
            case "NTLM": {
                return new String(Base64.encode(SMTP.NEGOTIATE_MESSAGE()));
            }
        }
        return null;
    }

    private static byte[] makeDesKey(byte[] input, int off) {
        int[] in = new int[input.length];
        for (int i = 0; i < in.length; ++i) {
            in[i] = input[i] < 0 ? input[i] + 256 : input[i];
        }
        byte[] out = new byte[]{(byte)in[off + 0], (byte)(in[off + 0] << 7 & 0xFF | in[off + 1] >> 1), (byte)(in[off + 1] << 6 & 0xFF | in[off + 2] >> 2), (byte)(in[off + 2] << 5 & 0xFF | in[off + 3] >> 3), (byte)(in[off + 3] << 4 & 0xFF | in[off + 4] >> 4), (byte)(in[off + 4] << 3 & 0xFF | in[off + 5] >> 5), (byte)(in[off + 5] << 2 & 0xFF | in[off + 6] >> 6), (byte)(in[off + 6] << 1 & 0xFF)};
        return out;
    }

    private static byte[] calcLMHash(String password, Cipher cipher, SecretKeyFactory fac) throws GeneralSecurityException {
        byte[] pwb;
        byte[] magic;
        block3: {
            magic = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
            pwb = null;
            try {
                pwb = password.toUpperCase(Locale.ENGLISH).getBytes("iso-8859-1");
            }
            catch (UnsupportedEncodingException ex) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        byte[] pwb1 = new byte[14];
        int len = password.length();
        if (len > 14) {
            len = 14;
        }
        System.arraycopy(pwb, 0, pwb1, 0, len);
        DESKeySpec dks1 = new DESKeySpec(SMTP.makeDesKey(pwb1, 0));
        DESKeySpec dks2 = new DESKeySpec(SMTP.makeDesKey(pwb1, 7));
        SecretKey key1 = fac.generateSecret(dks1);
        SecretKey key2 = fac.generateSecret(dks2);
        cipher.init(1, key1);
        byte[] out1 = cipher.doFinal(magic, 0, 8);
        cipher.init(1, key2);
        byte[] out2 = cipher.doFinal(magic, 0, 8);
        byte[] result = new byte[21];
        System.arraycopy(out1, 0, result, 0, 8);
        System.arraycopy(out2, 0, result, 8, 8);
        return result;
    }

    private static byte[] calcNTHash(String password) throws GeneralSecurityException {
        byte[] pw;
        block2: {
            pw = null;
            try {
                pw = password.getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        MD4 md4 = new MD4();
        byte[] out = md4.digest(pw);
        byte[] result = new byte[21];
        System.arraycopy(out, 0, result, 0, 16);
        return result;
    }

    private static byte[] calcNTv2Hash(String domain, String username, String password) throws GeneralSecurityException {
        try {
            MD4 md4 = new MD4();
            md4.update(password.getBytes("UnicodeLittleUnmarked"));
            HMACT64 hmac = new HMACT64(md4.digest());
            hmac.update(username.toUpperCase().getBytes("UnicodeLittleUnmarked"));
            hmac.update(domain.getBytes("UnicodeLittleUnmarked"));
            return hmac.digest();
        }
        catch (Exception uee) {
            return null;
        }
    }

    private static byte[] calcResponse(byte[] key, byte[] text, Cipher cipher, SecretKeyFactory fac) throws GeneralSecurityException {
        assert (key.length == 21);
        DESKeySpec dks1 = new DESKeySpec(SMTP.makeDesKey(key, 0));
        DESKeySpec dks2 = new DESKeySpec(SMTP.makeDesKey(key, 7));
        DESKeySpec dks3 = new DESKeySpec(SMTP.makeDesKey(key, 14));
        SecretKey key1 = fac.generateSecret(dks1);
        SecretKey key2 = fac.generateSecret(dks2);
        SecretKey key3 = fac.generateSecret(dks3);
        cipher.init(1, key1);
        byte[] out1 = cipher.doFinal(text, 0, 8);
        cipher.init(1, key2);
        byte[] out2 = cipher.doFinal(text, 0, 8);
        cipher.init(1, key3);
        byte[] out3 = cipher.doFinal(text, 0, 8);
        byte[] result = new byte[24];
        System.arraycopy(out1, 0, result, 0, 8);
        System.arraycopy(out2, 0, result, 8, 8);
        System.arraycopy(out3, 0, result, 16, 8);
        return result;
    }

    private static byte[] hmacMD5(Mac hmac, byte[] key, byte[] text) {
        block4: {
            try {
                byte[] nk = new byte[16];
                System.arraycopy(key, 0, nk, 0, key.length > 16 ? 16 : key.length);
                SecretKeySpec skey = new SecretKeySpec(nk, "HmacMD5");
                hmac.init(skey);
                return hmac.doFinal(text);
            }
            catch (InvalidKeyException ex) {
                assert (false);
            }
            catch (RuntimeException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        return null;
    }

    private static byte[] calcLMv2Response(String domain, String user, String password, byte[] server_nonce, byte[] client_nonce) {
        try {
            byte[] hash = new byte[16];
            byte[] response = new byte[24];
            MD4 md4 = new MD4();
            HMACT64 hmac = new HMACT64(md4.digest(password.getBytes("UnicodeLittleUnmarked")));
            hmac.update(user.toUpperCase().getBytes("UnicodeLittleUnmarked"));
            hmac.update(domain.toUpperCase().getBytes("UnicodeLittleUnmarked"));
            hmac = new HMACT64(hmac.digest());
            hmac.update(server_nonce);
            hmac.update(client_nonce);
            hmac.digest(response, 0, 16);
            System.arraycopy(client_nonce, 0, response, 16, 8);
            return response;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static byte[] calcNTv2Response(byte[] nthash, byte[] client_blob, byte[] server_nonce, String domain, String username) throws GeneralSecurityException {
        byte[] txt;
        block2: {
            txt = null;
            try {
                txt = (username.toUpperCase(Locale.ENGLISH) + domain).getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        Mac hmac = Mac.getInstance("HmacMD5");
        byte[] ntlmv2hash = SMTP.hmacMD5(hmac, nthash, txt);
        byte[] cb = new byte[client_blob.length + 8];
        System.arraycopy(server_nonce, 0, cb, 0, 8);
        System.arraycopy(client_blob, 0, cb, 8, client_blob.length);
        byte[] result = new byte[client_blob.length + 16];
        System.arraycopy(SMTP.hmacMD5(hmac, ntlmv2hash, cb), 0, result, 0, 16);
        System.arraycopy(client_blob, 0, result, 16, client_blob.length);
        return result;
    }

    private static byte[] calcNTv2ResponseVariant(byte[] nthash, byte[] client_blob, byte[] server_nonce) throws GeneralSecurityException {
        HMACT64 hmac = new HMACT64(nthash);
        hmac.update(server_nonce);
        hmac.update(client_blob, 0, client_blob.length);
        byte[] mac = hmac.digest();
        byte[] ret = new byte[mac.length + client_blob.length];
        System.arraycopy(mac, 0, ret, 0, mac.length);
        System.arraycopy(client_blob, 0, ret, mac.length, client_blob.length);
        return ret;
    }

    private static byte[] AUTHENTICATE_MESSAGE(String user_str, String pass_str, String response) {
        byte[] nt_response;
        byte[] lm_response;
        byte[] challenge = null;
        try {
            challenge = response.getBytes("us-ascii");
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        byte[] type2 = Base64.decode(challenge);
        byte[] server_nonce = Arrays.copyOfRange(type2, 24, 32);
        int server_flags = LE.getuint32(type2, 20);
        int client_flags = 33281;
        String domain_str = System.getenv("USERDOMAIN");
        String workstation_str = System.getenv("COMPUTERNAME");
        try {
            if ((server_flags & 0x80000) != 0) {
                JFLog.log("SMTP:AUTH:NTLMv2");
                client_flags |= 0x80000;
                byte[] client_nonce = new byte[8];
                new Random().nextBytes(client_nonce);
                lm_response = SMTP.calcLMv2Response(domain_str, user_str, pass_str, server_nonce, client_nonce);
                byte[] targetName = new byte[]{};
                if ((server_flags & 4) != 0) {
                    int tlen = LE.getuint16(type2, 12);
                    int toff = LE.getuint32(type2, 16);
                    targetName = new byte[tlen];
                    System.arraycopy(type2, toff, targetName, 0, tlen);
                }
                byte[] targetInfo = new byte[]{};
                if ((server_flags & 0x800000) != 0) {
                    int tlen = LE.getuint16(type2, 40);
                    int toff = LE.getuint32(type2, 44);
                    targetInfo = new byte[tlen];
                    System.arraycopy(type2, toff, targetInfo, 0, tlen);
                }
                byte[] blob = new byte[28 + targetInfo.length + 4];
                blob[0] = 1;
                blob[1] = 1;
                System.arraycopy(Z6, 0, blob, 2, 6);
                long now = (System.currentTimeMillis() + 11644473600000L) * 10000L;
                for (int i = 0; i < 8; ++i) {
                    blob[8 + i] = (byte)(now & 0xFFL);
                    now >>= 8;
                }
                new Random().nextBytes(client_nonce);
                System.arraycopy(client_nonce, 0, blob, 16, 8);
                System.arraycopy(Z4, 0, blob, 24, 4);
                System.arraycopy(targetInfo, 0, blob, 28, targetInfo.length);
                System.arraycopy(Z4, 0, blob, 28 + targetInfo.length, 4);
                byte[] nthash = SMTP.calcNTv2Hash(domain_str, user_str, pass_str);
                nt_response = SMTP.calcNTv2ResponseVariant(nthash, blob, server_nonce);
                if ((server_flags & 0x10) != 0) {
                    JFLog.log("SMTP:NTML:ERROR:NEED SESSION KEYS");
                    if ((server_flags & 0x40000000) != 0) {
                        JFLog.log("SMTP:NTML:ERROR:NEED EXCHANGE KEYS");
                    }
                }
            } else {
                JFLog.log("SMTP:AUTH:NTLMv1");
                SecretKeyFactory fac = SecretKeyFactory.getInstance("DES");
                Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
                byte[] lmhash = SMTP.calcLMHash(pass_str, cipher, fac);
                lm_response = SMTP.calcResponse(lmhash, server_nonce, cipher, fac);
                byte[] nthash = SMTP.calcNTHash(pass_str);
                nt_response = SMTP.calcResponse(nthash, server_nonce, cipher, fac);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
        int payload_off = 64;
        int lm_response_len = lm_response.length;
        int lm_response_off = payload_off;
        int nt_response_len = nt_response.length;
        int nt_response_off = payload_off += lm_response_len;
        payload_off += nt_response_len;
        if (domain_str == null) {
            return null;
        }
        byte[] domain = null;
        try {
            domain = domain_str.getBytes("UnicodeLittleUnmarked");
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        int domain_len = domain.length;
        int domain_off = payload_off;
        payload_off += domain_len;
        byte[] user = null;
        try {
            user = user_str.getBytes("UnicodeLittleUnmarked");
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        int user_len = user.length;
        int user_off = payload_off;
        payload_off += user_len;
        if (workstation_str == null) {
            return null;
        }
        byte[] workstation = null;
        try {
            workstation = workstation_str.getBytes("UnicodeLittleUnmarked");
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        int workstation_len = workstation.length;
        int workstation_off = payload_off;
        byte[] session_key = new byte[]{};
        int session_key_len = session_key.length;
        int session_key_off = payload_off += workstation_len;
        payload_off += session_key_len;
        byte[] type3 = new byte[64 + lm_response_len + nt_response_len + domain_len + user_len + workstation_len + session_key_len];
        int off = 0;
        LE.setString(type3, off, 7, "NTLMSSP");
        LE.setuint32(type3, off += 8, 3);
        LE.setuint16(type3, off += 4, lm_response_len);
        LE.setuint16(type3, off += 2, lm_response_len);
        LE.setuint32(type3, off += 2, lm_response_off);
        LE.setuint16(type3, off += 4, nt_response_len);
        LE.setuint16(type3, off += 2, nt_response_len);
        LE.setuint32(type3, off += 2, nt_response_off);
        LE.setuint16(type3, off += 4, domain_len);
        LE.setuint16(type3, off += 2, domain_len);
        LE.setuint32(type3, off += 2, domain_off);
        LE.setuint16(type3, off += 4, user_len);
        LE.setuint16(type3, off += 2, user_len);
        LE.setuint32(type3, off += 2, user_off);
        LE.setuint16(type3, off += 4, workstation_len);
        LE.setuint16(type3, off += 2, workstation_len);
        LE.setuint32(type3, off += 2, workstation_off);
        LE.setuint16(type3, off += 4, session_key_len);
        LE.setuint16(type3, off += 2, session_key_len);
        LE.setuint32(type3, off += 2, session_key_off);
        LE.setuint32(type3, off += 4, client_flags);
        System.arraycopy(lm_response, 0, type3, off += 4, lm_response.length);
        System.arraycopy(nt_response, 0, type3, off += lm_response.length, nt_response.length);
        System.arraycopy(domain, 0, type3, off += nt_response.length, domain.length);
        System.arraycopy(user, 0, type3, off += domain.length, user.length);
        System.arraycopy(workstation, 0, type3, off += user.length, workstation.length);
        System.arraycopy(session_key, 0, type3, off += workstation.length, session_key.length);
        off += session_key.length;
        return type3;
    }

    private static String encodeSecond(String user, String pass, String type, String response) {
        switch (type) {
            case "LOGIN": {
                return new String(Base64.encode(pass.getBytes()));
            }
            case "NTLM": {
                return new String(Base64.encode(SMTP.AUTHENTICATE_MESSAGE(user, pass, response)));
            }
        }
        return null;
    }

    private static String toHex(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 3);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hex[b[i] >> 4 & 0xF]).append(hex[b[i] & 0xF]).append(' ');
        }
        return sb.toString();
    }

    public static class Attachment {
        public String name;
        public byte[] data;

        public static Attachment readFile(String fn) {
            try {
                Attachment attach = new Attachment();
                FileInputStream fis = new FileInputStream(fn);
                attach.data = fis.readAllBytes();
                fis.close();
                fn = fn.replaceAll("\\\\", "/");
                int idx = fn.lastIndexOf(47);
                attach.name = idx == -1 ? fn : fn.substring(idx + 1);
                return attach;
            }
            catch (Exception e) {
                JFLog.log(e);
                return null;
            }
        }
    }
}

