/*
 * Decompiled with CFR 0.152.
 */
package javaforce.controls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.BE;
import javaforce.JFLog;
import javaforce.LE;
import javaforce.controls.Controller;
import javaforce.controls.TagListener;

public class Tag {
    public String host;
    public int type;
    public String tag;
    public int size;
    public int color;
    public int min;
    public int max;
    public float fmin;
    public float fmax;
    public int delay;
    public String desc;
    private byte[] pending;
    private Object pendingLock = new Object();
    private Controller c;
    private String socks;
    private Timer timer;
    private Reader reader;
    private TagListener listener;
    private HashMap<String, Object> user = new HashMap();
    private Tag parent;
    private int childIdx;
    private Object lock = new Object();
    private ArrayList<Tag> children = new ArrayList();
    private byte[][] childData;
    private ArrayList<Tag> queue = new ArrayList();
    private boolean multiRead = true;
    private String value = "0";

    public Object getData(String key) {
        return this.user.get(key);
    }

    public void setData(String key, Object value) {
        this.user.put(key, value);
    }

    public void setTag(String host, int type, String tag, int size, int delay) {
        this.host = host;
        this.type = type;
        this.tag = tag;
        this.size = size;
        this.delay = delay;
    }

    public boolean isValid() {
        if (this.size == 0) {
            return false;
        }
        if (this.type == 0) {
            return false;
        }
        if (this.host == null || this.host.length() == 0) {
            return false;
        }
        return !this.host.equalsIgnoreCase("null");
    }

    public boolean isFloat() {
        return this.size == 8 || this.size == 9;
    }

    public boolean isBE() {
        if (this.parent != null) {
            return this.parent.c.isBE();
        }
        return this.c.isBE();
    }

    public boolean isLE() {
        if (this.parent != null) {
            return this.parent.c.isLE();
        }
        return this.c.isLE();
    }

    public void setMultiRead(boolean state) {
        if (this.type != 2) {
            return;
        }
    }

    public int addChild(Tag child) {
        this.children.add(child);
        return this.children.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queue(Tag tag) {
        ArrayList<Tag> arrayList = this.queue;
        synchronized (arrayList) {
            this.queue.add(tag);
        }
    }

    public int getSize() {
        switch (this.size) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 8;
            }
            case 34: {
                return 1;
            }
            case 35: {
                return 2;
            }
            case 36: {
                return 4;
            }
            case 37: {
                return 8;
            }
            case 8: {
                return 4;
            }
            case 9: {
                return 8;
            }
        }
        return 0;
    }

    public String getURL() {
        switch (this.type) {
            case 1: {
                return "JF:" + this.host;
            }
            case 2: {
                return "S7:" + this.host;
            }
            case 3: {
                return "AB:" + this.host;
            }
            case 4: {
                return "MB:" + this.host;
            }
            case 5: {
                return "NI:" + this.host;
            }
            case 6: {
                return "MIC:" + this.host;
            }
        }
        JFLog.log("Tag:Error:type unknown:" + this.type);
        return null;
    }

    public Controller getController() {
        if (this.parent != null) {
            return this.parent.c;
        }
        return this.c;
    }

    public void setListener(TagListener listener) {
        this.listener = listener;
    }

    public String toString() {
        if (!this.isValid()) {
            return "not set";
        }
        if (this.type == 5) {
            return this.host;
        }
        if (this.type == 6) {
            return "MIC:" + this.host;
        }
        if (this.desc != null && this.desc.length() > 0) {
            return this.tag + " - " + this.desc;
        }
        return this.tag;
    }

    public String getmin() {
        if (this.isFloat()) {
            return Float.toString(this.fmin);
        }
        return Integer.toString(this.min);
    }

    public String getmax() {
        if (this.isFloat()) {
            return Float.toString(this.fmax);
        }
        return Integer.toString(this.max);
    }

    private boolean startTimer() {
        if (this.parent == null) {
            this.childData = null;
            this.c = new Controller();
            if (this.socks != null) {
                this.c.setSOCKS(this.socks);
            }
        } else {
            this.c = null;
        }
        this.timer = new Timer();
        this.reader = new Reader();
        this.reader.tag = this;
        if (this.delay < 25) {
            this.delay = 25;
        }
        this.timer.scheduleAtFixedRate((TimerTask)this.reader, this.delay, (long)this.delay);
        return true;
    }

    public boolean start() {
        this.parent = null;
        return this.startTimer();
    }

    public boolean start(Tag parent) {
        this.parent = parent;
        if (parent != null) {
            if (parent.type != this.type) {
                return false;
            }
            this.childIdx = parent.addChild(this);
        }
        return this.startTimer();
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.reader != null) {
            this.reader = null;
        }
        this.disconnect();
    }

    public void setSOCKS(String socksHost) {
        this.socks = socksHost;
    }

    public boolean connect() {
        if (this.parent != null) {
            return false;
        }
        return this.c.connect(this.getURL());
    }

    public void disconnect() {
        if (this.parent != null) {
            this.parent = null;
            return;
        }
        if (this.c != null) {
            this.c.disconnect();
            this.c = null;
        }
        this.children.clear();
    }

    public String getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String value) {
        byte[] data = null;
        if (this.isBE()) {
            switch (this.size) {
                case 1: {
                    data = new byte[]{(byte)(!value.equals("0") ? 1 : 0)};
                    break;
                }
                case 2: {
                    data = new byte[]{Byte.valueOf(value)};
                    break;
                }
                case 3: {
                    data = new byte[2];
                    BE.setuint16(data, 0, Short.valueOf(value).shortValue());
                    break;
                }
                case 4: {
                    data = new byte[4];
                    BE.setuint32(data, 0, Integer.valueOf(value));
                    break;
                }
                case 5: {
                    data = new byte[8];
                    BE.setuint64(data, 0, Long.valueOf(value));
                    break;
                }
                case 34: {
                    data = new byte[]{Byte.valueOf(value)};
                    break;
                }
                case 35: {
                    data = new byte[2];
                    BE.setuint16(data, 0, Short.valueOf(value).shortValue());
                    break;
                }
                case 36: {
                    data = new byte[4];
                    BE.setuint32(data, 0, Integer.valueOf(value));
                    break;
                }
                case 37: {
                    data = new byte[8];
                    BE.setuint64(data, 0, Long.valueOf(value));
                    break;
                }
                case 8: {
                    data = new byte[4];
                    BE.setuint32(data, 0, Float.floatToIntBits(Float.valueOf(value).floatValue()));
                    break;
                }
                case 9: {
                    data = new byte[4];
                    BE.setuint64(data, 0, Double.doubleToLongBits(Double.valueOf(value)));
                }
            }
        } else {
            switch (this.size) {
                case 1: {
                    data = new byte[]{(byte)(!value.equals("0") ? 1 : 0)};
                    break;
                }
                case 2: {
                    data = new byte[]{Byte.valueOf(value)};
                    break;
                }
                case 3: {
                    data = new byte[2];
                    LE.setuint16(data, 0, Short.valueOf(value).shortValue());
                    break;
                }
                case 4: {
                    data = new byte[4];
                    LE.setuint32(data, 0, Integer.valueOf(value));
                    break;
                }
                case 5: {
                    data = new byte[8];
                    LE.setuint64(data, 0, Long.valueOf(value));
                    break;
                }
                case 34: {
                    data = new byte[]{Byte.valueOf(value)};
                    break;
                }
                case 35: {
                    data = new byte[2];
                    LE.setuint16(data, 0, Short.valueOf(value).shortValue());
                    break;
                }
                case 36: {
                    data = new byte[4];
                    LE.setuint32(data, 0, Integer.valueOf(value));
                    break;
                }
                case 37: {
                    data = new byte[8];
                    LE.setuint64(data, 0, Long.valueOf(value));
                    break;
                }
                case 8: {
                    data = new byte[4];
                    LE.setuint32(data, 0, Float.floatToIntBits(Float.valueOf(value).floatValue()));
                    break;
                }
                case 9: {
                    data = new byte[4];
                    LE.setuint64(data, 0, Double.doubleToLongBits(Double.valueOf(value)));
                }
            }
        }
        Object object = this.pendingLock;
        synchronized (object) {
            this.pending = data;
        }
    }

    public int intValue() {
        return Integer.valueOf(this.value);
    }

    public float floatValue() {
        return Float.valueOf(this.value).floatValue();
    }

    public double doubleValue() {
        return Double.valueOf(this.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read() {
        if (this.parent != null) {
            if (this.parent.c == null) {
                return null;
            }
            if (this.multiRead) {
                return this.parent.read(this.childIdx);
            }
            Object object = this.lock;
            synchronized (object) {
                this.parent.queue(this);
                try {
                    this.lock.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return this.parent.c.read(this.tag);
            }
        }
        if (this.multiRead && this.type == 2 && this.children.size() > 0) {
            int cnt = this.children.size();
            String[] tags = new String[cnt + 1];
            tags[cnt] = this.tag;
            for (int a = 0; a < cnt; ++a) {
                tags[a] = this.children.get((int)a).tag;
            }
            this.childData = this.c.read(tags);
            if (this.childData == null) {
                return null;
            }
            return this.childData[cnt];
        }
        ArrayList<Tag> arrayList = this.queue;
        synchronized (arrayList) {
            while (this.queue.size() > 0) {
                Tag child = this.queue.remove(0);
                Object object = child.lock;
                synchronized (object) {
                    child.lock.notify();
                }
            }
        }
        return this.c.read(this.tag);
    }

    public void write(byte[] data) {
        if (this.parent != null) {
            if (this.parent.c == null) {
                return;
            }
            this.parent.c.write(this.tag, data);
        } else {
            this.c.write(this.tag, data);
        }
    }

    private byte[] read(int idx) {
        if (this.childData == null || idx >= this.childData.length) {
            return null;
        }
        return this.childData[idx];
    }

    private static class Reader
    extends TimerTask {
        public Tag tag;
        public byte[] data;

        private Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String lastValue = this.tag.value;
                if (this.tag.parent == null && !this.tag.c.isConnected() && !this.tag.connect()) {
                    return;
                }
                this.data = this.tag.read();
                if (this.data == null) {
                    return;
                }
                if (this.tag.isBE()) {
                    switch (this.tag.size) {
                        case 1: {
                            this.tag.value = this.data[0] == 0 ? "0" : "1";
                            break;
                        }
                        case 2: {
                            this.tag.value = Byte.toString(this.data[0]);
                            break;
                        }
                        case 3: {
                            this.tag.value = Short.toString((short)BE.getuint16(this.data, 0));
                            break;
                        }
                        case 4: {
                            this.tag.value = Integer.toString(BE.getuint32(this.data, 0));
                            break;
                        }
                        case 5: {
                            this.tag.value = Long.toString(BE.getuint64(this.data, 0));
                            break;
                        }
                        case 34: {
                            this.tag.value = Integer.toUnsignedString(this.data[0] & 0xFF);
                            break;
                        }
                        case 35: {
                            this.tag.value = Integer.toUnsignedString(BE.getuint16(this.data, 0) & 0xFFFF);
                            break;
                        }
                        case 36: {
                            this.tag.value = Integer.toUnsignedString(BE.getuint32(this.data, 0));
                            break;
                        }
                        case 37: {
                            this.tag.value = Long.toUnsignedString(BE.getuint64(this.data, 0));
                            break;
                        }
                        case 8: {
                            this.tag.value = Float.toString(Float.intBitsToFloat(BE.getuint32(this.data, 0)));
                            break;
                        }
                        case 9: {
                            this.tag.value = Double.toString(Double.longBitsToDouble(BE.getuint64(this.data, 0)));
                        }
                    }
                } else {
                    switch (this.tag.size) {
                        case 1: {
                            this.tag.value = this.data[0] == 0 ? "0" : "1";
                            break;
                        }
                        case 2: {
                            this.tag.value = Byte.toString(this.data[0]);
                            break;
                        }
                        case 3: {
                            this.tag.value = Short.toString((short)LE.getuint16(this.data, 0));
                            break;
                        }
                        case 4: {
                            this.tag.value = Integer.toString(LE.getuint32(this.data, 0));
                            break;
                        }
                        case 5: {
                            this.tag.value = Long.toString(LE.getuint64(this.data, 0));
                            break;
                        }
                        case 34: {
                            this.tag.value = Integer.toUnsignedString(this.data[0] & 0xFF);
                            break;
                        }
                        case 35: {
                            this.tag.value = Integer.toUnsignedString(LE.getuint16(this.data, 0) & 0xFFFF);
                            break;
                        }
                        case 36: {
                            this.tag.value = Integer.toUnsignedString(LE.getuint32(this.data, 0));
                            break;
                        }
                        case 37: {
                            this.tag.value = Long.toUnsignedString(LE.getuint64(this.data, 0));
                            break;
                        }
                        case 8: {
                            this.tag.value = Float.toString(Float.intBitsToFloat(LE.getuint32(this.data, 0)));
                            break;
                        }
                        case 9: {
                            this.tag.value = Double.toString(Double.longBitsToDouble(LE.getuint64(this.data, 0)));
                        }
                    }
                }
                Object object = this.tag.pendingLock;
                synchronized (object) {
                    if (this.tag.pending != null) {
                        this.tag.write(this.tag.pending);
                        this.tag.pending = null;
                    }
                }
                if (this.tag.listener == null) {
                    return;
                }
                if (lastValue == null || !this.tag.value.equals(lastValue)) {
                    this.tag.listener.tagChanged(this.tag, this.tag.value);
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }
}

