/*
 * Decompiled with CFR 0.152.
 */
package javaforce.pi;

import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.controls.Controller;
import javaforce.pi.GPIO;
import javaforce.webui.Button;
import javaforce.webui.Column;
import javaforce.webui.Image;
import javaforce.webui.Label;
import javaforce.webui.Pad;
import javaforce.webui.Panel;
import javaforce.webui.Resource;
import javaforce.webui.Row;
import javaforce.webui.WebUIClient;
import javaforce.webui.WebUIHandler;
import javaforce.webui.WebUIServer;

public class Test
implements WebUIHandler {
    public static TestPanel panel;
    public static Resource on;
    public static Resource off;
    public static boolean[] outputs;
    public static boolean[] inputs;
    public static boolean[] display;

    public static void main(String[] args) {
        if (args.length > 0) {
            switch (args[0]) {
                case "read": {
                    Test.read(args[1], args[2]);
                    break;
                }
                case "write": {
                    Test.write(args[1], args[2], args[3]);
                    break;
                }
                default: {
                    JFLog.log("usage: read|write ip tag [value]");
                    break;
                }
            }
        } else {
            new Test().start();
        }
    }

    public void start() {
        if (!GPIO.init()) {
            JFLog.log("GPIO.init() failed");
            return;
        }
        for (int a = 0; a < 8; ++a) {
            GPIO.configInput(a);
            GPIO.configOutput(a + 8);
        }
        this.initResources();
        WebUIServer server = new WebUIServer();
        server.start(this, 8080);
        Worker worker = new Worker();
        worker.start();
    }

    @Override
    public void clientConnected(WebUIClient client) {
    }

    @Override
    public void clientDisconnected(WebUIClient client) {
    }

    private void initResources() {
        on = Resource.readResource("javaforce/pi/on.png", "image/png");
        off = Resource.readResource("javaforce/pi/off.png", "image/png");
    }

    @Override
    public Panel getRootPanel(WebUIClient client) {
        Row row;
        int a;
        panel = new TestPanel();
        Column col = new Column();
        panel.add(col);
        for (a = 0; a < 8; ++a) {
            row = new Row();
            col.add(row);
            row.add(new Pad());
            Test.panel.il[a] = new Label("I" + (a + 1));
            row.add(Test.panel.il[a]);
            Test.panel.i[a] = new Image(off);
            row.add(Test.panel.i[a]);
            row.add(new Pad());
        }
        for (a = 0; a < 8; ++a) {
            row = new Row();
            col.add(row);
            row.add(new Pad());
            Test.panel.o[a] = new Button("O" + (a + 1));
            int idx = a;
            Test.panel.o[a].addClickListener((event, button) -> {
                boolean state;
                Test.outputs[idx] = state = !outputs[idx];
                GPIO.write(idx + 8, state);
                Test.panel.oi[idx].setImage(state ? on : off);
            });
            row.add(Test.panel.o[a]);
            Test.panel.oi[a] = new Image(off);
            row.add(Test.panel.oi[a]);
            row.add(new Pad());
        }
        return panel;
    }

    @Override
    public byte[] getResource(String url) {
        return null;
    }

    public static void write(String ip, String tag, String value) {
        Controller c = new Controller();
        if (!c.connect("MODBUS:" + ip)) {
            JFLog.log("Error:connect() failed");
            return;
        }
        byte[] data = new byte[2];
        switch (value) {
            case "true": {
                data[0] = 1;
                break;
            }
            case "false": {
                break;
            }
            default: {
                BE.setuint16(data, 0, Integer.valueOf(value));
            }
        }
        c.write(tag, data);
        JF.sleep(500);
        JFLog.log("write:" + tag + "=" + value);
    }

    public static void read(String ip, String tag) {
        Controller c = new Controller();
        if (!c.connect("MODBUS:" + ip)) {
            JFLog.log("Error:connect() failed");
            return;
        }
        byte[] data = c.read(tag);
        if (data == null) {
            JFLog.log("Error:read() == null");
            return;
        }
        int value = 0;
        switch (data.length) {
            case 0: {
                JFLog.log("Error:data.length==0");
                break;
            }
            case 1: {
                value = data[0] & 0xFF;
                break;
            }
            default: {
                value = BE.getuint16(data, 0);
            }
        }
        JFLog.log("read:" + tag + "=" + value);
    }

    static {
        outputs = new boolean[8];
        inputs = new boolean[8];
        display = new boolean[8];
    }

    public static class Worker
    extends Thread {
        public volatile boolean active;

        @Override
        public void run() {
            this.active = true;
            while (this.active) {
                for (int a = 0; a < 8; ++a) {
                    Test.inputs[a] = GPIO.read(a);
                    if (panel == null || inputs[a] == display[a]) continue;
                    Test.display[a] = inputs[a];
                    Test.panel.i[a].setImage(inputs[a] ? on : off);
                }
                JF.sleep(100);
            }
        }
    }

    public class TestPanel
    extends Panel {
        public Label[] il = new Label[8];
        public Image[] i = new Image[8];
        public Button[] o = new Button[8];
        public Image[] oi = new Image[8];
    }
}

