/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javaforce.HTTP;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.MD5;
import javaforce.voip.CallDetails;
import javaforce.voip.Codec;
import javaforce.voip.Packet;
import javaforce.voip.PacketPool;
import javaforce.voip.RTSPInterface;
import javaforce.voip.RTSPSession;
import javaforce.voip.RTSPURL;
import javaforce.voip.SDP;
import javaforce.voip.SIP;
import javaforce.voip.Transport;
import javaforce.voip.TransportInterface;
import javaforce.voip.TransportTCPClient;
import javaforce.voip.TransportTCPServer;
import javaforce.voip.TransportTLSClient;
import javaforce.voip.TransportTLSServer;
import javaforce.voip.TransportType;
import javaforce.voip.TransportUDP;

public abstract class RTSP
implements TransportInterface {
    private WorkerReader worker_reader;
    private WorkerPacket worker_packet;
    private PacketPool pool;
    private RTSPInterface iface;
    private boolean active = true;
    private String rinstance;
    private String tupleid;
    private Random r = new Random();
    private boolean server;
    protected Transport transport;
    protected String localhost;
    protected int localport;
    protected static String useragent;
    public int log;
    public static boolean debug;
    private static HashMap<String, String> dnsCache;
    private final int mtu = 1460;

    protected boolean init(String localhost, int localport, RTSPInterface iface, boolean server, TransportType type) throws Exception {
        JFLog.log(this.log, "RTSP:local=" + localhost + ":" + localport);
        this.rinstance = null;
        this.iface = iface;
        this.server = server;
        switch (type) {
            case UDP: {
                this.transport = new TransportUDP();
                break;
            }
            case TCP: {
                if (server) {
                    this.transport = new TransportTCPServer();
                    break;
                }
                this.transport = new TransportTCPClient();
                break;
            }
            case TLS: {
                this.transport = server ? new TransportTLSServer() : new TransportTLSClient();
            }
        }
        if (!this.transport.open(localhost, localport, this)) {
            return false;
        }
        this.localhost = localhost;
        this.localport = localport;
        this.pool = new PacketPool(1460);
        this.worker_reader = new WorkerReader();
        this.worker_reader.start();
        if (server) {
            this.worker_packet = new WorkerPacket();
            this.worker_packet.start();
        }
        return true;
    }

    protected void uninit() {
        if (debug) {
            JFLog.log(this.log, "RTSP.unint() start:" + this);
        }
        if (this.transport == null) {
            return;
        }
        this.active = false;
        this.transport.close();
        try {
            if (debug) {
                JFLog.log(this.log, "RTSP.uninit() waiting for reader:" + this);
            }
            this.worker_reader.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.worker_reader = null;
        if (this.server) {
            this.worker_packet.cancel();
            try {
                this.worker_packet.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.worker_packet = null;
        }
        this.pool = null;
        this.transport = null;
        this.worker_reader = null;
        if (debug) {
            JFLog.log(this.log, "RTSP.uninit() done:" + this);
        }
    }

    public void setLog(int id) {
        this.log = id;
    }

    protected boolean send(InetAddress remote, int remoteport, String datastr) {
        byte[] data = datastr.getBytes();
        if (debug) {
            JFLog.log(this.log, "RTSP:send:remote=" + remote.getHostAddress() + ":" + remoteport);
        }
        return this.transport.send(data, 0, data.length, remote, remoteport);
    }

    public static String join(String[] x) {
        int i;
        if (x == null) {
            return "\"null\"<sip:null@null>";
        }
        StringBuilder buf = new StringBuilder();
        if (x[0].length() > 0) {
            buf.append('\"');
            buf.append(x[0]);
            buf.append('\"');
            buf.append('<');
        }
        buf.append("sip:");
        if (x[1].length() > 0) {
            buf.append(x[1]);
            buf.append('@');
        }
        buf.append(x[2]);
        for (i = 3; i < x.length && !x[i].equals(":"); ++i) {
            buf.append(';');
            buf.append(x[i]);
        }
        ++i;
        if (x[0].length() > 0) {
            buf.append('>');
        }
        while (i < x.length) {
            buf.append(';');
            buf.append(x[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String getFlag2(String[] fields, String flg) {
        int i;
        flg = (String)flg + "=";
        for (i = 0; i < fields.length && !fields[i].equals(":"); ++i) {
        }
        if (i == fields.length) {
            return "";
        }
        ++i;
        while (i < fields.length) {
            if (fields[i].startsWith((String)flg)) {
                return fields[i].substring(((String)flg).length());
            }
            ++i;
        }
        return "";
    }

    public static String[] setFlag2(String[] fields, String flg, String value) {
        flg = (String)flg + "=";
        boolean seperator = false;
        for (int i = 3; i < fields.length; ++i) {
            if (!seperator) {
                if (!fields[i].equals(":")) continue;
                seperator = true;
                continue;
            }
            if (!fields[i].startsWith((String)flg)) continue;
            fields[i] = (String)flg + value;
            return fields;
        }
        String[] newfields = new String[fields.length + 1];
        for (int j = 0; j < fields.length; ++j) {
            newfields[j] = fields[j];
        }
        newfields[fields.length] = (String)flg + value;
        return newfields;
    }

    public String getbranch() {
        return String.format("z123456-y12345-%x%x-1--d12345-", this.r.nextInt(), this.r.nextInt());
    }

    protected String getbranch(String[] msg) {
        String[] vias = this.getvialist(msg);
        if (vias == null || vias.length == 0) {
            return null;
        }
        String[] f = vias[0].split(";");
        for (int a = 0; a < f.length; ++a) {
            if (!f[a].startsWith("branch=")) continue;
            return f[a].substring(7);
        }
        return null;
    }

    protected boolean ishold(String[] msg) {
        for (int a = 0; a < msg.length; ++a) {
            if (!msg[a].equalsIgnoreCase("a=sendonly")) continue;
            return true;
        }
        return false;
    }

    protected String[] getvialist(String[] msg) {
        ArrayList<String> vialist = new ArrayList<String>();
        for (int a = 0; a < msg.length; ++a) {
            String ln = msg[a];
            if (ln.regionMatches(true, 0, "Via:", 0, 4)) {
                vialist.add(ln);
                continue;
            }
            if (!ln.regionMatches(true, 0, "v:", 0, 2)) continue;
            vialist.add(ln);
        }
        return vialist.toArray(JF.StringArrayType);
    }

    protected String[] getroutelist(String[] msg) {
        ArrayList<CallSite> routelist = new ArrayList<CallSite>();
        for (int a = 0; a < msg.length; ++a) {
            String ln = msg[a];
            if (!ln.regionMatches(true, 0, "Record-Route:", 0, 13)) continue;
            routelist.add((CallSite)((Object)("Route:" + ln.substring(13))));
        }
        return routelist.toArray(JF.StringArrayType);
    }

    protected String getrinstance() {
        if (this.rinstance != null) {
            return this.rinstance;
        }
        this.rinstance = String.format("%x%x", this.r.nextInt(), this.r.nextInt());
        return this.rinstance;
    }

    protected String gettupleid() {
        if (this.tupleid != null) {
            return this.tupleid;
        }
        this.tupleid = String.format("%08x", this.r.nextInt());
        return this.tupleid;
    }

    protected String geturi(String[] msg) {
        int idx1 = msg[0].indexOf(32);
        if (idx1 == -1) {
            return null;
        }
        int idx2 = msg[0].substring(idx1 + 1).indexOf(32);
        if (idx2 == -1) {
            return null;
        }
        return msg[0].substring(idx1 + 1).substring(0, idx2);
    }

    public static String generatetag() {
        Random r = new Random();
        return String.format("null<sip:null@null>;tag=%x%x", r.nextInt(), r.nextInt());
    }

    public static String[] removetag(String[] fields) {
        boolean seperator = false;
        for (int i = 3; i < fields.length; ++i) {
            int j;
            if (!seperator) {
                if (!fields[i].equals(":")) continue;
                seperator = true;
                continue;
            }
            if (!fields[i].startsWith("tag=")) continue;
            String[] newfields = new String[fields.length - 1];
            for (j = 0; j < i; ++j) {
                newfields[j] = fields[j];
            }
            for (j = i + 1; j < fields.length; ++j) {
                newfields[j - 1] = fields[j];
            }
            return newfields;
        }
        return fields;
    }

    public static String gettag(String[] fields) {
        boolean seperator = false;
        for (int i = 3; i < fields.length; ++i) {
            if (!seperator) {
                if (!fields[i].equals(":")) continue;
                seperator = true;
                continue;
            }
            if (!fields[i].startsWith("tag=")) continue;
            return fields[i].substring(4);
        }
        return null;
    }

    public String getcallid() {
        return String.format("%x%x", this.r.nextInt(), System.currentTimeMillis());
    }

    protected long getNow() {
        return System.currentTimeMillis() / 1000L;
    }

    protected String getnonce() {
        return String.format("%x%x%x%x", this.r.nextInt(), this.r.nextInt(), System.currentTimeMillis(), this.r.nextInt());
    }

    private static String getCodecName(int id) {
        switch (id) {
            case 0: {
                return "PCMU";
            }
            case 3: {
                return "GSM";
            }
            case 8: {
                return "PCMA";
            }
            case 9: {
                return "G722";
            }
            case 26: {
                return "JPEG";
            }
            case 18: {
                return "G729";
            }
            case 34: {
                return "H263";
            }
        }
        return "?";
    }

    public SDP getSDP(String[] msg) {
        return SDP.getSDP(msg, this.log);
    }

    public static boolean hasCodec(Codec[] codecs, Codec codec) {
        for (int a = 0; a < codecs.length; ++a) {
            if (!codecs[a].name.equals(codec.name)) continue;
            return true;
        }
        return false;
    }

    public static Codec[] addCodec(Codec[] codecs, Codec codec) {
        Codec[] newCodecs = new Codec[codecs.length + 1];
        for (int a = 0; a < codecs.length; ++a) {
            newCodecs[a] = codecs[a];
        }
        newCodecs[codecs.length] = codec;
        return newCodecs;
    }

    public static Codec[] delCodec(Codec[] codecs, Codec codec) {
        if (!RTSP.hasCodec(codecs, codec)) {
            return codecs;
        }
        Codec[] newCodecs = new Codec[codecs.length - 1];
        int pos = 0;
        for (int a = 0; a < codecs.length; ++a) {
            if (codecs[a].name.equals(codec.name)) continue;
            newCodecs[pos++] = codecs[a];
        }
        return newCodecs;
    }

    public static Codec getCodec(Codec[] codecs, Codec codec) {
        for (int a = 0; a < codecs.length; ++a) {
            if (!codecs[a].name.equals(codec.name)) continue;
            return codecs[a];
        }
        return null;
    }

    protected String getRequest(String[] msg) {
        int idx = msg[0].indexOf(" ");
        if (idx == -1) {
            return null;
        }
        return msg[0].substring(0, idx);
    }

    protected String getURI(String[] msg) {
        String[] parts = msg[0].split(" ");
        return parts[1];
    }

    protected int getResponseType(String[] msg) {
        if (msg[0].length() < 11) {
            return -1;
        }
        if (!msg[0].regionMatches(true, 0, "RTSP/1.0 ", 0, 9)) {
            return -1;
        }
        return Integer.valueOf(msg[0].substring(9, 12));
    }

    protected int getcseq(String[] msg) {
        String cseqstr = HTTP.getParameter(msg, "CSeq");
        if (cseqstr == null) {
            return -1;
        }
        String[] parts = cseqstr.split(" ");
        return Integer.valueOf(parts[0]);
    }

    protected String getcseqcmd(String[] msg) {
        String cseqstr = HTTP.getParameter(msg, "CSeq");
        if (cseqstr == null) {
            return null;
        }
        String[] parts = cseqstr.split(" ");
        if (parts.length < 2) {
            return null;
        }
        return parts[1];
    }

    protected String getResponse(String user, String pass, String realm, String cmd, String uri, String nonce, String qop, String nc, String cnonce) {
        MD5 md5 = new MD5();
        Object H1 = user + ":" + realm + ":" + pass;
        md5.init();
        md5.add(((String)H1).getBytes(), 0, ((String)H1).length());
        H1 = new String(md5.byte2char(md5.done()));
        Object H2 = cmd + ":" + uri;
        md5.init();
        md5.add(((String)H2).getBytes(), 0, ((String)H2).length());
        H2 = new String(md5.byte2char(md5.done()));
        String H3 = (String)H1 + ":" + nonce + ":";
        if (qop != null && qop.length() > 0) {
            H3 = H3 + nc + ":" + cnonce + ":" + qop + ":";
        }
        H3 = H3 + (String)H2;
        md5.init();
        md5.add(H3.getBytes(), 0, H3.length());
        return new String(md5.byte2char(md5.done()));
    }

    private String[] split(String in, char delimit) {
        ArrayList<String> strs = new ArrayList<String>();
        boolean inquote = false;
        char[] ca = in.toCharArray();
        int p1 = 0;
        int p2 = 0;
        for (int a = 0; a < ca.length; ++a) {
            char ch = ca[a];
            if (ch == delimit && !inquote) {
                strs.add(in.substring(p1, p2).trim());
                p1 = ++p2;
                continue;
            }
            if (ch == '\"') {
                inquote = !inquote;
            }
            ++p2;
        }
        if (p2 > p1) {
            strs.add(in.substring(p1, p2).trim());
        }
        return strs.toArray(new String[strs.size()]);
    }

    protected String getAuthResponse(RTSPSession sess, String user, String pass, String remote, String cmd, String header) {
        String request = sess.authstr;
        if (!request.regionMatches(true, 0, "Digest ", 0, 7)) {
            JFLog.log(this.log, "err:no digest");
            return null;
        }
        String[] tags = SIP.convertParameters(request.substring(7), ',');
        String nonce = null;
        String qop = null;
        String cnonce = null;
        String nc = null;
        String stale = null;
        String realm = null;
        String algo = HTTP.getParameter(tags, "algorithm");
        if (algo != null && !algo.equalsIgnoreCase("MD5")) {
            JFLog.log(this.log, "err:only MD5 auth supported");
            return null;
        }
        realm = HTTP.getParameter(tags, "realm");
        nonce = HTTP.getParameter(tags, "nonce");
        qop = HTTP.getParameter(tags, "qop");
        stale = HTTP.getParameter(tags, "stale");
        if (nonce == null) {
            JFLog.log(this.log, "err:no nonce");
            return null;
        }
        if (realm == null) {
            JFLog.log(this.log, "err:no realm");
            return null;
        }
        if (qop != null) {
            String[] qops = qop.split(",");
            qop = null;
            for (int a = 0; a < qops.length; ++a) {
                if (!qops[a].trim().equals("auth")) continue;
                qop = "auth";
                break;
            }
            if (qop != null) {
                cnonce = this.getnonce();
                sess.nonceCount = sess.nonce != null && sess.nonce.equals(nonce) ? ++sess.nonceCount : 1;
                nc = String.format("%08x", sess.nonceCount);
            }
        }
        sess.nonce = nonce;
        String response = this.getResponse(user, pass, realm, cmd, sess.uri, nonce, qop, nc, cnonce);
        StringBuilder ret = new StringBuilder();
        ret.append(header);
        ret.append(":");
        ret.append(" Digest username=\"" + user + "\", realm=\"" + realm + "\", nonce=\"" + nonce + "\", uri=\"" + sess.uri + "\"");
        if (cnonce != null) {
            ret.append(", cnonce=\"" + cnonce + "\"");
        }
        if (qop != null) {
            ret.append(", nc=" + nc);
            ret.append(", qop=" + qop);
        }
        ret.append(", response=\"" + response + "\"");
        if (algo != null) {
            ret.append(", algorithm=MD5");
        }
        ret.append("\r\n");
        return ret.toString();
    }

    protected String getremotertphost(String[] msg) {
        String c = HTTP.getParameter(msg, "c");
        if (c == null) {
            return null;
        }
        int idx = c.indexOf("IP4 ");
        if (idx == -1) {
            return null;
        }
        return c.substring(idx + 4);
    }

    protected int getremote_audio_rtp_port(String[] msg) {
        String[] ms;
        for (String m : ms = HTTP.getParameters(msg, "m")) {
            if (!m.startsWith("audio")) continue;
            String[] p = m.split(" ");
            return Integer.valueOf(p[1]);
        }
        return -1;
    }

    protected int getremote_video_rtp_port(String[] msg) {
        String[] ms;
        for (String m : ms = HTTP.getParameters(msg, "m")) {
            if (!m.startsWith("video")) continue;
            String[] p = m.split(" ");
            return Integer.valueOf(p[1]);
        }
        return -1;
    }

    protected long geto(String[] msg, int idx) {
        String o = HTTP.getParameter(msg, "o");
        if (o == null) {
            return 0L;
        }
        String[] os = o.split(" ");
        return Long.valueOf(os[idx]);
    }

    public abstract String getlocalRTPhost(RTSPSession var1);

    public String[] buildsdp(RTSPSession sess, CallDetails.SideDetails cdsd) {
        SDP sdp = cdsd.sdp;
        if (sdp.ip == null) {
            sdp.ip = this.getlocalRTPhost(sess);
        }
        return sdp.build(sess.localhost);
    }

    public String resolve(String host) {
        String ip = dnsCache.get(host);
        if (ip != null) {
            return ip;
        }
        try {
            ip = InetAddress.getByName(host).getHostAddress();
        }
        catch (Exception e) {
            JFLog.log(this.log, (Throwable)e);
            return null;
        }
        JFLog.log(this.log, "dns:" + host + "=" + ip);
        dnsCache.put(host, ip);
        return ip;
    }

    @Override
    public void onConnect(String host, int port) {
        this.iface.onConnect(this, host, port);
    }

    @Override
    public void onDisconnect(String host, int port) {
        this.iface.onDisconnect(this, host, port);
    }

    public int getPacketPoolSize() {
        return this.pool.count();
    }

    static {
        RTSPURL.register();
        useragent = "JavaForce/" + JF.getVersion();
        debug = false;
        dnsCache = new HashMap();
    }

    private class WorkerReader
    extends Thread {
        private WorkerReader() {
        }

        @Override
        public void run() {
            this.setName("RTSP.WorkerReader");
            if (debug) {
                JFLog.log(RTSP.this.log, "RTSP.Worker:start:local=" + RTSP.this.localport);
            }
            while (RTSP.this.active) {
                if (RTSP.this.transport.error()) {
                    JFLog.log(RTSP.this.log, "RTSP:Transport:Error:server=" + RTSP.this.server + ":localport=" + RTSP.this.localport);
                    RTSP.this.active = false;
                    break;
                }
                Packet pack = null;
                try {
                    pack = RTSP.this.pool.alloc();
                    if (pack == null) {
                        JFLog.log(RTSP.this.log, "RTSP:PacketPool full");
                        JF.sleep(1000);
                        continue;
                    }
                    if (!RTSP.this.transport.receive(pack)) {
                        RTSP.this.pool.free(pack);
                        continue;
                    }
                    if (debug) {
                        JFLog.log(RTSP.this.log, "RTSP:packet:host=" + pack.host);
                    }
                    if (pack.length <= 4) {
                        RTSP.this.pool.free(pack);
                        continue;
                    }
                    if (RTSP.this.server) {
                        RTSP.this.worker_packet.add(pack);
                        continue;
                    }
                    if (debug) {
                        JFLog.log(RTSP.this.log, "RTSP:packet send:host=" + pack.host);
                    }
                    String[] msg = new String(pack.data, 0, pack.length).split("\r\n", -1);
                    RTSP.this.iface.onPacket(RTSP.this, msg, pack.host, pack.port);
                    if (debug) {
                        JFLog.log(RTSP.this.log, "RTSP:packet free:host=" + pack.host);
                    }
                    RTSP.this.pool.free(pack);
                    if (!debug) continue;
                    JFLog.log(RTSP.this.log, "RTSP:packet done:host=" + pack.host);
                }
                catch (Exception e) {
                    if (debug) {
                        JFLog.log(RTSP.this.log, (Throwable)e);
                    }
                    if (RTSP.this.server || pack == null) continue;
                    RTSP.this.pool.free(pack);
                }
            }
            if (debug) {
                JFLog.log(RTSP.this.log, "RTSP.Worker:stop:local=" + RTSP.this.localport);
            }
        }
    }

    private class WorkerPacket
    extends Thread {
        private Object queueLock = new Object();
        private ArrayList<Packet> queue = new ArrayList();

        private WorkerPacket() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("RTSP.WorkerPacket");
            while (RTSP.this.active) {
                Object object = this.queueLock;
                synchronized (object) {
                    if (this.queue.size() > 0) {
                        Packet packet = this.queue.remove(0);
                        String[] msg = new String(packet.data, 0, packet.length).split("\r\n", -1);
                        RTSP.this.iface.onPacket(RTSP.this, msg, packet.host, packet.port);
                        RTSP.this.pool.free(packet);
                    } else {
                        try {
                            this.queueLock.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Packet packet) {
            Object object = this.queueLock;
            synchronized (object) {
                this.queue.add(packet);
                this.queueLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            RTSP.this.active = false;
            Object object = this.queueLock;
            synchronized (object) {
                this.queueLock.notify();
            }
        }
    }
}

