/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.MenuBar;
import javaforce.webui.MenuItem;
import javaforce.webui.PopupMenu;
import javaforce.webui.WebUIClient;
import javaforce.webui.event.MouseEvent;

public class Menu
extends MenuItem {
    public PopupMenu popupMenu;
    private boolean inMenuBar;
    private boolean inMenu;

    public Menu(String text) {
        super(text);
        this.setClass("menu");
        this.popupMenu = new PopupMenu();
        this.add(this.popupMenu);
        this.addEvent("onmousemove", "onMouseMove(event, this);");
    }

    @Override
    public void init() {
        super.init();
        if (this.parent == null) {
            System.out.println("Error:Menu.parent == null");
        } else if (this.parent instanceof MenuBar) {
            this.inMenuBar = true;
        } else if (this.parent instanceof PopupMenu) {
            this.inMenu = true;
        } else {
            System.out.println("Error:Menu.parent type unknown");
        }
    }

    @Override
    public String html() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.html());
        sb.append(this.popupMenu.html());
        return sb.toString();
    }

    public void add(MenuItem item) {
        this.popupMenu.add(item);
    }

    @Override
    public void onMouseDown(String[] args) {
    }

    @Override
    public void onClick(String[] args, MouseEvent me) {
        this.sendEvent("getpossize", null);
    }

    @Override
    public void onPosSize(String[] args) {
        super.onPosSize(args);
        if (this.inMenuBar) {
            this.popupMenu.setPosition(this.x, this.y + this.height);
        } else {
            this.popupMenu.setPosition(this.x + this.width, this.y);
        }
        this.popupMenu.setVisible(true);
        if (this.inMenuBar) {
            this.client.topPopupMenu = this.popupMenu;
        }
    }

    @Override
    public void onMouseMove(String[] args) {
        if (!this.inMenu && this.client.topPopupMenu != null && this.client.topPopupMenu != this.popupMenu) {
            this.client.topPopupMenu.setVisible(false);
        }
        this.onClick(args, null);
    }

    public void closeMenu() {
        this.popupMenu.setVisible(false);
    }

    public static void onMouseDownBody(WebUIClient client, String[] args) {
        if (!client.popupMenuMouseDown) {
            if (client.topPopupMenu != null) {
                client.topPopupMenu.setVisible(false);
                client.topPopupMenu = null;
            }
        } else {
            client.popupMenuMouseDown = false;
        }
    }
}

