/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import java.util.Arrays;
import javaforce.webui.Block;
import javaforce.webui.Component;
import javaforce.webui.Container;
import javaforce.webui.Label;
import javaforce.webui.event.Click;
import javaforce.webui.event.MouseEvent;

public class Table
extends Container
implements Click {
    private int cellWidth;
    private int cellHeight;
    private int cols;
    private int rows;
    private boolean border;
    private boolean has_header;
    private int sel_mode;
    private int[] cellWidths;
    public static final int SELECT_CELL = 0;
    public static final int SELECT_ROW = 1;
    public static final int SELECT_COLUMN = 2;

    public Table(int cellWidth, int cellHeight, int cols, int rows) {
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.cols = cols;
        this.rows = rows;
        this.setClass("table");
        this.setSize();
    }

    public Table(int[] cellWidths, int cellHeight, int cols, int rows) {
        this.cellWidths = cellWidths;
        this.cellHeight = cellHeight;
        this.cols = cellWidths.length;
        this.rows = rows;
        this.setClass("table");
        this.setSize();
    }

    private int getColWidth(int col) {
        if (this.cellWidths == null) {
            return this.cellWidth;
        }
        return this.cellWidths[col];
    }

    private int getColPosition(int col) {
        if (this.cellWidths == null) {
            return col * this.cellWidth;
        }
        int total = 0;
        for (int x = 0; x < col; ++x) {
            total += this.cellWidths[x];
        }
        return total;
    }

    private int getTotalWidth() {
        if (this.cellWidths == null) {
            return this.cellWidth * this.cols;
        }
        int total = 0;
        for (int a = 0; a < this.cellWidths.length; ++a) {
            total += this.cellWidths[a];
        }
        return total;
    }

    private int getTotalHeight() {
        return this.cellHeight * this.rows;
    }

    private void setSize() {
        int totalWidth = this.getTotalWidth();
        int totalHeight = this.getTotalHeight();
        this.setSize(totalWidth, totalHeight);
        this.sendEvent("setsize", new String[]{"w=" + totalWidth, "h=" + totalHeight});
    }

    @Override
    public void setBorder(boolean state) {
        this.border = state;
        if (this.border) {
            this.addClass("border");
        } else {
            this.removeClass("border");
        }
    }

    public void setSelectionMode(int mode) {
        this.sel_mode = mode;
    }

    public int getSelectionMode() {
        return this.sel_mode;
    }

    public void setHeader(boolean state) {
        this.has_header = state;
    }

    public boolean getHeader() {
        return this.has_header;
    }

    @Override
    public String html() {
        StringBuilder sb = new StringBuilder();
        sb.append("<div" + this.getAttrs() + ">");
        Component[] cells = this.getAll();
        for (int a = 0; a < cells.length; ++a) {
            Cell cell = (Cell)cells[a];
            sb.append(cell.html());
        }
        sb.append("</div>");
        return sb.toString();
    }

    public void add(Component comp, int x, int y) {
        this.add(comp, x, y, 1, 1);
    }

    public void add(Component comp, int x, int y, int spanx, int spany) {
        Cell cell = new Cell(comp, this.border);
        cell.x = x;
        cell.y = y;
        cell.spanx = spanx;
        cell.spany = spany;
        cell.addClickListener(this);
        this.add(cell);
    }

    public void addRow() {
        ++this.rows;
        this.setSize();
    }

    public void addRow(Component[] cmps) {
        int x = 0;
        int y = this.rows;
        this.addRow();
        for (Component c : cmps) {
            this.add(c, x, y);
            ++x;
        }
    }

    public void addRow(String[] strs) {
        int x = 0;
        int y = this.rows;
        this.addRow();
        for (String s : strs) {
            this.add(new Label(s), x, y);
            ++x;
        }
    }

    public void addColumn() {
        if (this.cellWidths != null) {
            return;
        }
        ++this.cols;
        this.setSize();
    }

    public void addColumn(int width) {
        if (this.cellWidths == null) {
            return;
        }
        int idx = this.cellWidths.length;
        this.cellWidths = Arrays.copyOf(this.cellWidths, this.cellWidths.length + 1);
        this.cellWidths[idx] = width;
        ++this.cols;
        this.setSize();
    }

    public void addColumn(Component[] cmps) {
        int x = this.cols;
        int y = 0;
        this.addColumn();
        for (Component c : cmps) {
            this.add(c, x, y);
            ++y;
        }
    }

    public void addColumn(String[] strs) {
        int x = this.cols;
        int y = 0;
        this.addColumn();
        for (String s : strs) {
            this.add(new Label(s), x, y);
            ++y;
        }
    }

    public void setTableSize(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
        this.setSize();
    }

    @Override
    public void remove(Component c) {
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            Cell cell = (Cell)this.get(a);
            if (cell.get(0) != c) continue;
            super.remove(cell);
            cell.sendEvent("remove", new String[]{"child=" + cell.id});
            return;
        }
    }

    public Component remove(int x, int y) {
        Cell cell = this.getCell(x, y, false);
        if (cell != null) {
            super.remove(cell);
            cell.sendEvent("remove", new String[]{"child=" + cell.id});
            return cell.get(0);
        }
        return null;
    }

    public void removeRow(int row) {
        int cnt = this.count();
        if (this.has_header) {
            ++row;
        }
        int a = 0;
        while (a < cnt) {
            Cell cell = (Cell)this.get(a);
            Component c = cell.get(0);
            if (cell.y == row) {
                this.remove(c);
                --cnt;
                continue;
            }
            if (cell.y > row) {
                --cell.y;
            }
            ++a;
        }
        --this.rows;
    }

    public void removeColumn(int col) {
        int cnt = this.count();
        int a = 0;
        while (a < cnt) {
            Cell cell = (Cell)this.get(a);
            Component c = cell.get(0);
            if (cell.x == col) {
                this.remove(c);
                --cnt;
                continue;
            }
            if (cell.x > col) {
                --cell.x;
            }
            ++a;
        }
        --this.cols;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.rows = 0;
        this.setSize();
    }

    public void setSpans(int x, int y, int spanx, int spany) {
        if (this.cellWidths != null) {
            return;
        }
        Cell cell = this.getCell(x, y, false);
        if (cell == null) {
            return;
        }
        cell.spanx = spanx;
        cell.spany = spany;
        cell.sendEvent("setsize", new String[]{"w=" + spanx * this.cellWidth, "h=" + spany * this.cellHeight});
    }

    private Cell getCell(int x, int y, boolean checkSpans) {
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            Cell cell = (Cell)this.get(a);
            int x1 = cell.x;
            int y1 = cell.y;
            int x2 = x1;
            int y2 = y1;
            if (checkSpans) {
                x2 += cell.spanx - 1;
                y2 += cell.spany - 1;
            }
            if (x < x1 || x > x2 || y < y1 || y > y2) continue;
            return cell;
        }
        return null;
    }

    public Component get(int x, int y, boolean checkSpans) {
        Cell cell = this.getCell(x, y, checkSpans);
        if (cell == null) {
            return null;
        }
        return cell.get(0);
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    private Cell getCell(int idx) {
        return (Cell)this.get(idx);
    }

    public int getSelectedRow() {
        int cnt = this.count();
        for (int idx = 0; idx < cnt; ++idx) {
            Cell cell = this.getCell(idx);
            if (!cell.isSelected()) continue;
            return this.has_header ? cell.y - 1 : cell.y;
        }
        return -1;
    }

    public int getSelectedColumn() {
        int cnt = this.count();
        for (int idx = 0; idx < cnt; ++idx) {
            Cell cell = this.getCell(idx);
            if (!cell.isSelected()) continue;
            return cell.x;
        }
        return -1;
    }

    @Override
    public void onClick(MouseEvent me, Component cmp) {
        block17: {
            Cell cell;
            block16: {
                cell = (Cell)cmp;
                if (this.has_header && cell.y == 0) {
                    return;
                }
                if (!me.ctrlKey) break block16;
                switch (this.sel_mode) {
                    case 0: {
                        cell.setSelected(!cell.isSelected());
                        break;
                    }
                    case 1: {
                        int y = cell.y;
                        int cnt = this.count();
                        for (int idx = 0; idx < cnt; ++idx) {
                            Cell o = this.getCell(idx);
                            if (cell.y != y) continue;
                            o.setSelected(!o.isSelected());
                        }
                        break block17;
                    }
                    case 2: {
                        int x = cell.x;
                        int cnt = this.count();
                        for (int idx = 0; idx < cnt; ++idx) {
                            Cell o = this.getCell(idx);
                            if (cell.x != x) continue;
                            o.setSelected(!o.isSelected());
                        }
                        break block17;
                    }
                }
                break block17;
            }
            switch (this.sel_mode) {
                case 0: {
                    int cnt = this.count();
                    for (int idx = 0; idx < cnt; ++idx) {
                        Cell o;
                        o.setSelected((o = this.getCell(idx)) == cell);
                    }
                    break;
                }
                case 1: {
                    int y = cell.y;
                    int cnt = this.count();
                    for (int idx = 0; idx < cnt; ++idx) {
                        Cell o = this.getCell(idx);
                        o.setSelected(o.y == y);
                    }
                    break;
                }
                case 2: {
                    int x = cell.x;
                    int cnt = this.count();
                    for (int idx = 0; idx < cnt; ++idx) {
                        Cell o = this.getCell(idx);
                        o.setSelected(o.x == x);
                    }
                    break;
                }
            }
        }
        this.onChanged(null);
    }

    private class Cell
    extends Block {
        public int x;
        public int y;
        public int spanx;
        public int spany;
        private boolean border;
        private boolean selected;

        public Cell(Component comp, boolean border) {
            this.border = border;
            this.setClass("cell");
            this.add(comp);
            if (border) {
                this.addClass("border");
            }
        }

        @Override
        public String html() {
            this.setSize(this.spanx * Table.this.getColWidth(this.x), this.spany * Table.this.cellHeight);
            this.setStyle("left", Integer.toString(Table.this.getColPosition(this.x)));
            this.setStyle("top", Integer.toString(this.y * Table.this.cellHeight));
            StringBuilder sb = new StringBuilder();
            sb.append("<div" + this.getAttrs() + ">");
            sb.append(this.get(0).html());
            sb.append("</div>");
            return sb.toString();
        }

        @Override
        public void setBorder(boolean state) {
            this.border = state;
            if (this.border) {
                this.addClass("border");
            } else {
                this.removeClass("border");
            }
        }

        public Component getComponent() {
            return this.get(0);
        }

        public void setSelected(boolean state) {
            this.selected = state;
            if (state) {
                this.sendEvent("addclass", new String[]{"cls=selected"});
            } else {
                this.sendEvent("delclass", new String[]{"cls=selected"});
            }
        }

        public boolean isSelected() {
            return this.selected;
        }
    }
}

