/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import javaforce.JFLog;
import javaforce.service.WebSocket;
import javaforce.webui.Component;
import javaforce.webui.Menu;
import javaforce.webui.Panel;
import javaforce.webui.PopupMenu;
import javaforce.webui.WebUIHandler;
import javaforce.webui.WebUIServer;
import javaforce.webui.event.Resized;

public class WebUIClient {
    public WebSocket socket;
    public Panel root;
    public String hash;
    public int nextID;
    public int zIndex = 1;
    public int width;
    public int height;
    public boolean isReady;
    public boolean popupMenuMouseDown;
    public PopupMenu topPopupMenu;
    private WebUIHandler handler;
    private OutputStream os;
    private Object pingLock = new Object();
    private Object lock = new Object();
    private int tid = 1;
    private HashMap<String, Object> map = new HashMap();
    private Resized resized;

    public WebUIClient(WebSocket socket, WebUIHandler handler) {
        this.socket = socket;
        this.handler = handler;
        this.hash = Integer.toString(this.hashCode(), 16);
    }

    public synchronized int getNextID() {
        return this.nextID++;
    }

    public void setSocket(WebSocket socket) {
        this.socket = socket;
    }

    public Panel getPanel() {
        return this.root;
    }

    public Component getComponent(String name) {
        return this.root.getComponent(name);
    }

    public void setPanel(Panel root) {
        this.root = root;
        this.initPanel();
        try {
            this.dispatchEvent("", "load", null);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void refresh() {
        this.root = null;
        this.sendEvent("body", "redir", null);
    }

    private void initPanel() {
        this.root.setClient(this);
        this.root.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(String id, String event, String[] args) {
        if (id.length() == 0 || id.equals("body")) {
            switch (event) {
                case "load": {
                    if (this.root == null) {
                        this.root = this.handler.getRootPanel(this);
                        this.initPanel();
                    }
                    this.isReady = true;
                    String html = this.root.html();
                    this.sendEvent("body", "sethtml", new String[]{"html=" + html});
                    this.sendEvent("body", "setroot", new String[]{"root=" + this.root.id});
                    this.root.events();
                    break;
                }
                case "mousedown": {
                    Menu.onMouseDownBody(this, args);
                    break;
                }
                case "size": {
                    for (int a = 0; a < args.length; ++a) {
                        if (args[a].startsWith("w=")) {
                            this.width = Integer.valueOf(args[a].substring(2));
                        }
                        if (!args[a].startsWith("h=")) continue;
                        this.height = Integer.valueOf(args[a].substring(2));
                    }
                    if (WebUIServer.debug) {
                        JFLog.log("size=" + this.width + "x" + this.height);
                    }
                    if (this.resized == null) break;
                    this.resized.onResized(null, this.width, this.height);
                    break;
                }
                case "onloaded": {
                    this.root.dispatchEvent(event, args);
                    break;
                }
                case "pong": {
                    Object object = this.pingLock;
                    synchronized (object) {
                        this.pingLock.notify();
                        break;
                    }
                }
            }
        } else {
            Component c = this.root.get(id);
            if (c != null) {
                c.dispatchEvent(event, args);
            } else {
                JFLog.log("Error:Component not found:" + id);
            }
        }
    }

    public void dispatchData(byte[] data) {
        if (this.os != null) {
            try {
                this.os.write(data);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping(int ms) {
        Object object = this.pingLock;
        synchronized (object) {
            this.sendEvent("body", "ping", null);
            try {
                this.pingLock.wait(ms);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String stringify(String in) {
        StringBuilder sb = new StringBuilder();
        char[] ca = in.toCharArray();
        int len = ca.length;
        sb.append("\"");
        block6: for (int a = 0; a < len; ++a) {
            char ch = ca[a];
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block6;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block6;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block6;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                default: {
                    if (ch < ' ') {
                        sb.append(String.format("\\u%04x", ch));
                        continue block6;
                    }
                    sb.append(ch);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(byte[] data) {
        if (!this.isReady) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.socket.write(data, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(byte[] data, int pos, int length) {
        if (!this.isReady) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.socket.write(Arrays.copyOfRange(data, pos, pos + length), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void sendEvent(String id, String event, String[] args) {
        if (!this.isReady) {
            return;
        }
        if (id == null) {
            JFLog.log("WebUIClient:Error:sendEvent():id==null");
            return;
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder log = new StringBuilder();
        String str = "{\"event\":\"" + event + "\"";
        sb.append(str);
        log.append(str);
        if (id != null) {
            str = ",\"id\":\"" + id + "\"";
            sb.append(str);
            log.append(str);
        }
        if (WebUIServer.debug_tid) {
            str = ",\"tid\":\"" + this.tid++ + "\"";
            sb.append(str);
            log.append(str);
        }
        if (args != null) {
            for (String string : args) {
                void var9_11;
                int idx = string.indexOf("=");
                if (idx == -1) {
                    idx = string.length();
                    String string2 = string + "=true";
                }
                String key = var9_11.substring(0, idx);
                String value = var9_11.substring(idx + 1);
                str = ",\"" + key + "\":" + this.stringify(value);
                sb.append(str);
                if (key.equals("html")) {
                    log.append(",\"" + key + "\":\"...\"");
                    continue;
                }
                log.append(str);
            }
        }
        sb.append("}");
        log.append("}");
        if (WebUIServer.debug) {
            JFLog.log("SEND=" + log.toString());
        }
        try {
            Object cnt = this.lock;
            synchronized (cnt) {
                this.socket.write(sb.toString().getBytes("utf-8"));
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDataEvent(byte[] data, String id, String event, String[] args) {
        if (!this.isReady) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.sendData(data);
            this.sendEvent(id, event, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDataEvent(byte[] data, int pos, int length, String id, String event, String[] args) {
        if (!this.isReady) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.sendData(data, pos, length);
            this.sendEvent(id, event, args);
        }
    }

    public String html() {
        return this.root.html();
    }

    public void close() {
    }

    public void setProperty(String key, Object value) {
        this.map.put(key, value);
    }

    public Object getProperty(String key) {
        return this.map.get(key);
    }

    public HashMap<String, Object> getProperties() {
        return this.map;
    }

    public int getZIndex() {
        return this.zIndex++;
    }

    public void releaseZIndex() {
        --this.zIndex;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public void setTitle(String title) {
        this.sendEvent("body", "settitle", new String[]{"title=" + title});
    }

    public int getCurrentID() {
        if (!this.isConnected()) {
            return -1;
        }
        return this.nextID;
    }

    public void addResizedListener(Resized handler) {
        this.resized = handler;
    }

    public void openURL(String url) {
        this.sendEvent(this.root.id, "openurl", new String[]{"url=" + url});
    }

    public void setOutputStream(OutputStream os) {
        this.os = os;
    }
}

