/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import javaforce.JFLog;

public class UByte {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 255;
    public static final int MASK = 255;
    private byte value;

    public UByte(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public static byte valueOf(String s, int radix) throws NumberFormatException {
        int value = Integer.parseUnsignedInt(s, radix);
        if (value < 0 || value > 255) {
            throw new NumberFormatException("UByte:value out of range");
        }
        return (byte)value;
    }

    public static byte valueOf(String s) {
        return UByte.valueOf(s, 10);
    }

    public static String toString(byte value, int radix) {
        return Integer.toString(value & 0xFF, radix);
    }

    public static String toString(byte value) {
        return UByte.toString(value, 10);
    }

    public static int compare(byte v1, byte v2) {
        return Byte.compareUnsigned(v1, v2);
    }

    public static void main(String[] args) {
        byte val = 0;
        for (int a = 0; a < 16; ++a) {
            String str = UByte.toString(val, 16);
            byte v2 = UByte.valueOf(str, 16);
            JFLog.log("byte:" + (val & 0xFF) + " > " + str + " > " + (v2 & 0xFF));
            val = (byte)(val + 17);
        }
    }
}

