/*
 * Decompiled with CFR 0.152.
 */
package javaforce.linux;

import javaforce.JFLog;
import javaforce.ShellProcess;

public class ServiceControl {
    public static boolean start(String name) {
        ShellProcess sp = new ShellProcess();
        String output = sp.run(new String[]{"/usr/bin/systemctl", "start", name}, true);
        JFLog.log(output);
        return sp.getErrorLevel() == 0;
    }

    public static boolean stop(String name) {
        ShellProcess sp = new ShellProcess();
        String output = sp.run(new String[]{"/usr/bin/systemctl", "stop", name}, true);
        JFLog.log(output);
        return sp.getErrorLevel() == 0;
    }

    public static boolean restart(String name) {
        ShellProcess sp = new ShellProcess();
        String output = sp.run(new String[]{"/usr/bin/systemctl", "restart", name}, true);
        JFLog.log(output);
        return sp.getErrorLevel() == 0;
    }

    public static boolean enable(String name) {
        ShellProcess sp = new ShellProcess();
        String output = sp.run(new String[]{"/usr/bin/systemctl", "enable", name}, true);
        JFLog.log(output);
        return sp.getErrorLevel() == 0;
    }

    public static boolean disable(String name) {
        ShellProcess sp = new ShellProcess();
        String output = sp.run(new String[]{"/usr/bin/systemctl", "disable", name}, true);
        JFLog.log(output);
        return sp.getErrorLevel() == 0;
    }

    public static boolean isEnabled(String name) {
        String[] lns;
        ShellProcess sp = new ShellProcess();
        String output = sp.run(new String[]{"/usr/bin/systemctl", "status", name}, true);
        JFLog.log(output);
        boolean enabled = false;
        boolean active = false;
        for (String ln : lns = output.split("\n")) {
            if ((ln = ln.trim()).startsWith("Loaded:")) {
                int i1 = ln.indexOf(59);
                int i2 = ln.indexOf(59, i1 + 1);
                String state = ln.substring(i1 + 1, i2);
                enabled = state.trim().equals("enabled");
                continue;
            }
            if (!ln.startsWith("Active:")) continue;
            ln = ln.substring(7).trim();
            active = ln.startsWith("active");
        }
        return enabled;
    }

    public static boolean isActive(String name) {
        String[] lns;
        ShellProcess sp = new ShellProcess();
        String output = sp.run(new String[]{"/usr/bin/systemctl", "status", name}, true);
        JFLog.log(output);
        boolean enabled = false;
        boolean active = false;
        for (String ln : lns = output.split("\n")) {
            if ((ln = ln.trim()).startsWith("Loaded:")) {
                int i1 = ln.indexOf(59);
                int i2 = ln.indexOf(59, i1 + 1);
                String state = ln.substring(i1 + 1, i2);
                enabled = state.trim().equals("enabled");
                continue;
            }
            if (!ln.startsWith("Active:")) continue;
            ln = ln.substring(7).trim();
            active = ln.startsWith("active");
        }
        return active;
    }

    public static String[] getStates(String name) {
        String[] lns;
        ShellProcess sp = new ShellProcess();
        String output = sp.run(new String[]{"/usr/bin/systemctl", "status", name}, true);
        JFLog.log(output);
        String enabled = "n/a";
        String active = "n/a";
        for (String ln : lns = output.split("\n")) {
            if ((ln = ln.trim()).startsWith("Loaded:")) {
                String state;
                int i1 = ln.indexOf(59);
                int i2 = ln.indexOf(59, i1 + 1);
                if (i2 == -1) {
                    i2 = ln.indexOf(41, i1 + 1);
                }
                switch (state = ln.substring(i1 + 1, i2).trim()) {
                    case "enabled": {
                        enabled = "true";
                        break;
                    }
                    case "disabled": {
                        enabled = "false";
                        break;
                    }
                    default: {
                        enabled = state;
                        break;
                    }
                }
                continue;
            }
            if (!ln.startsWith("Active:")) continue;
            active = (ln = ln.substring(7).trim()).startsWith("active") ? "true" : "false";
        }
        String[] states = new String[]{name, enabled, active};
        return states;
    }
}

