/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ShellProcess;
import javaforce.utils.BuildTools;
import javaforce.utils.WixHeat;

public class GenMSI {
    private BuildTools tools;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage:GenMSI build.xml");
            System.exit(1);
        }
        try {
            new GenMSI().run(args[0]);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void run(String buildfile) throws Exception {
        String heat_home;
        this.tools = new BuildTools();
        if (!this.tools.loadXML(buildfile)) {
            throw new Exception("error loading " + buildfile);
        }
        String home = this.tools.getProperty("home");
        String app = this.tools.getProperty("app");
        Object apptype = this.tools.getProperty("apptype");
        String version = this.tools.getProperty("version");
        String jre = this.tools.getProperty("jre");
        jre = jre.replaceAll("\\$\\{home\\}", home);
        String msi = this.tools.getProperty("msi");
        if (msi.length() == 0) {
            msi = app;
        }
        if ((heat_home = this.tools.getProperty("heat_home")).length() == 0) {
            heat_home = "jre";
        }
        String candle_extra = this.tools.getProperty("candle_extra");
        String light_extra = this.tools.getProperty("light_extra");
        String ffmpeg_version = this.tools.getVersion("ffmpeg-version");
        String ffmpeg_folder = home + "/ffmpeg-bin/" + ffmpeg_version;
        switch (apptype) {
            case "client": 
            case "server": {
                apptype = "-" + (String)apptype;
                break;
            }
            default: {
                apptype = "";
            }
        }
        String out = msi + (String)apptype + "-" + version + "-win64.msi";
        String pdb = msi + (String)apptype + "-" + version + "-win64.wixpdb";
        try {
            ShellProcess.Output output;
            String[] extra;
            String[] cmd = new String[]{"wix", "build", "-arch", "x64", "-ext", "WixToolset.UI.wixext", "-ext", "WixToolset.Firewall.wixext", "-ext", "WixToolset.Util.wixext", "-o", "app.wixlib", "wix64.xml"};
            if (candle_extra.length() > 0) {
                for (String x : extra = candle_extra.split(" ")) {
                    cmd = JF.copyOfInsert(cmd, cmd.length, x);
                }
            }
            if ((output = ShellProcess.exec(cmd, true)) == null) {
                throw new Exception("error");
            }
            System.out.println(output.stdout);
            if (output.errorLevel > 0) {
                throw new Exception("error");
            }
            WixHeat.main(new String[]{jre, "jre.xml", "JRE", heat_home});
            ShellProcess.Output output2 = ShellProcess.exec(new String[]{"wix", "build", "-arch", "x64", "-o", "jre.wixlib", "jre.xml"}, true);
            if (output2 == null) {
                throw new Exception("error");
            }
            System.out.println(output2.stdout);
            if (output2.errorLevel > 0) {
                throw new Exception("error");
            }
            WixHeat.main(new String[]{ffmpeg_folder, "ffmpeg.xml", "FFMPEG", "."});
            output2 = ShellProcess.exec(new String[]{"wix", "build", "-arch", "x64", "-o", "ffmpeg.wixlib", "ffmpeg.xml"}, true);
            if (output2 == null) {
                throw new Exception("error");
            }
            System.out.println(output2.stdout);
            if (output2.errorLevel > 0) {
                throw new Exception("error");
            }
            WixHeat.main(new String[]{home + "/jre_base/bin", "msvcrt.xml", "MSVCRT", ".", "**/api*.dll", "**/msvc*.dll", "**/ucrtbase.dll", "**/vcruntime*.dll"});
            output2 = ShellProcess.exec(new String[]{"wix", "build", "-arch", "x64", "-o", "msvcrt.wixlib", "msvcrt.xml"}, true);
            if (output2 == null) {
                throw new Exception("error");
            }
            System.out.println(output2.stdout);
            if (output2.errorLevel > 0) {
                throw new Exception("error");
            }
            cmd = new String[]{"wix", "build", "-arch", "x64", "-ext", "WixToolset.UI.wixext", "-ext", "WixToolset.Firewall.wixext", "-ext", "WixToolset.Util.wixext", "-culture", "en-us", "-b", home, "-b", jre, "-b", jre + "/bin", "-b", ffmpeg_folder, "-bv", "WixUILicenseRtf=" + home + "/license.rtf", "-o", out, "app.wixlib", "jre.wixlib", "ffmpeg.wixlib", "msvcrt.wixlib"};
            if (light_extra.length() > 0) {
                for (String x : extra = light_extra.split(" ")) {
                    cmd = JF.copyOfInsert(cmd, cmd.length, x);
                }
            }
            if ((output = ShellProcess.exec(cmd, true)) == null) {
                throw new Exception("error");
            }
            System.out.println(output.stdout);
            if (output.errorLevel > 0) {
                throw new Exception("error");
            }
            new File("app.wixlib").delete();
            new File("jre.wixlib").delete();
            new File("jre.xml").delete();
            new File("ffmpeg.wixlib").delete();
            new File("ffmpeg.xml").delete();
            new File("msvcrt.wixlib").delete();
            new File("msvcrt.xml").delete();
            new File(pdb).delete();
            if (new File(home + "/repo/windows/amd64/readme.txt").exists() && !JF.moveFile(out, home + "/repo/windows/amd64/" + out)) {
                throw new Exception("move failed");
            }
            System.out.println(out + " created!");
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String getArch() {
        String arch = System.getenv("HOSTTYPE");
        if (arch == null && (arch = System.getProperty("os.arch")) == null) {
            JFLog.log("Error:Unable to detect CPU from env:HOSTTYPE or property:os.arch");
        }
        switch (arch) {
            case "x86_64": {
                return "amd64";
            }
            case "aarch64": {
                return "arm64";
            }
        }
        return arch;
    }

    public static String getArchExt() {
        return GenMSI.getArch();
    }
}

