/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.Serializable;
import javaforce.vm.Address;

public class Controller
extends Address
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String type;
    public String model;

    public Controller(String type, String model) {
        this.type = type;
        this.model = model;
    }

    public Controller(String type, String model, String addr_type, String domain, String bus, String slot, String function) {
        this.type = type;
        this.model = model;
        this.addr_type = addr_type;
        this.domain = domain;
        this.bus = bus;
        this.slot = slot;
        this.function = function;
    }

    public static String[] get_scsi_models() {
        return new String[]{"auto", "buslogic", "ibmvscsi", "lsilogic", "lsisas1068", "lsisas1078", "virtio-scsi", "vmpvscsi", "virtio-transitional", "virtio-non-transitional", "ncr53c90", "am53c974", "dc390"};
    }

    public static String[] get_usb_models() {
        return new String[]{"auto", "piix3-uhci", "piix4-uhci", "ehci", "ich9-ehci1", "ich9-uhci1", "ich9-uhci2", "ich9-uhci3", "vt82c686b-uhci", "pci-ohci", "nec-xhci", "qusb1", "qusb2", "qemu-xhci"};
    }

    public static String[] get_ide_models() {
        return new String[]{"auto", "piix3", "piix4", "ich6"};
    }

    public String toString() {
        return this.type + ":" + this.model;
    }

    public String toXML() {
        StringBuilder xml = new StringBuilder();
        if (this.type == null || this.type.equals("auto")) {
            return "";
        }
        xml.append("<controller type='" + this.type + "' model='" + this.model + "'>");
        if (!this.type.endsWith("-root")) {
            xml.append(this.getAddressXML());
        }
        xml.append("</controller>");
        return xml.toString();
    }
}

