/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.net.InetAddress;
import java.util.HashMap;
import javaforce.HTTP;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.STUN;
import javaforce.voip.RTP;
import javaforce.voip.RTSP;
import javaforce.voip.RTSPInterface;
import javaforce.voip.RTSPServerInterface;
import javaforce.voip.RTSPSession;
import javaforce.voip.SIP;
import javaforce.voip.TransportType;

public class RTSPServer
extends RTSP
implements RTSPInterface,
STUN.Listener {
    private RTSPServerInterface iface;
    private String localhost;
    private int localport;
    private static NAT nat = NAT.None;
    private static boolean useNATOnPrivateNetwork = false;
    private static String stunHost;
    private static String stunUser;
    private static String stunPass;
    private boolean use_qop = false;
    private static final String realm = "javaforce";
    private boolean active = true;
    private WorkerKeepAlive keepAlive;
    public Object userobj;
    public int expires;
    private Object clientsLock = new Object();
    private HashMap<String, RTSPSession> clients = new HashMap();
    private STUN stun;
    private final Object stunLock = new Object();
    private volatile boolean stunWaiting = false;
    private volatile boolean stunResponse = false;
    private static RTSPSession[] RTSPSessionArrayType;
    private byte[] nullmsg = new byte[4];

    public boolean init(int localport, RTSPServerInterface iface, TransportType type) {
        this.iface = iface;
        if (localport == -1) {
            localport = 554;
        }
        this.localport = localport;
        try {
            JFLog.log(this.log, "localhost = " + this.localhost);
            if (nat == NAT.STUN || nat == NAT.ICE) {
                this.startSTUN();
            }
            this.keepAlive = new WorkerKeepAlive();
            this.keepAlive.start();
            return super.init(this.localhost, localport, this, true, type);
        }
        catch (Exception e) {
            if (this.stun != null) {
                this.stopSTUN();
            }
            JFLog.log(this.log, (Throwable)e);
            return false;
        }
    }

    @Override
    public void uninit() {
        if (nat == NAT.STUN || nat == NAT.ICE) {
            this.stopSTUN();
        }
        this.active = false;
        super.uninit();
    }

    public static void setNAT(NAT nat, String host, String user, String pass) {
        RTSPServer.nat = nat;
        stunHost = host;
        stunUser = user;
        stunPass = pass;
    }

    public static void useNATOnPrivateNetwork(boolean state) {
        useNATOnPrivateNetwork = state;
    }

    public static boolean isPrivateNetwork(String ip) {
        if (ip.startsWith("192.168.")) {
            return true;
        }
        if (ip.startsWith("10.")) {
            return true;
        }
        if (ip.startsWith("169.254.")) {
            return true;
        }
        for (int a = 16; a <= 31; ++a) {
            if (!ip.startsWith("172." + a + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getlocalRTPhost(RTSPSession sess) {
        if (RTP.useTURN) {
            return RTP.getTurnIP();
        }
        return sess.localhost;
    }

    private boolean startSTUN() {
        this.stun = new STUN();
        return this.stun.start(this.localport, stunHost, stunUser, stunPass, this);
    }

    private void stopSTUN() {
        if (this.stun == null) {
            return;
        }
        this.stun.close();
        this.stun = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stunPublicIP(STUN stun, String ip, int port) {
        Object object = this.stunLock;
        synchronized (object) {
            if (this.stunWaiting) {
                this.stunResponse = true;
                this.stunLock.notify();
            }
        }
    }

    @Override
    public void turnAlloc(STUN stun, String ip, int port, byte[] token, int lifetime) {
    }

    @Override
    public void turnBind(STUN stun) {
    }

    @Override
    public void turnRefresh(STUN stun, int lifetime) {
    }

    @Override
    public void turnFailed(STUN stun) {
    }

    @Override
    public void turnData(STUN stun, byte[] data, int offset, int length, short channel) {
    }

    public boolean reply(RTSPSession sess, int code, String msg, String header) {
        JFLog.log(this.log, "issue reply : " + code + ":" + sess);
        sess.reply = code;
        StringBuilder req = new StringBuilder();
        req.append("RTSP/1.0 " + code + " " + msg + "\r\n");
        req.append("Cseq: " + sess.cseq + "\r\n");
        req.append("User-Agent: " + useragent + "\r\n");
        if (sess.epass != null) {
            req.append(sess.epass);
        }
        if (sess.transport != null) {
            req.append(sess.transport);
        }
        if (sess.accept != null) {
            req.append("Accept: " + sess.accept + "\r\n");
        }
        if (header != null) {
            req.append(header);
        }
        if (sess.sdp != null) {
            String post = String.join((CharSequence)"\r\n", sess.sdp) + "\r\n";
            req.append("Content-Type: application/sdp\r\n");
            req.append("Content-Length: " + post.length() + "\r\n\r\n");
            req.append(post);
        } else if (sess.params != null) {
            String post = String.join((CharSequence)"\r\n", sess.params) + "\r\n";
            req.append("Content-Type: text/plain\r\n");
            req.append("Content-Length: " + post.length() + "\r\n\r\n");
            req.append(post);
        } else {
            req.append("Content-Length: 0\r\n\r\n");
        }
        return this.send(sess.remoteaddr, sess.remoteport, req.toString());
    }

    public boolean reply(RTSPSession sess, int reply, String msg) {
        return this.reply(sess, reply, msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RTSPSession getSession(String host, int port, String id) {
        RTSPSession sess;
        Object object = this.clientsLock;
        synchronized (object) {
            sess = this.clients.get(id);
        }
        return sess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RTSPSession createSession(String host, int port, String id) {
        RTSPSession sess;
        Object object = this.clientsLock;
        synchronized (object) {
            sess = this.clients.get(id);
            if (sess == null) {
                sess = new RTSPSession(this.localhost, this.localport);
                sess.remotehost = host;
                sess.remoteport = port;
                sess.ts = System.currentTimeMillis();
                this.clients.put(id, sess);
            }
        }
        return sess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTSPSession[] getSessions() {
        Object object = this.clientsLock;
        synchronized (object) {
            return this.clients.values().toArray(RTSPSessionArrayType);
        }
    }

    public String[] getTransportClients() {
        return this.transport.getClients();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onPacket(RTSP rtsp, String[] msg, String remoteip, int remoteport) {
        String id = remoteip + ":" + remoteport;
        try {
            RTSPSession sess = this.getSession(remoteip, remoteport, id);
            sess.ts = System.currentTimeMillis();
            String cmd = null;
            if (remoteip.equals("127.0.0.1") && sess.localhost != null) {
                remoteip = sess.localhost;
            }
            sess.remotehost = remoteip;
            sess.remoteaddr = InetAddress.getByName(remoteip);
            sess.remoteport = remoteport;
            sess.remotecseq = this.getcseq(msg);
            sess.id = HTTP.getParameter(msg, "Session");
            int reply = this.getResponseType(msg);
            if (reply != -1) {
                JFLog.log(this.log, "nreply=" + reply + ":" + sess);
            } else {
                cmd = this.getRequest(msg);
                sess.uri = this.getURI(msg);
                JFLog.log(this.log, "request=" + cmd + ":" + sess);
            }
            switch (reply) {
                case -1: {
                    sess.cmd = cmd;
                    switch (cmd) {
                        case "OPTIONS": {
                            String auth = HTTP.getParameter(msg, "Authorization");
                            if (auth == null) {
                                sess.nonce = this.getnonce();
                                String challenge = "WWW-Authenticate: Digest algorithm=MD5, realm=\"javaforce\", nonce=\"" + sess.nonce + "\"";
                                if (this.use_qop) {
                                    challenge = challenge + ", qop=\"auth\"";
                                }
                                challenge = challenge + "\r\n";
                                this.reply(sess, 401, "REQ AUTH", challenge);
                                return;
                            }
                            if (!auth.regionMatches(true, 0, "digest ", 0, 7)) {
                                JFLog.log(this.log, "invalid Authorization");
                                return;
                            }
                            String[] tags = SIP.convertParameters(auth.substring(7), ',');
                            String res = HTTP.getParameter(tags, "response");
                            String nonce = HTTP.getParameter(tags, "nonce");
                            sess.user = HTTP.getParameter(tags, "username");
                            if (nonce == null || sess.nonce == null || !sess.nonce.equals(nonce) || sess.user == null) {
                                sess.nonce = this.getnonce();
                                String challenge = "WWW-Authenticate: Digest algorithm=MD5, realm=\"javaforce\", nonce=\"" + sess.nonce + "\"";
                                if (this.use_qop) {
                                    challenge = challenge + ", qop=\"auth\"";
                                }
                                challenge = challenge + "\r\n";
                                this.reply(sess, 401, "REQ AUTH", challenge);
                                return;
                            }
                            String test = this.getResponse(sess.user, this.iface.getPassword(sess.user), realm, sess.cmd, HTTP.getParameter(tags, "uri"), sess.nonce, HTTP.getParameter(tags, "qop"), HTTP.getParameter(tags, "nc"), HTTP.getParameter(tags, "cnonce"));
                            sess.nonce = null;
                            if (!res.equalsIgnoreCase(test)) {
                                this.reply(sess, 403, "BAD PASSWORD", null);
                                return;
                            }
                            sess.auth = true;
                            this.iface.onOptions(this, sess);
                            return;
                        }
                        case "DESCRIBE": {
                            if (!sess.auth) {
                                JFLog.log(this.log, "!auth");
                                return;
                            }
                            this.iface.onDescribe(this, sess);
                            return;
                        }
                        case "SETUP": {
                            if (!sess.auth) {
                                JFLog.log(this.log, "!auth");
                                return;
                            }
                            String transport = HTTP.getParameter(msg, "Transport");
                            String[] tags = SIP.convertParameters(transport, ';');
                            String client_port = HTTP.getParameter(tags, "client_port");
                            String[] ports = client_port.split("[-]");
                            sess.channel.stream.port = Integer.valueOf(ports[0]);
                            this.iface.onSetup(this, sess);
                            return;
                        }
                        case "PLAY": {
                            if (!sess.auth) {
                                if (!debug) return;
                                JFLog.log(this.log, "!auth");
                                return;
                            }
                            this.iface.onPlay(this, sess);
                            return;
                        }
                        case "TEARDOWN": {
                            if (!sess.auth) {
                                if (!debug) return;
                                JFLog.log(this.log, "!auth");
                                return;
                            }
                            this.iface.onTeardown(this, sess);
                            return;
                        }
                        case "GET_PARAMETER": {
                            this.iface.onGetParameter(this, sess, HTTP.getContent(msg));
                        }
                    }
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            JFLog.log(this.log, (Throwable)e);
        }
    }

    @Override
    public void onConnect(RTSP rtsp, String remoteip, int remoteport) {
        String id = remoteip + ":" + remoteport;
        this.iface.onConnect(this, this.createSession(remoteip, remoteport, id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisconnect(RTSP rtsp, String remoteip, int remoteport) {
        String id = remoteip + ":" + remoteport;
        RTSPSession sess = this.getSession(remoteip, remoteport, id);
        if (sess == null) {
            return;
        }
        this.iface.onDisconnect(this, sess);
        Object object = this.clientsLock;
        synchronized (object) {
            this.clients.remove(id);
        }
    }

    static {
        RTSPSessionArrayType = new RTSPSession[0];
    }

    public static enum NAT {
        None,
        STUN,
        TURN,
        ICE;

    }

    public class WorkerKeepAlive
    extends Thread {
        @Override
        public void run() {
            this.setName("RTSPServer.WorkerKeepAlive");
            while (RTSPServer.this.active) {
                String[] clients;
                JF.sleep(1000);
                long now = System.currentTimeMillis();
                long cut = now - 60000L;
                for (String client : clients = RTSPServer.this.transport.getClients()) {
                    try {
                        int idx = client.indexOf(58);
                        String host = client.substring(0, idx);
                        String portstr = client.substring(idx + 1);
                        int port = Integer.valueOf(portstr);
                        RTSPSession sess = RTSPServer.this.getSession(host, port, client);
                        if (sess == null || sess.ts >= cut) continue;
                        InetAddress hostaddr = InetAddress.getByName(host);
                        RTSPServer.this.transport.disconnect(host, port);
                    }
                    catch (Exception e) {
                        if (!RTSP.debug) continue;
                        JFLog.log(RTSPServer.this.log, (Throwable)e);
                    }
                }
            }
        }
    }
}

