/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.JFLog;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javax.swing.JPopupMenu;

public class JFIcon
extends TimerTask {
    private Timer timer;
    private double scaling;
    private int width;
    private int height;
    private SystemTray tray;
    private TrayIcon icon;
    private PopupMenu menu;
    private JPopupMenu jmenu;
    private JFImage image;
    private JFImage scaled;
    private ActionListener listener;
    private String tooltip;

    public boolean create(JFImage image, PopupMenu menu, ActionListener listener, String tooltip) {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this, 1000L, 1000L);
        this.scaling = JFAWT.getScaling();
        this.width = JFAWT.getWidth();
        this.height = JFAWT.getHeight();
        this.image = image;
        this.menu = menu;
        this.listener = listener;
        this.tooltip = tooltip;
        this.create();
        return true;
    }

    public boolean create(JFImage image, JPopupMenu menu, ActionListener listener, String tooltip) {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this, 1000L, 1000L);
        this.scaling = JFAWT.getScaling();
        this.width = JFAWT.getWidth();
        this.height = JFAWT.getHeight();
        this.image = image;
        this.jmenu = menu;
        this.listener = listener;
        this.tooltip = tooltip;
        this.create();
        return true;
    }

    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.remove();
    }

    private void remove() {
        if (this.tray != null) {
            if (this.icon != null) {
                this.tray.remove(this.icon);
                this.icon.setPopupMenu(null);
                this.icon = null;
            }
            this.tray = null;
        }
    }

    private void create() {
        this.tray = SystemTray.getSystemTray();
        Dimension size = this.tray.getTrayIconSize();
        this.scaled = new JFImage(size.width, size.height);
        this.scaled.fill(0, 0, size.width, size.height, 0, true);
        this.scaled.getGraphics().drawImage(this.image.getImage(), (size.width - this.image.getWidth()) / 2, (size.height - this.image.getHeight()) / 2, null);
        this.icon = new TrayIcon(this.scaled.getImage(), this.tooltip, this.menu);
        this.icon.setImageAutoSize(true);
        this.icon.addActionListener(this.listener);
        if (this.jmenu != null) {
            this.icon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                private void maybeShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        JFIcon.this.jmenu.setLocation(e.getX(), e.getY());
                        JFIcon.this.jmenu.setInvoker(JFIcon.this.jmenu);
                        JFIcon.this.jmenu.setVisible(true);
                    }
                }
            });
        }
        try {
            this.tray.add(this.icon);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    @Override
    public void run() {
        double scaling_now = JFAWT.getScaling();
        int width_now = JFAWT.getWidth();
        int height_now = JFAWT.getHeight();
        if (scaling_now == this.scaling && width_now == this.width && height_now == this.height) {
            return;
        }
        this.scaling = scaling_now;
        this.width = width_now;
        this.height = height_now;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFIcon.this.icon.setImage(JFIcon.this.scaled.getImage());
            }
        });
    }
}

