/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.awt.RFB;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;

public class VNC
extends JFrame
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private RFB rfb;
    private String host;
    private int port;
    private String pass;
    private JFImage image;
    private int buttons;
    public static boolean debug;
    private static boolean fast;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JScrollPane scroll;
    private JToolBar tools;

    public VNC(String host, int port, String pass) {
        this.initComponents();
        this.host = host;
        this.port = port;
        this.pass = pass;
        new Connect().start();
    }

    private void initComponents() {
        this.jButton2 = new JButton();
        this.tools = new JToolBar();
        this.jButton3 = new JButton();
        this.jButton1 = new JButton();
        this.jButton4 = new JButton();
        this.scroll = new JScrollPane();
        this.jButton2.setText("jButton2");
        this.setDefaultCloseOperation(3);
        this.tools.setRollover(true);
        this.jButton3.setText("Refresh");
        this.jButton3.setFocusable(false);
        this.jButton3.setHorizontalTextPosition(0);
        this.jButton3.setVerticalTextPosition(3);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VNC.this.jButton3ActionPerformed(evt);
            }
        });
        this.tools.add(this.jButton3);
        this.jButton1.setText("C+A+D");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VNC.this.jButton1ActionPerformed(evt);
            }
        });
        this.tools.add(this.jButton1);
        this.jButton4.setText("WinKey");
        this.jButton4.setFocusable(false);
        this.jButton4.setHorizontalTextPosition(0);
        this.jButton4.setVerticalTextPosition(3);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VNC.this.jButton4ActionPerformed(evt);
            }
        });
        this.tools.add(this.jButton4);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tools, -1, 400, Short.MAX_VALUE).addComponent(this.scroll));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tools, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroll, -1, 269, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.ctrl_alt_del();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.win_key();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    public static void main(String[] args) {
        String host = null;
        int port = 5900;
        String pass = null;
        if (args.length > 0) {
            host = args[0];
        }
        if (args.length > 1) {
            pass = args[1];
        }
        block10: for (int a = 2; a < args.length; ++a) {
            switch (args[a]) {
                case "--debug": {
                    debug = true;
                    RFB.debug = true;
                    JFImage.debug = true;
                    continue block10;
                }
                case "--fast": {
                    fast = true;
                    continue block10;
                }
                case "--lean": {
                    fast = false;
                }
            }
        }
        if (host == null && (host = JFAWT.getString("Enter VNC Host[:port]", "")) == null) {
            return;
        }
        int idx = host.indexOf(58);
        if (idx != -1) {
            port = Integer.valueOf(host.substring(idx + 1));
            host = host.substring(0, idx);
        }
        if (pass == null && (pass = JFAWT.getString("Enter Password", "")) == null) {
            return;
        }
        final String _host = host;
        final int _port = port;
        final String _pass = pass;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new VNC(_host, _port, _pass).setVisible(true);
            }
        });
    }

    public void setupEvents() {
        this.image.addMouseListener(this);
        this.image.addMouseMotionListener(this);
        this.image.addMouseListener(this);
        this.image.setFocusable(true);
        this.addKeyListener(this);
    }

    public void keyDown(int code, boolean convert) {
        if (convert) {
            code = RFB.convertKeyCode(code);
        }
        this.rfb.writeKeyEvent(code, true);
    }

    public void keyUp(int code, boolean convert) {
        if (convert) {
            code = RFB.convertKeyCode(code);
        }
        this.rfb.writeKeyEvent(code, false);
    }

    public void mouse(int x, int y, int buttons) {
        if (debug) {
            JFLog.log("mouse:" + x + "," + y + ":" + buttons);
        }
        this.rfb.writeMouseEvent(x, y, buttons);
    }

    public void ctrl_alt_del() {
        this.keyDown(17, true);
        this.keyDown(18, true);
        JF.sleep(10);
        this.keyDown(127, true);
        JF.sleep(50);
        this.keyUp(127, true);
        JF.sleep(10);
        this.keyUp(18, true);
        this.keyUp(17, true);
    }

    public void win_key() {
        this.keyDown(17, true);
        JF.sleep(10);
        this.keyDown(27, true);
        JF.sleep(50);
        this.keyUp(27, true);
        JF.sleep(10);
        this.keyUp(17, true);
    }

    public void refresh() {
        if (this.rfb == null) {
            return;
        }
        int width = this.rfb.getWidth();
        int height = this.rfb.getHeight();
        this.rfb.writeBufferUpdateRequest(0, 0, width, height, false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int button = e.getButton();
        this.buttons &= 7;
        switch (button) {
            case 1: {
                this.buttons |= 1;
                break;
            }
            case 2: {
                this.buttons |= 2;
                break;
            }
            case 3: {
                this.buttons |= 4;
            }
        }
        this.mouse(x, y, this.buttons);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int button = e.getButton();
        this.buttons &= 7;
        switch (button) {
            case 1: {
                this.buttons &= 0xE;
                break;
            }
            case 2: {
                this.buttons &= 0xD;
                break;
            }
            case 3: {
                this.buttons &= 0xB;
            }
        }
        this.mouse(x, y, this.buttons);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.buttons &= 7;
        this.mouse(x, y, this.buttons);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.buttons &= 7;
        this.mouse(x, y, this.buttons);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int x = e.getX();
        int y = e.getY();
        int wheel = e.getWheelRotation();
        if (wheel > 0) {
            this.buttons |= 8;
        }
        if (wheel < 0) {
            this.buttons |= 0x10;
        }
        this.mouse(x, y, this.buttons);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        e.consume();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        char ch = e.getKeyChar();
        int code = e.getKeyCode();
        if (debug) {
            JFLog.log("VNC:KeyPressed:" + Integer.toString(ch) + ":" + code);
        }
        if (ch == '\uffff') {
            this.keyDown(code, true);
        } else {
            if (e.isControlDown()) {
                ch = (char)(ch + 96);
            }
            this.keyDown(ch, ch < ' ');
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        char ch = e.getKeyChar();
        int code = e.getKeyCode();
        if (debug) {
            JFLog.log("VNC:KeyReleased:" + Integer.toString(ch) + ":" + code);
        }
        if (ch == '\uffff') {
            this.keyUp(code, true);
        } else {
            if (e.isControlDown()) {
                ch = (char)(ch + 96);
            }
            this.keyUp(ch, ch < ' ');
        }
    }

    static {
        fast = true;
    }

    public class Connect
    extends Thread {
        @Override
        public void run() {
            try {
                while (true) {
                    VNC.this.rfb = new RFB();
                    if (VNC.this.rfb.connect(VNC.this.host, VNC.this.port)) {
                        float server_version = VNC.this.rfb.readVersion();
                        VNC.this.rfb.writeVersion(RFB.VERSION_3_8);
                        byte[] auths = VNC.this.rfb.readAuthTypes();
                        if (auths == null || auths.length == 0) {
                            JFLog.log("VNC:No auth types available");
                            System.exit(0);
                        }
                        VNC.this.rfb.writeAuthType(auths[0]);
                        boolean ok = false;
                        switch (auths[0]) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                ok = true;
                                break;
                            }
                            case 2: {
                                byte[] challenge = VNC.this.rfb.readAuthChallenge();
                                byte[] response = RFB.encodeResponse(challenge, VNC.this.pass.getBytes());
                                VNC.this.rfb.writeAuthResponse(response);
                                ok = VNC.this.rfb.readAuthResult();
                            }
                        }
                        if (ok) {
                            VNC.this.rfb.writeClientInit(true);
                            if (VNC.this.rfb.readServerInit()) {
                                int width = VNC.this.rfb.getWidth();
                                int height = VNC.this.rfb.getHeight();
                                VNC.this.image = new JFImage(width, height);
                                VNC.this.image.setResizeOperation(JFImage.ResizeOperation.NONE);
                                VNC.this.image.fill(0, 0, width, height, -16777216);
                                VNC.this.setupEvents();
                                VNC.this.setSize(width, height);
                                VNC.this.scroll.setViewportView(VNC.this.image);
                                new MainLoop().start();
                                break;
                            }
                        }
                    }
                    JFLog.log("Connection failed...");
                    VNC.this.rfb = null;
                    VNC.this.pass = JFAWT.getString("Enter Password", VNC.this.pass);
                    if (VNC.this.pass != null) continue;
                    VNC.this.dispose();
                    System.exit(0);
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public class MainLoop
    extends Thread {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (fast) {
                VNC.this.rfb.writeEncodingsFast();
            } else {
                VNC.this.rfb.writeEncodingsLean();
            }
            VNC.this.rfb.writePixelFormat();
            int width = VNC.this.rfb.getWidth();
            int height = VNC.this.rfb.getHeight();
            VNC.this.rfb.writeBufferUpdateRequest(0, 0, width, height, false);
            try {
                block9: while (true) {
                    int msg = VNC.this.rfb.readMessageType();
                    switch (msg) {
                        case -1: {
                            VNC.this.dispose();
                            System.exit(0);
                            continue block9;
                        }
                        case 0: {
                            RFB.Rectangle rect = VNC.this.rfb.readBufferUpdate();
                            if (debug) {
                                JFLog.log("VNC:Rectangle Update=" + rect);
                            }
                            int width2 = VNC.this.rfb.getWidth();
                            int height2 = VNC.this.rfb.getHeight();
                            if (rect.newSize) {
                                if (debug) {
                                    JFLog.log("VNC:New Desktop Size:" + width2 + "x" + height2);
                                }
                                VNC.this.image.setSize(width2, height2);
                                VNC.this.rfb.writeBufferUpdateRequest(0, 0, width2, height2, false);
                            } else {
                                if (debug) {
                                    JFLog.log("VNC:DrawRect:" + rect);
                                }
                                VNC.this.image.putPixels(VNC.this.rfb.getBuffer(), rect.x, rect.y, rect.width, rect.height, rect.y * width2 + rect.x, width2);
                                VNC.this.rfb.writeBufferUpdateRequest(0, 0, width2, height2, true);
                            }
                            EventQueue.invokeLater(() -> VNC.this.image.repaint());
                            continue block9;
                        }
                        case 2: {
                            VNC.this.rfb.readBell();
                            continue block9;
                        }
                        case 1: {
                            VNC.this.rfb.readColorMap();
                            continue block9;
                        }
                        case 3: {
                            VNC.this.rfb.readCutText();
                            continue block9;
                        }
                    }
                    JFLog.log("Unknown msg:" + msg);
                }
            }
            catch (Exception e) {
                JFLog.log(e);
                return;
            }
        }
    }
}

