/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl;

import javaforce.JFLog;
import javaforce.gl.Matrix;
import javaforce.gl.Quaternion;

public class Angles3 {
    public float[] v = new float[3];

    public Angles3() {
    }

    public Angles3(float x, float y, float z) {
        this.v[0] = x;
        this.v[1] = y;
        this.v[2] = z;
    }

    public void set(float x, float y, float z) {
        this.v[0] = x;
        this.v[1] = y;
        this.v[2] = z;
    }

    private float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public void set(Quaternion q, Order order) {
        Matrix m = new Matrix();
        m.set(q);
        float[] te = m.m;
        float m11 = te[0];
        float m12 = te[4];
        float m13 = te[8];
        float m21 = te[1];
        float m22 = te[5];
        float m23 = te[9];
        float m31 = te[2];
        float m32 = te[6];
        float m33 = te[10];
        switch (order) {
            case XYZ: {
                this.v[1] = (float)Math.asin(this.clamp(m13, -1.0f, 1.0f));
                if ((double)Math.abs(m13) < 0.9999999) {
                    this.v[0] = (float)Math.atan2(-m23, m33);
                    this.v[2] = (float)Math.atan2(-m12, m11);
                    break;
                }
                this.v[0] = (float)Math.atan2(m32, m22);
                this.v[2] = 0.0f;
                break;
            }
            case YXZ: {
                this.v[0] = (float)Math.asin(-this.clamp(m23, -1.0f, 1.0f));
                if ((double)Math.abs(m23) < 0.9999999) {
                    this.v[1] = (float)Math.atan2(m13, m33);
                    this.v[2] = (float)Math.atan2(m21, m22);
                    break;
                }
                this.v[1] = (float)Math.atan2(-m31, m11);
                this.v[2] = 0.0f;
                break;
            }
            case ZXY: {
                this.v[0] = (float)Math.asin(this.clamp(m32, -1.0f, 1.0f));
                if ((double)Math.abs(m32) < 0.9999999) {
                    this.v[1] = (float)Math.atan2(-m31, m33);
                    this.v[2] = (float)Math.atan2(-m12, m22);
                    break;
                }
                this.v[1] = 0.0f;
                this.v[2] = (float)Math.atan2(m21, m11);
                break;
            }
            case ZYX: {
                this.v[1] = (float)Math.asin(-this.clamp(m31, -1.0f, 1.0f));
                if ((double)Math.abs(m31) < 0.9999999) {
                    this.v[0] = (float)Math.atan2(m32, m33);
                    this.v[2] = (float)Math.atan2(m21, m11);
                    break;
                }
                this.v[0] = 0.0f;
                this.v[2] = (float)Math.atan2(-m12, m22);
                break;
            }
            case YZX: {
                this.v[2] = (float)Math.asin(this.clamp(m21, -1.0f, 1.0f));
                if ((double)Math.abs(m21) < 0.9999999) {
                    this.v[0] = (float)Math.atan2(-m23, m22);
                    this.v[1] = (float)Math.atan2(-m31, m11);
                    break;
                }
                this.v[0] = 0.0f;
                this.v[1] = (float)Math.atan2(m13, m33);
                break;
            }
            case XZY: {
                this.v[2] = (float)Math.asin(-this.clamp(m12, -1.0f, 1.0f));
                if ((double)Math.abs(m12) < 0.9999999) {
                    this.v[0] = (float)Math.atan2(m32, m22);
                    this.v[1] = (float)Math.atan2(m13, m11);
                    break;
                }
                this.v[0] = (float)Math.atan2(-m23, m33);
                this.v[1] = 0.0f;
                break;
            }
            default: {
                JFLog.log("Error:Angles3.set(Quaternion,Order):Unknown order");
            }
        }
    }

    public String toString() {
        return String.format("%.3f,%.3f,%.3f\r\n", Float.valueOf(this.v[0]), Float.valueOf(this.v[1]), Float.valueOf(this.v[2]));
    }

    public static enum Order {
        XYZ,
        YXZ,
        ZXY,
        ZYX,
        YZX,
        XZY;

    }
}

