/*
 * Decompiled with CFR 0.152.
 */
package javaforce.jni;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import javaforce.jni.Library;

public class JFNative {
    public static boolean findLibraries(File[] folders, Library[] libs, String ext, int needed) {
        boolean once = false;
        for (int fn = 0; fn < folders.length; ++fn) {
            File[] files = folders[fn].listFiles();
            if (files == null || files.length == 0) continue;
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    boolean d1 = f1.isDirectory();
                    boolean d2 = f2.isDirectory();
                    if (d1 && d2) {
                        return 0;
                    }
                    if (d1) {
                        return 1;
                    }
                    if (d2) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (int a = 0; a < files.length; ++a) {
                File file = files[a];
                String fileName = files[a].getName();
                if (file.isDirectory() || !fileName.contains(ext)) continue;
                int cnt = 0;
                for (int b = 0; b < libs.length; ++b) {
                    if (!fileName.startsWith(libs[b].name) && !fileName.startsWith("lib" + libs[b].name) || once && libs[b].once) continue;
                    libs[b].path = file.getAbsolutePath();
                    ++cnt;
                    if (!libs[b].once) continue;
                    once = true;
                }
                if (cnt != needed) continue;
                return true;
            }
        }
        return false;
    }
}

