/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javaforce.JF;
import javaforce.service.WebResponse;

public class WebRequest {
    public String request;
    public String[] fields;
    public String[] fields0;
    public InputStream is;
    public String[] cookies;
    public static HashMap<String, Session> sessions = new HashMap();
    public Session session;
    public String serverIP;
    public String remoteIP;
    public int serverPort;
    public int remotePort;
    public String method;

    public Session getSession() {
        return this.session;
    }

    public String getQueryString() {
        int idx = this.fields0[1].indexOf("?");
        if (idx == -1) {
            return "";
        }
        return this.fields0[1].substring(idx + 1);
    }

    public String getURL() {
        int idx = this.fields0[1].indexOf("?");
        if (idx == -1) {
            return this.fields0[1];
        }
        return this.fields0[1].substring(0, idx);
    }

    public String getCookie(String name) {
        name = (String)name + "=";
        for (int a = 0; a < this.cookies.length; ++a) {
            if (!this.cookies[a].startsWith((String)name)) continue;
            return this.cookies[a].substring(((String)name).length());
        }
        return null;
    }

    public String getHeader(String name) {
        name = (String)name + ":";
        for (int a = 0; a < this.fields.length; ++a) {
            if (!this.fields[a].startsWith((String)name)) continue;
            return this.fields[a].substring(((String)name).length()).trim();
        }
        return null;
    }

    private String randomID() {
        Random r = new Random();
        return r.nextLong() + "-" + r.nextLong() + "-" + System.currentTimeMillis();
    }

    void init(WebResponse res) {
        String id;
        ArrayList<String> list = new ArrayList<String>();
        for (int a = 1; a < this.fields.length; ++a) {
            if (!this.fields[a].startsWith("Cookie: ")) continue;
            String[] sets = this.fields[a].substring(8).split(";");
            for (int b = 0; b < sets.length; ++b) {
                list.add(sets[b].trim());
            }
        }
        this.cookies = list.toArray(JF.StringArrayType);
        String orgid = id = this.getCookie("jsession-id");
        if (id == null) {
            id = this.randomID();
            res.addCookie("jsession-id", id);
            this.session = new Session();
            this.session.id = id;
            sessions.put(id, this.session);
        } else {
            this.session = sessions.get(id);
            if (this.session == null) {
                this.session = new Session();
                this.session.id = id;
                sessions.put(id, this.session);
            }
        }
    }

    public String getHost() {
        String host = this.getHeader("Host");
        if (host == null) {
            return "";
        }
        int idx = host.indexOf(":");
        if (idx == -1) {
            return host;
        }
        return host.substring(0, idx);
    }

    public String getLocalAddr() {
        return this.serverIP;
    }

    public int getLocalPort() {
        return this.serverPort;
    }

    public String getRemoteAddr() {
        return this.remoteIP;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getMethod() {
        return this.method;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public static class Session {
        public String id;
        public HashMap<String, Object> props = new HashMap();

        public void setAttribute(String key, Object value) {
            this.props.put(key, value);
        }

        public Object getAttribute(String key) {
            return this.props.get(key);
        }
    }
}

