/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import javaforce.ui.Dimension;
import javaforce.ui.Image;
import javaforce.ui.TextComponent;

public class TextBox
extends TextComponent {
    private Image buffer;

    public TextBox(String text) {
        super(true);
        this.setText(text);
        this.setFocusable(true);
        this.setEditable(true);
    }

    @Override
    public void render(Image image) {
        int x1 = this.getX();
        int y1 = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        if (w == 0 || h == 0) {
            return;
        }
        int adv = this.getFont().getMaxAdvance();
        int fonty = this.getFont().getMaxHeight();
        Dimension size = new Dimension(this.getMaxLength() * adv, fonty);
        size.width += adv;
        if (this.buffer == null || this.buffer.getWidth() < size.width || this.buffer.getHeight() != size.height) {
            this.buffer = new Image(size.width, size.height);
        }
        int bw = this.buffer.getWidth();
        int bh = this.buffer.getHeight();
        super.render(image);
        image.setForeColor(this.getForeColor());
        image.drawBox(x1, y1, w, h);
        int x2 = ++x1 + (w -= 2) - 1;
        int y2 = ++y1 + (h -= 2) - 1;
        int lineheight = size.height;
        int lines = this.getLineCount();
        int cursor_line = this.getCursorLine();
        int line_start = this.getViewY() / lineheight;
        int clip_y = this.getViewY() % lineheight;
        for (int line = line_start; line < lines; ++line) {
            this.buffer.fill(0, 0, size.width, size.height, this.getBackColor().getColor());
            if (this.haveSelection()) {
                int sx1 = -1;
                int sx2 = -1;
                if (line == this.getSelectionStartLine() && line == this.getSelectionEndLine()) {
                    sx1 = this.getSelectionStartOffset() * adv;
                    sx2 = this.getSelectionEndOffset() * adv - 1;
                } else if (line == this.getSelectionStartLine()) {
                    sx1 = this.getSelectionStartOffset() * adv;
                    sx2 = this.getLineLength(line) * adv;
                } else if (line == this.getSelectionEndLine()) {
                    sx1 = 0;
                    sx2 = this.getSelectionEndOffset() * adv - 1;
                } else {
                    sx1 = 0;
                    sx2 = this.getLineLength(line) * adv;
                }
                int sel_width = sx2 - sx1 + 1;
                this.buffer.fill(sx1, 0, sel_width, bh, this.getSelectedColor().getColor());
            }
            this.buffer.setForeColor(this.getForeColor());
            this.buffer.drawText(0, -this.getFont().getMaxAscent(), this.getLineText(line));
            if (this.isFocused() && this.getFont().showCursor() && cursor_line == line) {
                int cx1 = this.getCursorOffset() * adv;
                int cx2 = this.isOverwrite() ? cx1 + adv - 1 : cx1 + 2;
                int cy1 = 0;
                int cy2 = this.getFont().getMaxHeight() - 1;
                int cw = cx2 - cx1 + 1;
                int ch = cy2 - cy1 + 1;
                this.buffer.fill(cx1, cy1, cw, ch);
            }
            if (this.getViewX() + w >= bw) {
                w = bw - this.getViewX();
            }
            if (y1 + lineheight > y2 && (lineheight = y2 - y1 + 1) <= 0) break;
            image.putPixelsBlend(this.buffer.getBuffer(), x1, y1, w, lineheight - clip_y, this.getViewX() + clip_y * bw, bw, true);
            if (clip_y > 0) {
                y1 += lineheight - clip_y;
                clip_y = 0;
                continue;
            }
            y1 += lineheight;
        }
    }
}

