/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javaforce.Compression;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.vm.Controller;
import javaforce.vm.Device;
import javaforce.vm.Disk;
import javaforce.vm.Network;
import javaforce.vm.Size;

public class Hardware
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String pool;
    public String name;
    public String genid;
    public int os;
    public int cores;
    public Size memory;
    public String machine = "pc";
    public String video = "vga";
    public int vram = 16384;
    public ArrayList<Disk> disks;
    public ArrayList<Network> networks;
    public ArrayList<Device> devices;
    public ArrayList<Controller> controllers;
    public boolean bios_efi;
    public boolean bios_secure;
    public boolean video_3d_accel;
    public static final int OS_LINUX = 0;
    public static final int OS_WINDOWS = 1;

    public Hardware() {
        this.pool = "default";
        this.name = "default";
        this.genid = JF.generateUUID();
        this.os = 0;
        this.cores = 2;
        this.memory = new Size(1, 3);
        this.disks = new ArrayList();
        this.networks = new ArrayList();
        this.devices = new ArrayList();
        this.controllers = new ArrayList();
    }

    public Hardware(String pool, String name, int os, int cores, Size memory) {
        this.pool = pool;
        this.name = name;
        this.genid = JF.generateUUID();
        this.os = os;
        this.cores = cores;
        this.memory = memory;
        this.disks = new ArrayList();
        this.networks = new ArrayList();
        this.devices = new ArrayList();
        this.controllers = new ArrayList();
    }

    public static Hardware load(String file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            Hardware hardware = (Hardware)Compression.deserialize(fis, new File(file).length());
            fis.close();
            return hardware;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public synchronized boolean save(String file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            boolean res = Compression.serialize(fos, (Object)this);
            fos.close();
            return res;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public String getPath() {
        return "/volumes/" + this.pool + "/" + this.name;
    }

    public void addNetwork(Network network) {
        this.networks.add(network);
    }

    public void removeNetwork(Network network) {
        this.networks.remove(network);
    }

    public void addDisk(Disk disk) {
        this.disks.add(disk);
    }

    public void removeDisk(Disk disk) {
        this.disks.remove(disk);
    }

    public String getNextDiskName() {
        int num = this.disks.size();
        while (true) {
            String name = "disk" + num;
            boolean ok = true;
            for (Disk disk : this.disks) {
                if (!disk.name.equals(name)) continue;
                ok = false;
            }
            if (ok) {
                return name;
            }
            ++num;
        }
    }

    public boolean hasDisk(String name) {
        for (Disk disk : this.disks) {
            if (!disk.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addDevice(Device device) {
        this.devices.add(device);
    }

    public void removeDevice(Device device) {
        this.devices.remove(device);
    }

    public void addController(Controller ctrl) {
        this.controllers.add(ctrl);
    }

    public void removeController(Controller ctrl) {
        this.controllers.remove(ctrl);
    }

    public void validate() {
        if (this.genid == null) {
            this.genid = JF.generateUUID();
        }
        if (this.cores == 0) {
            this.cores = 2;
        }
        if (this.machine == null) {
            this.machine = "pc";
        }
        if (this.video == null) {
            this.video = "vga";
        }
        if (this.vram <= 0) {
            this.vram = 16384;
        }
        if (this.memory == null) {
            this.memory = new Size(1, 3);
        }
        if (this.disks == null) {
            this.disks = new ArrayList();
        }
        if (this.networks == null) {
            this.networks = new ArrayList();
        }
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        if (this.controllers == null) {
            this.controllers = new ArrayList();
        }
        int idx = 0;
        for (Disk disk : this.disks) {
            disk.target_dev = String.format("sd%c", 97 + idx);
            ++idx;
        }
    }
}

