/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt.priv;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import javaforce.Base64;
import javaforce.JFLog;
import javaforce.ui.Dimension;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;

public class svg
extends ImageTranscoder {
    private BufferedImage image;
    private Dimension size;

    private svg(Dimension size) {
        this.size = size;
    }

    public BufferedImage createImage(int width, int height) {
        if (width != this.size.width) {
            this.size.width = width;
        }
        if (height != this.size.height) {
            this.size.height = height;
        }
        if (this.image == null) {
            this.image = new BufferedImage(width, height, 2);
        }
        return this.image;
    }

    public void writeImage(BufferedImage image, TranscoderOutput out) throws TranscoderException {
        this.image = image;
    }

    public static int[] load(InputStream in, Dimension size) {
        TranscodingHints transcoderHints = new TranscodingHints();
        transcoderHints.put((Object)ImageTranscoder.KEY_DOM_IMPLEMENTATION, (Object)SVGDOMImplementation.getDOMImplementation());
        transcoderHints.put((Object)ImageTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, (Object)"http://www.w3.org/2000/svg");
        transcoderHints.put((Object)ImageTranscoder.KEY_DOCUMENT_ELEMENT, (Object)"svg");
        transcoderHints.put((Object)ImageTranscoder.KEY_WIDTH, (Object)Float.valueOf(size.width));
        transcoderHints.put((Object)ImageTranscoder.KEY_HEIGHT, (Object)Float.valueOf(size.height));
        try {
            svg svg_obj = new svg(size);
            TranscoderInput input = new TranscoderInput(in);
            svg transcoder = svg_obj;
            transcoder.setTranscodingHints(transcoderHints);
            transcoder.transcode(input, null);
            int[] px = new int[size.width * size.height];
            svg_obj.image.getRGB(0, 0, size.width, size.height, px, 0, size.width);
            return px;
        }
        catch (TranscoderException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean save(OutputStream out, byte[] png_data, Dimension size) {
        int w = size.width;
        int h = size.height;
        try {
            out.write("<?xml version='1.0' encoding='UTF-8' standalone='no'?>".getBytes());
            out.write(("<svg xmlns:xlink='http://www.w3.org/1999/xlink' version='1.1' width='" + w + "' height='" + h + "'>").getBytes());
            out.write(("<image width='" + w + "' height='" + h + "' x='0' y='0' ").getBytes());
            out.write("xlink:href='data:image/png;base64,".getBytes());
            out.write(Base64.encode(png_data, 76));
            out.write("'/>".getBytes());
            out.write("</svg>".getBytes());
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }
}

