/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl.model;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.LE;
import javaforce.gl.Model;
import javaforce.gl.Object3;
import javaforce.gl.UVMap;

public class GL_BLEND {
    private byte[] data;
    private int datapos;
    private boolean x64;
    private boolean le;
    private Model model;
    private Object3 obj;
    private float[] org = new float[3];
    private boolean haveDups;
    private HashMap<Long, Chunk> chunks = new HashMap();
    private static final int ID_ME = 17741;
    private static final int ID_OB = 16975;
    private static final int ID_SC = 17235;
    private static final int ID_DNA1 = 826363460;
    private static final int CD_MVERT = 0;
    private static final int CD_MSTICKY = 1;
    private static final int CD_MDEFORMVERT = 2;
    private static final int CD_MEDGE = 3;
    private static final int CD_MFACE = 4;
    private static final int CD_MTFACE = 5;
    private static final int CD_MCOL = 6;
    private static final int CD_ORIGINDEX = 7;
    private static final int CD_NORMAL = 8;
    private static final int CD_PROP_FLT = 10;
    private static final int CD_PROP_INT = 11;
    private static final int CD_PROP_STR = 12;
    private static final int CD_ORIGSPACE = 13;
    private static final int CD_ORCO = 14;
    private static final int CD_MTEXPOLY = 15;
    private static final int CD_MLOOPUV = 16;
    private static final int CD_MLOOPCOL = 17;
    private static final int CD_TANGENT = 18;
    private static final int CD_MDISPS = 19;
    private static final int CD_PREVIEW_MCOL = 20;
    private static final int CD_ID_MCOL = 21;
    private static final int CD_TEXTURE_MCOL = 22;
    private static final int CD_CLOTH_ORCO = 23;
    private static final int CD_RECAST = 24;
    private static final int CD_MPOLY = 25;
    private static final int CD_MLOOP = 26;
    private static final int CD_SHAPE_KEYINDEX = 27;
    private static final int CD_SHAPEKEY = 28;
    private static final int CD_BWEIGHT = 29;
    private static final int CD_CREASE = 30;
    private static final int CD_ORIGSPACE_MLOOP = 31;
    private static final int CD_PREVIEW_MLOOPCOL = 32;
    private static final int CD_BM_ELEM_PYPTR = 33;
    private static final int CD_PAINT_MASK = 34;
    private static final int CD_GRID_PAINT_MASK = 35;
    private static final int CD_MVERT_SKIN = 36;
    private static final int CD_FREESTYLE_EDGE = 37;
    private static final int CD_FREESTYLE_FACE = 38;
    private static final int CD_MLOOPTANGENT = 39;
    private static final int CD_TESSLOOPNORMAL = 40;
    private static final int CD_CUSTOMLOOPNORMAL = 41;
    private static final int CD_NUMTYPES = 42;
    private ArrayList<String> names = new ArrayList();
    private ArrayList<String> types = new ArrayList();
    private ArrayList<Short> typelen = new ArrayList();
    private ArrayList<struct> structs = new ArrayList();

    private struct getStruct(String name) throws Exception {
        for (int a = 0; a < this.structs.size(); ++a) {
            struct s = this.structs.get(a);
            if (!s.name.equals(name)) continue;
            return s;
        }
        throw new Exception("struct not found:" + name);
    }

    private int calcMemberSize(member m) {
        if (m.name.startsWith("*")) {
            if (this.x64) {
                return 8;
            }
            return 4;
        }
        if (m.name.indexOf("[") != -1) {
            String[] f = m.name.replaceAll("\\]", "").split("\\[");
            if (f.length == 2) {
                return m.typelen * Integer.valueOf(f[1]);
            }
            return m.typelen * Integer.valueOf(f[1]) * Integer.valueOf(f[2]);
        }
        return m.typelen;
    }

    public Model load(String filename) {
        try {
            return this.loadBlend(new FileInputStream(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Model load(InputStream is) {
        try {
            return this.loadBlend(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean eof() {
        return this.datapos >= this.data.length;
    }

    private byte readuint8() {
        byte uint8 = this.data[this.datapos++];
        return uint8;
    }

    private short readuint16() {
        int uint16 = this.le ? LE.getuint16(this.data, this.datapos) : BE.getuint16(this.data, this.datapos);
        this.datapos += 2;
        return (short)uint16;
    }

    private int readuint32() {
        int uint32 = this.le ? LE.getuint32(this.data, this.datapos) : BE.getuint32(this.data, this.datapos);
        this.datapos += 4;
        return uint32;
    }

    private long readuint64() {
        long uint64 = this.le ? LE.getuint64(this.data, this.datapos) : BE.getuint64(this.data, this.datapos);
        this.datapos += 8;
        return uint64;
    }

    private long readptr() {
        if (this.x64) {
            return this.readuint64();
        }
        return this.readuint32();
    }

    private void readByteArray(byte[] in) {
        System.arraycopy(this.data, this.datapos, in, 0, in.length);
        this.datapos += in.length;
    }

    private void readPtrArray(long[] in) {
        for (int a = 0; a < in.length; ++a) {
            in[a] = this.readptr();
        }
    }

    private void readFloatArray(float[] in) {
        for (int a = 0; a < in.length; ++a) {
            in[a] = this.readfloat();
        }
    }

    private float readfloat() {
        return Float.intBitsToFloat(this.readuint32());
    }

    private String readString(int len) {
        int sl = this.strlen(this.data, this.datapos, len);
        String str = new String(this.data, this.datapos, sl);
        this.datapos += len;
        return str;
    }

    private String readString() {
        int sl = this.strlen(this.data, this.datapos, this.data.length - this.datapos);
        String str = new String(this.data, this.datapos, sl);
        this.datapos += sl + 1;
        return str;
    }

    private void setData(byte[] in) {
        this.data = in;
        this.datapos = 0;
    }

    private Context pushData() {
        Context ctx = new Context();
        ctx.data = this.data;
        ctx.datapos = this.datapos;
        return ctx;
    }

    private void popData(Context ctx) {
        this.data = ctx.data;
        this.datapos = ctx.datapos;
    }

    private int strlen(byte[] str, int offset, int max) {
        for (int a = 0; a < max; ++a) {
            if (str[a + offset] != 0) continue;
            return a;
        }
        return max;
    }

    private Chunk findChunkByPtr(long ptr) {
        if (ptr == 0L) {
            return null;
        }
        Chunk chunk = this.chunks.get(ptr);
        if (chunk == null) {
            return null;
        }
        if (chunk.dup) {
            int cnt = chunk.dupidx++;
            for (int a = 0; a < cnt; ++a) {
                chunk = chunk.nextdup;
            }
        }
        return chunk;
    }

    private Model loadBlend(InputStream is) throws Exception {
        int i;
        this.setData(JF.readAll(is));
        if (this.data.length < 12) {
            throw new Exception("GL_BLEND:File too small");
        }
        this.model = new Model();
        if (!new String(this.data, 0, 7).equals("BLENDER")) {
            throw new Exception("Not a blender file");
        }
        switch (this.data[7]) {
            case 45: {
                this.x64 = true;
                break;
            }
            case 95: {
                this.x64 = false;
                break;
            }
            default: {
                throw new Exception("GL_BLEND:Unknown bit size");
            }
        }
        switch (this.data[8]) {
            case 118: {
                this.le = true;
                break;
            }
            case 86: {
                this.le = false;
                break;
            }
            default: {
                throw new Exception("GL_BLEND:Unknown Endianness");
            }
        }
        String version = new String(this.data, 9, 3);
        int ver = Integer.valueOf(version);
        if (ver < 263) {
            throw new Exception("Error:Blender file too old, can not read.");
        }
        this.datapos = 12;
        while (!this.eof()) {
            Chunk chunk = new Chunk();
            chunk.filepos = this.datapos;
            chunk.read();
            Chunk ochunk = this.chunks.get(chunk.ptr);
            if (ochunk != null) {
                if (!this.haveDups) {
                    JFLog.log("Warning:This file contains duplicate BHeads.");
                    this.haveDups = true;
                }
                ochunk.dup = true;
                while (ochunk.nextdup != null) {
                    ochunk = ochunk.nextdup;
                }
                ochunk.nextdup = chunk;
                continue;
            }
            this.chunks.put(chunk.ptr, chunk);
        }
        int chunkCnt = this.chunks.size();
        Chunk[] chunkArray = this.chunks.values().toArray(new Chunk[chunkCnt]);
        for (i = 0; i < chunkCnt; ++i) {
            if (chunkArray[i].id != 826363460) continue;
            Chunk raw = chunkArray[i];
            this.setData(raw.raw);
            String SDNA = this.readString(4);
            if (!SDNA.equals("SDNA")) {
                throw new Exception("Bad DNA Struct:SDNA");
            }
            String NAME = this.readString(4);
            if (!NAME.equals("NAME")) {
                throw new Exception("Bad DNA Struct:NAME");
            }
            int nr_names = this.readuint32();
            for (int a = 0; a < nr_names; ++a) {
                String str = this.readString();
                this.names.add(str);
            }
            this.datapos += 3;
            this.datapos &= 0xFFFFFFFC;
            String TYPE = this.readString(4);
            if (!TYPE.equals("TYPE")) {
                throw new Exception("Bad DNA Struct:TYPE");
            }
            int nr_types = this.readuint32();
            for (int a = 0; a < nr_types; ++a) {
                String str = this.readString();
                this.types.add(str);
            }
            this.datapos += 3;
            this.datapos &= 0xFFFFFFFC;
            String TLEN = this.readString(4);
            if (!TLEN.equals("TLEN")) {
                throw new Exception("Bad DNA Struct:TLEN");
            }
            for (int a = 0; a < nr_types; ++a) {
                this.typelen.add(this.readuint16());
            }
            this.datapos += 3;
            this.datapos &= 0xFFFFFFFC;
            String STRC = this.readString(4);
            if (!STRC.equals("STRC")) {
                throw new Exception("Bad DNA Struct:STRC");
            }
            int nr_structs = this.readuint32();
            for (int a = 0; a < nr_structs; ++a) {
                struct s = new struct();
                s.typeidx = this.readuint16();
                s.nr = this.readuint16();
                s.name = this.types.get(s.typeidx);
                for (int b = 0; b < s.nr; ++b) {
                    member m = new member();
                    m.typelenidx = this.readuint16();
                    m.nameidx = this.readuint16();
                    m.name = this.names.get(m.nameidx);
                    m.typelen = this.typelen.get(m.typelenidx).shortValue();
                    m.size = this.calcMemberSize(m);
                    s.members.add(m);
                }
                this.structs.add(s);
            }
            break;
        }
        for (i = 0; i < chunkCnt; ++i) {
            Chunk chunk;
            if (chunkArray[i].id != 17235) continue;
            this.setData(chunkArray[i].raw);
            Scene scene = new Scene();
            scene.read();
            long ptr = scene.last;
            while (ptr != 0L && (chunk = this.findChunkByPtr(ptr)) != null) {
                this.setData(chunk.raw);
                Base base = new Base();
                base.read();
                chunk = this.findChunkByPtr(base.object);
                if (chunk.id == 16975) {
                    this.readObject(chunk);
                }
                ptr = base.prev;
            }
        }
        return this.model;
    }

    private void readObject(Chunk chunk) throws Exception {
        int a;
        ArrayList<Vertex> vertexList = new ArrayList<Vertex>();
        ArrayList<Integer> loopList = new ArrayList<Integer>();
        this.setData(chunk.raw);
        bObject bObj = new bObject();
        bObj.read();
        if (bObj.type != 1) {
            return;
        }
        this.obj = new Object3();
        this.model.addObject(this.obj);
        this.obj.name = bObj.id.name.substring(2);
        chunk = this.findChunkByPtr(bObj.data);
        if (chunk == null) {
            throw new Exception("GL_BLEND:Unable to find Mesh for Object");
        }
        Mesh mesh = new Mesh();
        this.setData(chunk.raw);
        mesh.read();
        this.obj.org.x = bObj.loc[0];
        this.org[0] = bObj.loc[0];
        this.obj.org.y = bObj.loc[1];
        this.org[1] = bObj.loc[1];
        this.obj.org.z = bObj.loc[2];
        this.org[2] = bObj.loc[2];
        chunk = this.findChunkByPtr(mesh.mvert);
        if (chunk == null) {
            throw new Exception("GL_BLEND:Unable to find MVert for Mesh");
        }
        this.setData(chunk.raw);
        for (a = 0; a < chunk.nr; ++a) {
            MVert mvert = new MVert();
            mvert.read();
            Vertex v = new Vertex();
            v.xyz = mvert.v;
            vertexList.add(v);
        }
        chunk = this.findChunkByPtr(mesh.mloop);
        if (chunk == null) {
            throw new Exception("GL_BLEND:Unable to find MLoop for Mesh");
        }
        this.setData(chunk.raw);
        for (a = 0; a < chunk.nr; ++a) {
            MLoop mloop = new MLoop();
            mloop.read();
            loopList.add(mloop.v);
        }
        chunk = this.findChunkByPtr(mesh.mpoly);
        if (chunk == null) {
            throw new Exception("GL_BLEND:Unable to find MPoly for Mesh");
        }
        this.setData(chunk.raw);
        int type = -1;
        int pcnt = -1;
        int vidx = 0;
        for (int a2 = 0; a2 < chunk.nr; ++a2) {
            MPoly mpoly = new MPoly();
            mpoly.read();
            switch (mpoly.totloop) {
                case 3: {
                    if (type == 7) {
                        throw new Exception("GL_BLEND:Mixed QUADS/TRIANGLES not supported");
                    }
                    type = 4;
                    pcnt = 3;
                    break;
                }
                case 4: {
                    if (type == 4) {
                        throw new Exception("GL_BLEND:Mixed QUADS/TRIANGLES not supported");
                    }
                    type = 7;
                    pcnt = 4;
                    break;
                }
                default: {
                    throw new Exception("GL_BLEND:Polygon not supported:nr=" + mpoly.totloop);
                }
            }
            int loopidx = mpoly.loopstart;
            for (int p = 0; p < pcnt; ++p) {
                int idx = (Integer)loopList.get(loopidx++);
                this.obj.addVertex(((Vertex)vertexList.get((int)idx)).xyz);
                this.obj.addPoly(new int[]{vidx++});
            }
        }
        this.obj.type = type;
        this.readLayer(mesh.vdata.layers, "vdata");
        this.readLayer(mesh.edata.layers, "edata");
        this.readLayer(mesh.fdata.layers, "fdata");
        this.readLayer(mesh.pdata.layers, "pdata");
        this.readLayer(mesh.ldata.layers, "ldata");
    }

    private void readLayer(long layers, String name) throws Exception {
        if (layers == 0L) {
            return;
        }
        Chunk raw = this.findChunkByPtr(layers);
        if (raw == null) {
            throw new Exception("GL_BLEND:Unable to find " + name + ".layers for Mesh");
        }
        this.setData(raw.raw);
        for (int a = 0; a < raw.nr; ++a) {
            CustomDataLayer layer = new CustomDataLayer();
            layer.read();
            String layer_name = layer.name;
            if (layer.data == 0L) continue;
            Chunk layer_data = this.findChunkByPtr(layer.data);
            if (layer_data == null) {
                throw new Exception("GL_BLEND:Unable to find " + name + ".layers.data for Mesh");
            }
            Context ctx = this.pushData();
            this.setData(layer_data.raw);
            switch (layer.type) {
                case 15: {
                    int tidx;
                    MTexPoly tex = new MTexPoly();
                    tex.read();
                    Chunk imageChunk = this.findChunkByPtr(tex.tpage);
                    if (imageChunk == null) {
                        throw new Exception("GL_BLEND:No texture found for UVMap:" + a);
                    }
                    this.setData(imageChunk.raw);
                    Image image = new Image();
                    image.read();
                    UVMap map = a < this.obj.getUVMaps() ? this.obj.getUVMap(a) : this.obj.createUVMap();
                    String tn = image.name;
                    int tnidx = tn.lastIndexOf("/");
                    if (tnidx != -1) {
                        tn = tn.substring(tnidx + 1);
                    }
                    if ((tnidx = tn.lastIndexOf("\\")) != -1) {
                        tn = tn.substring(tnidx + 1);
                    }
                    map.textureIndex = tidx = this.model.addTexture(tn);
                    map.name = layer_name;
                    break;
                }
                case 16: {
                    if (a >= this.obj.getUVMaps()) {
                        this.obj.createUVMap();
                    }
                    for (int b = 0; b < layer_data.nr; ++b) {
                        MLoopUV uv = new MLoopUV();
                        uv.read();
                        uv.uv[1] = 1.0f - uv.uv[1];
                        this.obj.addText(uv.uv, a);
                    }
                    break;
                }
            }
            this.popData(ctx);
        }
    }

    private class struct {
        short typeidx;
        short nr;
        String name;
        ArrayList<member> members = new ArrayList();

        private struct() {
        }
    }

    private class member {
        short typelenidx;
        short nameidx;
        String name;
        int typelen;
        int size;

        private member() {
        }
    }

    private class Context {
        byte[] data;
        int datapos;

        private Context() {
        }
    }

    private class Chunk {
        int id;
        int len;
        long ptr;
        int SDNAnr;
        int nr;
        byte[] raw;
        int filepos;
        boolean dup;
        int dupidx;
        Chunk nextdup;
        int fileOffset;

        private Chunk() {
        }

        void read() {
            this.id = GL_BLEND.this.readuint32();
            this.len = GL_BLEND.this.readuint32();
            this.ptr = GL_BLEND.this.readptr();
            this.SDNAnr = GL_BLEND.this.readuint32();
            this.nr = GL_BLEND.this.readuint32();
            this.fileOffset = GL_BLEND.this.datapos;
            if (this.len == 0) {
                return;
            }
            this.raw = new byte[this.len];
            GL_BLEND.this.readByteArray(this.raw);
        }
    }

    private class Scene {
        long first;
        long last;

        private Scene() {
        }

        void read() throws Exception {
            struct s = GL_BLEND.this.getStruct("Scene");
            for (int a = 0; a < s.nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("base")) {
                    this.first = GL_BLEND.this.readptr();
                    this.last = GL_BLEND.this.readptr();
                    continue;
                }
                GL_BLEND.this.datapos += m.size;
            }
        }
    }

    private class Base {
        long next;
        long prev;
        long object;

        private Base() {
        }

        void read() throws Exception {
            struct s = GL_BLEND.this.getStruct("Base");
            for (int a = 0; a < s.nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("*next")) {
                    this.next = GL_BLEND.this.readptr();
                    continue;
                }
                if (m.name.equals("*prev")) {
                    this.prev = GL_BLEND.this.readptr();
                    continue;
                }
                if (m.name.equals("*object")) {
                    this.object = GL_BLEND.this.readptr();
                    continue;
                }
                GL_BLEND.this.datapos += m.size;
            }
        }
    }

    private class bObject {
        ID id;
        int type;
        long data;
        float[] loc;

        private bObject() {
            this.id = new ID();
            this.loc = new float[3];
        }

        void read() throws Exception {
            struct s = GL_BLEND.this.getStruct("Object");
            for (int a = 0; a < s.nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("*data")) {
                    this.data = GL_BLEND.this.readptr();
                    continue;
                }
                if (m.name.equals("loc[3]")) {
                    GL_BLEND.this.readFloatArray(this.loc);
                    continue;
                }
                if (m.name.equals("type")) {
                    this.type = GL_BLEND.this.readuint16();
                    continue;
                }
                if (m.name.equals("id")) {
                    this.id.read();
                    continue;
                }
                GL_BLEND.this.datapos += m.size;
            }
        }
    }

    private class ID {
        String name;

        private ID() {
        }

        void read() throws Exception {
            struct s = GL_BLEND.this.getStruct("ID");
            for (int a = 0; a < s.nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("name[66]")) {
                    this.name = GL_BLEND.this.readString(m.size);
                    continue;
                }
                GL_BLEND.this.datapos += m.size;
            }
        }
    }

    private class Mesh {
        ID id;
        long mpoly;
        long mloop;
        long mloopuv;
        long mvert;
        CustomData vdata;
        CustomData edata;
        CustomData fdata;
        CustomData pdata;
        CustomData ldata;

        private Mesh() {
            this.id = new ID();
            this.vdata = new CustomData();
            this.edata = new CustomData();
            this.fdata = new CustomData();
            this.pdata = new CustomData();
            this.ldata = new CustomData();
        }

        void read() throws Exception {
            struct s = GL_BLEND.this.getStruct("Mesh");
            for (int a = 0; a < s.nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("*mpoly")) {
                    this.mpoly = GL_BLEND.this.readptr();
                    continue;
                }
                if (m.name.equals("*mloop")) {
                    this.mloop = GL_BLEND.this.readptr();
                    continue;
                }
                if (m.name.equals("*mloopuv")) {
                    this.mloopuv = GL_BLEND.this.readptr();
                    continue;
                }
                if (m.name.equals("*mvert")) {
                    this.mvert = GL_BLEND.this.readptr();
                    continue;
                }
                if (m.name.equals("vdata")) {
                    this.vdata.read("vdata");
                    continue;
                }
                if (m.name.equals("edata")) {
                    this.edata.read("edata");
                    continue;
                }
                if (m.name.equals("fdata")) {
                    this.fdata.read("fdata");
                    continue;
                }
                if (m.name.equals("pdata")) {
                    this.pdata.read("pdata");
                    continue;
                }
                if (m.name.equals("ldata")) {
                    this.ldata.read("ldata");
                    continue;
                }
                if (m.name.equals("id")) {
                    this.id.read();
                    continue;
                }
                GL_BLEND.this.datapos += m.size;
            }
        }
    }

    private class MVert {
        float[] v = new float[3];

        private MVert() {
        }

        void read() throws Exception {
            struct s = GL_BLEND.this.getStruct("MVert");
            for (int a = 0; a < s.nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("co[3]")) {
                    for (int b = 0; b < 3; ++b) {
                        this.v[b] = GL_BLEND.this.readfloat() + GL_BLEND.this.org[b];
                    }
                    continue;
                }
                GL_BLEND.this.datapos += m.size;
            }
        }
    }

    private class Vertex {
        float[] xyz;

        private Vertex() {
        }
    }

    private class MLoop {
        int v;

        private MLoop() {
        }

        void read() throws Exception {
            struct s = GL_BLEND.this.getStruct("MLoop");
            for (int a = 0; a < s.nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("v")) {
                    this.v = GL_BLEND.this.readuint32();
                    continue;
                }
                GL_BLEND.this.datapos += m.size;
            }
        }
    }

    private class MPoly {
        int loopstart;
        int totloop;

        private MPoly() {
        }

        void read() throws Exception {
            struct s = GL_BLEND.this.getStruct("MPoly");
            for (int a = 0; a < s.nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("loopstart")) {
                    this.loopstart = GL_BLEND.this.readuint32();
                    continue;
                }
                if (m.name.equals("totloop")) {
                    this.totloop = GL_BLEND.this.readuint32();
                    continue;
                }
                GL_BLEND.this.datapos += m.size;
            }
        }
    }

    private class CustomData {
        long layers;

        private CustomData() {
        }

        void read(String name) throws Exception {
            struct s = GL_BLEND.this.getStruct("CustomData");
            for (int a = 0; a < s.nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("*layers")) {
                    this.layers = GL_BLEND.this.readptr();
                    continue;
                }
                GL_BLEND.this.datapos += m.size;
            }
        }
    }

    private class CustomDataLayer {
        int type;
        String name;
        long data;

        private CustomDataLayer() {
        }

        void read() throws Exception {
            struct s = GL_BLEND.this.getStruct("CustomDataLayer");
            for (int a = 0; a < s.nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("type")) {
                    this.type = GL_BLEND.this.readuint32();
                    continue;
                }
                if (m.name.equals("name[64]")) {
                    this.name = GL_BLEND.this.readString(m.size);
                    continue;
                }
                if (m.name.equals("*data")) {
                    this.data = GL_BLEND.this.readptr();
                    continue;
                }
                GL_BLEND.this.datapos += m.size;
            }
        }
    }

    private class MTexPoly {
        long tpage;

        private MTexPoly() {
        }

        void read() throws Exception {
            struct s = GL_BLEND.this.getStruct("MTexPoly");
            for (int a = 0; a < s.nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("*tpage")) {
                    this.tpage = GL_BLEND.this.readptr();
                    continue;
                }
                GL_BLEND.this.datapos += m.size;
            }
        }
    }

    private class Image {
        ID id;
        String name;

        private Image() {
            this.id = new ID();
        }

        void read() throws Exception {
            struct s = GL_BLEND.this.getStruct("Image");
            for (int a = 0; a < s.nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("name[1024]")) {
                    this.name = GL_BLEND.this.readString(m.size);
                    continue;
                }
                if (m.name.equals("id")) {
                    this.id.read();
                    continue;
                }
                GL_BLEND.this.datapos += m.size;
            }
        }
    }

    private class MLoopUV {
        float[] uv = new float[2];

        private MLoopUV() {
        }

        void read() throws Exception {
            struct s = GL_BLEND.this.getStruct("MLoopUV");
            for (int a = 0; a < s.nr; ++a) {
                member m = s.members.get(a);
                if (m.name.equals("uv[2]")) {
                    this.uv[0] = GL_BLEND.this.readfloat();
                    this.uv[1] = GL_BLEND.this.readfloat();
                    continue;
                }
                GL_BLEND.this.datapos += m.size;
            }
        }
    }
}

