/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.POP3;
import javaforce.SMTP;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;

public class SMTPRelay
extends Thread {
    private static String pop3_host;
    private static int pop3_port;
    private static boolean pop3_secure;
    private static String pop3_user;
    private static String pop3_pass;
    private static String smtp_host;
    private static int smtp_port;
    private static boolean smtp_secure;
    private static String smtp_user;
    private static String smtp_pass;
    private static String smtp_from;
    private static boolean keepalive;
    private static long interval;
    private static volatile boolean active;
    private static Object lock;
    private static SMTPRelay service;
    private static POP3 pop3;
    private static boolean debug;
    public static final String busPack = "net.sf.jfsmtprelay";
    private static final String defaultConfig = "[global]\n#pop3_host=1.2.3.4\n#pop3_port=995\n#pop3_secure=true #(default = false)\n#pop3_user=bob\n#pop3_pass=secret\n#smtp_host=5.6.7.8\n#smtp_port=25\n#smtp_secure=false #(default = false)\n#smtp_user=bob@example.com #optional\n#smtp_pass=secret #optional\n#smtp_from=bob@example.com #override from email address (optional)\nkeepalive=true #keep pop3 connection alive (default = false)\n#interval=15 #how often to check for messages (minutes) (default=15)\n";
    private static JBusServer busServer;
    private JBusClient busClient;
    private String config;

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfsmtprelay.cfg";
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfsmtprelay.log";
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33011;
        }
        return 777;
    }

    @Override
    public void run() {
        JFLog.append(JF.getLogPath() + "/jfsmtprelay.log", true);
        JFLog.setRetention(30);
        JFLog.log("SMTPRelay : Starting service");
        try {
            this.loadConfig();
            this.busClient = new JBusClient(busPack, new JBusMethods());
            this.busClient.setPort(SMTPRelay.getBusPort());
            this.busClient.start();
            active = true;
            while (active) {
                this.relay();
                int a = 0;
                while ((long)a < interval * 60L) {
                    if (!active) {
                        return;
                    }
                    JF.sleep(1000);
                    ++a;
                }
            }
            if (pop3 != null) {
                pop3.disconnect();
                pop3 = null;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void close() {
        active = false;
    }

    private void relay() {
        if (!SMTPRelay.validConfig()) {
            JFLog.log("Please configure!");
            return;
        }
        SMTP smtp = null;
        try {
            POP3.Message[] list;
            if (debug) {
                JFLog.log("Checking messages...");
            }
            if (pop3 == null) {
                pop3 = new POP3();
                POP3.debug = debug;
                if (debug) {
                    JFLog.log("POP3:connecting...");
                }
                if (pop3_secure) {
                    pop3.connectSSL(pop3_host, pop3_port);
                } else {
                    pop3.connect(pop3_host, pop3_port);
                }
                if (debug) {
                    JFLog.log("POP3:auth...");
                }
                if (!pop3.auth(pop3_user, pop3_pass, "APOP")) {
                    throw new Exception("POP3:auth failed!");
                }
            }
            if (debug) {
                JFLog.log("POP3 listing...");
            }
            if ((list = pop3.list()) == null || list.length == 0) {
                if (!keepalive) {
                    pop3.disconnect();
                    pop3 = null;
                }
                if (debug) {
                    JFLog.log("No messages found");
                }
                return;
            }
            if (debug || list.length > 0) {
                JFLog.log("Found " + list.length + " messages to relay");
            }
            for (POP3.Message em : list) {
                if (debug) {
                    JFLog.log("Relay message:" + em.idx + ":size=" + em.size);
                }
                byte[] data = pop3.get(em.idx);
                if (debug) {
                    JFLog.log("Message size=" + data.length);
                }
                smtp = new SMTP();
                SMTP.debug = debug;
                if (smtp_secure) {
                    smtp.connectSSL(smtp_host, smtp_port);
                } else {
                    smtp.connect(smtp_host, smtp_port);
                }
                if (smtp_user != null && smtp_pass != null) {
                    if (!smtp.auth(smtp_user, smtp_pass, "LOGIN")) {
                        smtp.disconnect();
                        throw new Exception("SMTP auth failed!");
                    }
                } else {
                    smtp.login();
                }
                String msg = new String(data);
                String[] lns = msg.split("\r\n");
                String em_from = null;
                ArrayList<String> em_to = new ArrayList<String>();
                int idx = 0;
                while (!lns[idx].equals("")) {
                    String key;
                    String ln;
                    int sp;
                    if ((sp = (ln = lns[idx++]).indexOf(58)) == -1) continue;
                    switch (key = ln.substring(0, sp).toLowerCase()) {
                        case "from": {
                            em_from = this.getEmail(ln);
                            break;
                        }
                        case "to": {
                            em_to.add(this.getEmail(ln));
                        }
                    }
                }
                if (smtp_from != null) {
                    em_from = smtp_from;
                }
                smtp.from(em_from);
                for (String to : em_to) {
                    smtp.to(to);
                }
                smtp.data(msg);
                smtp.disconnect();
                smtp = null;
                pop3.delete(em.idx);
            }
            if (!keepalive) {
                pop3.disconnect();
                pop3 = null;
            }
        }
        catch (Exception e) {
            if (pop3 != null) {
                try {
                    pop3.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                pop3 = null;
            }
            if (smtp != null) {
                try {
                    smtp.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                smtp = null;
            }
            JFLog.log(e);
        }
    }

    private String getEmail(String ln) {
        int i1 = ln.indexOf(60);
        int i2 = ln.indexOf(62);
        if (i1 == -1 || i2 == -1) {
            return ln;
        }
        return ln.substring(i1 + 1, i2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadConfig() {
        JFLog.log("loadConfig");
        Section section = Section.None;
        try {
            BufferedReader br = new BufferedReader(new FileReader(SMTPRelay.getConfigFile()));
            StringBuilder cfg = new StringBuilder();
            block40: while (true) {
                int idx;
                String ln;
                if ((ln = br.readLine()) == null) {
                    br.close();
                    this.config = cfg.toString();
                    return;
                }
                cfg.append(ln);
                cfg.append("\n");
                if ((ln = ln.trim()).startsWith("#") || ln.length() == 0) continue;
                if (ln.equals("[global]")) {
                    section = Section.Global;
                    continue;
                }
                int cmt = ln.indexOf(35);
                if (cmt != -1) {
                    ln = ln.substring(0, cmt).trim();
                }
                if ((idx = ln.indexOf("=")) == -1) continue;
                String key = ln.substring(0, idx);
                String value = ln.substring(idx + 1);
                switch (section) {
                    case None: 
                    case Global: {
                        switch (key) {
                            case "pop3_host": {
                                pop3_host = value;
                                break;
                            }
                            case "pop3_port": {
                                pop3_port = Integer.valueOf(value);
                                break;
                            }
                            case "pop3_secure": {
                                pop3_secure = value.equals("true");
                                break;
                            }
                            case "pop3_user": {
                                pop3_user = value;
                                break;
                            }
                            case "pop3_pass": {
                                pop3_pass = value;
                                break;
                            }
                            case "smtp_host": {
                                smtp_host = value;
                                break;
                            }
                            case "smtp_port": {
                                smtp_port = Integer.valueOf(value);
                                break;
                            }
                            case "smtp_secure": {
                                smtp_secure = value.equals("true");
                                break;
                            }
                            case "smtp_user": {
                                smtp_user = value;
                                break;
                            }
                            case "smtp_pass": {
                                smtp_pass = value;
                                break;
                            }
                            case "smtp_from": {
                                smtp_from = value;
                                break;
                            }
                            case "keepalive": {
                                keepalive = value.equals("true");
                                break;
                            }
                            case "interval": {
                                interval = Integer.valueOf(value).intValue();
                                if (interval < 1L) {
                                    interval = 1L;
                                }
                                if (interval <= 1440L) break;
                                interval = 1440L;
                                break;
                            }
                            case "debug": {
                                debug = value.equals("true");
                            }
                        }
                        continue block40;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            JFLog.log("config not found, creating defaults.");
            try {
                FileOutputStream fos = new FileOutputStream(SMTPRelay.getConfigFile());
                fos.write(defaultConfig.getBytes());
                fos.close();
                this.config = defaultConfig;
                return;
            }
            catch (Exception e2) {
                JFLog.log(e2);
                return;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static boolean validConfig() {
        if (pop3_host == null) {
            return false;
        }
        if (pop3_user == null) {
            return false;
        }
        if (pop3_pass == null) {
            return false;
        }
        return smtp_host != null;
    }

    public static void serviceStart(String[] args) {
        if (JF.isWindows()) {
            busServer = new JBusServer(SMTPRelay.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
        service = new SMTPRelay();
        service.start();
    }

    public static void serviceStop() {
        JFLog.log("SMTPRelay : Stopping service");
        if (busServer != null) {
            busServer.close();
            busServer = null;
        }
        service.close();
    }

    public static void main(String[] args) {
    }

    static {
        keepalive = false;
        interval = 15L;
        lock = new Object();
        debug = false;
    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            JBusClient cfr_ignored_0 = SMTPRelay.service.busClient;
            JBusClient cfr_ignored_1 = SMTPRelay.service.busClient;
            SMTPRelay.service.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(SMTPRelay.service.config)));
        }

        public void setConfig(String cfg) {
            JFLog.log("setConfig");
            try {
                FileOutputStream fos = new FileOutputStream(SMTPRelay.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            JFLog.log("restart");
            service.close();
            service = new SMTPRelay();
            service.start();
        }
    }

    static enum Section {
        None,
        Global;

    }
}

