/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.awt.ViewLog;
import javaforce.jbus.JBusClient;
import javaforce.service.SSHServer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class SSHApp
extends JFrame {
    private JTextArea config;
    private JButton help;
    private JButton jButton1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton save;
    public ViewLog viewer;
    public JBusClient busClient;

    public SSHApp() {
        this.initComponents();
        JFImage img = new JFImage();
        img.loadPNG(this.getClass().getResourceAsStream("/javaforce/icons/ssh.png"));
        this.setIconImage(img.getImage());
        new Thread(){

            @Override
            public void run() {
                Random r = new Random();
                SSHApp.this.busClient = new JBusClient("net.sf.jfssh.client" + r.nextInt(), new JBusMethods());
                SSHApp.this.busClient.setPort(SSHServer.getBusPort());
                SSHApp.this.busClient.start();
                SSHApp.this.busClient.call("net.sf.jfssh", "getConfig", "\"" + SSHApp.this.busClient.pack + "\"");
            }
        }.start();
        JFAWT.centerWindow(this);
    }

    public void writeConfig() {
        this.busClient.call("net.sf.jfssh", "setConfig", JBusClient.quote(JBusClient.encodeString(this.config.getText())));
    }

    public void restart() {
        this.busClient.call("net.sf.jfssh", "restart", "");
    }

    private void initComponents() {
        this.save = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.config = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.help = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("SSH Server");
        this.save.setText("Save");
        this.save.setEnabled(false);
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SSHApp.this.saveActionPerformed(evt);
            }
        });
        this.config.setColumns(20);
        this.config.setRows(5);
        this.config.setText(" [ loading ... ]\n");
        this.config.setEnabled(false);
        this.jScrollPane1.setViewportView(this.config);
        this.jLabel1.setText("SSH Configuration:");
        this.jButton1.setText("View Log");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SSHApp.this.jButton1ActionPerformed(evt);
            }
        });
        this.help.setText("Help");
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SSHApp.this.helpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 583, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.help).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.save)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 418, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.save).addComponent(this.jButton1).addComponent(this.help)).addContainerGap()));
        this.pack();
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.writeConfig();
        this.restart();
        JFAWT.showMessage("Notice", "Settings saved!");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.showViewLog();
    }

    private void helpActionPerformed(ActionEvent evt) {
        this.showHelp();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SSHApp().setVisible(true);
            }
        });
    }

    public void showViewLog() {
        if (this.viewer == null || this.viewer.isClosed) {
            this.viewer = new ViewLog(SSHServer.getLogFile());
            this.viewer.setTitle("SSH Log");
        }
        this.viewer.setVisible(true);
    }

    private void showHelp() {
        JFAWT.openURL("http://jfssh.sf.net/help.html");
    }

    public class JBusMethods {
        public void getConfig(String cfg) {
            final String _cfg = cfg;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SSHApp.this.config.setText(JBusClient.decodeString(_cfg));
                    SSHApp.this.config.setEnabled(true);
                    SSHApp.this.save.setEnabled(true);
                }
            });
        }
    }
}

