/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javaforce.JF;
import javaforce.service.WebRequest;

public class WebUpload {
    private static int maxlength = 0x4000000;

    public static boolean isMultipartContent(WebRequest req) {
        String contentType = req.getHeader("Content-Type");
        if (contentType == null) {
            return false;
        }
        return contentType.trim().startsWith("multipart/form-data;");
    }

    public static void setMaxLength(int maxlength) {
        WebUpload.maxlength = maxlength;
    }

    private boolean cmp(byte[] s1, int p1, byte[] s2, int p2, int len) {
        while (len > 0) {
            if (s1[p1++] != s2[p2++]) {
                return false;
            }
            --len;
        }
        return true;
    }

    public WebFile[] parseRequest(WebRequest req) throws Exception {
        String contentType = req.getHeader("Content-Type");
        if (contentType == null) {
            throw new Exception("WebUpload:No Content-Type");
        }
        int idx = contentType.indexOf("boundary=");
        if (idx == -1) {
            throw new Exception("WebUpload:No boundary");
        }
        byte[] boundary = ("--" + contentType.substring(idx + 9)).getBytes();
        int boundaryLength = boundary.length;
        String contentLength = req.getHeader("Content-Length");
        if (contentLength == null) {
            throw new Exception("WebUpload:No Content-Length");
        }
        int postlength = Integer.valueOf(contentLength);
        if (postlength > maxlength) {
            throw new Exception("WebUpload:Upload > Max allowed");
        }
        byte[] data = JF.readAll(req.is, postlength);
        int pos = 0;
        ArrayList<WebFile> files = new ArrayList<WebFile>();
        while (pos < postlength) {
            if (data[pos] == 13 && data[pos + 1] == 10) {
                pos += 2;
                continue;
            }
            if (!this.cmp(data, pos, boundary, 0, boundaryLength)) {
                throw new Exception("WebUpload:Bad boundary @ " + pos);
            }
            pos += boundaryLength;
            StringBuilder headers = new StringBuilder();
            while (!headers.toString().endsWith("\r\n\r\n")) {
                headers.append((char)data[pos++]);
            }
            String[] lns = headers.toString().split("\r\n");
            String filename = null;
            block2: for (int a = 0; a < lns.length; ++a) {
                if (!lns[a].startsWith("Content-Disposition:")) continue;
                String[] fields = lns[a].split(";");
                for (int b = 0; b < fields.length; ++b) {
                    if (!fields[b].trim().startsWith("filename=")) continue;
                    filename = fields[b].trim().substring(9);
                    break block2;
                }
                break;
            }
            if (filename == null) {
                throw new Exception("WebUpload:Upload has no filename");
            }
            if (filename.startsWith("\"") && filename.endsWith("\"")) {
                filename = filename.substring(1, filename.length() - 1);
            }
            WebFile file = new WebFile();
            file.name = filename;
            int fileStart = pos;
            int fileEnd = -1;
            while (pos < postlength) {
                if (data[pos] == 13 && data[pos + 1] == 10 && this.cmp(data, pos + 2, boundary, 0, boundaryLength)) {
                    fileEnd = pos;
                    break;
                }
                ++pos;
            }
            if (fileEnd == -1) {
                throw new Exception("WebUpload:No boundary found after file data");
            }
            int fileLength = fileEnd - fileStart;
            file.data = new byte[fileLength];
            System.arraycopy(data, fileStart, file.data, 0, fileLength);
            files.add(file);
            pos += fileLength;
        }
        return files.toArray(new WebFile[0]);
    }

    public static class WebFile {
        public byte[] data;
        public String name;

        public void write(File dest) throws Exception {
            FileOutputStream fos = new FileOutputStream(dest);
            fos.write(this.data);
            fos.close();
        }

        public String getName() {
            return this.name;
        }
    }
}

