/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import javaforce.ui.ActionListener;
import javaforce.ui.Dimension;
import javaforce.ui.FontMetrics;
import javaforce.ui.Image;
import javaforce.ui.TextComponent;

public class Button
extends TextComponent {
    private ActionListener action;
    private Image icon;

    public Button(String text) {
        super(false);
        this.setText(text);
        this.setFocusable(true);
    }

    public Button(Image image) {
        super(false);
        this.setImage(image);
        this.setFocusable(true);
    }

    @Override
    public Dimension getMinSize() {
        if (this.icon != null) {
            return new Dimension(this.icon.getWidth() + 8, this.icon.getHeight() + 8);
        }
        FontMetrics metrics = this.getFont().getMetrics(this.getText());
        return new Dimension(metrics.getWidth() + 8, metrics.getHeight() + 8);
    }

    protected void renderText(Image image, int dx, int dy) {
        image.drawText(this.pos.x + dx, this.pos.y + dy - this.getFont().getMaxAscent(), this.getText());
    }

    @Override
    public void render(Image image) {
        int x = this.pos.x;
        int y = this.pos.y;
        int w = this.size.width;
        int h = this.size.height;
        if (w == 0 || h == 0) {
            return;
        }
        if (this.isEnabled()) {
            image.setForeColor(this.getForeColor());
        } else {
            image.setForeColor(this.getDisabledColor());
        }
        image.setLineStyle(1);
        image.drawBox(x, y, w, h);
        if (this.isFocused()) {
            image.setLineStyle(2);
            image.drawBox(x + 1, y + 1, w - 2, h - 2);
            image.setLineStyle(1);
        }
        if (this.icon == null) {
            this.renderText(image, 4, 4);
        } else {
            image.drawImageBlend(this.icon, x + (this.getWidth() - this.icon.getWidth()) / 2, y + (this.getHeight() - this.icon.getHeight()) / 2, true);
        }
    }

    public void setImage(Image image) {
        this.icon = image;
    }

    public String toString() {
        return "Button:" + this.getText();
    }

    protected void doAction() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.action != null) {
            this.action.actionPerformed(this);
        }
    }

    @Override
    public void mouseUp(int button) {
        if (button == 1) {
            this.doAction();
        }
    }

    @Override
    public void keyReleased(int key) {
        if (key == 32) {
            this.doAction();
        }
    }

    public void setActionListner(ActionListener action) {
        this.action = action;
    }
}

