/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import java.util.Arrays;
import javaforce.JF;
import javaforce.ui.Dimension;
import javaforce.ui.FontComponent;
import javaforce.ui.Point;
import javaforce.ui.ScrollBox;
import javaforce.ui.ScrollLink;

public class TextComponent
extends FontComponent
implements ScrollLink {
    private char[][] text;
    private int sel_start_off = -1;
    private int sel_start_ln = -1;
    private int sel_end_off = -1;
    private int sel_end_ln = -1;
    private int cur_off = 0;
    private int cur_ln = 0;
    private int offx = 0;
    private int offy = 0;
    private boolean multi;
    private boolean overwrite;
    private ScrollBox link;
    private Dimension minsize = new Dimension();

    public TextComponent(boolean multi) {
        this.multi = multi;
        this.text = new char[1][0];
    }

    @Override
    public Dimension getMinSize() {
        if (this.link == null) {
            Dimension size = super.getMinSize();
            this.minsize.width = size.width;
            this.minsize.height = size.height;
        } else {
            int adv = this.getFont().getMaxAdvance();
            int fonty = this.getFont().getMaxHeight();
            this.minsize.width = this.getMaxLength() * adv;
            this.minsize.height = this.getLineCount() * fonty;
        }
        return this.minsize;
    }

    public String getText() {
        return new String(this.text[this.cur_ln]);
    }

    public String getLineText(int line) {
        return new String(this.text[line]);
    }

    public void setText(String text) {
        if (this.multi) {
            String[] lns = text.replaceAll("\r", "").split("\n");
            int lines = lns.length;
            this.text = new char[lines][];
            for (int line = 0; line < lines; ++line) {
                this.text[line] = lns[line].toCharArray();
            }
        } else {
            this.text[this.cur_ln] = text.toCharArray();
        }
        this.showCursor();
    }

    public void setLineText(int line, String text) {
        this.text[line] = text.toCharArray();
        this.showCursor();
    }

    public int getLength() {
        return this.text[this.cur_ln].length;
    }

    public int getLineLength(int line) {
        return this.text[line].length;
    }

    public int getMaxLength() {
        int max = 0;
        for (int a = 0; a < this.text.length; ++a) {
            int length = this.text[a].length;
            if (length <= max) continue;
            max = length;
        }
        return max;
    }

    public int getLineCount() {
        return this.text.length;
    }

    private void insertLine(int line, char[] newLine) {
        this.text = JF.copyOfInsert(this.text, line, newLine);
    }

    private void deleteLine(int line) {
        this.text = (char[][])JF.copyOfExcluding(this.text, line);
    }

    private void splitLine() {
        char[] end = Arrays.copyOfRange(this.text[this.cur_ln], this.cur_off, this.getLength());
        this.text[this.cur_ln] = Arrays.copyOfRange(this.text[this.cur_ln], 0, this.cur_off);
        this.insertLine(this.cur_ln + 1, end);
    }

    public int getSelectionStartOffset() {
        return this.sel_start_off;
    }

    public int getSelectionStartLine() {
        return this.sel_start_ln;
    }

    public int getSelectionEndOffset() {
        return this.sel_end_off;
    }

    public int getSelectionEndLine() {
        return this.sel_end_ln;
    }

    public int getCursorOffset() {
        return this.cur_off;
    }

    public int getCursorLine() {
        return this.cur_ln;
    }

    public void setCursorPosition(int offset, int line) {
        if (line < 0) {
            line = 0;
        }
        if (line >= this.getLineCount()) {
            line = this.getLineCount() - 1;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset > this.getLineLength(line)) {
            offset = this.getLineLength(line);
        }
        this.cur_ln = line;
        this.cur_off = offset;
        this.showCursor();
    }

    public void setCursorOffset(int offset) {
        this.cur_off = offset;
        this.showCursor();
    }

    public void setCursorLine(int line) {
        this.cur_ln = line;
        this.showCursor();
    }

    public int getViewX() {
        return this.offx;
    }

    public int getViewY() {
        return this.offy;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean state) {
        this.overwrite = state;
    }

    public boolean isEOL() {
        return this.cur_off == this.getLength();
    }

    public boolean haveSelection() {
        return this.sel_start_off != -1;
    }

    private void deleteSelection() {
        if (!this.haveSelection()) {
            return;
        }
        if (this.sel_start_ln == this.sel_end_ln) {
            String text = this.getLineText(this.cur_ln);
            this.setLineText(this.cur_ln, text.substring(0, this.getSelectionStartOffset()) + text.substring(this.getSelectionEndOffset()));
        } else {
            for (int line = this.sel_start_ln; line <= this.sel_end_ln; ++line) {
                if (line == this.sel_start_ln) {
                    this.text[line] = Arrays.copyOfRange(this.text[line], 0, this.sel_start_off);
                    continue;
                }
                if (line == this.sel_end_ln) {
                    this.text[line] = Arrays.copyOfRange(this.text[line], this.sel_end_off, this.text[line].length);
                    continue;
                }
                this.deleteLine(line);
            }
        }
        this.cur_ln = this.sel_start_ln;
        this.cur_off = this.sel_start_off;
        this.clearSelection();
    }

    private void copySelection() {
    }

    private void cutSelection() {
        this.copySelection();
        this.deleteSelection();
    }

    private void pasteSelection() {
        this.insert("TODO");
    }

    private void checkSelection() {
        if (this.sel_start_ln == this.sel_end_ln) {
            if (this.sel_start_off == this.sel_end_off) {
                this.clearSelection();
                return;
            }
            if (this.sel_start_off > this.sel_end_off) {
                int tmp = this.sel_start_off;
                this.sel_start_off = this.sel_end_off;
                this.sel_end_off = tmp;
            }
        } else if (this.sel_start_ln > this.sel_end_ln) {
            int tmp_ln = this.sel_start_ln;
            int tmp_off = this.sel_start_off;
            this.sel_start_ln = this.sel_end_ln;
            this.sel_start_off = this.sel_end_off;
            this.sel_end_ln = tmp_ln;
            this.sel_end_off = tmp_off;
        }
    }

    public void clearSelection() {
        this.sel_start_off = -1;
        this.sel_start_ln = -1;
        this.sel_end_off = -1;
        this.sel_end_ln = -1;
    }

    public void setSelection(int start, int end) {
        this.sel_start_off = start;
        this.sel_start_ln = this.cur_ln;
        this.sel_end_off = end;
        this.sel_end_ln = this.cur_ln;
    }

    public void setMultiSelection(int start_line, int start_offset, int end_line, int end_offset) {
        this.sel_start_off = start_offset;
        this.sel_start_ln = start_line;
        this.sel_end_off = end_offset;
        this.sel_end_ln = end_line;
    }

    private void insert(char ch) {
        String text = this.getLineText(this.cur_ln);
        this.setLineText(this.cur_ln, text.substring(0, this.cur_off) + Character.toString(ch) + text.substring(this.cur_off));
    }

    private void insert(String str) {
    }

    public void showCursor() {
        if (this.cur_ln < 0) {
            this.cur_ln = 0;
        }
        if (this.cur_ln > this.text.length - 1) {
            this.cur_ln = this.text.length - 1;
        }
        if (this.cur_off < 0) {
            this.cur_off = 0;
        }
        if (this.cur_off > this.text[this.cur_ln].length) {
            this.cur_off = this.text[this.cur_ln].length;
        }
        int adv = this.getFont().getMaxAdvance();
        int cx1 = this.getCursorOffset() * adv;
        int cx2 = cx1 + adv - 1;
        int w = this.getWidth();
        if (w == 0) {
            return;
        }
        boolean movedX = false;
        if (cx2 > this.offx + (w -= 2)) {
            this.offx = cx2 - w;
            if (this.offx < 0) {
                this.offx = 0;
            }
            movedX = true;
        }
        if (cx1 < this.offx) {
            this.offx = cx1;
            movedX = true;
        }
        if (movedX && this.link != null) {
            this.link.setClientX(this.offx);
        }
        if (!this.multi) {
            return;
        }
        int fonty = this.getFont().getMaxHeight();
        int cy1 = this.getCursorLine() * fonty;
        int cy2 = cy1 + fonty - 1;
        int h = this.getHeight();
        boolean movedY = false;
        if (cy2 > this.offy + (h -= 2)) {
            this.offy = cy2 - h;
            if (this.offy < 0) {
                this.offy = 0;
            }
            movedY = true;
        }
        if (cy1 < this.offy) {
            this.offy = cy1;
            movedY = true;
        }
        if (movedY && this.link != null) {
            this.link.setClientY(this.offy);
        }
        if (this.link != null) {
            this.link.setFullsize(this.getMinSize());
        }
    }

    @Override
    public void keyTyped(char ch) {
        super.keyTyped(ch);
        if (!this.isEditable()) {
            return;
        }
        if (this.haveSelection()) {
            this.deleteSelection();
        } else if (this.isOverwrite() && !this.isEOL()) {
            this.keyPressed(261);
        }
        this.insert(ch);
        ++this.cur_off;
        this.showCursor();
    }

    @Override
    public void keyPressed(int key) {
        super.keyPressed(key);
        if (!this.isEditable()) {
            return;
        }
        boolean shift = this.getKeyState(340) || this.getKeyState(344);
        boolean ctrl = this.getKeyState(341) || this.getKeyState(345);
        switch (key) {
            case 259: {
                if (this.haveSelection()) {
                    this.deleteSelection();
                    break;
                }
                String text = this.getLineText(this.cur_ln);
                if (text.length() > 0 && this.cur_off > 0) {
                    boolean eol = this.isEOL();
                    this.setLineText(this.cur_ln, text.substring(0, this.cur_off - 1) + text.substring(this.cur_off));
                    if (eol) break;
                    --this.cur_off;
                    break;
                }
                if (this.cur_ln <= 0) break;
                this.deleteLine(this.cur_ln);
                --this.cur_ln;
                String text1 = this.getLineText(this.cur_ln);
                this.setLineText(this.cur_ln, text1 + text);
                this.cur_off = text1.length();
                break;
            }
            case 261: {
                if (this.haveSelection()) {
                    this.copySelection();
                    this.deleteSelection();
                    break;
                }
                String text = this.getLineText(this.cur_ln);
                if (!this.isEOL()) {
                    this.setLineText(this.cur_ln, text.substring(0, this.cur_off) + text.substring(this.cur_off + 1));
                    break;
                }
                if (this.cur_ln >= this.getLineCount() - 1) break;
                String text1 = this.getLineText(this.cur_ln + 1);
                this.deleteLine(this.cur_ln + 1);
                this.setLineText(this.cur_ln, text + text1);
                break;
            }
            case 263: {
                if (this.cur_off == 0) break;
                if (this.haveSelection()) {
                    if (shift) {
                        if (this.sel_start_off == this.cur_off) {
                            --this.sel_start_off;
                        } else {
                            --this.sel_end_off;
                            if (this.sel_start_off == this.sel_end_off && this.sel_start_ln == this.sel_end_ln) {
                                this.clearSelection();
                            }
                        }
                    } else {
                        this.clearSelection();
                    }
                } else if (shift) {
                    this.setSelection(this.cur_off - 1, this.cur_off);
                }
                --this.cur_off;
                break;
            }
            case 262: {
                if (this.cur_off == this.getLength()) break;
                if (this.haveSelection()) {
                    if (shift) {
                        if (this.sel_end_off == this.cur_off) {
                            ++this.sel_end_off;
                        } else {
                            --this.sel_start_off;
                            if (this.sel_start_off == this.sel_end_off && this.sel_start_ln == this.sel_end_ln) {
                                this.clearSelection();
                            }
                        }
                    } else {
                        this.clearSelection();
                    }
                } else if (shift) {
                    this.setSelection(this.cur_off, this.cur_off + 1);
                }
                ++this.cur_off;
                break;
            }
            case 265: {
                if (!this.multi || this.cur_ln == 0) break;
                if (this.haveSelection()) {
                    if (shift) {
                        if (this.sel_start_ln == this.cur_ln) {
                            --this.sel_start_ln;
                        } else {
                            --this.sel_end_ln;
                        }
                        this.checkSelection();
                    } else {
                        this.clearSelection();
                    }
                } else if (shift) {
                    this.setMultiSelection(this.cur_ln - 1, this.cur_off, this.cur_ln, this.cur_off);
                }
                --this.cur_ln;
                if (this.cur_off <= this.getLength()) break;
                this.cur_off = this.getLength();
                break;
            }
            case 264: {
                if (!this.multi || this.cur_ln == this.getLineCount() - 1) break;
                if (this.haveSelection()) {
                    if (shift) {
                        if (this.sel_start_ln == this.cur_ln) {
                            ++this.sel_start_ln;
                        } else {
                            ++this.sel_end_ln;
                        }
                        this.checkSelection();
                    } else {
                        this.clearSelection();
                    }
                } else if (shift) {
                    this.setMultiSelection(this.cur_ln, this.cur_off, this.cur_ln + 1, this.cur_off);
                }
                ++this.cur_ln;
                if (this.cur_off <= this.getLength()) break;
                this.cur_off = this.getLength();
                break;
            }
            case 268: {
                if (this.cur_off == 0) break;
                if (this.haveSelection()) {
                    if (shift) {
                        this.sel_start_off = 0;
                    } else {
                        this.clearSelection();
                    }
                } else if (shift) {
                    this.setSelection(0, this.cur_off);
                }
                this.cur_off = 0;
                break;
            }
            case 269: {
                int length = this.getLength();
                if (this.cur_off == length) break;
                if (this.haveSelection()) {
                    if (shift) {
                        this.sel_end_off = length;
                    } else {
                        this.clearSelection();
                    }
                } else if (shift) {
                    this.setSelection(this.cur_off, length);
                }
                this.cur_off = length;
                break;
            }
            case 260: {
                this.setOverwrite(!this.isOverwrite());
                break;
            }
            case 257: {
                if (!this.multi) break;
                if (this.haveSelection()) {
                    this.deleteSelection();
                }
                if (this.isEOL()) {
                    ++this.cur_ln;
                    this.insertLine(this.cur_ln, new char[0]);
                } else if (this.cur_off == 0) {
                    this.insertLine(this.cur_ln, new char[0]);
                    ++this.cur_ln;
                } else {
                    this.splitLine();
                    ++this.cur_ln;
                }
                this.cur_off = 0;
                break;
            }
            case 120: {
                if (!ctrl) break;
                this.cutSelection();
                break;
            }
            case 99: {
                if (!ctrl) break;
                this.copySelection();
                break;
            }
            case 118: {
                if (!ctrl) break;
                this.pasteSelection();
            }
        }
        this.showCursor();
    }

    @Override
    public int getClientX() {
        return this.offx;
    }

    @Override
    public void setClientX(int value) {
        this.offx = value;
    }

    @Override
    public int getClientY() {
        return this.offy;
    }

    @Override
    public void setClientY(int value) {
        this.offy = value;
    }

    @Override
    public void setLink(ScrollBox link) {
        this.link = link;
    }

    @Override
    public void mouseDown(int button) {
        super.mouseDown(button);
        Point pt = this.getMousePosition();
        int fontx = this.getFont().getMaxAdvance();
        int fonty = this.getFont().getMaxHeight();
        int dy = (pt.y - this.getY() + this.getClientY()) / fonty;
        int dx = (pt.x - this.getX() + this.getClientX()) / fontx;
        this.setCursorPosition(dx, dy);
    }
}

