/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.File;
import java.io.FileInputStream;
import javaforce.JFLog;

public class VMHost {
    private static final long ms_day = 86400000L;

    public static native long total_memory();

    public static native long free_memory();

    public static native long cpu_load();

    public static native boolean get_all_stats(int var0, int var1, int var2, int var3, int var4);

    public static void clean_stats(int days) {
        long ts = System.currentTimeMillis() - (long)days * 86400000L;
        File[] folders = new File("/var/jfkvm/stats").listFiles();
        if (folders == null || folders.length == 0) {
            return;
        }
        for (File folder : folders) {
            File[] files = folder.listFiles();
            int deleted = 0;
            for (File file : files) {
                if (file.lastModified() >= ts) continue;
                file.delete();
                ++deleted;
            }
            if (files.length != deleted) continue;
            folder.delete();
        }
    }

    public static native boolean connect(String var0);

    public static String getHostname() {
        try {
            FileInputStream fis = new FileInputStream("/etc/hostname");
            String hostname = new String(fis.readAllBytes()).trim();
            fis.close();
            return hostname;
        }
        catch (Exception e) {
            JFLog.log(e);
            return "localhost";
        }
    }
}

