/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javaforce.BE;
import javaforce.HTTPS;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;

public class DNS {
    private InetSocketAddress server;
    private int transport;
    public static final int TRANSPORT_UDP = 0;
    public static final int TRANSPORT_DOH = 1;
    public static final int TRANSPORT_DOT = 2;
    private static final int REPLY = 32768;
    private static final int OPCODE_MASK = 30720;
    private static final int OPCODE_QUERY = 0;
    private static final int OPCODE_IQUERY = 16384;
    private static final int OPCODE_UPDATE = 10240;
    private static final int AA = 1024;
    private static final int TC = 512;
    private static final int RD = 256;
    private static final int RA = 128;
    private static final int Z = 64;
    private static final int AD = 32;
    private static final int CD = 16;
    private static final int ERR_NO_ERROR = 0;
    private static final int ERR_NO_SUCH_NAME = 3;
    public static final int TYPE_A = 1;
    public static final int TYPE_NS = 2;
    public static final int TYPE_CNAME = 5;
    public static final int TYPE_SOA = 6;
    public static final int TYPE_PTR = 12;
    public static final int TYPE_MX = 15;
    public static final int TYPE_TXT = 16;
    public static final int TYPE_AAAA = 28;
    public static final int TYPE_LOC = 29;
    public static final int TYPE_SRV = 33;
    public static final int TYPE_NAPTR = 35;
    public static final int TYPE_ANY = 255;

    public DNS(String server) {
        this.server = new InetSocketAddress(server, 53);
        this.transport = 0;
    }

    public DNS(String server, int port) {
        this.server = new InetSocketAddress(server, port);
        this.transport = 0;
    }

    public DNS(int transport, String server) {
        this.server = new InetSocketAddress(server, this.getPort(transport));
        this.transport = transport;
    }

    public DNS(int transport, String server, int port) {
        this.server = new InetSocketAddress(server, port);
        this.transport = transport;
    }

    private int getPort(int transport) {
        int port = 53;
        switch (transport) {
            case 0: {
                port = 53;
                break;
            }
            case 1: {
                port = 443;
                break;
            }
            case 2: {
                port = 853;
            }
        }
        return port;
    }

    public String getServer() {
        return this.server.getHostString();
    }

    public int getPort() {
        return this.server.getPort();
    }

    public String[] resolve(int type, String name) {
        try {
            Packet reply;
            Packet request = new Packet(new byte[1500]);
            int id = new Random().nextInt(65535);
            request.writeShort(id);
            int flgs = 272;
            request.writeShort(flgs);
            request.writeShort(1);
            request.writeShort(0);
            request.writeShort(0);
            request.writeShort(0);
            request.writeName(name);
            request.writeShort(type);
            request.writeShort(1);
            switch (this.transport) {
                case 0: {
                    reply = this.transportUDP(request);
                    break;
                }
                case 1: {
                    reply = this.transportDOH(request);
                    break;
                }
                case 2: {
                    reply = this.transportDOT(request);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (reply == null) {
                return null;
            }
            if (reply.getLength() < 12) {
                throw new Exception("DNS:Reply too short");
            }
            int rid = reply.readShort();
            if (rid != id) {
                throw new Exception(String.format("DNS:Response id(0x%x) != Request id(0x%x)", rid, id));
            }
            int rflgs = reply.readShort();
            if ((rflgs & 0x8000) == 0) {
                throw new Exception("DNS:Response is not a reply");
            }
            int rqueries = reply.readShort();
            int ranswers = reply.readShort();
            int rauth = reply.readShort();
            int radditional = reply.readShort();
            String[] queries = new String[rqueries];
            for (int i = 0; i < rqueries; ++i) {
                queries[i] = reply.readName();
                int qtype = reply.readShort();
                int n = reply.readShort();
            }
            int totalres = ranswers + rauth + radditional;
            String[] resname = new String[totalres];
            ArrayList<Object> results = new ArrayList<Object>();
            for (int i = 0; i < totalres; ++i) {
                resname[i] = reply.readName();
                int qtype = reply.readShort();
                int qclass = reply.readShort();
                int qttl = reply.readInt();
                int qdatalen = reply.readShort();
                int nextOffset = reply.getOffset() + qdatalen;
                switch (qtype) {
                    case 1: {
                        if (qdatalen != 4) {
                            throw new Exception("invalid A data");
                        }
                        byte[] oct4x8 = reply.readBytes(qdatalen);
                        if (type != qtype && type != 255) break;
                        results.add(String.format("%d.%d.%d.%d", oct4x8[0] & 0xFF, oct4x8[1] & 0xFF, oct4x8[2] & 0xFF, oct4x8[3] & 0xFF));
                        break;
                    }
                    case 28: {
                        if (qdatalen != 16) {
                            throw new Exception("invalid AAAA data");
                        }
                        byte[] oct16x8 = reply.readBytes(qdatalen);
                        short[] oct8x16 = new short[8];
                        for (int o = 0; o < 8; ++o) {
                            oct8x16[o] = (short)BE.getuint16(oct16x8, o * 2);
                        }
                        if (type != qtype && type != 255) break;
                        results.add(String.format("%04x:%04x:%04x:%04x:%04x:%04x:%04x:%04x", oct8x16[0] & 0xFFFF, oct8x16[1] & 0xFFFF, oct8x16[2] & 0xFFFF, oct8x16[3] & 0xFFFF, oct8x16[4] & 0xFFFF, oct8x16[5] & 0xFFFF, oct8x16[6] & 0xFFFF, oct8x16[7] & 0xFFFF));
                        break;
                    }
                    case 5: {
                        String cname = reply.readName();
                        if (type != qtype && type != 255) break;
                        results.add(cname);
                        break;
                    }
                    case 6: {
                        String pri_ns = reply.readName();
                        String mailbox = reply.readName();
                        int serial = reply.readInt();
                        int refresh_interval = reply.readInt();
                        int retry_interval = reply.readInt();
                        int expire_limit = reply.readInt();
                        int min_ttl = reply.readInt();
                        if (type != qtype && type != 255) break;
                        results.add(pri_ns);
                        break;
                    }
                    case 12: {
                        String ptr = reply.readName();
                        if (type != qtype && type != 255) break;
                        results.add(ptr);
                        break;
                    }
                    case 2: {
                        String ns = reply.readName();
                        if (type != qtype && type != 255) break;
                        results.add(ns);
                        break;
                    }
                    case 15: {
                        int pri = reply.readShort();
                        String mx = reply.readName();
                        if (type != qtype && type != 255) break;
                        results.add(mx + ":" + pri);
                        break;
                    }
                    case 33: {
                        int pri = reply.readShort();
                        int weight = reply.readShort();
                        int port = reply.readShort();
                        String target = reply.readName();
                        if (type != qtype && type != 255) break;
                        results.add(target + ":" + port);
                        break;
                    }
                    case 35: {
                        int order = reply.readShort();
                        int pref = reply.readShort();
                        int flag_len = reply.readByte();
                        byte[] flags = reply.readBytes(flag_len);
                        int svc_len = reply.readByte();
                        byte[] service2 = reply.readBytes(svc_len);
                        int regex_len = reply.readByte();
                        byte[] regex = reply.readBytes(regex_len);
                        String replacement = reply.readName();
                        if (type != qtype && type != 255) break;
                        results.add(replacement);
                        break;
                    }
                    default: {
                        results.add("unknown type:" + qtype);
                    }
                }
                if (reply.getOffset() == nextOffset) continue;
                throw new Exception("Invalid DNS record");
            }
            if (results.size() == 0) {
                return null;
            }
            return results.toArray(JF.StringArrayType);
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    private Packet transportUDP(Packet request) {
        try {
            DatagramSocket socket = new DatagramSocket();
            DatagramPacket udprequest = new DatagramPacket(request.getData(), request.getSize(), this.server);
            socket.send(udprequest);
            DatagramPacket reply = new DatagramPacket(new byte[1500], 1500);
            socket.receive(reply);
            return new Packet(reply.getData(), reply.getLength());
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    private Packet transportDOH(Packet request) {
        try {
            HTTPS https = new HTTPS();
            https.open(this.server.getHostString(), this.server.getPort());
            byte[] reply = https.post("/dns-query", Arrays.copyOf(request.getData(), request.getSize()), "application/dns-message");
            return new Packet(reply);
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    private Packet transportDOT(Packet request) {
        JFLog.log("DNS over TLS is not working yet!");
        try {
            int read;
            JF.initHttps(KeyMgmt.getDefaultClient());
            Socket socket = JF.connectSSL(this.server.getHostString(), this.server.getPort(), KeyMgmt.getDefaultClient());
            OutputStream os = socket.getOutputStream();
            InputStream is = socket.getInputStream();
            os.write(request.getData(), 0, request.getSize());
            byte[] buf = new byte[1500];
            int total = 0;
            while (total == 0 && (read = is.read(buf, total, buf.length - total)) != -1) {
                JFLog.log("read=" + read);
                if (read <= 0) continue;
                total += read;
            }
            socket.close();
            if (total == 0) {
                throw new Exception("null reply");
            }
            return new Packet(buf, total);
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    private static void test(DNS dns, int type, String domain) {
        JFLog.log("Request=" + domain);
        String[] reply = dns.resolve(type, domain);
        if (reply == null) {
            JFLog.log("  Reply == null");
        } else {
            for (int i = 0; i < reply.length; ++i) {
                JFLog.log("  Reply[]=" + reply[i]);
            }
            if (type == 1 && reply.length > 0) {
                String[] p = reply[0].split("[.]");
                Object reverse = "";
                for (int i = 3; i >= 0; --i) {
                    reverse = (String)reverse + p[i];
                    reverse = (String)reverse + ".";
                }
                reverse = (String)reverse + "in-addr.arpa";
                DNS.test(dns, 12, (String)reverse);
            }
        }
    }

    public static void main(String[] args) {
        DNS dns = new DNS(1, "8.8.8.8");
        DNS.test(dns, 1, "google.com");
        DNS.test(dns, 28, "google.com");
        DNS.test(dns, 5, "google.com");
        DNS.test(dns, 15, "gmail.com");
        DNS.test(dns, 2, "google.com");
        DNS.test(dns, 33, "_ldap._tcp.google.com");
    }

    private static class Packet {
        private byte[] data;
        private int offset;

        public Packet(byte[] data) {
            this.data = data;
        }

        public Packet(byte[] data, int length) {
            this.data = data.length != length ? Arrays.copyOf(data, length) : data;
        }

        public int getLength() {
            return this.data.length;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getSize() {
            return this.offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public int readByte() throws Exception {
            byte value = this.data[this.offset++];
            return value;
        }

        public int readShort() throws Exception {
            int value = BE.getuint16(this.data, this.offset);
            this.offset += 2;
            return value;
        }

        public int readInt() throws Exception {
            int value = BE.getuint32(this.data, this.offset);
            this.offset += 4;
            return value;
        }

        public String readName() {
            StringBuilder str = new StringBuilder();
            int ptr = this.offset;
            boolean compressed = false;
            while (true) {
                int len = this.data[ptr++] & 0xFF;
                if (!compressed) {
                    ++this.offset;
                }
                if (len == 0) break;
                if (len >= 192) {
                    if (!compressed) {
                        ++this.offset;
                    }
                    compressed = true;
                    ptr = BE.getuint16(this.data, ptr - 1) & 0x3FFF;
                    continue;
                }
                String p = new String(this.data, ptr, len);
                if (str.length() > 0) {
                    str.append('.');
                }
                str.append(p);
                ptr += len;
                if (compressed) continue;
                this.offset += len;
            }
            return str.toString();
        }

        public byte[] readBytes(int len) {
            byte[] buf = new byte[len];
            System.arraycopy(this.data, this.offset, buf, 0, len);
            this.offset += len;
            return buf;
        }

        public void writeShort(int value) {
            BE.setuint16(this.data, this.offset, value);
            this.offset += 2;
        }

        public void writeName(String name) {
            String[] ps = name.split("[.]");
            for (int i = 0; i < ps.length; ++i) {
                String p = ps[i];
                int len = p.length();
                this.data[this.offset++] = (byte)len;
                System.arraycopy(p.getBytes(), 0, this.data, this.offset, len);
                this.offset += len;
            }
            this.data[this.offset++] = 0;
        }
    }
}

