/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javaforce.JFLog;

public class JFClassLoader
extends ClassLoader {
    private ArrayList<Folder> cp_folders = new ArrayList();
    private HashMap<String, Folder> cp_files = new HashMap();

    public JFClassLoader(String[] classpath) {
        File[] files = new File[classpath.length];
        int idx = 0;
        for (String cp : classpath) {
            files[idx++] = new File(cp);
        }
        this.init(files);
    }

    public JFClassLoader(File[] classpath) {
        this.init(classpath);
    }

    private void init(File[] classpath) {
        for (File file : classpath) {
            Folder folder;
            if (!file.exists()) {
                JFLog.log("Error:ClassPath element not found:" + file.getAbsolutePath());
                continue;
            }
            if (file.isDirectory()) {
                folder = new Folder();
                this.cp_folders.add(folder);
                this.doFileFolder(file, folder, "");
                continue;
            }
            if (file.getName().endsWith(".jar")) {
                folder = new Folder();
                this.cp_folders.add(folder);
                this.doJarFolder(file, folder, "");
                continue;
            }
            JFLog.log("Unknown ClassPath element:" + String.valueOf(file));
        }
    }

    private void doFileFolder(File folder, Folder file_folder, String path) {
        try {
            File[] files;
            for (File file : files = folder.listFiles()) {
                String name = file.getName();
                if (file.isDirectory()) {
                    this.doFileFolder(file, file_folder, path + "/" + name);
                    continue;
                }
                Object full = path.length() == 0 ? name : path + "/" + name;
                FileInputStream fis = new FileInputStream(file);
                byte[] data = fis.readAllBytes();
                fis.close();
                file_folder.files.put((String)full, data);
                this.cp_files.put((String)full, file_folder);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private void doJarFolder(File jar, Folder jar_folder, String path) {
        try {
            ZipEntry ze;
            ZipInputStream zis = new ZipInputStream(new FileInputStream(jar));
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                if (ze.isDirectory()) continue;
                Object full = path.length() == 0 ? name : path + "/" + name;
                byte[] data = zis.readAllBytes();
                jar_folder.files.put((String)full, data);
                this.cp_files.put((String)full, jar_folder);
            }
            zis.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (Exception exception) {
            byte[] data = this.getData(name);
            if (data == null) {
                return null;
            }
            return this.defineClass(name, data, 0, data.length);
        }
    }

    @Override
    public Class<?> findClass(String module_name, String name) {
        try {
            return super.findClass(module_name, name);
        }
        catch (Exception exception) {
            byte[] data = this.getData(name);
            if (data == null) {
                return null;
            }
            return this.defineClass(name, data, 0, data.length);
        }
    }

    private byte[] getData(String name) {
        Folder folder = this.cp_files.get(name);
        if (folder == null) {
            return null;
        }
        return folder.files.get(name);
    }

    @Override
    public URL findResource(String name) {
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return super.findResources(name);
    }

    @Override
    public URL getResource(String name) {
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return super.getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] data = this.getData(name);
        if (data == null) {
            return super.getResourceAsStream(name);
        }
        return new ByteArrayInputStream(data);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve);
    }

    private static class Folder {
        HashMap<String, byte[]> files = new HashMap();

        private Folder() {
        }
    }
}

