/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyParams;

public class KeyMgmt {
    private static boolean keytool = true;
    private KeyStore keyStore = null;
    private char[] storePass = new char[0];
    private String keyFile = "keystore.ks";
    private String root = "root";
    private static String keyStoreType = "PKCS12";
    private static String keyStoreProvider = "SUN";

    public static boolean keytool(String[] args) {
        ArrayList<Object> cmd = new ArrayList<Object>();
        try {
            if (JF.isWindows()) {
                cmd.add(System.getProperty("java.home") + "\\bin\\keytool.exe");
            } else {
                cmd.add(System.getProperty("java.home") + "/bin/keytool");
            }
            for (int a = 0; a < args.length; ++a) {
                cmd.add(args[a]);
            }
            String[] sa = cmd.toArray(new String[cmd.size()]);
            Process p = Runtime.getRuntime().exec(sa);
            InputStream is = p.getInputStream();
            p.waitFor();
            String output = new String(is.readAllBytes());
            JFLog.log("KeyMgmt.keyTool()=" + output);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public KeyMgmt() {
        try {
            this.open(null);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public KeyMgmt(String keyfile, String storepass) {
        try {
            this.keyFile = keyfile;
            this.storePass = storepass.toCharArray();
            this.open();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void setFile(String keyfile) {
        this.keyFile = keyfile;
    }

    public void setKeyStorePass(String storepass) {
        this.storePass = storepass.toCharArray();
    }

    public void setRootAlias(String alias) {
        this.root = alias;
    }

    public static void setKeyStoreType(String type, String provider) {
        keyStoreType = type;
        keyStoreProvider = provider;
    }

    public void create() {
        this.open(null);
        this.save();
    }

    public void create(String file, String password) {
        this.keyFile = file;
        this.storePass = password.toCharArray();
        this.open(null);
        this.save();
    }

    public boolean open() {
        try {
            this.keyStore = KeyStore.getInstance(keyStoreType, keyStoreProvider);
            FileInputStream fis = new FileInputStream(this.keyFile);
            this.keyStore.load(fis, this.storePass);
            fis.close();
            return true;
        }
        catch (Exception e) {
            this.keyStore = null;
            this.storePass = null;
            JFLog.log(e);
            return false;
        }
    }

    public boolean open(String file, String keystorepass) {
        this.storePass = keystorepass.toCharArray();
        try {
            this.keyStore = KeyStore.getInstance(keyStoreType, keyStoreProvider);
            FileInputStream fis = new FileInputStream(file);
            this.keyStore.load(fis, keystorepass.toCharArray());
            fis.close();
            this.keyFile = file;
            return true;
        }
        catch (Exception e) {
            this.keyStore = null;
            this.storePass = null;
            JFLog.log(e);
            return false;
        }
    }

    public boolean open(InputStream is, String keystorepass) {
        this.storePass = keystorepass.toCharArray();
        try {
            this.keyStore = KeyStore.getInstance(keyStoreType, keyStoreProvider);
            this.keyStore.load(is, this.storePass);
            return true;
        }
        catch (Exception e) {
            this.keyStore = null;
            this.storePass = null;
            JFLog.log(e);
            return false;
        }
    }

    public boolean open(InputStream is) {
        try {
            this.keyStore = KeyStore.getInstance(keyStoreType, keyStoreProvider);
            this.keyStore.load(is, this.storePass);
            return true;
        }
        catch (Exception e) {
            this.keyStore = null;
            this.storePass = null;
            JFLog.log(e);
            return false;
        }
    }

    public boolean save() {
        try {
            if (this.keyFile == null) {
                this.keyFile = "keystore.ks";
            }
            FileOutputStream fos = new FileOutputStream(this.keyFile);
            this.keyStore.store(fos, this.storePass);
            fos.close();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean save(OutputStream os) {
        try {
            if (this.keyFile == null) {
                this.keyFile = "keystore.ks";
            }
            this.keyStore.store(os, this.storePass);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean save(OutputStream os, String keystorepass) {
        this.storePass = keystorepass.toCharArray();
        try {
            this.keyStore.store(os, this.storePass);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static KeyMgmt getDefaultClient() {
        String file = JF.getUserPath() + "/.javaforce-client.ks";
        if (new File(file).exists()) {
            return new KeyMgmt(file, "password");
        }
        KeyParams params = new KeyParams();
        params.dname = "CN=javaforce.sourceforge.net, O=server, OU=webserver, C=CA";
        return KeyMgmt.create(file, "password", "client", params, "password");
    }

    public static KeyMgmt create(String storefile, String storepass, String alias, KeyParams params, String keypass) {
        if (keytool) {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("-genkey");
            cmd.add("-keystore");
            cmd.add(storefile);
            cmd.add("-storepass");
            cmd.add(storepass);
            cmd.add("-keypass");
            cmd.add(keypass);
            cmd.add("-alias");
            cmd.add(alias);
            cmd.add("-validity");
            cmd.add(params.validity);
            cmd.add("-dname");
            cmd.add(params.dname);
            cmd.add("-keyalg");
            cmd.add("RSA");
            cmd.add("-keysize");
            cmd.add("2048");
            if (params.exts != null) {
                for (String ext : params.exts) {
                    cmd.add("-ext");
                    cmd.add(ext);
                }
            }
            KeyMgmt.keytool(cmd.toArray(JF.StringArrayType));
            try {
                FileInputStream fis = new FileInputStream(storefile);
                KeyMgmt keys = new KeyMgmt();
                keys.open(fis, keypass);
                fis.close();
                return keys;
            }
            catch (Exception e) {
                JFLog.log(e);
                return null;
            }
        }
        try {
            KeyMgmt keys = new KeyMgmt();
            keys.keyStore = KeyStore.getInstance(keyStoreType, keyStoreProvider);
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(2048);
            KeyPair pair = gen.generateKeyPair();
            PrivateKey prikey = pair.getPrivate();
            PublicKey pubkey = pair.getPublic();
            keys.keyStore.setKeyEntry(alias, prikey, keypass.toCharArray(), new Certificate[]{null});
            return keys;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public boolean create(String alias, KeyParams params, String keypass) {
        if (keytool) {
            this.save();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("-genkey");
            cmd.add("-alias");
            cmd.add(alias);
            cmd.add("-keypass");
            cmd.add(keypass);
            cmd.add("-storepass");
            cmd.add(this.getKeyStorePass());
            cmd.add("-keystore");
            cmd.add(this.keyFile);
            cmd.add("-validity");
            cmd.add(params.validity);
            cmd.add("-dname");
            cmd.add(params.dname);
            cmd.add("-keyalg");
            cmd.add("RSA");
            cmd.add("-keysize");
            cmd.add("2048");
            if (params.exts != null) {
                for (String ext : params.exts) {
                    cmd.add("-ext");
                    cmd.add(ext);
                }
            }
            KeyMgmt.keytool(cmd.toArray(JF.StringArrayType));
            try {
                FileInputStream fis = new FileInputStream(this.keyFile);
                KeyMgmt keys = new KeyMgmt();
                keys.open(fis, keypass);
                fis.close();
                return true;
            }
            catch (Exception e) {
                JFLog.log(e);
                return false;
            }
        }
        try {
            KeyMgmt keys = new KeyMgmt();
            keys.keyStore = KeyStore.getInstance(keyStoreType, keyStoreProvider);
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(2048);
            KeyPair pair = gen.generateKeyPair();
            PrivateKey prikey = pair.getPrivate();
            PublicKey pubkey = pair.getPublic();
            keys.keyStore.setKeyEntry(alias, prikey, keypass.toCharArray(), new Certificate[]{null});
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean create(String alias, KeyParams params, String keypass, String signerAlias, String signerKeyPass) {
        if (keytool) {
            this.save();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("-genkey");
            cmd.add("-alias");
            cmd.add(alias);
            cmd.add("-keypass");
            cmd.add(keypass);
            cmd.add("-storepass");
            cmd.add(this.getKeyStorePass());
            cmd.add("-keystore");
            cmd.add(this.keyFile);
            cmd.add("-validity");
            cmd.add(params.validity);
            cmd.add("-dname");
            cmd.add(params.dname);
            cmd.add("-keyalg");
            cmd.add("RSA");
            cmd.add("-keysize");
            cmd.add("2048");
            cmd.add("-signer");
            cmd.add(signerAlias);
            cmd.add("-signerkeypass");
            cmd.add(signerKeyPass);
            if (params.exts != null) {
                for (String ext : params.exts) {
                    cmd.add("-ext");
                    cmd.add(ext);
                }
            }
            KeyMgmt.keytool(cmd.toArray(JF.StringArrayType));
            try {
                FileInputStream fis = new FileInputStream(this.keyFile);
                KeyMgmt keys = new KeyMgmt();
                keys.open(fis, keypass);
                fis.close();
                return true;
            }
            catch (Exception e) {
                JFLog.log(e);
                return false;
            }
        }
        try {
            KeyMgmt keys = new KeyMgmt();
            keys.keyStore = KeyStore.getInstance(keyStoreType, keyStoreProvider);
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(2048);
            KeyPair pair = gen.generateKeyPair();
            PrivateKey prikey = pair.getPrivate();
            PublicKey pubkey = pair.getPublic();
            keys.keyStore.setKeyEntry(alias, prikey, keypass.toCharArray(), new Certificate[]{null});
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean createCertSignRequest(String alias, String keypass, String out_file_csr) {
        this.save();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("-certreq");
        cmd.add("-alias");
        cmd.add(alias);
        cmd.add("-keypass");
        cmd.add(this.getKeyStorePass());
        cmd.add("-storepass");
        cmd.add(keypass);
        cmd.add("-keystore");
        cmd.add(this.keyFile);
        cmd.add("-keyalg");
        cmd.add("RSA");
        cmd.add("-keysize");
        cmd.add("2048");
        cmd.add("-file");
        cmd.add(out_file_csr);
        KeyMgmt.keytool(cmd.toArray(JF.StringArrayType));
        return true;
    }

    public boolean signRequest(String alias, String keypass, String in_file_csr, String out_file_crt) {
        this.save();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("-gencert");
        cmd.add("-alias");
        cmd.add(alias);
        cmd.add("-storepass");
        cmd.add(this.getKeyStorePass());
        cmd.add("-keypass");
        cmd.add(keypass);
        cmd.add("-keystore");
        cmd.add(this.keyFile);
        cmd.add("-keyalg");
        cmd.add("RSA");
        cmd.add("-keysize");
        cmd.add("2048");
        cmd.add("-sigalg");
        cmd.add("RSA");
        cmd.add("-infile");
        cmd.add(in_file_csr);
        cmd.add("-outfile");
        cmd.add(out_file_crt);
        KeyMgmt.keytool(cmd.toArray(JF.StringArrayType));
        return true;
    }

    public boolean loadKEYandCRT(String alias, InputStream keyStream, InputStream certStream, String keypass) {
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            byte[] key = JF.readAll(keyStream);
            PKCS8EncodedKeySpec keysp = new PKCS8EncodedKeySpec(key);
            PrivateKey ff = kf.generatePrivate(keysp);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> c = cf.generateCertificates(certStream);
            Certificate[] certs = (Certificate[])c.toArray();
            this.keyStore.setKeyEntry(alias, ff, keypass.toCharArray(), certs);
            return true;
        }
        catch (Exception e) {
            this.keyStore = null;
            this.storePass = null;
            JFLog.log(e);
            return false;
        }
    }

    public boolean loadCRT(String alias, InputStream certStream) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate crt = cf.generateCertificate(certStream);
            this.keyStore.setCertificateEntry(alias, crt);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean hasCRT(InputStream certStream) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate crt = cf.generateCertificate(certStream);
            return this.keyStore.getCertificateAlias(crt) != null;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public KeyStore.Entry getEntry(String alias) {
        try {
            return this.keyStore.getEntry(alias, new KeyStore.PasswordProtection(this.storePass));
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public boolean setEntry(String alias, KeyStore.Entry entry) {
        try {
            this.keyStore.setEntry(alias, entry, new KeyStore.PasswordProtection(this.storePass));
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean deleteEntry(String alias) {
        try {
            this.keyStore.deleteEntry(alias);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public Certificate getCRT(String alias) {
        try {
            return this.keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean exportCRT(String alias, String fileout) {
        try {
            Certificate crt = this.getCRT(alias);
            byte[] data = crt.getEncoded();
            FileOutputStream fos = new FileOutputStream(fileout);
            fos.write(data);
            fos.close();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public Key getKEY(String alias, String keypass) {
        try {
            return this.keyStore.getKey(alias, keypass.toCharArray());
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean exportKEY(String alias, String keypass, String fileout) {
        try {
            Key key = this.getKEY(alias, keypass);
            byte[] data = key.getEncoded();
            FileOutputStream fos = new FileOutputStream(fileout);
            fos.write(data);
            fos.close();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static String fingerprintSHA256(byte[] key) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] res = md.digest(key);
            StringBuilder sb = new StringBuilder();
            for (int a = 0; a < res.length; ++a) {
                int b = res[a] & 0xFF;
                if (a > 0) {
                    sb.append(":");
                }
                if (b < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toString(b, 16).toUpperCase());
            }
            return sb.toString();
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public boolean isValid() {
        return this.keyStore != null && this.storePass != null;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePass() {
        return new String(this.storePass);
    }

    public int getCount() {
        try {
            return this.keyStore.size();
        }
        catch (Exception e) {
            JFLog.log(e);
            return 0;
        }
    }

    public boolean verify(String alias) {
        Certificate rootcert = this.getCRT(this.root);
        if (rootcert == null) {
            return false;
        }
        PublicKey key = rootcert.getPublicKey();
        Certificate cert = this.getCRT(alias);
        try {
            cert.verify(key);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean contains(String alias) {
        try {
            return this.keyStore.containsAlias(alias);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }
}

