/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;

public class SQL {
    public Exception lastException;
    public String[] colNames;
    public static boolean debug = false;
    private Connection conn;
    public static String derbySQL = "org.apache.derby.jdbc.EmbeddedDriver";
    public static String msSQL = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static String mySQL = "com.mysql.jdbc.Driver";
    public static String oracleSQL = "oracle.jdbc.driver.OracleDriver";
    public static String jTDS = "net.sourceforge.jtds.jdbc.Driver";
    public static String UniData = "com.ibm.u2.jdbc.UniJDBCDriver";

    public static boolean initClass(String jdbcClass) {
        try {
            Class<?> cls = Class.forName(jdbcClass);
            Constructor<?> ctor = cls.getConstructor(new Class[0]);
            ctor.newInstance(new Object[0]);
            return true;
        }
        catch (Exception e) {
            JFLog.log("Error:Unable to find class:" + jdbcClass);
            return false;
        }
    }

    public boolean connect(String connectionURL) {
        try {
            this.conn = DriverManager.getConnection(connectionURL);
            if (this.conn == null) {
                JFLog.log("Error:Unable to connect to database:" + connectionURL);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.lastException = e;
            JFLog.log(e);
            return false;
        }
    }

    public boolean connect(String jdbcClass, String connectionURL) {
        if (!SQL.initClass(jdbcClass)) {
            return false;
        }
        return this.connect(connectionURL);
    }

    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.conn = null;
        }
    }

    public static String quote(String str) {
        char[] strca = str.toCharArray();
        char[] strca2 = new char[strca.length + 2];
        block3: for (int a = 0; a < strca.length; ++a) {
            switch (strca[a]) {
                case '\"': 
                case '\'': {
                    strca2[a + 1] = 32;
                    continue block3;
                }
                default: {
                    strca2[a + 1] = strca[a];
                }
            }
        }
        strca2[0] = 39;
        strca2[strca.length + 1] = 39;
        return new String(strca2);
    }

    public static String numbers(String str) {
        return JF.filter(str, JF.filter_numeric);
    }

    public static String letters(String str) {
        return "'" + JF.filter(str, JF.filter_alpha) + "'";
    }

    public static String letters_numbers(String str) {
        return "'" + JF.filter(str, JF.filter_alpha_numeric) + "'";
    }

    public boolean execute(String str) {
        Statement stmt = null;
        Object rs = null;
        Object rsmd = null;
        if (debug) {
            JFLog.log(str);
        }
        try {
            stmt = this.conn.createStatement();
            stmt.execute(str);
            stmt.close();
        }
        catch (Exception e) {
            this.lastException = e;
            JFLog.log(str);
            JFLog.log(e);
            return false;
        }
        return true;
    }

    public String select1value(String str) {
        String ret;
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        if (debug) {
            JFLog.log(str);
        }
        try {
            stmt = this.conn.createStatement();
            if (!stmt.execute(str)) {
                throw new Exception();
            }
            rs = stmt.getResultSet();
            rsmd = rs.getMetaData();
            int colcnt = rsmd.getColumnCount();
            this.colNames = new String[colcnt];
            for (int c = 0; c < colcnt; ++c) {
                this.colNames[c] = rsmd.getColumnName(c + 1);
            }
            if (!rs.next()) {
                stmt.close();
                return null;
            }
            ret = rs.getString(1);
            stmt.close();
        }
        catch (Exception e) {
            this.lastException = e;
            JFLog.log(str);
            JFLog.log(e);
            return null;
        }
        return ret;
    }

    public String[] select1row(String str) {
        String[] ret;
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        if (debug) {
            JFLog.log(str);
        }
        try {
            stmt = this.conn.createStatement();
            if (!stmt.execute(str)) {
                throw new Exception();
            }
            rs = stmt.getResultSet();
            rsmd = rs.getMetaData();
            int colcnt = rsmd.getColumnCount();
            this.colNames = new String[colcnt];
            for (int c = 0; c < colcnt; ++c) {
                this.colNames[c] = rsmd.getColumnName(c + 1);
            }
            ret = new String[colcnt];
            if (!rs.next()) {
                stmt.close();
                return null;
            }
            for (int a = 0; a < colcnt; ++a) {
                ret[a] = rs.getString(a + 1);
            }
            stmt.close();
        }
        catch (Exception e) {
            this.lastException = e;
            JFLog.log(str);
            JFLog.log(e);
            return null;
        }
        return ret;
    }

    public String[] select1col(String str) {
        ArrayList<String> rows = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        if (debug) {
            JFLog.log(str);
        }
        try {
            stmt = this.conn.createStatement();
            if (!stmt.execute(str)) {
                throw new Exception();
            }
            rs = stmt.getResultSet();
            rsmd = rs.getMetaData();
            int colcnt = rsmd.getColumnCount();
            this.colNames = new String[colcnt];
            for (int c = 0; c < colcnt; ++c) {
                this.colNames[c] = rsmd.getColumnName(c + 1);
            }
            while (rs.next()) {
                rows.add(rs.getString(1));
            }
            stmt.close();
        }
        catch (Exception e) {
            this.lastException = e;
            JFLog.log(str);
            JFLog.log(e);
            return null;
        }
        String[] ret = new String[rows.size()];
        for (int r = 0; r < rows.size(); ++r) {
            ret[r] = (String)rows.get(r);
        }
        return ret;
    }

    public String[][] select(String str) {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        if (debug) {
            JFLog.log(str);
        }
        try {
            int c;
            stmt = this.conn.createStatement();
            if (!stmt.execute(str)) {
                throw new Exception();
            }
            rs = stmt.getResultSet();
            rsmd = rs.getMetaData();
            int colcnt = rsmd.getColumnCount();
            this.colNames = new String[colcnt];
            for (c = 0; c < colcnt; ++c) {
                this.colNames[c] = rsmd.getColumnName(c + 1);
            }
            while (rs.next()) {
                String[] row = new String[colcnt];
                rows.add(row);
                for (c = 0; c < colcnt; ++c) {
                    row[c] = rs.getString(c + 1);
                }
            }
            stmt.close();
        }
        catch (Exception e) {
            this.lastException = e;
            JFLog.log(str);
            JFLog.log(e);
            return null;
        }
        String[][] ret = new String[rows.size()][];
        for (int r = 0; r < rows.size(); ++r) {
            ret[r] = (String[])rows.get(r);
        }
        return ret;
    }

    public int getColumnIndex(String col) {
        if (this.colNames == null) {
            return -1;
        }
        for (int idx = 0; idx < this.colNames.length; ++idx) {
            if (!this.colNames.equals(col)) continue;
            return idx;
        }
        return -1;
    }

    public Exception getLastException() {
        return this.lastException;
    }
}

