/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import javaforce.Condition;
import javaforce.Console;
import javaforce.JFLog;
import javaforce.RelayStream;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;

public class SSH {
    private SshClient client;
    private ClientSession session;
    private ClientChannel channel;
    private InputStream in;
    private OutputStream out;
    private Object[] pipes;

    public boolean connect(String host, int port, String username, String password) {
        try {
            this.client = SshClient.setUpDefaultClient();
            this.client.start();
            ConnectFuture cf = this.client.connect(username, host, port);
            this.session = (ClientSession)((ConnectFuture)cf.verify(new CancelOption[0])).getSession();
            this.session.addPasswordIdentity(password);
            this.session.auth().verify(30000L, new CancelOption[0]);
            this.channel = this.session.createChannel("shell");
            this.pipes = this.createPipes();
            if (this.pipes == null) {
                return false;
            }
            this.out = (OutputStream)this.pipes[1];
            this.channel.setIn((InputStream)this.pipes[0]);
            this.pipes = this.createPipes();
            if (this.pipes == null) {
                return false;
            }
            this.in = (InputStream)this.pipes[0];
            this.channel.setOut((OutputStream)this.pipes[1]);
            this.channel.open();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public void disconnect() {
        try {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean connected() {
        return this.client.isOpen();
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    private Object[] createPipes() {
        Object[] ret = new Object[2];
        try {
            ret[0] = new PipedInputStream();
            ret[1] = new PipedOutputStream((PipedInputStream)ret[0]);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void usage() {
        System.out.println("jfssh [user@]host[:port] [-p port]");
        System.exit(1);
    }

    public static void error(String msg) {
        System.out.println("Error:" + msg);
        System.exit(2);
    }

    public static void main(String[] args) {
        String dest = null;
        int port = 22;
        ArrayList<String> cmd = new ArrayList<String>();
        String argtype = null;
        for (String arg : args) {
            if (argtype != null) {
                switch (argtype) {
                    case "-p": {
                        port = Integer.valueOf(arg);
                    }
                }
                argtype = null;
                continue;
            }
            if (arg.startsWith("-")) {
                switch (arg) {
                    case "-p": {
                        argtype = arg;
                        break;
                    }
                    default: {
                        SSH.usage();
                        break;
                    }
                }
                continue;
            }
            if (dest == null) {
                dest = arg;
                continue;
            }
            cmd.add(arg);
        }
        if (dest == null) {
            SSH.usage();
        }
        String user = null;
        String host = null;
        int idx = dest.indexOf(64);
        if (idx == -1) {
            host = dest;
        } else {
            user = dest.substring(0, idx);
            host = dest.substring(idx + 1);
        }
        idx = host.indexOf(58);
        if (idx != -1) {
            port = Integer.valueOf(host.substring(idx + 1));
            host = host.substring(0, idx);
        }
        System.out.print("Enter Password:");
        String pass = new String(System.console().readPassword());
        SSH ssh = new SSH();
        if (!ssh.connect(host, port, user, pass)) {
            SSH.error("Connection failed");
        }
        Condition connected = () -> ssh.connected();
        RelayStream rs1 = new RelayStream(Console.getInputStream(), ssh.getOutputStream(), connected);
        RelayStream rs2 = new RelayStream(ssh.getInputStream(), Console.getOutputStream(), connected);
        rs1.start();
        rs2.start();
        try {
            rs1.join();
            rs2.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

