/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ansi.client;

import java.awt.Color;
import javaforce.ASCII8;
import javaforce.JFLog;
import javaforce.ansi.client.Buffer;

public class ANSI {
    public static final char ESC = '\u001b';
    public static final int[][] clrs = new int[][]{{0, 0x880000, 34816, 0x888800, 136, 0x880088, 34952, 0x888888}, {0x444444, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF}};
    public boolean altfnt = false;
    public boolean keypadMode = false;
    public char altcode = (char)91;
    public int high = 0;
    private int savedx = -1;
    private int savedy = -1;
    private Color orgForeColor;
    private Color orgBackColor;
    private boolean telnet;
    public int numc;
    public int[] nums = new int[16];
    private static char[] altfntchars = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00b1', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00d9', '\u00bf', '\u00da', '\u00c0', '\u0000', '\u0000', '\u0000', '\u00c4', '\u0000', '\u0000', '\u00c3', '\u00b4', '\u00c1', '\u00c2', '\u00b3', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};

    public ANSI(Buffer buffer, boolean telnet) {
        this.orgForeColor = buffer.getForeColor();
        this.orgBackColor = buffer.getBackColor();
    }

    public char encodeChar(char ch) {
        if (!this.altfnt) {
            if (ch > '\u007f' && ch < '\u0100') {
                ch = ASCII8.convert(ch);
            }
            return ch;
        }
        char ret = altfntchars[ch];
        if (ret == '\u0000') {
            ret = ch;
        }
        if (ret > '\u007f' && ret < '\u0100') {
            ret = ASCII8.convert(ret);
        }
        return ret;
    }

    public char[] encodeString(char[] buf, int buflen) {
        char[] ret = new char[buflen];
        for (int a = 0; a < buflen; ++a) {
            ret[a] = this.encodeChar(buf[a]);
        }
        return ret;
    }

    public void keyPressed(int keyCode, int keyMods, Buffer buffer) {
        Object str = null;
        if (keyMods == 128) {
            if (keyCode >= 65 && keyCode <= 90) {
                str = "" + (char)(keyCode - 65 + 1);
            }
            switch (keyCode) {
                case 38: {
                    str = "\u001b" + this.altcode + "1;5A";
                    break;
                }
                case 40: {
                    str = "\u001b" + this.altcode + "1;5B";
                    break;
                }
                case 39: {
                    str = "\u001b" + this.altcode + "1;5C";
                    break;
                }
                case 37: {
                    str = "\u001b" + this.altcode + "1;5D";
                }
            }
        }
        if (keyMods == 512) {
            switch (keyCode) {
                case 38: {
                    str = "\u001b" + this.altcode + "1;3A";
                    break;
                }
                case 40: {
                    str = "\u001b" + this.altcode + "1;3B";
                    break;
                }
                case 39: {
                    str = "\u001b" + this.altcode + "1;3C";
                    break;
                }
                case 37: {
                    str = "\u001b" + this.altcode + "1;3D";
                }
            }
        }
        if (keyMods == 64) {
            switch (keyCode) {
                case 38: {
                    str = "\u001b" + this.altcode + "1;2A";
                    break;
                }
                case 40: {
                    str = "\u001b" + this.altcode + "1;2B";
                    break;
                }
                case 39: {
                    str = "\u001b" + this.altcode + "1;2C";
                    break;
                }
                case 37: {
                    str = "\u001b" + this.altcode + "1;2D";
                    break;
                }
                case 112: {
                    str = "\u001b[25~";
                    break;
                }
                case 113: {
                    str = "\u001b[26~";
                    break;
                }
                case 114: {
                    str = "\u001b[28~";
                    break;
                }
                case 115: {
                    str = "\u001b[29~";
                    break;
                }
                case 116: {
                    str = "\u001b[31~";
                    break;
                }
                case 117: {
                    str = "\u001b[32~";
                    break;
                }
                case 118: {
                    str = "\u001b[33~";
                    break;
                }
                case 119: {
                    str = "\u001b[34~";
                }
            }
        }
        if (str != null) {
            buffer.output(((String)str).toCharArray());
        }
        if (keyMods != 0) {
            return;
        }
        switch (keyCode) {
            case 38: {
                str = "\u001b" + this.altcode + "A";
                break;
            }
            case 40: {
                str = "\u001b" + this.altcode + "B";
                break;
            }
            case 39: {
                str = "\u001b" + this.altcode + "C";
                break;
            }
            case 37: {
                str = "\u001b" + this.altcode + "D";
                break;
            }
            case 36: {
                str = "\u001b[H";
                break;
            }
            case 35: {
                str = "\u001b[F";
                break;
            }
            case 112: {
                str = "\u001b" + this.altcode + "P";
                break;
            }
            case 113: {
                str = "\u001b" + this.altcode + "Q";
                break;
            }
            case 114: {
                str = "\u001b" + this.altcode + "R";
                break;
            }
            case 115: {
                str = "\u001b" + this.altcode + "S";
                break;
            }
            case 116: {
                if (this.telnet) {
                    str = "\u00ff\u00f3";
                    break;
                }
                str = "\u001b[15~";
                break;
            }
            case 117: {
                str = "\u001b[17~";
                break;
            }
            case 118: {
                str = "\u001b[18~";
                break;
            }
            case 119: {
                str = "\u001b[19~";
                break;
            }
            case 120: {
                str = "\u001b[20~";
                break;
            }
            case 121: {
                str = "\u001b[21~";
                break;
            }
            case 122: {
                str = "\u001b[23~";
                break;
            }
            case 123: {
                str = "\u001b[24~";
                break;
            }
            case 127: {
                str = "\u001b[3~";
                break;
            }
            case 33: {
                str = "\u001b[5~";
                break;
            }
            case 34: {
                str = "\u001b[6~";
                break;
            }
            case 19: {
                str = "\u00ff\u00f3";
            }
        }
        if (str != null) {
            buffer.output(((String)str).toCharArray());
        }
    }

    public boolean decode(char[] code, int codelen, Buffer buffer) {
        block134: {
            int x = buffer.getx();
            int y = buffer.gety();
            if (codelen < 2) {
                return false;
            }
            switch (code[1]) {
                case 'H': {
                    JFLog.log("ANSI:Not implemented:" + code[1]);
                    return true;
                }
                case 'M': {
                    if (y <= buffer.gety1()) {
                        buffer.scrollDown(1);
                    } else {
                        buffer.gotoPos(x, y - 1);
                    }
                    return true;
                }
                case 'D': {
                    if (y >= buffer.gety2()) {
                        buffer.scrollUp(1);
                    } else {
                        buffer.gotoPos(x, y + 1);
                    }
                    return true;
                }
                case '7': {
                    this.savedx = x;
                    this.savedy = y;
                    return true;
                }
                case '8': {
                    if (this.savedx == -1) {
                        return true;
                    }
                    buffer.gotoPos(this.savedx, this.savedy);
                    return true;
                }
                case '=': {
                    this.keypadMode = true;
                    return true;
                }
                case '>': {
                    this.keypadMode = false;
                    return true;
                }
                case '#': 
                case '(': 
                case '[': 
                case ']': {
                    break;
                }
                default: {
                    JFLog.log("ANSI:Unknown code:" + code[1]);
                    return true;
                }
            }
            if (codelen < 3) {
                return false;
            }
            block10 : switch (code[1]) {
                case '#': {
                    break;
                }
                case '(': {
                    switch (code[2]) {
                        case 'A': {
                            this.altfnt = false;
                            break;
                        }
                        case 'B': {
                            this.altfnt = false;
                            break;
                        }
                        case '0': {
                            this.altfnt = true;
                            break;
                        }
                        case '1': {
                            this.altfnt = false;
                            break;
                        }
                        case '2': {
                            this.altfnt = false;
                        }
                    }
                    break;
                }
                case ']': {
                    if (code[codelen - 1] == '\u0007') break;
                    return false;
                }
                case '[': {
                    if (!(code[codelen - 1] >= 'A' && code[codelen - 1] <= 'Z' || code[codelen - 1] >= 'a' && code[codelen - 1] <= 'z' || code[codelen - 1] == '~' || code[codelen - 1] == '@')) {
                        return false;
                    }
                    if (code[2] == '?') {
                        this.decodeNums(code, codelen, 3);
                        switch (code[codelen - 1]) {
                            case 'h': {
                                block76: for (int a = 0; a < this.numc; ++a) {
                                    switch (this.nums[a]) {
                                        case 1: {
                                            this.altcode = (char)79;
                                            continue block76;
                                        }
                                        case 7: {
                                            buffer.setAutoWrap(false);
                                            continue block76;
                                        }
                                        case 12: {
                                            continue block76;
                                        }
                                        case 25: {
                                            continue block76;
                                        }
                                        default: {
                                            JFLog.log("ANSI:Unknown [ ? h:" + this.nums[a]);
                                        }
                                    }
                                }
                                return true;
                            }
                            case 'l': {
                                block77: for (int a = 0; a < this.numc; ++a) {
                                    switch (this.nums[a]) {
                                        case 1: {
                                            this.altcode = (char)91;
                                            continue block77;
                                        }
                                        case 7: {
                                            buffer.setAutoWrap(true);
                                            continue block77;
                                        }
                                        case 12: {
                                            continue block77;
                                        }
                                        case 25: {
                                            continue block77;
                                        }
                                        default: {
                                            JFLog.log("ANSI:Unknown [ ? l:" + this.nums[a]);
                                        }
                                    }
                                }
                                return true;
                            }
                        }
                        JFLog.log("ANSI:Unknown [ ? code:" + code[codelen - 1]);
                        return true;
                    }
                    this.decodeNums(code, codelen, 2);
                    switch (code[codelen - 1]) {
                        case 'J': {
                            if (this.numc == 0) {
                                this.nums[0] = 0;
                            }
                            switch (this.nums[0]) {
                                case 0: {
                                    for (int a = x; a <= buffer.sx; ++a) {
                                        buffer.setChar(a, y, ' ');
                                    }
                                    for (int b = y + 1; b <= buffer.sy; ++b) {
                                        for (int a = 1; a <= buffer.sx; ++a) {
                                            buffer.setChar(a, b, ' ');
                                        }
                                    }
                                    break block134;
                                }
                                case 1: {
                                    for (int a = 1; a < x; ++a) {
                                        buffer.setChar(a, y, ' ');
                                    }
                                    for (int b = 1; b < y; ++b) {
                                        for (int a = 1; a <= buffer.sx; ++a) {
                                            buffer.setChar(a, b, ' ');
                                        }
                                    }
                                    break block134;
                                }
                                case 2: {
                                    buffer.clrscr();
                                }
                            }
                            break block134;
                        }
                        case 'K': {
                            if (this.numc == 0) {
                                this.nums[0] = 0;
                            }
                            switch (this.nums[0]) {
                                case 0: {
                                    for (int a = x; a <= buffer.sx; ++a) {
                                        buffer.setChar(a, y, ' ');
                                    }
                                    break block134;
                                }
                                case 1: {
                                    for (int a = 1; a < x; ++a) {
                                        buffer.setChar(a, y, ' ');
                                    }
                                    break block134;
                                }
                                case 2: {
                                    for (int a = 1; a <= buffer.sx; ++a) {
                                        buffer.setChar(a, y, ' ');
                                    }
                                }
                            }
                            break block134;
                        }
                        case 'H': 
                        case 'f': {
                            if (this.numc == 2 && this.nums[1] == 0) {
                                this.numc = 1;
                            }
                            if (this.numc == 1 && this.nums[0] == 0) {
                                this.numc = 0;
                            }
                            switch (this.numc) {
                                case 2: {
                                    buffer.gotoPos(this.min(buffer.sx, this.nums[1]), this.min(buffer.sy, this.nums[0]));
                                    break block10;
                                }
                                case 1: {
                                    buffer.gotoPos(1, this.min(buffer.sy, this.nums[0]));
                                    break block10;
                                }
                                case 0: {
                                    buffer.gotoPos(1, 1);
                                }
                            }
                            break block10;
                        }
                        case 'A': {
                            if (this.numc == 0) {
                                this.nums[0] = 1;
                            }
                            if (y - this.nums[0] > 1) {
                                buffer.gotoPos(x, y - this.nums[0]);
                                break block10;
                            }
                            buffer.gotoPos(x, 1);
                            break block10;
                        }
                        case 'B': {
                            if (this.numc == 0) {
                                this.nums[0] = 1;
                            }
                            if (y + this.nums[0] < buffer.sy) {
                                buffer.gotoPos(x, y + this.nums[0]);
                                break block10;
                            }
                            buffer.gotoPos(x, buffer.sy);
                            break block10;
                        }
                        case 'C': {
                            if (this.numc == 0) {
                                this.nums[0] = 1;
                            }
                            if (x + this.nums[0] < buffer.sx) {
                                buffer.gotoPos(x + this.nums[0], y);
                                break block10;
                            }
                            buffer.gotoPos(buffer.sx, y);
                            break block10;
                        }
                        case 'D': {
                            if (this.numc == 0) {
                                this.nums[0] = 1;
                            }
                            if (x - this.nums[0] > 1) {
                                buffer.gotoPos(x - this.nums[0], y);
                                break block10;
                            }
                            buffer.gotoPos(1, y);
                            break block10;
                        }
                        case 'L': {
                            if (y >= buffer.gety1() && y <= buffer.gety2()) {
                                if (this.numc == 0) {
                                    this.nums[0] = 1;
                                }
                                int oy1 = buffer.gety1();
                                buffer.sety1(y);
                                buffer.scrollDown(this.nums[0]);
                                buffer.sety1(oy1);
                                break block10;
                            }
                            break block134;
                        }
                        case 'r': {
                            if (this.numc == 2) {
                                buffer.sety1(this.nums[0]);
                                buffer.sety2(this.nums[1]);
                                break block10;
                            }
                            break block134;
                        }
                        case 'm': {
                            int a;
                            if (this.numc == 0) {
                                this.numc = 1;
                                this.nums[0] = 0;
                            }
                            for (a = 0; a < this.numc; ++a) {
                                if (this.nums[a] == 1) {
                                    this.high = 1;
                                    continue;
                                }
                                if (this.nums[a] != 2) continue;
                                this.high = 0;
                            }
                            for (a = 0; a < this.numc; ++a) {
                                if (this.nums[a] == 0) {
                                    this.high = 0;
                                    buffer.setBlinker(false);
                                    buffer.setReverse(false);
                                    buffer.setForeColor(this.orgForeColor);
                                    buffer.setBackColor(this.orgBackColor);
                                    continue;
                                }
                                if (this.nums[a] == 5) {
                                    buffer.setBlinker(true);
                                    continue;
                                }
                                if (this.nums[a] == 7) {
                                    buffer.setReverse(true);
                                    continue;
                                }
                                if (this.nums[a] == 25) {
                                    buffer.setBlinker(false);
                                    continue;
                                }
                                if (this.nums[a] == 27) {
                                    buffer.setReverse(false);
                                    continue;
                                }
                                if (this.nums[a] >= 30 && this.nums[a] <= 37) {
                                    buffer.setForeColor(clrs[this.high][this.nums[a] - 30]);
                                    continue;
                                }
                                if (this.nums[a] == 39) {
                                    buffer.setForeColor(this.orgForeColor);
                                    continue;
                                }
                                if (this.nums[a] >= 40 && this.nums[a] <= 47) {
                                    buffer.setBackColor(clrs[0][this.nums[a] - 40]);
                                    continue;
                                }
                                if (this.nums[a] != 49) continue;
                                buffer.setBackColor(this.orgBackColor);
                            }
                            break block134;
                        }
                        case 'n': {
                            if (this.numc == 1 && this.nums[0] == 6) {
                                String str = "\u001b[" + buffer.gety() + ";" + buffer.getx() + "R";
                                buffer.output(str.toCharArray());
                                break block10;
                            }
                            break block134;
                        }
                        case 'P': {
                            if (this.numc == 0) {
                                this.numc = 1;
                                this.nums[0] = 1;
                            }
                            for (int cnt = 0; cnt < this.nums[0]; ++cnt) {
                                buffer.delete();
                            }
                            break block134;
                        }
                        case '@': {
                            if (this.numc == 0) {
                                this.numc = 1;
                                this.nums[0] = 1;
                            }
                            for (int cnt = 0; cnt < this.nums[0]; ++cnt) {
                                buffer.insert();
                            }
                            break block134;
                        }
                        case 's': {
                            this.savedx = buffer.getx();
                            this.savedy = buffer.gety();
                            break block10;
                        }
                        case 'u': {
                            if (this.savedx == -1) {
                                return true;
                            }
                            buffer.gotoPos(this.savedx, this.savedy);
                            break block10;
                        }
                        case 'g': {
                            break block10;
                        }
                        case 'd': {
                            if (this.numc == 0) {
                                this.nums[0] = 1;
                            }
                            buffer.gotoPos(x, this.nums[0]);
                            break block10;
                        }
                        case 'e': {
                            if (this.numc == 0) {
                                this.nums[0] = 1;
                            }
                            buffer.gotoPos(x, y + this.nums[0]);
                            break block10;
                        }
                        case 'G': {
                            if (this.numc == 0) {
                                this.nums[0] = 1;
                            }
                            buffer.gotoPos(this.nums[0], y);
                            break block10;
                        }
                        case 'X': {
                            if (this.numc == 0) {
                                this.nums[0] = 1;
                            }
                            for (int cnt = this.nums[0]; cnt > 0; --cnt) {
                                buffer.setChar(x, y, ' ');
                                if (++x != buffer.sx + 1) continue;
                                x = 1;
                                if (++y == buffer.sy + 1) break block10;
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    private void decodeNums(char[] code, int codelen, int start) {
        int c = start;
        this.numc = 0;
        code[codelen] = 120;
        while (c < codelen) {
            while (code[c] == ';' || code[c] == ',') {
                this.nums[this.numc++] = 0;
                ++c;
            }
            if (code[c] < '0' || code[c] > '9') break;
            int s = c;
            while (code[c] >= '0' && code[c] <= '9') {
                ++c;
            }
            int e = c;
            int t = 0;
            int m = 1;
            while (c != s) {
                t += (code[--c] - 48) * m;
                m *= 10;
            }
            this.nums[this.numc++] = t;
            c = e;
            if (code[c] != ';' && code[c] != ',') continue;
            ++c;
        }
    }

    private int min(int v1, int v2) {
        if (v1 < v2) {
            return v1;
        }
        return v2;
    }

    private int max(int v1, int v2) {
        if (v1 > v2) {
            return v1;
        }
        return v2;
    }
}

