/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import javaforce.Base64;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.LDAP;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;
import javaforce.net.EMail;
import javaforce.net.IP4;
import javaforce.net.IP4Port;
import javaforce.net.Subnet4;

public class FTPServer
extends Thread {
    public static final String busPack = "net.sf.jfftp";
    public static boolean debug = false;
    private static final int bufsiz = 1460;
    private static FTPServer ftp;
    private static volatile boolean active;
    private static ArrayList<ServerWorker> servers;
    private static ArrayList<ClientWorker> clients;
    private static String ldap_domain;
    private static String ldap_server;
    private static String root;
    private static ArrayList<EMail> users;
    private static Object lock;
    private static IP4Port bind;
    private static ArrayList<Subnet4> subnet_src_list;
    private static ArrayList<Integer> ports;
    private static ArrayList<Integer> ssl_ports;
    private static final String defaultConfig = "[global]\nport=21\n#secure=990\n#bind=192.168.100.2\n#ldap_domain=example.org\n#ldap_server=192.168.200.2\n#account=user:pass\n#root=/\n#root=c:/\n#root=/user/${user}/\n#root=c:/users/${user}/\n#digest=true\n#src.ipnet=192.168.2.0/255.255.255.0\n#src.ip=192.168.3.2\n";
    private static JBusServer busServer;
    private JBusClient busClient;
    private String config;

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfftp.cfg";
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfftp.log";
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33013;
        }
        return 777;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSession(ClientWorker sess) {
        Object object = lock;
        synchronized (object) {
            clients.add(sess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeSession(ClientWorker sess) {
        Object object = lock;
        synchronized (object) {
            clients.remove(sess);
        }
    }

    private static String getKeyFile() {
        return JF.getConfigPath() + "/jfftp.key";
    }

    @Override
    public void run() {
        JFLog.append(JF.getLogPath() + "/jfftp.log", true);
        JFLog.setRetention(30);
        JFLog.log("FTP : Starting service");
        try {
            ServerWorker worker;
            this.loadConfig();
            this.busClient = new JBusClient(busPack, new JBusMethods());
            this.busClient.setPort(FTPServer.getBusPort());
            this.busClient.start();
            for (int p : ports) {
                worker = new ServerWorker(p, false);
                worker.start();
                servers.add(worker);
            }
            for (int p : ssl_ports) {
                worker = new ServerWorker(p, true);
                worker.start();
                servers.add(worker);
            }
            while (active) {
                JF.sleep(1000);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        active = false;
        Object object = lock;
        synchronized (object) {
            ClientWorker[] ca;
            ServerWorker[] sa;
            for (ServerWorker s : sa = servers.toArray(new ServerWorker[0])) {
                s.close();
            }
            servers.clear();
            for (ClientWorker s : ca = clients.toArray(new ClientWorker[0])) {
                s.close();
            }
            clients.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadConfig() {
        JFLog.log("loadConfig");
        users = new ArrayList();
        Section section = Section.None;
        bind.setIP("0.0.0.0");
        FTPServer.bind.port = 25;
        subnet_src_list = new ArrayList();
        if (JF.isWindows()) {
            this.setRoot("c:/");
        } else {
            this.setRoot("/");
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(FTPServer.getConfigFile()));
            StringBuilder cfg = new StringBuilder();
            while (true) {
                String ln;
                if ((ln = br.readLine()) == null) {
                    br.close();
                    this.config = cfg.toString();
                    return;
                }
                cfg.append(ln);
                cfg.append("\n");
                ln = ln.trim();
                int cmt = ln.indexOf(35);
                if (cmt != -1) {
                    ln = ln.substring(0, cmt).trim();
                }
                if (ln.length() == 0) continue;
                if (ln.equals("[global]")) {
                    section = Section.Global;
                    continue;
                }
                int idx = ln.indexOf("=");
                if (idx == -1) continue;
                String key = ln.substring(0, idx);
                String value = ln.substring(idx + 1);
                block2 : switch (section.ordinal()) {
                    case 0: 
                    case 1: {
                        switch (key) {
                            case "port": {
                                ports.add(Integer.valueOf(ln.substring(5)));
                                break;
                            }
                            case "secure": {
                                ssl_ports.add(Integer.valueOf(ln.substring(7)));
                                break;
                            }
                            case "bind": {
                                if (bind.setIP(value)) break;
                                JFLog.log("FTP:bind:Invalid IP:" + value);
                                break;
                            }
                            case "account": {
                                EMail user = new EMail();
                                int cln = value.indexOf(58);
                                if (cln == -1) {
                                    JFLog.log("Invalid user:" + value);
                                    break block2;
                                }
                                user.user = value.substring(0, cln);
                                user.pass = value.substring(cln + 1);
                                users.add(user);
                                break;
                            }
                            case "ldap_domain": {
                                ldap_domain = value;
                                break;
                            }
                            case "ldap_server": {
                                ldap_server = value;
                                break;
                            }
                            case "root": {
                                this.setRoot(value.replaceAll("\\\\", "/"));
                                break;
                            }
                            case "debug": {
                                debug = value.equals("true");
                                break;
                            }
                            case "src.ipnet": {
                                Subnet4 subnet = new Subnet4();
                                idx = value.indexOf(47);
                                if (idx == -1) {
                                    JFLog.log("FTP:Invalid IP Subnet:" + value);
                                    break;
                                }
                                String ip = value.substring(0, idx);
                                String mask = value.substring(idx + 1);
                                if (!subnet.setIP(ip)) {
                                    JFLog.log("FTP:Invalid IP:" + ip);
                                    break;
                                }
                                if (!subnet.setMask(mask)) {
                                    JFLog.log("FTP:Invalid netmask:" + mask);
                                    break;
                                }
                                JFLog.log("Source Allow IP Network=" + subnet.toString());
                                subnet_src_list.add(subnet);
                                break;
                            }
                            case "src.ip": {
                                Subnet4 subnet = new Subnet4();
                                if (!subnet.setIP(value)) {
                                    JFLog.log("FTP:Invalid IP:" + value);
                                    break;
                                }
                                subnet.setMask("255.255.255.255");
                                JFLog.log("Source Allow IP Address=" + subnet.toString());
                                subnet_src_list.add(subnet);
                                break;
                            }
                        }
                        break;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            JFLog.log("config not found, creating defaults.");
            try {
                FileOutputStream fos = new FileOutputStream(FTPServer.getConfigFile());
                fos.write(defaultConfig.getBytes());
                fos.close();
                this.config = defaultConfig;
                return;
            }
            catch (Exception e2) {
                JFLog.log(e2);
                return;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private void setRoot(String path) {
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        try {
            root = new File((String)path).getCanonicalPath().replaceAll("\\\\", "/");
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static boolean login(String user, String pass) {
        for (EMail acct : users) {
            if (!acct.user.equals(user)) continue;
            return acct.pass.equals(pass);
        }
        if (ldap_server != null && ldap_domain != null) {
            LDAP ldap = new LDAP();
            return ldap.login(ldap_server, ldap_domain, user, pass);
        }
        return false;
    }

    private static boolean ip_src_allowed(String ip4) {
        if (subnet_src_list.size() == 0) {
            return true;
        }
        IP4 target = new IP4();
        if (!target.setIP(ip4)) {
            return false;
        }
        for (Subnet4 net : subnet_src_list) {
            if (!net.matches(target)) continue;
            return true;
        }
        return false;
    }

    private static boolean userExists(EMail email) {
        for (EMail acct : users) {
            if (!acct.user.equals(email.user)) continue;
            return true;
        }
        return false;
    }

    public static void serviceStart(String[] args) {
        if (JF.isWindows()) {
            busServer = new JBusServer(FTPServer.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
        ftp = new FTPServer();
        ftp.start();
    }

    public static void serviceStop() {
        JFLog.log("FTP : Stopping service");
        if (busServer != null) {
            busServer.close();
            busServer = null;
        }
        ftp.close();
    }

    public static void main(String[] args) {
    }

    static {
        servers = new ArrayList();
        clients = new ArrayList();
        lock = new Object();
        bind = new IP4Port();
        ports = new ArrayList();
        ssl_ports = new ArrayList();
    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            JBusClient cfr_ignored_0 = FTPServer.ftp.busClient;
            JBusClient cfr_ignored_1 = FTPServer.ftp.busClient;
            FTPServer.ftp.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(FTPServer.ftp.config)));
        }

        public void setConfig(String cfg) {
            JFLog.log("setConfig");
            try {
                FileOutputStream fos = new FileOutputStream(FTPServer.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            JFLog.log("restart");
            ftp.close();
            ftp = new FTPServer();
            ftp.start();
        }

        public void genKeys(String pack) {
            if (KeyMgmt.keytool(new String[]{"-genkey", "-debug", "-alias", "jfftp", "-keypass", "password", "-storepass", "password", "-keystore", FTPServer.getKeyFile(), "-validity", "3650", "-dname", "CN=jfftp.sourceforge.net, OU=user, O=server, C=CA", "-keyalg", "RSA", "-keysize", "2048"})) {
                JFLog.log("Generated Keys");
                JBusClient cfr_ignored_0 = FTPServer.ftp.busClient;
                FTPServer.ftp.busClient.call(pack, "getKeys", JBusClient.quote("OK"));
            } else {
                JBusClient cfr_ignored_1 = FTPServer.ftp.busClient;
                FTPServer.ftp.busClient.call(pack, "getKeys", JBusClient.quote("ERROR"));
            }
        }
    }

    public static class ServerWorker
    extends Thread {
        private ServerSocket ss;
        private int port;
        private boolean secure;

        public ServerWorker(int port, boolean secure) {
            this.port = port;
            this.secure = secure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object keys;
                if (this.secure) {
                    JFLog.log("CreateServerSocketSSL");
                    keys = new KeyMgmt();
                    if (new File(FTPServer.getKeyFile()).exists()) {
                        FileInputStream fis = new FileInputStream(FTPServer.getKeyFile());
                        ((KeyMgmt)keys).open(fis, "password");
                        fis.close();
                    } else {
                        JFLog.log("Warning:Server SSL Keys not generated!");
                    }
                    this.ss = JF.createServerSocketSSL((KeyMgmt)keys);
                } else {
                    this.ss = new ServerSocket();
                }
                keys = bind;
                synchronized (keys) {
                    FTPServer.bind.port = this.port;
                    this.ss.bind(bind.toInetSocketAddress());
                }
                active = true;
                while (active) {
                    Socket s = this.ss.accept();
                    InetSocketAddress sa = (InetSocketAddress)s.getRemoteSocketAddress();
                    String src_ip = sa.getAddress().getHostAddress();
                    if (src_ip.equals("0:0:0:0:0:0:0:1")) {
                        src_ip = "127.0.0.1";
                    }
                    if (!FTPServer.ip_src_allowed(src_ip)) {
                        JFLog.log("FTP:Source IP blocked:" + src_ip);
                        s.close();
                        continue;
                    }
                    ClientWorker sess = new ClientWorker(s, this.secure);
                    FTPServer.addSession(sess);
                    sess.start();
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void close() {
            try {
                this.ss.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ss = null;
        }
    }

    public static class ClientWorker
    extends Thread {
        private Socket c;
        private boolean secure;
        private InputStream cis = null;
        private OutputStream cos = null;
        private Socket d;
        private InputStream dis = null;
        private OutputStream dos = null;
        private String user;
        private String croot;
        private String curdir;
        private String olddir;
        private byte[] req = new byte[1500];
        private int reqSize = 0;
        private byte[] buffer = new byte[1500];
        private int bufferSize = 0;
        private Mode mode = Mode.none;
        private ServerSocket passive_ss;
        private String port_ip;
        private int port_port;

        public ClientWorker(Socket s, boolean secure) {
            this.c = s;
            this.secure = secure;
        }

        public void close() {
            if (this.cos != null) {
                try {
                    this.cos.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.c != null) {
                try {
                    this.c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.c = null;
                this.cis = null;
                this.cos = null;
            }
            this.closeData();
        }

        private boolean openData() throws Exception {
            switch (this.mode.ordinal()) {
                case 0: {
                    this.cos.write("500 No data port established\r\n".getBytes());
                    return false;
                }
                case 1: {
                    this.mode = Mode.none;
                    this.d = this.passive_ss.accept();
                    this.dis = this.d.getInputStream();
                    this.dos = this.d.getOutputStream();
                    this.passive_ss.close();
                    this.passive_ss = null;
                    this.cos.write("150 Using existing data connection\r\n".getBytes());
                    return true;
                }
                case 2: {
                    this.mode = Mode.none;
                    this.d = new Socket(this.port_ip, this.port_port);
                    this.dis = this.d.getInputStream();
                    this.dos = this.d.getOutputStream();
                    return true;
                }
            }
            return false;
        }

        private void closeData() {
            if (this.dos != null) {
                try {
                    this.dos.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.d != null) {
                try {
                    this.d.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.d = null;
                this.dis = null;
                this.dos = null;
            }
            if (this.passive_ss != null) {
                try {
                    this.passive_ss.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.passive_ss = null;
            }
            this.port_ip = null;
            this.port_port = 0;
            this.mode = Mode.none;
        }

        public String readln() {
            if (this.bufferSize > 0) {
                System.arraycopy(this.buffer, 0, this.req, 0, this.bufferSize);
                this.reqSize = this.bufferSize;
                this.bufferSize = 0;
            } else {
                this.reqSize = 0;
            }
            try {
                while (this.c != null && this.c.isConnected()) {
                    int read;
                    if (this.reqSize >= 2) {
                        for (int idx = 2; idx <= this.reqSize; ++idx) {
                            if (this.req[idx - 2] != 13 || this.req[idx - 1] != 10) continue;
                            int left = this.reqSize - idx;
                            if (left > 0) {
                                System.arraycopy(this.req, idx, this.buffer, 0, left);
                                this.bufferSize = left;
                            }
                            return new String(this.req, 0, idx - 2).trim();
                        }
                    }
                    if (this.reqSize == this.req.length) {
                        if (this.req.length >= 12000) {
                            throw new Exception("data too large");
                        }
                        int newSize = this.req.length << 1;
                        byte[] new_req = new byte[newSize];
                        this.buffer = new byte[newSize];
                        System.arraycopy(this.req, 0, new_req, 0, this.req.length);
                        this.req = new_req;
                    }
                    if ((read = this.cis.read(this.req, this.reqSize, this.req.length - this.reqSize)) >= 0) {
                        this.reqSize += read;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            return null;
        }

        @Override
        public void run() {
            block4: {
                try {
                    String ln;
                    JFLog.log("Session start");
                    this.cis = this.c.getInputStream();
                    this.cos = this.c.getOutputStream();
                    this.cos.write(("220 jfFTP Server/" + JF.getVersion() + "\r\n").getBytes());
                    this.curdir = "";
                    while (this.c != null && this.c.isConnected() && (ln = this.readln()) != null) {
                        String[] args = ln.split(" ");
                        String cmd = args[0].toUpperCase();
                        if (cmd.equals("QUIT")) {
                            this.cos.write("221 Goodbye\r\n".getBytes());
                            break;
                        }
                        this.doCommand(cmd, args);
                    }
                }
                catch (Exception e) {
                    if (e instanceof SocketException) break block4;
                    JFLog.log(e);
                }
            }
            this.close();
            FTPServer.removeSession(this);
        }

        private void doCommand(String cmd, String[] args) throws Exception {
            if (debug) {
                JFLog.log("Request=" + cmd);
            }
            switch (cmd) {
                case "AUTH": {
                    String type = args[1];
                    switch (type.toUpperCase()) {
                        case "LOGIN": {
                            this.cos.write("334 Send username\r\n".getBytes());
                            String user_base64 = this.readln();
                            if (user_base64 == null) {
                                this.close();
                                return;
                            }
                            String user = new String(Base64.decode(user_base64.getBytes()));
                            this.cos.write("334 Send password\r\n".getBytes());
                            String pass_base64 = this.readln();
                            if (pass_base64 == null) {
                                this.close();
                                return;
                            }
                            String pass = new String(Base64.decode(pass_base64.getBytes()));
                            if (FTPServer.login(user, pass)) {
                                this.cos.write("230 Login successful\r\n".getBytes());
                                this.setClientRoot();
                                break;
                            }
                            JF.sleep(1000);
                            this.cos.write("501 Login failed\r\n".getBytes());
                            this.close();
                            return;
                        }
                        default: {
                            this.cos.write("504 Unknown AUTH type\r\n".getBytes());
                        }
                    }
                    return;
                }
                case "USER": {
                    this.user = args[1];
                    this.cos.write("331 Send password\r\n".getBytes());
                    return;
                }
                case "PASS": {
                    if (this.user == null) {
                        this.cos.write("501 Login failed\r\n".getBytes());
                        this.close();
                        return;
                    }
                    if (!FTPServer.login(this.user, args[1])) {
                        JF.sleep(1000);
                        this.cos.write("501 Login failed\r\n".getBytes());
                        this.close();
                        return;
                    }
                    this.cos.write("230 Login successful\r\n".getBytes());
                    this.setClientRoot();
                    return;
                }
                case "STARTTLS": {
                    if (this.secure) {
                        this.cos.write("550 Already secure\r\n".getBytes());
                        break;
                    }
                    this.cos.write("220 Ok\r\n".getBytes());
                    this.c = JF.connectSSL(this.c, KeyMgmt.getDefaultClient());
                    this.cis = this.c.getInputStream();
                    this.cos = this.c.getOutputStream();
                    this.secure = true;
                    return;
                }
            }
            if (this.croot == null) {
                this.cos.write("401 Unauthorized\r\n".getBytes());
                throw new Exception("unauthorized");
            }
            block37 : switch (cmd) {
                case "RETR": {
                    this.get(JF.join(" ", args, 1));
                    break;
                }
                case "STOR": {
                    this.put(JF.join(" ", args, 1));
                    break;
                }
                case "CDUP": {
                    this.changeDir("..");
                    break;
                }
                case "CWD": {
                    this.changeDir(JF.join(" ", args, 1));
                    break;
                }
                case "SITE": {
                    String cmd2;
                    switch (cmd2 = args[1]) {
                        case "chmod": {
                            this.chmod(args[2], JF.join(" ", args, 3));
                            break block37;
                        }
                    }
                    break;
                }
                case "MKD": {
                    this.makeDir(JF.join(" ", args, 1));
                    break;
                }
                case "RNFR": {
                    this.renameFrom(JF.join(" ", args, 1));
                    break;
                }
                case "RNTO": {
                    this.renameTo(JF.join(" ", args, 1));
                    break;
                }
                case "DELE": {
                    this.delete(JF.join(" ", args, 1));
                    break;
                }
                case "RMD": {
                    this.removeDir(JF.join(" ", args, 1));
                    break;
                }
                case "LS": 
                case "LIST": {
                    String path = ".";
                    if (args.length > 1) {
                        path = JF.join(" ", args, 1);
                    }
                    this.list(path);
                    break;
                }
                case "PWD": {
                    this.printCurDir();
                    break;
                }
                case "PASV": {
                    this.passive();
                    break;
                }
                case "PORT": {
                    this.port(args[1]);
                    break;
                }
                case "TYPE": {
                    this.cos.write("200 Ok\r\n".getBytes());
                    break;
                }
                case "SYST": {
                    this.cos.write("215 UNIX Type:L8\r\n".getBytes());
                    break;
                }
                default: {
                    this.cos.write("500 Unknown command\r\n".getBytes());
                }
            }
        }

        private void get(String filename) throws Exception {
            String full = this.checkPath(filename);
            if (full == null) {
                this.cos.write("500 Invalid path\r\n".getBytes());
                return;
            }
            File file = new File(full);
            if (!file.exists()) {
                this.cos.write("500 File not found\r\n".getBytes());
                return;
            }
            if (file.isDirectory()) {
                this.cos.write("500 File is directory\r\n".getBytes());
                return;
            }
            if (!this.openData()) {
                return;
            }
            long length = file.length();
            long sent = 0L;
            long left = length;
            byte[] buf = new byte[1460];
            FileInputStream fis = new FileInputStream(file);
            while (sent < length) {
                int read;
                int toread = 1460;
                if ((long)toread > left) {
                    toread = (int)left;
                }
                if ((read = fis.read(buf)) <= 0) continue;
                this.dos.write(buf, 0, read);
                sent += (long)read;
                left -= (long)read;
            }
            fis.close();
            this.closeData();
            this.cos.write("226 Transfer complete\r\n".getBytes());
        }

        private void put(String filename) throws Exception {
            int read;
            String full = this.checkPath(filename);
            if (full == null) {
                this.cos.write("500 Invalid path\r\n".getBytes());
                return;
            }
            File file = new File(full);
            if (file.isDirectory()) {
                this.cos.write("500 File is directory\r\n".getBytes());
                return;
            }
            if (!this.openData()) {
                return;
            }
            byte[] buf = new byte[1460];
            FileOutputStream fos = new FileOutputStream(file);
            while ((this.d.isConnected() || this.dis.available() > 0) && (read = this.dis.read(buf)) != -1) {
                if (read <= 0) continue;
                fos.write(buf, 0, read);
            }
            fos.close();
            this.closeData();
            this.cos.write("226 Transfer complete\r\n".getBytes());
        }

        private void changeDir(String dir) throws Exception {
            this.olddir = null;
            String newdir = this.checkPath(dir);
            if (newdir == null) {
                this.cos.write("500 Invalid path\r\n".getBytes());
            } else {
                this.curdir = this.stripPath(newdir);
                this.cos.write("250 Ok\r\n".getBytes());
            }
        }

        private void chmod(String mode, String filename) throws Exception {
            this.olddir = null;
            String full = this.checkPath(filename);
            if (full == null) {
                this.cos.write("500 Invalid path\r\n".getBytes());
            } else {
                File file = new File(full);
                this.cos.write("500 Not implemented yet!\r\n".getBytes());
            }
        }

        private void makeDir(String dir) throws Exception {
            this.olddir = null;
            String newdir = this.checkPath(dir);
            if (newdir == null) {
                this.cos.write("500 Invalid path\r\n".getBytes());
            } else if (!new File(newdir).mkdir()) {
                this.cos.write("500 Unable to create directory\r\n".getBytes());
            } else {
                this.cos.write("257 Ok\r\n".getBytes());
            }
        }

        private void renameFrom(String oldname) throws Exception {
            this.olddir = this.checkPath(oldname);
            if (this.olddir == null) {
                this.cos.write("500 Unable to create directory\r\n".getBytes());
            } else {
                this.cos.write("350 Ok\r\n".getBytes());
            }
        }

        private void renameTo(String newname) throws Exception {
            if (this.olddir == null) {
                this.cos.write("500 do renameFrom first\r\n".getBytes());
                return;
            }
            String newdir = this.checkPath(newname);
            if (newdir == null) {
                this.cos.write("500 Invalid path\r\n".getBytes());
                return;
            }
            if (!new File(this.olddir).renameTo(new File(newdir))) {
                this.cos.write("500 rename failed\r\n".getBytes());
            } else {
                this.cos.write("250 Ok\r\n".getBytes());
            }
        }

        private void delete(String filename) throws Exception {
            this.olddir = null;
            String full = this.checkPath(filename);
            if (full == null) {
                this.cos.write("500 Invalid path\r\n".getBytes());
                return;
            }
            File file = new File(full);
            if (!file.exists()) {
                this.cos.write("500 File not found\r\n".getBytes());
                return;
            }
            if (!file.delete()) {
                this.cos.write("500 Failed to delete!\r\n".getBytes());
            } else {
                this.cos.write("250 Ok\r\n".getBytes());
            }
        }

        private void removeDir(String dirname) throws Exception {
            this.olddir = null;
            String full = this.checkPath(dirname);
            if (full == null) {
                this.cos.write("500 Invalid path\r\n".getBytes());
                return;
            }
            File file = new File(full);
            if (!file.exists()) {
                this.cos.write("500 File not found\r\n".getBytes());
                return;
            }
            if (!file.delete()) {
                this.cos.write("500 Failed to delete!\r\n".getBytes());
            } else {
                this.cos.write("250 Ok\r\n".getBytes());
            }
        }

        private void list(String dir) throws Exception {
            String path = this.checkPath(dir);
            if (path == null) {
                this.cos.write("500 Invalid path\r\n".getBytes());
                return;
            }
            if (!this.openData()) {
                return;
            }
            File[] files = new File(path).listFiles();
            if (files == null) {
                files = new File[]{};
                JFLog.log("Warning:no files for path:" + dir);
            }
            StringBuilder sb = new StringBuilder();
            for (File file : files) {
                String name = file.getName();
                if (file.isDirectory()) {
                    sb.append("drwxrwxrwx");
                    sb.append("   1");
                    sb.append(" 0");
                    sb.append("      0");
                    sb.append(String.format("%16s", 0));
                    sb.append(" Jan 01  2001 ");
                    sb.append(name);
                    sb.append("\r\n");
                    continue;
                }
                long length = file.length();
                sb.append("-rwxrwxrwx");
                sb.append("   1");
                sb.append(" 0");
                sb.append("      0");
                sb.append(String.format("%16s", length));
                sb.append(" Jan 01  2001 ");
                sb.append(name);
                sb.append("\r\n");
            }
            this.dos.write(sb.toString().getBytes());
            this.cos.write("226 Transfer complete\r\n".getBytes());
            JF.sleep(250);
            this.closeData();
        }

        private void printCurDir() throws Exception {
            this.cos.write(("257 \"/" + this.curdir + "\" is current directory\r\n").getBytes());
        }

        private void passive() throws Exception {
            this.passive_ss = new ServerSocket(0);
            InetAddress sa = this.c.getLocalAddress();
            byte[] ip8 = sa.getAddress();
            int[] ip32 = new int[4];
            for (int a = 0; a < 4; ++a) {
                ip32[a] = ip8[a] & 0xFF;
            }
            int port = this.passive_ss.getLocalPort();
            String msg = String.format("227 Entering Passive Mode (%d,%d,%d,%d,%d,%d)\r\n", ip32[0], ip32[1], ip32[2], ip32[3], (port & 0xFF00) >> 8, port & 0xFF);
            this.cos.write(msg.getBytes());
            this.mode = Mode.passive;
        }

        private void port(String ip_port) throws Exception {
            String[] p = ip_port.split("[,]");
            if (p.length != 6) {
                this.cos.write("500 Invalid port command\r\n".getBytes());
                return;
            }
            int[] v = new int[6];
            for (int a = 0; a < 6; ++a) {
                v[a] = Integer.valueOf(p[a]);
                if (v[a] >= 0 && v[a] <= 255) continue;
                this.cos.write("500 Invalid port command\r\n".getBytes());
                return;
            }
            this.port_ip = String.format("%d.%d.%d.%d", v[0], v[1], v[2], v[3]);
            this.port_port = v[4] << 8 | v[5];
            this.cos.write("200 Ok\r\n".getBytes());
            this.mode = Mode.port;
        }

        private String checkPath(String name) throws Exception {
            String newdir;
            if (name.startsWith("/")) {
                newfile = new File(this.croot + name);
                newdir = newfile.getCanonicalPath().replaceAll("\\\\", "/");
            } else {
                newfile = new File(this.croot + this.curdir + "/" + name);
                newdir = newfile.getCanonicalPath().replaceAll("\\\\", "/");
            }
            if (newdir.length() < this.croot.length()) {
                JFLog.log("checkPath:length<root:" + newdir);
                return null;
            }
            String rootdir = newdir.substring(0, this.croot.length());
            if (!rootdir.equals(this.croot)) {
                JFLog.log("checkPath:not under root:" + newdir);
                return null;
            }
            return newdir;
        }

        private String stripPath(String path) {
            int len = this.croot.length();
            return path.substring(len);
        }

        private void setClientRoot() {
            this.croot = root.replaceAll("\\$\\{user\\}", this.user);
        }
    }

    static enum Section {
        None,
        Global;

    }

    private static enum Mode {
        none,
        passive,
        port;

    }
}

