/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.Serializable;

public class Size
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int B = 0;
    public static final int KB = 1;
    public static final int MB = 2;
    public static final int GB = 3;
    public static final int TB = 4;
    public static final int PB = 5;
    public int size;
    public int unit;
    private static final long _KB = 1024L;
    private static final long _MB = 0x100000L;
    private static final long _GB = 0x40000000L;
    private static final long _TB = 0x10000000000L;
    private static final long _PB = 0x4000000000000L;

    public Size(int size, int unit) {
        this.size = size;
        this.unit = unit;
    }

    public Size(long value) {
        if (value >= 0x4000000000000L) {
            this.size = (int)(value / 0x4000000000000L);
            this.unit = 5;
        } else if (value >= 0x10000000000L) {
            this.size = (int)(value / 0x10000000000L);
            this.unit = 4;
        } else if (value >= 0x40000000L) {
            this.size = (int)(value / 0x40000000L);
            this.unit = 3;
        } else if (value >= 0x100000L) {
            this.size = (int)(value / 0x100000L);
            this.unit = 2;
        } else if (value >= 1024L) {
            this.size = (int)(value / 1024L);
            this.unit = 1;
        } else {
            this.size = (int)value;
            this.unit = 0;
        }
    }

    public char getUnitChar() {
        switch (this.unit) {
            case 1: {
                return 'K';
            }
            case 2: {
                return 'M';
            }
            case 3: {
                return 'G';
            }
            case 4: {
                return 'T';
            }
            case 5: {
                return 'P';
            }
        }
        return 'B';
    }

    public boolean greaterThan(Size other) {
        return this.toLong() > other.toLong();
    }

    public String getSize() {
        return String.format("%d%c", this.size, Character.valueOf(this.getUnitChar()));
    }

    public String getSize_iB() {
        return String.format("%d%ciB", this.size, Character.valueOf(this.getUnitChar()));
    }

    public long toLong() {
        switch (this.unit) {
            case 1: {
                return 1024L * (long)this.size;
            }
            case 2: {
                return 0x100000L * (long)this.size;
            }
            case 3: {
                return 0x40000000L * (long)this.size;
            }
            case 4: {
                return 0x10000000000L * (long)this.size;
            }
            case 5: {
                return 0x4000000000000L * (long)this.size;
            }
        }
        return this.size;
    }

    public String toString() {
        return this.getSize();
    }

    public String toMemoryXML() {
        return "<memory unit='" + this.getUnitChar() + "iB'>" + this.size + "</memory>";
    }

    public static void main(String[] args) {
        long val = 0xC0000000000L;
        Size size = new Size(val += 0xC0000000L);
        System.out.println("size=" + String.valueOf(size));
    }
}

