/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.webui.Container;
import javaforce.webui.Rectangle;
import javaforce.webui.WebUIClient;
import javaforce.webui.WebUIServer;
import javaforce.webui.event.Action;
import javaforce.webui.event.Changed;
import javaforce.webui.event.Click;
import javaforce.webui.event.KeyDown;
import javaforce.webui.event.KeyEvent;
import javaforce.webui.event.KeyUp;
import javaforce.webui.event.Loaded;
import javaforce.webui.event.MouseDown;
import javaforce.webui.event.MouseEnter;
import javaforce.webui.event.MouseEvent;
import javaforce.webui.event.MouseMove;
import javaforce.webui.event.MouseUp;
import javaforce.webui.event.Moved;
import javaforce.webui.event.Resized;
import javaforce.webui.event.Validate;
import javaforce.webui.event.Visible;

public abstract class Component {
    public String id;
    public Container parent;
    public WebUIClient client;
    public String name;
    public ArrayList<String> classes = new ArrayList();
    public HashMap<String, String> attrs = new HashMap();
    public HashMap<String, String> styles = new HashMap();
    public int x;
    public int y;
    public int width;
    public int height;
    public int clr = 0;
    public int backclr = 0xCCCCCC;
    public int borderclr = 0;
    private int drag_type;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private ArrayList<Event> pendingEvents;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    public static final int VISIBLE = 10;
    public static final int HIDDEN = 11;
    public static final int SCROLL = 12;
    public static final int AUTO = 13;
    public ArrayList<OnEvent> events = new ArrayList();
    private HashMap<String, Object> map = new HashMap();
    private boolean isVisible = true;
    public static final int DRAG_MOVE = 1;
    public static final int DRAG_NS = 2;
    public static final int DRAG_EW = 3;
    public static final int DRAG_NESW = 4;
    public static final int DRAG_NWSE = 5;
    private Loaded[] loaded = new Loaded[0];
    private Click[] click = new Click[0];
    private MouseUp[] mouseUp = new MouseUp[0];
    private MouseDown[] mouseDown = new MouseDown[0];
    private MouseMove[] mouseMove = new MouseMove[0];
    private MouseEnter[] mouseEnter = new MouseEnter[0];
    private KeyUp[] keyUp = new KeyUp[0];
    private KeyDown[] keyDown = new KeyDown[0];
    private Changed[] changed = new Changed[0];
    private Visible[] visible = new Visible[0];
    private Validate[] validate = new Validate[0];
    private Action[] action = new Action[0];
    private Resized[] resized = new Resized[0];
    private Moved[] moved = new Moved[0];

    public String getID() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Container getParent() {
        return this.parent;
    }

    public Container getTopParent() {
        Container top = this.parent;
        Container next;
        while ((next = top.getParent()) != null) {
            top = next;
        }
        return top;
    }

    public void setClient(WebUIClient client) {
        if (this.id != null) {
            return;
        }
        this.client = client;
        this.id = "c" + client.getNextID();
    }

    public WebUIClient getClient() {
        while (this.client == null) {
            JF.sleep(50);
        }
        return this.client;
    }

    public void init() {
    }

    public void events() {
        if (this.pendingEvents != null) {
            for (Event event : this.pendingEvents) {
                this.sendEvent(event.msg, event.args);
            }
        }
    }

    public abstract String html();

    public void setProperty(String key, Object value) {
        this.map.put(key, value);
    }

    public Object getProperty(String key) {
        return this.map.get(key);
    }

    public void sendEvent(String msg, String[] args) {
        if (this.client != null) {
            this.client.sendEvent(this.id, msg, args);
        } else {
            if (this.pendingEvents == null) {
                this.pendingEvents = new ArrayList();
            }
            Event event = new Event();
            event.msg = msg;
            event.args = args;
            this.pendingEvents.add(event);
        }
    }

    public void sendData(byte[] data) {
        if (this.client != null) {
            this.client.sendData(data);
        }
    }

    public void sendOnResize() {
        this.sendEvent("onresize", null);
    }

    public void setClass(String cls) {
        this.classes.clear();
        this.classes.add(cls);
        this.sendEvent("setclass", new String[]{"cls=" + cls});
    }

    public boolean hasClass(String cls) {
        return this.classes.contains(cls);
    }

    public void addClass(String cls) {
        if (this.hasClass(cls)) {
            return;
        }
        this.classes.add(cls);
        this.sendEvent("addclass", new String[]{"cls=" + cls});
    }

    public void removeClass(String cls) {
        this.classes.remove(cls);
        this.sendEvent("delclass", new String[]{"cls=" + cls});
    }

    public void setFlex(boolean state) {
        if (state) {
            this.addClass("pad");
        } else {
            this.removeClass("pad");
        }
    }

    public boolean hasAttr(String attr) {
        return this.attrs.containsKey(attr);
    }

    public void addAttr(String attr, String value) {
        this.attrs.put(attr, value);
    }

    public void removeAttr(String attr) {
        this.attrs.remove(attr);
    }

    public boolean hasStyle(String style) {
        return this.styles.containsKey(style);
    }

    public void setStyle(String style, String value) {
        this.styles.put(style, value);
    }

    public void removeStyle(String style) {
        this.styles.remove(style);
    }

    public String getStyle(String style) {
        return this.styles.get(style);
    }

    public void setFontSize(int size) {
        this.setStyle("font-size", size + "pt");
    }

    public void setAlign(int align) {
        switch (align) {
            case 1: {
                this.setStyle("text-align", "left");
                break;
            }
            case 2: {
                this.setStyle("text-align", "center");
                this.setStyle("margin", "0 auto");
                break;
            }
            case 3: {
                this.setStyle("text-align", "right");
            }
        }
    }

    public void setVerticalAlign(int align) {
        switch (align) {
            case 4: {
                this.setStyle("vertical-align", "top");
                break;
            }
            case 2: {
                this.setStyle("vertical-align", "middle");
                break;
            }
            case 5: {
                this.setStyle("vertical-align", "bottom");
            }
        }
    }

    private OnEvent getEvent(String onX) {
        int cnt = this.events.size();
        for (int a = 0; a < cnt; ++a) {
            OnEvent event = this.events.get(a);
            if (!event.event.equals(onX)) continue;
            return event;
        }
        return null;
    }

    public void addEvent(String onX, String js) {
        OnEvent event = this.getEvent(onX);
        if (event != null) {
            event.js = js.replaceAll("'", "\"");
        } else {
            event = new OnEvent();
            event.event = onX;
            event.js = js.replaceAll("'", "\"");
            this.events.add(event);
        }
    }

    public String getEvents() {
        StringBuilder sb = new StringBuilder();
        int cnt = this.events.size();
        for (int a = 0; a < cnt; ++a) {
            sb.append(' ');
            OnEvent event = this.events.get(a);
            sb.append(event.event);
            sb.append("='");
            sb.append(event.js);
            sb.append("'");
        }
        return sb.toString();
    }

    public void requestPos() {
        this.sendEvent("getpos", null);
    }

    public void requestPosSize() {
        this.sendEvent("getpossize", null);
    }

    public void requestSize() {
        this.sendEvent("getsize", null);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        if (width > 0) {
            this.setStyle("width", width + "px");
        }
        if (height > 0) {
            this.setStyle("height", height + "px");
        }
        this.sendEvent("setsize", new String[]{"w=" + width, "h=" + height});
    }

    public int getX() {
        return this.x;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        this.setStyle("width", width + "px");
        this.sendEvent("setwidth", new String[]{"w=" + width});
    }

    public void setMaxWidth() {
        this.setStyle("width", "100%");
    }

    public void setAutoWidth() {
        this.setStyle("width", "auto");
    }

    public int getY() {
        return this.y;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
        this.setStyle("height", height + "px");
        this.sendEvent("setheight", new String[]{"h=" + height});
    }

    public void setMaxHeight() {
        this.setStyle("height", "100%");
    }

    public void setAutoHeight() {
        this.setStyle("height", "auto");
    }

    public void setColor(int clr) {
        this.clr = clr;
        String style = String.format("#%06x", clr);
        this.setStyle("color", style);
        this.sendEvent("setclr", new String[]{"clr=" + style});
    }

    public int getColor() {
        return this.clr;
    }

    public void setBackColor(int clr) {
        this.backclr = clr;
        String style = String.format("#%06x", clr);
        this.setStyle("background-color", style);
        this.sendEvent("setbackclr", new String[]{"clr=" + style});
    }

    public int getBackColor() {
        return this.backclr;
    }

    public void setBorderColor(int clr) {
        this.borderclr = clr;
        String style = String.format("#%06x", clr);
        this.setStyle("border-color", style);
        this.sendEvent("setborderclr", new String[]{"clr=" + style});
    }

    public int getBorderColor() {
        return this.borderclr;
    }

    public String getAttrs() {
        int a;
        String[] vals;
        String[] keys;
        int size;
        StringBuilder sb = new StringBuilder();
        sb.append(" id='" + this.id + "'");
        if (this.attrs.size() > 0) {
            size = this.attrs.size();
            keys = this.attrs.keySet().toArray(new String[size]);
            vals = this.attrs.values().toArray(new String[size]);
            for (a = 0; a < size; ++a) {
                if (vals[a] == null) {
                    sb.append(" " + keys[a]);
                    continue;
                }
                sb.append(" " + keys[a] + "='" + vals[a] + "'");
            }
        }
        if (this.classes.size() > 0) {
            sb.append(" class='");
            for (int a2 = 0; a2 < this.classes.size(); ++a2) {
                if (a2 > 0) {
                    sb.append(' ');
                }
                sb.append(this.classes.get(a2));
            }
            sb.append("'");
        }
        sb.append(this.getEvents());
        if (this.styles.size() > 0) {
            sb.append(" style='");
            size = this.styles.size();
            keys = this.styles.keySet().toArray(new String[size]);
            vals = this.styles.values().toArray(new String[size]);
            for (a = 0; a < size; ++a) {
                sb.append(keys[a] + ":" + vals[a] + ";");
            }
            sb.append("'");
        }
        return sb.toString();
    }

    protected void initInvisible() {
        this.isVisible = false;
        this.setStyle("display", "none");
    }

    public void setVisible(boolean state) {
        this.isVisible = state;
        if (state) {
            this.sendEvent("display", new String[]{"val="});
            this.setStyle("display", "");
        } else {
            this.sendEvent("display", new String[]{"val=none"});
            this.setStyle("display", "none");
        }
        for (int a = 0; a < this.visible.length; ++a) {
            this.visible[a].onVisible(this, state);
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setPosition(int x, int y) {
        this.sendEvent("setpos", new String[]{"x=" + x, "y=" + y});
        this.x = x;
        this.y = y;
        this.setStyle("left", x + "px");
        this.setStyle("top", y + "px");
    }

    public void setReadonly(boolean state) {
        if (state) {
            this.addAttr("readonly", "readonly");
        } else {
            this.removeAttr("readonly");
        }
    }

    public void setDisabled(boolean state) {
        if (state) {
            this.addAttr("disabled", "true");
        } else {
            this.removeAttr("disabled");
        }
    }

    public void setBorderGray(boolean state) {
        if (state) {
            this.addClass("bordergray");
        } else {
            this.removeClass("bordergray");
        }
    }

    public void setBorder(boolean state) {
        if (state) {
            this.addClass("border");
        } else {
            this.removeClass("border");
        }
    }

    public void setFocus() {
        this.sendEvent("focus", null);
    }

    public void enableDragging(int drag_type, int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        switch (drag_type) {
            case 1: {
                this.addClass("drag_move");
                break;
            }
            case 2: {
                this.addClass("drag_ns_resize");
                break;
            }
            case 3: {
                this.addClass("drag_ew_resize");
                break;
            }
            case 4: {
                this.addClass("drag_nesw_resize");
                break;
            }
            case 5: {
                this.addClass("drag_nwse_resize");
            }
        }
        this.sendEvent("enabledrag", new String[]{"x1=" + x1, "y1=" + y1, "x2=" + x2, "y2=" + y2, "type=" + drag_type});
    }

    public String encode(String str) {
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public String decode(String url) {
        try {
            return URLDecoder.decode(url, "utf-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.id;
    }

    public void dispatchEvent(String event, String[] args) {
        MouseEvent me = new MouseEvent();
        KeyEvent ke = new KeyEvent();
        if (args != null) {
            block90: for (int a = 0; a < args.length; ++a) {
                String arg = args[a];
                int idx = arg.indexOf(61);
                if (idx == -1) continue;
                String key = arg.substring(0, idx);
                String value = arg.substring(idx + 1);
                switch (key) {
                    case "ck": {
                        boolean bin;
                        me.ctrlKey = bin = value.equals("true");
                        ke.ctrlKey = bin;
                        continue block90;
                    }
                    case "ak": {
                        boolean bin;
                        me.altKey = bin = value.equals("true");
                        ke.altKey = bin;
                        continue block90;
                    }
                    case "sk": {
                        boolean bin;
                        me.shiftKey = bin = value.equals("true");
                        ke.shiftKey = bin;
                        continue block90;
                    }
                    case "key": {
                        int keyCode = 0;
                        int keyChar = 0;
                        if (value.length() == 1) {
                            keyChar = value.charAt(0);
                            keyCode = Character.toUpperCase(value.charAt(0));
                        } else {
                            switch (value) {
                                case "Enter": {
                                    keyCode = KeyEvent.VK_ENTER;
                                    break;
                                }
                                case "Tab": {
                                    keyCode = KeyEvent.VK_TAB;
                                    break;
                                }
                                case "Control": {
                                    keyCode = KeyEvent.VK_CONTROL;
                                    break;
                                }
                                case "Alt": {
                                    keyCode = KeyEvent.VK_ALT;
                                    break;
                                }
                                case "Shift": {
                                    keyCode = KeyEvent.VK_SHIFT;
                                    break;
                                }
                                case "Escape": {
                                    keyCode = KeyEvent.VK_ESCAPE;
                                    break;
                                }
                                case "ArrowUp": {
                                    keyCode = KeyEvent.VK_ARROW_UP;
                                    break;
                                }
                                case "ArrowDown": {
                                    keyCode = KeyEvent.VK_ARROW_DOWN;
                                    break;
                                }
                                case "ArrowLeft": {
                                    keyCode = KeyEvent.VK_ARROW_LEFT;
                                    break;
                                }
                                case "ArrowRight": {
                                    keyCode = KeyEvent.VK_ARROW_RIGHT;
                                    break;
                                }
                                case "Insert": {
                                    keyCode = KeyEvent.VK_INSERT;
                                    break;
                                }
                                case "Delete": {
                                    keyCode = KeyEvent.VK_DELETE;
                                    break;
                                }
                                case "Home": {
                                    keyCode = KeyEvent.VK_HOME;
                                    break;
                                }
                                case "End": {
                                    keyCode = KeyEvent.VK_END;
                                    break;
                                }
                                case "PageUp": {
                                    keyCode = KeyEvent.VK_PAGE_UP;
                                    break;
                                }
                                case "PageDown": {
                                    keyCode = KeyEvent.VK_PAGE_DOWN;
                                    break;
                                }
                                case "\\\\": {
                                    keyChar = 92;
                                    break;
                                }
                                case "Backspace": {
                                    keyCode = KeyEvent.VK_BACK_SPACE;
                                    break;
                                }
                                default: {
                                    JFLog.log("webui:unknown key code:" + value);
                                }
                            }
                        }
                        ke.keyChar = (char)keyChar;
                        ke.keyCode = keyCode;
                        continue block90;
                    }
                    case "x": {
                        me.x = Integer.valueOf(value);
                        continue block90;
                    }
                    case "y": {
                        me.y = Integer.valueOf(value);
                        continue block90;
                    }
                    case "b": {
                        me.buttons = Integer.valueOf(value);
                    }
                }
            }
        }
        switch (event) {
            case "click": {
                this.onClick(args, me);
                break;
            }
            case "action": {
                this.action();
                break;
            }
            case "changed": {
                this.onChanged(args);
                break;
            }
            case "mousedown": {
                this.onMouseDown(args, me);
                break;
            }
            case "mouseup": {
                this.onMouseUp(args, me);
                break;
            }
            case "mousemove": {
                this.onMouseMove(args, me);
                break;
            }
            case "mouseenter": {
                this.onMouseEnter(args, me);
                break;
            }
            case "keydown": {
                this.onKeyDown(args, ke);
                break;
            }
            case "keyup": {
                this.onKeyUp(args, ke);
                break;
            }
            case "possize": {
                this.onPosSize(args);
                break;
            }
            case "pos": {
                this.onPos(args);
                break;
            }
            case "size": {
                this.onSize(args);
                break;
            }
            case "onloaded": {
                this.onLoaded(args);
                break;
            }
            case "drawrect": {
                this.onDrawRect(args);
                break;
            }
            default: {
                this.onEvent(event, args);
            }
        }
    }

    public void onEvent(String event, String[] args) {
    }

    public void onPosSize(String[] args) {
        int a;
        for (a = 0; a < this.moved.length; ++a) {
            this.moved[a].onMoved(this, this.x, this.y);
        }
        for (a = 0; a < this.resized.length; ++a) {
            this.resized[a].onResized(this, this.width, this.height);
        }
        for (int c = 0; c < args.length; ++c) {
            String a2 = args[c];
            if (a2.startsWith("x=")) {
                this.x = Integer.valueOf(a2.substring(2));
            }
            if (a2.startsWith("y=")) {
                this.y = Integer.valueOf(a2.substring(2));
            }
            if (a2.startsWith("w=")) {
                this.width = Integer.valueOf(a2.substring(2));
            }
            if (!a2.startsWith("h=")) continue;
            this.height = Integer.valueOf(a2.substring(2));
        }
    }

    public void onSize(String[] args) {
        for (int c = 0; c < args.length; ++c) {
            String a = args[c];
            if (a.startsWith("w=")) {
                this.width = Integer.valueOf(a.substring(2));
            }
            if (!a.startsWith("h=")) continue;
            this.height = Integer.valueOf(a.substring(2));
        }
        for (int a = 0; a < this.resized.length; ++a) {
            this.resized[a].onResized(this, this.width, this.height);
        }
    }

    public void onPos(String[] args) {
        for (int c = 0; c < args.length; ++c) {
            String a = args[c];
            if (a.startsWith("x=")) {
                this.x = Integer.valueOf(a.substring(2));
            }
            if (!a.startsWith("y=")) continue;
            this.y = Integer.valueOf(a.substring(2));
        }
        for (int a = 0; a < this.moved.length; ++a) {
            this.moved[a].onMoved(this, this.x, this.y);
        }
    }

    protected void onLoaded(String[] args) {
        for (int a = 0; a < this.loaded.length; ++a) {
            this.loaded[a].loaded(this);
        }
    }

    public void addLoadedListener(Loaded handler) {
        this.loaded = Arrays.copyOf(this.loaded, this.loaded.length + 1);
        this.loaded[this.loaded.length - 1] = handler;
    }

    protected void onClick(String[] args, MouseEvent me) {
        if (WebUIServer.debug) {
            JFLog.log("onClick:" + String.valueOf(this) + ":" + this.click.length);
        }
        for (int a = 0; a < this.click.length; ++a) {
            this.click[a].onClick(me, this);
        }
    }

    public void addClickListener(Click handler) {
        this.addEvent("onclick", "onClick(event, this);");
        this.addEvent("oncontextmenu", "return false;");
        this.click = Arrays.copyOf(this.click, this.click.length + 1);
        this.click[this.click.length - 1] = handler;
    }

    public void click() {
        this.onClick(null, new MouseEvent());
    }

    protected void onMouseUp(String[] args, MouseEvent me) {
        me.action = "up";
        for (int a = 0; a < this.mouseUp.length; ++a) {
            this.mouseUp[a].onMouseUp(me, this);
        }
    }

    public void addMouseUpListener(MouseUp handler) {
        this.addEvent("onmouseup", "onMouseUp(event, this);");
        this.addEvent("oncontextmenu", "return false;");
        this.mouseUp = Arrays.copyOf(this.mouseUp, this.mouseUp.length + 1);
        this.mouseUp[this.mouseUp.length - 1] = handler;
    }

    protected void onMouseDown(String[] args, MouseEvent me) {
        me.action = "down";
        for (int a = 0; a < this.mouseDown.length; ++a) {
            this.mouseDown[a].onMouseDown(me, this);
        }
    }

    public void addMouseDownListener(MouseDown handler) {
        this.addEvent("onmousedown", "onMouseDown(event, this);");
        this.addEvent("oncontextmenu", "return false;");
        this.mouseDown = Arrays.copyOf(this.mouseDown, this.mouseDown.length + 1);
        this.mouseDown[this.mouseDown.length - 1] = handler;
    }

    protected void onMouseMove(String[] args, MouseEvent me) {
        me.action = "move";
        for (int a = 0; a < this.mouseMove.length; ++a) {
            this.mouseMove[a].onMouseMove(me, this);
        }
    }

    public void addMouseMoveListener(MouseMove handler) {
        this.addEvent("onmousemove", "onMouseMove(event, this);");
        this.mouseMove = Arrays.copyOf(this.mouseMove, this.mouseMove.length + 1);
        this.mouseMove[this.mouseMove.length - 1] = handler;
    }

    protected void onMouseEnter(String[] args, MouseEvent me) {
        me.action = "enter";
        for (int a = 0; a < this.mouseEnter.length; ++a) {
            this.mouseEnter[a].onMouseEnter(me, this);
        }
    }

    public void addMouseEnterListener(MouseEnter handler) {
        this.mouseEnter = Arrays.copyOf(this.mouseEnter, this.mouseEnter.length + 1);
        this.mouseEnter[this.mouseEnter.length - 1] = handler;
    }

    protected void onKeyUp(String[] args, KeyEvent ke) {
        ke.action = "up";
        for (int a = 0; a < this.keyUp.length; ++a) {
            this.keyUp[a].onKeyUp(ke, this);
        }
    }

    public void addKeyUpListener(KeyUp handler) {
        this.addEvent("onkeyup", "onKeyUp(event, this);");
        this.keyUp = Arrays.copyOf(this.keyUp, this.keyUp.length + 1);
        this.keyUp[this.keyUp.length - 1] = handler;
    }

    public void addKeyUpListenerPreventDefault(KeyUp handler) {
        this.addEvent("onkeyup", "onKeyUp2(event, this);");
        this.keyUp = Arrays.copyOf(this.keyUp, this.keyUp.length + 1);
        this.keyUp[this.keyUp.length - 1] = handler;
    }

    protected void onKeyDown(String[] args, KeyEvent ke) {
        ke.action = "down";
        for (int a = 0; a < this.keyDown.length; ++a) {
            this.keyDown[a].onKeyDown(ke, this);
        }
    }

    public void addKeyDownListener(KeyDown handler) {
        this.addEvent("onkeydown", "onKeyDown(event, this);");
        this.keyDown = Arrays.copyOf(this.keyDown, this.keyDown.length + 1);
        this.keyDown[this.keyDown.length - 1] = handler;
    }

    public void addKeyDownListenerPreventDefault(KeyDown handler) {
        this.addEvent("onkeydown", "onKeyDown2(event, this);");
        this.keyDown = Arrays.copyOf(this.keyDown, this.keyDown.length + 1);
        this.keyDown[this.keyDown.length - 1] = handler;
    }

    protected void onChanged(String[] args) {
        for (int a = 0; a < this.changed.length; ++a) {
            this.changed[a].onChanged(this);
        }
    }

    public void addChangedListener(Changed handler) {
        this.changed = Arrays.copyOf(this.changed, this.changed.length + 1);
        this.changed[this.changed.length - 1] = handler;
    }

    public void addVisibleListener(Visible handler) {
        this.visible = Arrays.copyOf(this.visible, this.visible.length + 1);
        this.visible[this.visible.length - 1] = handler;
    }

    public void addValidateListener(Validate handler) {
        this.validate = Arrays.copyOf(this.validate, this.validate.length + 1);
        this.validate[this.validate.length - 1] = handler;
    }

    public boolean validate() {
        for (int a = 0; a < this.validate.length; ++a) {
            if (this.validate[a].validate(this)) continue;
            return false;
        }
        return true;
    }

    public void addActionListener(Action handler) {
        this.action = Arrays.copyOf(this.action, this.action.length + 1);
        this.action[this.action.length - 1] = handler;
    }

    public void action() {
        for (int a = 0; a < this.action.length; ++a) {
            this.action[a].action(this);
        }
    }

    public void addResizedListener(Resized handler) {
        this.addEvent("onresize", "onResize(event, this);");
        this.resized = Arrays.copyOf(this.resized, this.resized.length + 1);
        this.resized[this.resized.length - 1] = handler;
    }

    public void addMovedListener(Moved handler) {
        this.addEvent("onmoved", "onMoved(event, this);");
        this.moved = Arrays.copyOf(this.moved, this.moved.length + 1);
        this.moved[this.moved.length - 1] = handler;
    }

    public void onDrawRect(String[] args) {
        Rectangle rect = new Rectangle();
        for (int c = 0; c < args.length; ++c) {
            String a = args[c];
            if (a.startsWith("x=")) {
                rect.x = Integer.valueOf(a.substring(2));
            }
            if (a.startsWith("y=")) {
                rect.y = Integer.valueOf(a.substring(2));
            }
            if (a.startsWith("w=")) {
                rect.width = Integer.valueOf(a.substring(2));
            }
            if (!a.startsWith("h=")) continue;
            rect.height = Integer.valueOf(a.substring(2));
        }
        this.onDrawRect(rect);
    }

    public void onDrawRect(Rectangle rect) {
    }

    public static class Event {
        public String msg;
        public String[] args;
    }

    private static class OnEvent {
        public String event;
        public String js;

        private OnEvent() {
        }
    }
}

