/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Block;
import javaforce.webui.Component;
import javaforce.webui.Label;
import javaforce.webui.LayoutManager;

public class GridLayout
extends LayoutManager {
    private int cols;
    private int rows;
    private boolean border;
    private int[] layouts;
    private String[] align_classes = new String[]{"none", "left", "center", "right"};

    public GridLayout(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
        this.layouts = new int[cols];
        for (int y = 0; y < cols; ++y) {
            this.layouts[y] = 2;
        }
    }

    public GridLayout(int cols, int rows, int[] align_cols) {
        this.cols = cols;
        this.rows = rows;
        this.layouts = new int[cols];
        if (align_cols.length != cols) {
            for (int y = 0; y < cols; ++y) {
                this.layouts[y] = 2;
            }
        } else {
            for (int y = 0; y < cols; ++y) {
                this.layouts[y] = align_cols[y];
            }
        }
    }

    @Override
    public String html() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table" + this.getAttrs() + ">");
        for (int y = 0; y < this.rows; ++y) {
            sb.append("<tr>");
            for (int x = 0; x < this.cols; ++x) {
                Cell cell = this.getCell(x, y, false);
                if (cell == null) continue;
                sb.append("<td>");
                sb.append(cell.html());
                sb.append("</td>");
            }
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    @Override
    public void setBorder(boolean state) {
        this.border = state;
        if (this.border) {
            this.addClass("border");
        } else {
            this.removeClass("border");
        }
    }

    private Cell getCell(int x, int y, boolean checkSpans) {
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            Cell cell = (Cell)this.get(a);
            int x1 = cell.x;
            int y1 = cell.y;
            int x2 = x1;
            int y2 = y1;
            if (checkSpans) {
                x2 += cell.spanx - 1;
                y2 += cell.spany - 1;
            }
            if (x < x1 || x > x2 || y < y1 || y > y2) continue;
            return cell;
        }
        return null;
    }

    public Component get(int x, int y, boolean checkSpans) {
        Cell cell = this.getCell(x, y, checkSpans);
        if (cell == null) {
            return null;
        }
        return cell.get(0);
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void add(Component comp, int x, int y) {
        this.add(comp, x, y, 1, 1);
    }

    public void add(Component comp, int x, int y, int spanx, int spany) {
        Cell cell = new Cell(comp, this.layouts[x], this.border);
        cell.x = x;
        cell.y = y;
        cell.spanx = spanx;
        cell.spany = spany;
        this.add(cell);
    }

    public void addRow() {
        ++this.rows;
    }

    public void addRow(Component[] cmps) {
        int x = 0;
        int y = this.rows;
        this.addRow();
        for (Component c : cmps) {
            this.add(c, x, y);
            ++x;
        }
    }

    public void addRow(String[] strs) {
        int x = 0;
        int y = this.rows;
        this.addRow();
        for (String s : strs) {
            this.add(new Label(s), x, y);
            ++x;
        }
    }

    public void addColumn() {
        ++this.cols;
    }

    public void addColumn(Component[] cmps) {
        int x = this.cols;
        int y = 0;
        this.addColumn();
        for (Component c : cmps) {
            this.add(c, x, y);
            ++y;
        }
    }

    public void addColumn(String[] strs) {
        int x = this.cols;
        int y = 0;
        this.addColumn();
        for (String s : strs) {
            this.add(new Label(s), x, y);
            ++y;
        }
    }

    private class Cell
    extends Block {
        public int x;
        public int y;
        public int spanx;
        public int spany;
        private boolean border;
        private int align;

        public Cell(Component comp, int align, boolean border) {
            this.border = border;
            this.align = align;
            this.setClass(GridLayout.this.align_classes[align]);
            this.add(comp);
            if (border) {
                this.addClass("border");
            }
        }

        @Override
        public String html() {
            StringBuilder sb = new StringBuilder();
            sb.append("<div" + this.getAttrs() + ">");
            sb.append(this.get(0).html());
            sb.append("</div>");
            return sb.toString();
        }

        @Override
        public void setBorder(boolean state) {
            this.border = state;
            if (this.border) {
                this.addClass("border");
            } else {
                this.removeClass("border");
            }
        }

        public Component getComponent() {
            return this.get(0);
        }
    }
}

