/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Block;
import javaforce.webui.Color;
import javaforce.webui.Container;

public class Slider
extends Container {
    private int dir;
    private int min;
    private int max;
    private int pos;
    private int size;
    private Block bar;

    public Slider(int dir, int min, int max, int pos) {
        this.dir = dir;
        this.min = min;
        this.max = max;
        this.pos = pos;
        this.size = max - min;
        this.bar = new Block();
        this.bar.setClass("slider");
        this.bar.setSize(16, 16);
        this.add(this.bar);
        this.setBackColor(Color.grey);
        this.bar.setBackColor(Color.darkBlue);
        switch (dir) {
            case 2: {
                this.setSize(this.size + 16, 16);
                this.bar.setStyle("margin-left", pos + "px");
                break;
            }
            case 1: {
                this.setSize(16, this.size + 16);
                this.bar.setStyle("margin-top", pos + "px");
            }
        }
    }

    @Override
    public void onEvent(String event, String[] args) {
        switch (event) {
            case "sliderpos": {
                for (int a = 0; a < args.length; ++a) {
                    if (!args[a].startsWith("pos=")) continue;
                    this.pos = Integer.valueOf(args[a].substring(4));
                    this.onChanged(null);
                }
                break;
            }
        }
    }

    @Override
    public void init() {
        super.init();
        switch (this.dir) {
            case 2: {
                this.bar.addEvent("onmousedown", "onmousedownSlider(event, this,'" + this.id + "','h'," + this.size + ");");
                break;
            }
            case 1: {
                this.bar.addEvent("onmousedown", "onmousedownSlider(event, this,'" + this.id + "','v'," + this.size + ");");
            }
        }
    }

    public void setPos(int pos) {
        if (pos < this.min) {
            pos = this.min;
        }
        if (pos > this.max) {
            pos = this.max;
        }
        this.pos = pos;
        switch (this.dir) {
            case 2: {
                this.bar.sendEvent("setmarginleft", new String[]{"px=" + pos});
                break;
            }
            case 1: {
                this.bar.sendEvent("setmargintop", new String[]{"px=" + pos});
            }
        }
    }

    public int getPos() {
        return this.pos;
    }
}

