/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.awt.JFImage;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;

public class JFAWT {
    public static int KEY_MASKS = 704;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;

    public static void openURL(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static JFrame createJFrame(String title, int x, int y, int w, int h, LayoutManager lm) {
        JFrame frame = new JFrame(title);
        frame.setDefaultCloseOperation(0);
        frame.setVisible(true);
        frame.setLocation(x, y);
        Insets insets = frame.getInsets();
        frame.setSize(w + insets.left + insets.right, h + insets.top + insets.bottom);
        Container mainpane = frame.getContentPane();
        mainpane.setLayout(lm);
        return frame;
    }

    public static JPanel createJPanel(LayoutManager lm, Container parent) {
        JPanel ret = new JPanel();
        ret.setLayout(lm);
        if (parent != null) {
            ret.setBounds(0, 0, parent.getWidth(), parent.getHeight());
        }
        ret.setVisible(false);
        if (parent != null) {
            parent.add(ret);
        }
        return ret;
    }

    public static JPanel createJPanel(int x, int y, int w, int h, LayoutManager lm, Container parent) {
        JPanel ret = new JPanel();
        ret.setLayout(lm);
        ret.setBounds(x, y, w, h);
        ret.setVisible(false);
        if (parent != null) {
            parent.add(ret);
        }
        return ret;
    }

    public static JFImage createJFImage(Container parent) {
        JFImage ret = new JFImage();
        if (parent != null) {
            ret.setBounds(0, 0, parent.getWidth(), parent.getHeight());
            parent.add(ret);
        }
        return ret;
    }

    public static JFImage createJFImage(int x, int y, int w, int h, Container parent) {
        JFImage ret = new JFImage();
        ret.setBounds(x, y, w, h);
        if (parent != null) {
            parent.add(ret);
        }
        return ret;
    }

    public static int[] getFontMetrics(Font fnt) {
        JFImage tmp = new JFImage(128, 128);
        Graphics g = tmp.getGraphics();
        g.setFont(fnt);
        g.setColor(Color.white);
        g.drawString("\u2588", 0, 64);
        int ascent = 1;
        int y = 63;
        while (y >= 0 && tmp.getPixel(0, y) != 0) {
            --y;
            ++ascent;
        }
        int descent = 0;
        int y2 = 65;
        while (y2 < 128 && tmp.getPixel(0, y2) != 0) {
            ++y2;
            ++descent;
        }
        int width = 0;
        int x = 0;
        while (x < 128 && tmp.getPixel(x, 63) != 0) {
            ++x;
            ++width;
        }
        int[] ret = new int[]{width, ascent, descent};
        return ret;
    }

    public static int[] getFontMetrics(Font font, String txt) {
        JFImage tmp = new JFImage(1, 1);
        FontMetrics fm = tmp.getGraphics().getFontMetrics(font);
        int[] ret = new int[3];
        char[] ca = txt.toCharArray();
        ret[0] = fm.charsWidth(ca, 0, ca.length);
        ret[1] = fm.getAscent();
        ret[2] = fm.getDescent();
        return ret;
    }

    public static void showMessage(String title, String msg) {
        JOptionPane.showMessageDialog(null, msg, title, 1);
    }

    public static void showError(String title, String msg) {
        JOptionPane.showMessageDialog(null, msg, title, 0);
    }

    public static String getString(String msg, String str) {
        return JOptionPane.showInputDialog(null, msg, str);
    }

    public static boolean showConfirm(String title, String msg) {
        return JOptionPane.showConfirmDialog(null, msg, title, 2) == 0;
    }

    public static final int showConfirm3(String title, String msg) {
        return JOptionPane.showConfirmDialog(null, msg, title, 1);
    }

    public static void assignHotKey(JDialog dialog, final JButton button, int vk) {
        String name = "Action" + vk;
        AbstractAction event = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                button.doClick();
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(2).put(KeyStroke.getKeyStroke(vk, 0), name);
        root.getActionMap().put(name, event);
    }

    public static void assignHotKey(JRootPane root, final JButton button, int vk) {
        String name = "Action" + vk;
        AbstractAction event = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                button.doClick();
            }
        };
        root.getInputMap(2).put(KeyStroke.getKeyStroke(vk, 0), name);
        root.getActionMap().put(name, event);
    }

    public static void assignHotKey(JDialog dialog, final Runnable action, int vk) {
        String name = "Action" + vk;
        AbstractAction event = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                action.run();
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(2).put(KeyStroke.getKeyStroke(vk, 0), name);
        root.getActionMap().put(name, event);
    }

    public static void assignHotKey(JRootPane root, final Runnable action, int vk) {
        String name = "Action" + vk;
        AbstractAction event = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                action.run();
            }
        };
        root.getInputMap(2).put(KeyStroke.getKeyStroke(vk, 0), name);
        root.getActionMap().put(name, event);
    }

    public static Font getMonospacedFont(int style, int size) {
        JFImage tmp = new JFImage(1, 1);
        Graphics g = tmp.getGraphics();
        Font fnt = new Font("monospaced", style, size);
        g.setFont(fnt);
        FontMetrics fm = g.getFontMetrics();
        try {
            int width = fm.charWidth('.');
            if (fm.charWidth('w') != width) {
                throw new Exception("nope");
            }
            if (fm.charWidth('\u2588') != width) {
                throw new Exception("nope");
            }
            return fnt;
        }
        catch (Exception exception) {
            fnt = new Font("Lucida Console", style, size);
            g.setFont(fnt);
            fm = g.getFontMetrics();
            try {
                int width = fm.charWidth('.');
                if (fm.charWidth('w') != width) {
                    throw new Exception("nope");
                }
                if (fm.charWidth('\u2588') != width) {
                    throw new Exception("nope");
                }
                return fnt;
            }
            catch (Exception exception2) {
                JFLog.log("JF.getMonospacedFont():Unable to find a fixed width font");
                return null;
            }
        }
    }

    public static Rectangle getMaximumBounds() {
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        DisplayMode mode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        Rectangle bounds = new Rectangle();
        bounds.x = insets.left;
        bounds.y = insets.top;
        bounds.width = mode.getWidth() - (insets.left + insets.right);
        bounds.height = mode.getHeight() - (insets.top + insets.bottom);
        return bounds;
    }

    public static void centerWindow(Window window) {
        Dimension d = window.getSize();
        Rectangle s = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        window.setLocation(s.width / 2 - d.width / 2, s.height / 2 - d.height / 2);
    }

    public static void setJPanelMenuBar(JPanel parent, JPanel child, JMenuBar menuBar) {
        parent.removeAll();
        parent.setLayout(new BorderLayout());
        JRootPane root = new JRootPane();
        parent.add((Component)root, "Center");
        root.setJMenuBar(menuBar);
        root.getContentPane().add(child);
        parent.putClientProperty("root", root);
    }

    public static void donate() {
        JFAWT.showMessage("Donate", "If you find this program useful,\nplease send $5 US or more via Paypal to pquiring@gmail.com\nThanks!");
    }

    public static String getOpenFile(String path) {
        return JFAWT.getOpenFile(path, null);
    }

    public static String getOpenFile(String path, String[][] filters) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setCurrentDirectory(new File(path));
        if (filters != null) {
            for (int a = 0; a < filters.length; ++a) {
                FileNameExtensionFilter ff = new FileNameExtensionFilter(filters[a][0], filters[a][1]);
                chooser.addChoosableFileFilter(ff);
                if (a != 0) continue;
                chooser.setFileFilter(ff);
            }
        }
        if (chooser.showOpenDialog(null) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public static String getSaveFile(String file) {
        return JFAWT.getSaveFile(file, null);
    }

    public static String getSaveFile(String file, String[][] filters) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setCurrentDirectory(new File(file).getParentFile());
        if (filters != null) {
            for (int a = 0; a < filters.length; ++a) {
                FileNameExtensionFilter ff = new FileNameExtensionFilter(filters[a][0], filters[a][1]);
                chooser.addChoosableFileFilter(ff);
                if (a != 0) continue;
                chooser.setFileFilter(ff);
            }
        }
        chooser.setSelectedFile(new File(file));
        if (chooser.showSaveDialog(null) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public static String getSaveAsFile(String path) {
        return JFAWT.getSaveAsFile(path, null);
    }

    public static String getSaveAsFile(String path, String[][] filters) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setCurrentDirectory(new File(path));
        if (filters != null) {
            for (int a = 0; a < filters.length; ++a) {
                FileNameExtensionFilter ff = new FileNameExtensionFilter(filters[a][0], filters[a][1]);
                chooser.addChoosableFileFilter(ff);
                if (a != 0) continue;
                chooser.setFileFilter(ff);
            }
        }
        if (chooser.showSaveDialog(null) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public static String getOpenFolder(String path) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        chooser.setCurrentDirectory(new File(path));
        if (chooser.showOpenDialog(null) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public static void setMetalLAF() {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getWidth() {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        return device.getDisplayMode().getWidth();
    }

    public static int getHeight() {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        return device.getDisplayMode().getWidth();
    }

    public static double getScaling() {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        return (double)device.getDisplayMode().getWidth() / (double)device.getDefaultConfiguration().getBounds().width;
    }

    public static void main(String[] args) {
        while (true) {
            System.out.println("scaling=" + JFAWT.getScaling());
            JF.sleep(1000);
        }
    }

    public static void loadFontConfig() {
        try {
            InputStream fontconfig = Class.forName("javaforce.awt.JFAWT").getClassLoader().getResourceAsStream("fontconfig.bfc");
            Class<?> fontconfiguration = Class.forName("sun.awt.FontConfiguration");
            Method mid = fontconfiguration.getMethod("loadBinary", InputStream.class);
            mid.invoke(null, fontconfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void listFonts() {
        Font[] allFonts;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (Font font : allFonts = ge.getAllFonts()) {
            System.out.println(font.getFontName(Locale.US));
        }
    }

    public static Set<? extends AWTKeyStroke> emptyKeys() {
        HashSet list = new HashSet();
        return list;
    }
}

