/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javaforce.BE;
import javaforce.JFLog;
import javaforce.awt.priv.bmp;
import javaforce.awt.priv.svg;
import javaforce.awt.priv.xpm;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.Icon;
import javax.swing.JComponent;

public class JFImage
extends JComponent
implements Icon {
    private BufferedImage bi;
    private Graphics2D g2d;
    private int[] buffer;
    private ResizeOperation resizeOperation = ResizeOperation.CLEAR;
    private int imageType;
    public static boolean debug = false;
    public static final int ALPHA_MASK = -16777216;
    public static final int OPAQUE = -16777216;
    public static final int TRANSPARENT = 0;
    public static final int RED_MASK = 0xFF0000;
    public static final int GREEN_MASK = 65280;
    public static final int BLUE_MASK = 255;
    public static final int RGB_MASK = 0xFFFFFF;

    public JFImage() {
        this.imageType = 2;
    }

    public JFImage(boolean alpha) {
        this.imageType = alpha ? 2 : 1;
    }

    public JFImage(int x, int y) {
        this.imageType = 2;
        this.setImageSize(x, y);
    }

    public JFImage(int x, int y, boolean alpha) {
        this.imageType = alpha ? 2 : 1;
        this.setImageSize(x, y);
    }

    private void init(boolean clear) {
        this.g2d = this.bi.createGraphics();
        this.buffer = ((DataBufferInt)this.bi.getRaster().getDataBuffer()).getData();
        if (clear) {
            this.fill(0, 0, this.getWidth(), this.getHeight(), 0);
        }
    }

    private void initImage(int x, int y) {
        if (debug) {
            JFLog.log("JFImage.initImage:" + x + "," + y);
        }
        this.bi = new BufferedImage(x, y, this.imageType);
        this.init(true);
        this.setPreferredSize(new Dimension(x, y));
    }

    public void setImageSize(int x, int y) {
        this.setSize(x, y);
        this.initImage(x, y);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (debug) {
            JFLog.log("JFImage.setBounds:" + x + "," + y + "," + w + "," + h);
        }
        super.setBounds(x, y, w, h);
        if (this.bi != null) {
            BufferedImage oldbi = this.bi;
            int oldw = this.getWidth();
            int oldh = this.getHeight();
            switch (this.resizeOperation.ordinal()) {
                case 3: {
                    break;
                }
                case 0: {
                    this.initImage(w, h);
                    break;
                }
                case 1: {
                    this.initImage(w, h);
                    Composite org = this.g2d.getComposite();
                    this.g2d.setComposite(AlphaComposite.Src);
                    this.g2d.drawImage((Image)oldbi, 0, 0, null);
                    this.g2d.setComposite(org);
                    break;
                }
                case 2: {
                    this.initImage(w, h);
                    Composite org = this.g2d.getComposite();
                    this.g2d.setComposite(AlphaComposite.Src);
                    this.g2d.drawImage(oldbi, 0, 0, w, h, 0, 0, oldw, oldh, null);
                    this.g2d.setComposite(org);
                }
            }
        } else {
            this.initImage(w, h);
        }
    }

    @Override
    public void setSize(int x, int y) {
        if (debug) {
            JFLog.log("JFImage.setSize:" + x + "," + y);
        }
        super.setSize(x, y);
    }

    @Override
    public void setSize(Dimension d) {
        if (debug) {
            JFLog.log("JFImage.setSize:" + String.valueOf(d));
        }
        super.setSize(d);
    }

    public void setResizeOperation(ResizeOperation ro) {
        this.resizeOperation = ro;
    }

    public Image getImage() {
        return this.bi;
    }

    public BufferedImage getBufferedImage() {
        return this.bi;
    }

    public void setBufferedImage(BufferedImage bi) {
        int newType = bi.getType();
        if (newType != 2 || newType != 1) {
            int x = bi.getWidth();
            int y = bi.getHeight();
            int[] px = bi.getRGB(0, 0, x, y, null, 0, x);
            this.setImageSize(x, y);
            this.putPixels(px, 0, 0, x, y, 0);
            return;
        }
        this.bi = bi;
        this.imageType = bi.getType();
        this.init(false);
    }

    @Override
    public Graphics getGraphics() {
        return this.g2d;
    }

    public Graphics2D getGraphics2D() {
        return this.g2d;
    }

    @Override
    public void paint(Graphics g) {
        if (debug) {
            JFLog.log("JFImage:paint");
        }
        if (this.bi == null) {
            return;
        }
        g.drawImage(this.getImage(), 0, 0, null);
    }

    @Override
    public int getWidth() {
        if (this.bi == null) {
            return -1;
        }
        return this.bi.getWidth();
    }

    @Override
    public int getHeight() {
        if (this.bi == null) {
            return -1;
        }
        return this.bi.getHeight();
    }

    public boolean load(InputStream in) {
        BufferedImage tmp;
        try {
            tmp = ImageIO.read(in);
            in.close();
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        if (tmp == null) {
            return false;
        }
        int x = tmp.getWidth();
        int y = tmp.getHeight();
        int[] px = tmp.getRGB(0, 0, x, y, null, 0, x);
        this.setImageSize(x, y);
        this.putPixels(px, 0, 0, x, y, 0);
        return true;
    }

    public boolean save(OutputStream out, String fmt) {
        boolean ret;
        if (fmt.equals("jpg")) {
            ret = this.saveJPG(out);
        } else if (fmt.equals("ico")) {
            ret = this.saveICO(out);
        } else if (fmt.equals("icns")) {
            ret = this.saveICNS(out);
        } else if (fmt.equals("bmp")) {
            ret = this.saveBMP(out);
        } else {
            try {
                ret = ImageIO.write((RenderedImage)this.bi, fmt, out);
            }
            catch (Exception e) {
                JFLog.log(e);
                ret = false;
            }
        }
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean load(String filename) {
        try {
            return this.load(new FileInputStream(filename));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean save(String filename, String fmt) {
        try {
            return this.save(new FileOutputStream(filename), fmt);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static JFImage[] loadmulti(InputStream is) {
        try {
            ImageInputStream stream = ImageIO.createImageInputStream(is);
            if (stream == null) {
                throw new Exception("reader not found");
            }
            ImageReader reader = ImageIO.getImageReaders(stream).next();
            reader.setInput(stream);
            int cnt = reader.getNumImages(true);
            JFImage[] imgs = new JFImage[cnt];
            for (int i = 0; i < cnt; ++i) {
                BufferedImage img = reader.read(i);
                imgs[i] = new JFImage();
                imgs[i].setBufferedImage(img);
            }
            return imgs;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static boolean savemulti(OutputStream os, JFImage[] imgs, String format) {
        try {
            ImageOutputStream stream = ImageIO.createImageOutputStream(os);
            if (stream == null) {
                throw new Exception("writer not found");
            }
            ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
            writer.setOutput(stream);
            int cnt = imgs.length;
            for (int i = 0; i < cnt; ++i) {
                if (!writer.canInsertImage(i)) {
                    throw new Exception("writer does not support layers, idx=" + i);
                }
                writer.writeInsert(i, new IIOImage(imgs[i].getBufferedImage(), null, null), null);
            }
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean loadJPG(InputStream in) {
        return this.load(in);
    }

    public boolean saveJPG(OutputStream out) {
        try {
            int w = this.bi.getWidth();
            int h = this.bi.getHeight();
            int[] px = new int[w * h];
            BufferedImage tmp = new BufferedImage(this.bi.getWidth(), this.bi.getHeight(), 5);
            this.bi.getRGB(0, 0, w, h, px, 0, w);
            tmp.setRGB(0, 0, w, h, px, 0, w);
            return ImageIO.write((RenderedImage)tmp, "jpg", out);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean loadJPG(String filename) {
        try {
            return this.loadJPG(new FileInputStream(filename));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean saveJPG(String filename) {
        try {
            return this.saveJPG(new FileOutputStream(filename));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean loadPNG(InputStream in) {
        return this.load(in);
    }

    public boolean savePNG(OutputStream out) {
        return this.save(out, "png");
    }

    public boolean loadPNG(String filename) {
        try {
            return this.loadPNG(new FileInputStream(filename));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean savePNG(String filename) {
        try {
            return this.savePNG(new FileOutputStream(filename));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean loadBMP(String filename, int index) {
        try {
            return this.loadBMP(new FileInputStream(filename), index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean saveBMP(String filename) {
        try {
            return this.saveBMP(new FileOutputStream(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadBMP(InputStream in, int index) {
        javaforce.ui.Dimension size = new javaforce.ui.Dimension(0, 0);
        int[] buf = bmp.load(in, size, index);
        try {
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (buf == null) {
            JFLog.log("loadBMP() failed! null returned");
            return false;
        }
        if (size.width == 0 || size.height == 0) {
            JFLog.log("loadBMP() failed! image size zero");
            return false;
        }
        this.setImageSize(size.width, size.height);
        this.putPixels(buf, 0, 0, size.width, size.height, 0);
        return true;
    }

    public boolean saveBMP(OutputStream out) {
        int[] pixels = this.getPixels(0, 0, this.getWidth(), this.getHeight());
        javaforce.ui.Dimension size = new javaforce.ui.Dimension(this.getWidth(), this.getHeight());
        return bmp.save24(out, pixels, size, false, false);
    }

    public boolean saveICO(String filename) {
        try {
            return this.saveICO(new FileOutputStream(filename));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean saveICO(OutputStream out) {
        int[] pixels = this.getPixels(0, 0, this.getWidth(), this.getHeight());
        javaforce.ui.Dimension size = new javaforce.ui.Dimension(this.getWidth(), this.getHeight());
        return bmp.save32(out, pixels, size, false, true);
    }

    public boolean saveICNS(String filename) {
        try {
            return this.saveICNS(new FileOutputStream(filename));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean saveICNS(OutputStream out) {
        int h;
        byte[] header = new byte[16];
        int w = this.getWidth();
        if (w > (h = this.getHeight())) {
            h = w;
        }
        if (h > w) {
            w = h;
        }
        int newSize = 16;
        String OSType2 = "icp4";
        if (w > 256) {
            newSize = 512;
            OSType2 = "ic09";
        } else if (w > 128) {
            newSize = 256;
            OSType2 = "ic08";
        } else if (w > 64) {
            newSize = 128;
            OSType2 = "ic07";
        } else if (w > 32) {
            newSize = 64;
            OSType2 = "icp6";
        } else if (w > 16) {
            newSize = 32;
            OSType2 = "icp5";
        }
        if (w != newSize || h != newSize) {
            if (debug) {
                JFLog.log("JFImage:saveICNS:Scaling icns to:" + newSize + "x" + newSize);
            }
            this.setResizeOperation(ResizeOperation.SCALE);
            this.setSize(newSize, newSize);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.savePNG(baos);
        if (debug) {
            JFLog.log("JFImage:saveICNS:png.size=" + baos.size());
        }
        System.arraycopy("icns".getBytes(), 0, header, 0, 4);
        BE.setuint32(header, 4, 16 + baos.size());
        System.arraycopy(OSType2.getBytes(), 0, header, 8, 4);
        BE.setuint32(header, 12, 8 + baos.size());
        try {
            out.write(header);
            out.write(baos.toByteArray());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean loadSVG(String filename, int width, int height) {
        try {
            return this.loadSVG(new FileInputStream(filename), width, height);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean saveSVG(String filename) {
        try {
            return this.saveSVG(new FileOutputStream(filename));
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean loadSVG(InputStream in, int width, int height) {
        javaforce.ui.Dimension size = new javaforce.ui.Dimension(width, height);
        int[] buf = svg.load(in, size);
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (buf == null) {
            JFLog.log("error:buf==null");
            return false;
        }
        if (size.width == 0 || size.height == 0) {
            JFLog.log("error:width,height=" + size.width + "," + size.height);
            return false;
        }
        this.setImageSize(size.width, size.height);
        this.putPixels(buf, 0, 0, size.width, size.height, 0);
        return true;
    }

    public boolean saveSVG(OutputStream out) {
        ByteArrayOutputStream png_data = new ByteArrayOutputStream();
        this.savePNG(png_data);
        javaforce.ui.Dimension size = new javaforce.ui.Dimension(this.getWidth(), this.getHeight());
        boolean ret = svg.save(out, png_data.toByteArray(), size);
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean loadXPM(String filename) {
        try {
            return this.loadXPM(new FileInputStream(filename));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean loadXPM(InputStream in) {
        javaforce.ui.Dimension size = new javaforce.ui.Dimension(0, 0);
        int[] buf = new xpm().load(in, size);
        if (buf == null) {
            return false;
        }
        if (size.width == 0 || size.height == 0) {
            return false;
        }
        this.setImageSize(size.width, size.height);
        this.putPixels(buf, 0, 0, size.width, size.height, 0);
        return true;
    }

    public boolean loadTIFF(InputStream in) {
        return this.load(in);
    }

    public boolean saveTIFF(OutputStream out) {
        return this.save(out, "tiff");
    }

    public boolean loadTIFF(String filename) {
        try {
            return this.loadTIFF(new FileInputStream(filename));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean saveTIFF(String filename) {
        try {
            return this.saveTIFF(new FileOutputStream(filename));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static JFImage[] loadTIFFs(InputStream in) {
        return JFImage.loadmulti(in);
    }

    public static boolean saveTIFFs(OutputStream out, JFImage[] imgs) {
        return JFImage.savemulti(out, imgs, "tiff");
    }

    public void putJFImage(JFImage img, int x, int y) {
        int[] px = img.getPixels();
        this.putPixels(px, x, y, img.getWidth(), img.getHeight(), 0);
    }

    public void putJFImageKeyClr(JFImage img, int x, int y, int keyClr) {
        int[] px = img.getPixels();
        this.putPixelsKeyClr(px, x, y, img.getWidth(), img.getHeight(), 0, keyClr);
    }

    public void putJFImageBlend(JFImage img, int x, int y, boolean keepAlpha) {
        int[] px = img.getPixels(0, 0, img.getWidth(), img.getHeight());
        this.putPixelsBlend(px, x, y, img.getWidth(), img.getHeight(), 0, img.getWidth(), keepAlpha);
    }

    public void putJFImageScale(JFImage img, int x, int y, int width, int height) {
        this.g2d.drawImage(img.getImage(), x, y, x + width - 1, y + height - 1, 0, 0, img.getWidth() - 1, img.getHeight() - 1, null);
    }

    public JFImage getJFImage(int x, int y, int w, int h) {
        JFImage ret = new JFImage(w, h);
        int[] px = this.getPixels(x, y, w, h);
        ret.putPixels(px, 0, 0, w, h, 0);
        return ret;
    }

    public void putPixel(int x, int y, int r, int g, int b) {
        this.buffer[y * this.getWidth() + x] = 0xFF000000 | r << 16 | g << 8 | b;
    }

    public void putPixel(int x, int y, int c) {
        this.buffer[y * this.getWidth() + x] = 0xFF000000 | c;
    }

    public int getPixel(int x, int y) {
        return this.buffer[y * this.getWidth() + x] & 0xFFFFFF;
    }

    public int getAlpha(int x, int y) {
        return (this.buffer[y * this.getWidth() + x] & 0xFF000000) >>> 24;
    }

    public void putAlpha(int x, int y, int lvl) {
        int offset = y * this.getWidth() + x;
        int px = this.buffer[offset] & 0xFFFFFF;
        this.buffer[offset] = px |= lvl << 24;
    }

    public void putPixels(int[] src, int x, int y, int w, int h, int srcOffset) {
        this.putPixels(src, x, y, w, h, srcOffset, w);
    }

    public void putPixels(int[] src, int x, int y, int w, int h, int srcOffset, int srcScanSize) {
        int bw = this.getWidth();
        int bh = this.getHeight();
        if (y < 0) {
            if ((h -= (y *= -1)) <= 0) {
                return;
            }
            srcOffset += y * srcScanSize;
            y = 0;
        }
        if (x < 0) {
            if ((w -= (x *= -1)) <= 0) {
                return;
            }
            srcOffset += x;
            x = 0;
        }
        if (x + w > bw && (w = bw - x) <= 0) {
            return;
        }
        if (y + h > bh && (h = bh - y) <= 0) {
            return;
        }
        int dstOffset = y * bw + x;
        if (w == bw && srcScanSize == w) {
            System.arraycopy(src, srcOffset, this.buffer, dstOffset, w * h);
        } else {
            for (int i = 0; i < h; ++i) {
                System.arraycopy(src, srcOffset, this.buffer, dstOffset, w);
                srcOffset += srcScanSize;
                dstOffset += bw;
            }
        }
    }

    public void putPixelsKeyClr(int[] px, int x, int y, int w, int h, int offset, int keyclr) {
        int scansize = w;
        int bw = this.getWidth();
        int bh = this.getHeight();
        if (y < 0) {
            if ((h -= (y *= -1)) <= 0) {
                return;
            }
            offset += y * scansize;
            y = 0;
        }
        if (x < 0) {
            if ((w -= (x *= -1)) <= 0) {
                return;
            }
            offset += x;
            x = 0;
        }
        if (x + w > bw && (w = bw - x) <= 0) {
            return;
        }
        if (y + h > bh && (h = bh - y) <= 0) {
            return;
        }
        int dst = y * bw + x;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                if ((px[offset + j] & 0xFFFFFF) == keyclr) continue;
                this.buffer[dst + j] = px[offset + j];
            }
            offset += scansize;
            dst += bw;
        }
    }

    public void putPixelsBlend(int[] px, int x, int y, int w, int h, int srcOffset, int srcScansize, boolean keepAlpha) {
        int bw = this.getWidth();
        int bh = this.getHeight();
        if (y < 0) {
            if ((h -= (y *= -1)) <= 0) {
                return;
            }
            srcOffset += y * srcScansize;
            y = 0;
        }
        if (x < 0) {
            if ((w -= (x *= -1)) <= 0) {
                return;
            }
            srcOffset += x;
            x = 0;
        }
        if (x + w > bw && (w = bw - x) <= 0) {
            return;
        }
        if (y + h > bh && (h = bh - y) <= 0) {
            return;
        }
        int dst = y * bw + x;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                int sp = px[srcOffset + j];
                int sa = sp & 0xFF000000;
                sp &= 0xFFFFFF;
                int slvl = sa >>> 24;
                if (slvl > 0) {
                    ++slvl;
                }
                int dlvl = 256 - slvl;
                int dp = this.buffer[dst + j];
                int da = dp & 0xFF000000;
                this.buffer[dst + j] = (keepAlpha ? da : sa) + (((dp &= 0xFFFFFF) & 0xFF0000) * dlvl >> 8 & 0xFF0000) + ((dp & 0xFF00) * dlvl >> 8 & 0xFF00) + ((dp & 0xFF) * dlvl >> 8 & 0xFF) + ((sp & 0xFF0000) * slvl >> 8 & 0xFF0000) + ((sp & 0xFF00) * slvl >> 8 & 0xFF00) + ((sp & 0xFF) * slvl >> 8 & 0xFF);
            }
            srcOffset += srcScansize;
            dst += bw;
        }
    }

    public void putPixelsBlendKeyClr(int[] px, int x, int y, int w, int h, int srcOffset, int srcScansize, boolean keepAlpha, int keyclr) {
        int bw = this.getWidth();
        int bh = this.getHeight();
        if (y < 0) {
            if ((h -= (y *= -1)) <= 0) {
                return;
            }
            srcOffset += y * srcScansize;
            y = 0;
        }
        if (x < 0) {
            if ((w -= (x *= -1)) <= 0) {
                return;
            }
            srcOffset += x;
            x = 0;
        }
        if (x + w > bw && (w = bw - x) <= 0) {
            return;
        }
        if (y + h > bh && (h = bh - y) <= 0) {
            return;
        }
        int dst = y * bw + x;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                int sp = px[srcOffset + j];
                int sa = sp & 0xFF000000;
                if ((sp &= 0xFFFFFF) == keyclr) continue;
                int slvl = sa >>> 24;
                if (slvl > 0) {
                    ++slvl;
                }
                int dlvl = 256 - slvl;
                int dp = this.buffer[dst + j];
                int da = dp & 0xFF000000;
                this.buffer[dst + j] = (keepAlpha ? da : sa) + (((dp &= 0xFFFFFF) & 0xFF0000) * dlvl >> 8 & 0xFF0000) + ((dp & 0xFF00) * dlvl >> 8 & 0xFF00) + ((dp & 0xFF) * dlvl >> 8 & 0xFF) + ((sp & 0xFF0000) * slvl >> 8 & 0xFF0000) + ((sp & 0xFF00) * slvl >> 8 & 0xFF00) + ((sp & 0xFF) * slvl >> 8 & 0xFF);
            }
            srcOffset += srcScansize;
            dst += bw;
        }
    }

    public int[] getPixels(int x, int y, int w, int h) {
        int[] dst = new int[w * h];
        int dstScanSize = w;
        int dstOffset = 0;
        int bw = this.getWidth();
        int bh = this.getHeight();
        if (y < 0) {
            if ((h -= (y *= -1)) <= 0) {
                return null;
            }
            dstOffset += y * dstScanSize;
            y = 0;
        }
        if (x < 0) {
            if ((w -= (x *= -1)) <= 0) {
                return null;
            }
            dstOffset += x;
            x = 0;
        }
        if (x + w > bw && (w = bw - x) <= 0) {
            return null;
        }
        if (y + h > bh && (h = bh - y) <= 0) {
            return null;
        }
        int srcOffset = y * bw + x;
        if (w == bw && dstScanSize == w) {
            System.arraycopy(this.buffer, srcOffset, dst, dstOffset, w * h);
        } else {
            for (int i = 0; i < h; ++i) {
                System.arraycopy(this.buffer, srcOffset, dst, dstOffset, w);
                dstOffset += dstScanSize;
                srcOffset += bw;
            }
        }
        return dst;
    }

    public int[] getPixels() {
        int[] px = new int[this.buffer.length];
        System.arraycopy(this.buffer, 0, px, 0, this.buffer.length);
        return px;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    public void clear() {
        this.fill(0, 0, this.getWidth(), this.getHeight(), 0);
    }

    public void fill(int x, int y, int w, int h, int clr) {
        this.fill(x, y, w, h, clr, false);
    }

    public void fill(int x, int y, int w, int h, int clr, boolean hasAlpha) {
        if (!hasAlpha) {
            clr |= 0xFF000000;
        }
        int scansize = w;
        int bw = this.getWidth();
        int bh = this.getHeight();
        if (y < 0) {
            if ((h -= (y *= -1)) <= 0) {
                return;
            }
            y = 0;
        }
        if (x < 0) {
            if ((w -= (x *= -1)) <= 0) {
                return;
            }
            x = 0;
        }
        if (x + w > bw && (w = bw - x) <= 0) {
            return;
        }
        if (y + h > bh && (h = bh - y) <= 0) {
            return;
        }
        int dst = y * bw + x;
        if (w == bw && scansize == w) {
            Arrays.fill(this.buffer, dst, dst + w * h, clr);
        } else {
            for (int i = 0; i < h; ++i) {
                Arrays.fill(this.buffer, dst, dst + w, clr);
                dst += bw;
            }
        }
    }

    public void fillAlpha(int x, int y, int w, int h, int lvl) {
        lvl <<= 24;
        int scansize = w;
        int bw = this.getWidth();
        int bh = this.getHeight();
        if (y < 0) {
            if ((h -= (y *= -1)) <= 0) {
                return;
            }
            y = 0;
        }
        if (x < 0) {
            if ((w -= (x *= -1)) <= 0) {
                return;
            }
            x = 0;
        }
        if (x + w > bw && (w = bw - x) <= 0) {
            return;
        }
        if (y + h > bh && (h = bh - y) <= 0) {
            return;
        }
        int dst = y * bw + x;
        if (w == bw && scansize == w) {
            int cnt = w * h;
            for (int i = 0; i < cnt; ++i) {
                this.buffer[dst] = this.buffer[dst] & 0xFFFFFF | lvl;
                ++dst;
            }
        } else {
            for (int i = 0; i < h; ++i) {
                int odst = dst;
                for (int j = 0; j < w; ++j) {
                    this.buffer[dst] = this.buffer[dst] & 0xFFFFFF | lvl;
                    ++dst;
                }
                dst = odst + bw;
            }
        }
    }

    public void fillAlphaKeyClr(int x, int y, int w, int h, int lvl, int keyClr) {
        lvl <<= 24;
        int scansize = w;
        int bw = this.getWidth();
        int bh = this.getHeight();
        if (y < 0) {
            if ((h -= (y *= -1)) <= 0) {
                return;
            }
            y = 0;
        }
        if (x < 0) {
            if ((w -= (x *= -1)) <= 0) {
                return;
            }
            x = 0;
        }
        if (x + w > bw && (w = bw - x) <= 0) {
            return;
        }
        if (y + h > bh && (h = bh - y) <= 0) {
            return;
        }
        int dst = y * bw + x;
        if (w == bw && scansize == w) {
            int cnt = w * h;
            for (int i = 0; i < cnt; ++i) {
                if ((this.buffer[dst] & 0xFFFFFF) == keyClr) {
                    int n = dst;
                    this.buffer[n] = this.buffer[n] & 0xFFFFFF;
                    int n2 = dst;
                    this.buffer[n2] = this.buffer[n2] | lvl;
                }
                ++dst;
            }
        } else {
            for (int i = 0; i < h; ++i) {
                int odst = dst;
                for (int j = 0; j < w; ++j) {
                    if ((this.buffer[dst] & 0xFFFFFF) == keyClr) {
                        int n = dst;
                        this.buffer[n] = this.buffer[n] & 0xFFFFFF;
                        int n3 = dst;
                        this.buffer[n3] = this.buffer[n3] | lvl;
                    }
                    ++dst;
                }
                dst = odst + bw;
            }
        }
    }

    public void box(int x, int y, int w, int h, int clr) {
        this.g2d.setColor(new Color(clr |= 0xFF000000));
        this.g2d.drawRect(x, y, w, h);
    }

    public void hline(int x1, int x2, int y, int clr) {
        this.line(x1, y, x2, y, clr);
    }

    public void vline(int x, int y1, int y2, int clr) {
        this.line(x, y1, x, y2, clr);
    }

    public void line(int x1, int y1, int x2, int y2, int clr) {
        this.g2d.setColor(new Color(clr |= 0xFF000000));
        this.g2d.drawLine(x1, y1, x2, y2);
    }

    public void oval(int x, int y, int w, int h, int clr) {
        this.g2d.setColor(new Color(clr |= 0xFF000000));
        this.g2d.drawOval(x, y, w, h);
    }

    public void arc(int x, int y, int w, int h, int startAngle, int arcAngle, int clr) {
        this.g2d.setColor(new Color(clr |= 0xFF000000));
        this.g2d.drawArc(x, y, w, h, startAngle, arcAngle);
    }

    public void fillOval(int x, int y, int w, int h, int clr) {
        this.g2d.setColor(new Color(clr |= 0xFF000000));
        this.g2d.fillOval(x, y, w, h);
    }

    public void fillArc(int x, int y, int w, int h, int startAngle, int arcAngle, int clr) {
        this.g2d.setColor(new Color(clr |= 0xFF000000));
        this.g2d.fillArc(x, y, w, h, startAngle, arcAngle);
    }

    public int[] getFontMetrics(Font fnt, String txt) {
        FontRenderContext frc = this.g2d.getFontRenderContext();
        TextLayout tl = new TextLayout(txt, fnt, frc);
        int[] ret = new int[]{(int)tl.getBounds().getWidth(), (int)tl.getAscent(), (int)tl.getDescent()};
        return ret;
    }

    public void print(Font fnt, int x, int y, String txt, int clr) {
        this.g2d.setColor(new Color(clr));
        this.g2d.setFont(fnt);
        this.g2d.drawString(txt, x, y);
    }

    @Override
    public void setFont(Font font) {
        this.getGraphics().setFont(font);
    }

    @Override
    public int getIconHeight() {
        return this.getHeight();
    }

    @Override
    public int getIconWidth() {
        return this.getWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.drawImage(this.getImage(), x, y, null);
    }

    public static JFImage createScreenCapture() {
        return JFImage.createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
    }

    public static JFImage createScreenCapture(GraphicsDevice device) {
        DisplayMode mode = device.getDisplayMode();
        return JFImage.createScreenCapture(device, device.getDefaultConfiguration().getBounds());
    }

    public static JFImage createScreenCapture(Rectangle rect) {
        return JFImage.createScreenCapture(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice(), rect);
    }

    public static JFImage createScreenCapture(GraphicsDevice device, Rectangle rect) {
        try {
            JFImage img = new JFImage();
            BufferedImage cap = new Robot(device).createScreenCapture(rect);
            int width = cap.getWidth();
            int height = cap.getHeight();
            if (cap.getType() == 2) {
                img.bi = cap;
                img.init(false);
                return img;
            }
            if (cap.getType() == 1) {
                img.setSize(width, height);
                int[] src = ((DataBufferInt)cap.getRaster().getDataBuffer()).getData();
                int cnt = width * height;
                for (int a = 0; a < cnt; ++a) {
                    img.buffer[a] = src[a] | 0xFF000000;
                }
                return img;
            }
            JFLog.log("JFImage.createScreenCapture() unknown type=" + cap.getType());
            int[] px = cap.getRGB(0, 0, width, height, null, 0, width);
            img.setSize(width, height);
            img.putPixels(px, 0, 0, width, height, 0);
            return img;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public int[] getLayer(int bits) {
        int[] px = this.getPixels();
        int a = 0;
        while (a < px.length) {
            int n = a;
            px[n] = px[n] & bits;
            int n2 = a++;
            px[n2] = px[n2] | 0xFF000000;
        }
        return px;
    }

    public void putLayer(int[] px, int bits) {
        if (px.length != this.buffer.length) {
            return;
        }
        int mask = -1 - bits;
        for (int a = 0; a < px.length; ++a) {
            int n = a;
            this.buffer[n] = this.buffer[n] & mask;
            int n2 = a;
            this.buffer[n2] = this.buffer[n2] | px[a] & 0xFFFFFF;
        }
    }

    public int[] getAlphaLayer() {
        int[] px = this.getPixels();
        for (int a = 0; a < px.length; ++a) {
            int p2;
            int p1 = px[a] & 0xFF000000;
            px[a] = p2 = 0xFF000000 | (p1 >>>= 8) | p1 >> 8 | p1 >> 16;
        }
        return px;
    }

    public void putAlphaLayer(int[] px) {
        if (px.length != this.buffer.length) {
            return;
        }
        for (int a = 0; a < px.length; ++a) {
            int n = a;
            this.buffer[n] = this.buffer[n] & 0xFFFFFF;
            int n2 = a;
            this.buffer[n2] = this.buffer[n2] | (px[a] & 0xFF0000) << 8;
        }
    }

    public static enum ResizeOperation {
        CLEAR,
        CHOP,
        SCALE,
        NONE;

    }
}

