/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.zip.Inflater;
import javaforce.BE;
import javaforce.JFLog;
import javaforce.awt.JFImage;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class RFB {
    private Socket s;
    private InputStream is;
    private OutputStream os;
    private boolean connected;
    private int width;
    private int height;
    private String name;
    private JFImage image;
    private int[] buffer;
    private PixelFormat pf;
    private int bytesPixel;
    private int clr;
    private int[] colors = new int[256];
    private int mx;
    private int my;
    private static int log;
    private static final int MAX_TEXT_LENGTH = 0x100000;
    public static boolean debug;
    public static float VERSION_3_3;
    public static float VERSION_3_7;
    public static float VERSION_3_8;
    public static final int AUTH_FAIL = 0;
    public static final int AUTH_NONE = 1;
    public static final int AUTH_VNC = 2;
    public static final int C_MSG_SET_PIXEL_FORMAT = 0;
    public static final int C_MSG_SET_ENCODING = 2;
    public static final int C_MSG_BUFFER_REQUEST = 3;
    public static final int C_MSG_KEY_EVENT = 4;
    public static final int C_MSG_MOUSE_EVENT = 5;
    public static final int C_MSG_CUT_TEXT = 6;
    public static final int S_MSG_CLOSE = -1;
    public static final int S_MSG_BUFFER_UPDATE = 0;
    public static final int S_MSG_COLOR_MAP = 1;
    public static final int S_MSG_BELL = 2;
    public static final int S_MSG_CUT_TEXT = 3;
    public static final int TYPE_RAW = 0;
    public static final int TYPE_COPY_RECT = 1;
    public static final int TYPE_RRE = 2;
    public static final int TYPE_CORRE = 4;
    public static final int TYPE_HEXTILE = 5;
    public static final int TYPE_ZLIB = 6;
    public static final int TYPE_TIGHT = 7;
    public static final int TYPE_ZLIB_HEX = 8;
    public static final int TYPE_TRLE = 15;
    public static final int TYPE_ZRLE = 16;
    public static final int TYPE_ZYWRLE = 17;
    public static final int TYPE_DESKTOP_SIZE = -223;
    public static final int TYPE_LAST_RECT = -224;
    public static final int TYPE_POINTER_POS = -232;
    public static final int TYPE_CURSOR = -239;
    public static final int TYPE_JPEG_9 = -23;
    public static final int TYPE_JPEG_8 = -24;
    public static final int TYPE_JPEG_7 = -25;
    public static final int TYPE_JPEG_6 = -26;
    public static final int TYPE_JPEG_5 = -27;
    public static final int TYPE_JPEG_4 = -28;
    public static final int TYPE_JPEG_3 = -29;
    public static final int TYPE_JPEG_2 = -30;
    public static final int TYPE_JPEG_1 = -31;
    public static final int TYPE_JPEG_0 = -32;
    private int hextile_bg = 0;
    private int hextile_fg = 0;
    private final int HEXTILE_RAW = 1;
    private final int HEXTILE_BACKGROUND_SPECIFIED = 2;
    private final int HEXTILE_FOREGROUND_SPECIFIED = 4;
    private final int HEXTILE_ANY_SUBRECTS = 8;
    private final int HEXTILE_SUBRECTS_COLOURED = 16;
    private final int HEXTILE_ZLIB_RAW = 32;
    private final int HEXTILE_ZLIB = 64;
    private byte[] zlibBuf;
    private int zlibBufLen = 0;
    private Inflater zlibInflater;
    private Inflater[] tightInflaters = new Inflater[4];
    private static final int TIGHT_FILTER_COPY = 0;
    private static final int TIGHT_FILTER_PALETTE = 1;
    private static final int TIGHT_FILTER_GRADIENT = 2;
    private static final int TIGHT_EXPLICIT_FILTER = 4;
    private static final int TIGHT_FILL = 8;
    private static final int TIGHT_JPEG = 9;
    private static final int TIGHT_MAXSUBENCODING = 9;
    private static final int TIGHT_MIN_TO_COMPRESS = 12;

    public boolean connect(String host, int port) {
        try {
            this.s = new Socket(host, port);
            this.is = this.s.getInputStream();
            this.os = this.s.getOutputStream();
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            JFLog.log(log, (Throwable)e);
            return false;
        }
        return true;
    }

    public void disconnect() {
        try {
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
        }
        catch (Exception e) {
            JFLog.log(log, (Throwable)e);
        }
    }

    public static void setLog(int log) {
        RFB.log = log;
    }

    private void setSize() {
        if (debug) {
            JFLog.log("RFB:setSize:" + this.width + "x" + this.height);
        }
        this.image = new JFImage(this.width, this.height);
        this.buffer = this.image.getBuffer();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    public JFImage getImage(Rectangle area) {
        JFImage image = new JFImage(area.width, area.height);
        image.putPixels(this.getBuffer(), 0, 0, area.width, area.height, area.y * this.width + area.x, this.width);
        return image;
    }

    public int getMouseX() {
        return this.mx;
    }

    public int getMouseY() {
        return this.my;
    }

    public String getDesktopName() {
        return this.name;
    }

    private static int getPixel(byte[] data, int offset) {
        int ret = (data[offset + 2] & 0xFF) << 16;
        ret += (data[offset + 1] & 0xFF) << 8;
        return ret += data[offset + 0] & 0xFF;
    }

    private void fill(Rectangle rect, int clr) {
        if (debug) {
            JFLog.log(log, "RFB:fill:" + String.valueOf(rect) + ",clr=" + Integer.toString(clr, 16));
        }
        int x1 = rect.x;
        int x2 = x1 + rect.width - 1;
        int y1 = rect.y;
        int y2 = y1 + rect.height - 1;
        if (x2 >= this.width) {
            x2 = this.width - 1;
        }
        if (y2 >= this.height) {
            y2 = this.height - 1;
        }
        clr |= 0xFF000000;
        for (int y = y1; y <= y2; ++y) {
            for (int x = x1; x <= x2; ++x) {
                this.buffer[y * this.width + x] = clr;
            }
        }
    }

    private int readByte() {
        try {
            int val = this.is.read();
            if (val == -1) {
                throw new Exception("EOF");
            }
            return val;
        }
        catch (Exception e) {
            this.connected = false;
            JFLog.log(log, (Throwable)e);
            return -1;
        }
    }

    private int readShort() {
        byte[] data = this.read(2);
        if (data == null) {
            return -1;
        }
        return BE.getuint16(data, 0);
    }

    private int readInt() {
        byte[] data = this.read(4);
        if (data == null) {
            return -1;
        }
        return BE.getuint32(data, 0);
    }

    private byte[] read(int len) {
        try {
            return this.is.readNBytes(len);
        }
        catch (Exception e) {
            this.connected = false;
            JFLog.log(log, (Throwable)e);
            return null;
        }
    }

    int readCompactLen() {
        int[] portion = new int[3];
        portion[0] = this.readByte();
        int byteCount = 1;
        int len = portion[0] & 0x7F;
        if ((portion[0] & 0x80) != 0) {
            portion[1] = this.readByte();
            ++byteCount;
            len |= (portion[1] & 0x7F) << 7;
            if ((portion[1] & 0x80) != 0) {
                portion[2] = this.readByte();
                ++byteCount;
                len |= (portion[2] & 0xFF) << 14;
            }
        }
        return len;
    }

    private void writeByte(int data) {
        try {
            this.os.write(data);
        }
        catch (Exception e) {
            this.connected = false;
            JFLog.log(log, (Throwable)e);
        }
    }

    private void writeShort(int data) {
        byte[] pkt = new byte[2];
        BE.setuint16(pkt, 0, data);
        this.write(pkt);
    }

    private void writeInt(int data) {
        byte[] pkt = new byte[4];
        BE.setuint32(pkt, 0, data);
        this.write(pkt);
    }

    private void write(byte[] data) {
        try {
            this.os.write(data);
        }
        catch (Exception e) {
            this.connected = false;
            JFLog.log(log, (Throwable)e);
        }
    }

    public float readVersion() {
        byte[] data = this.read(12);
        String major = new String(data, 4, 3);
        String minor = new String(data, 8, 3);
        float ver = Float.valueOf(major).floatValue() + Float.valueOf(minor).floatValue() / 10.0f;
        if (debug) {
            JFLog.log(log, "RFB:read server version=" + ver);
        }
        return ver;
    }

    public void writeVersion(float ver) {
        int major = (int)ver;
        int minor = (int)((ver - (float)major + 0.01f) * 10.0f);
        String str = String.format("RFB %03d.%03d\n", major, minor);
        if (debug) {
            JFLog.log(log, "RFB:write client version=" + str);
        }
        byte[] pkt = str.getBytes();
        this.write(pkt);
    }

    public byte[] readAuthTypes() {
        int cnt = this.readByte();
        if (debug) {
            JFLog.log(log, "RFB:read AuthType Count=" + cnt);
        }
        byte[] types2 = this.read(cnt);
        if (debug) {
            for (int a = 0; a < types2.length; ++a) {
                JFLog.log(log, "RFB:read AuthType[]=" + types2[a]);
            }
        }
        return types2;
    }

    public byte[] readAuthChallenge() {
        byte[] data = this.read(16);
        if (debug) {
            JFLog.log(log, "RFB:read challenge=" + String.valueOf(data));
        }
        return data;
    }

    private static byte[] reverseBits(byte[] input) {
        byte[] output = new byte[input.length];
        for (int a = 0; a < input.length; ++a) {
            byte in = input[a];
            int out = 0;
            for (int b = 0; b < 8; ++b) {
                out = (byte)(out << 1);
                if ((in & 1) == 1) {
                    out = (byte)(out | 1);
                }
                in = (byte)(in >> 1);
            }
            output[a] = out;
        }
        return output;
    }

    public static byte[] encodeResponse(byte[] challenge, byte[] password) {
        if (password.length != 8) {
            JFLog.log(log, "Password must be zero padded to 8 bytes");
            return null;
        }
        byte[] r_password = RFB.reverseBits(password);
        try {
            DESKeySpec desKeySpec = new DESKeySpec(r_password);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, secretKey);
            return cipher.doFinal(challenge);
        }
        catch (Exception e) {
            JFLog.log(log, (Throwable)e);
            return null;
        }
    }

    public void writeAuthType(int type) {
        if (debug) {
            JFLog.log(log, "RFB:write AuthType=" + type);
        }
        this.writeByte(type);
    }

    public void writeAuthResponse(byte[] res) {
        if (debug) {
            JFLog.log(log, "RFB:write AuthResponse=" + String.valueOf(res));
        }
        this.write(res);
    }

    public boolean readAuthResult() {
        int res = this.readInt();
        if (debug) {
            JFLog.log(log, "RFB:read AuthResult=" + res);
        }
        if (res == 1) {
            int strlen = this.readInt();
            if (strlen > 0x100000) {
                JFLog.log(log, "RFB:error strlen=" + strlen);
                this.connected = false;
                return false;
            }
            byte[] errmsg_bytes = this.read(strlen);
            String errmsg = new String(errmsg_bytes);
            this.connected = false;
            JFLog.log("RFB:errmsg=" + errmsg);
        }
        return res == 0;
    }

    public void writeClientInit(boolean shared) {
        if (debug) {
            JFLog.log(log, "RFB:write ClientInit:shared=" + shared);
        }
        this.writeByte((byte)(shared ? 1 : 0));
    }

    public boolean readServerInit() {
        int strlen;
        byte[] pkt = this.read(20);
        this.width = BE.getuint16(pkt, 0);
        this.height = BE.getuint16(pkt, 2);
        this.setSize();
        this.pf = new PixelFormat();
        this.pf.decode(pkt, 4);
        this.bytesPixel = this.pf.bytesPixel();
        if (debug) {
            JFLog.log(log, "RFB:read server pixel format=" + String.valueOf(this.pf));
        }
        if ((strlen = this.readInt()) > 0x100000) {
            JFLog.log(log, "RFB:error strlen=" + strlen);
            this.connected = false;
            return false;
        }
        byte[] name_bytes = this.read(strlen);
        this.name = new String(name_bytes);
        if (debug) {
            JFLog.log("RFB:desktop name=" + this.name);
        }
        return true;
    }

    public void writePixelFormat() {
        if (debug) {
            JFLog.log(log, "RFB:write PixelFormat");
        }
        byte[] pkt = new byte[20];
        pkt[0] = 0;
        PixelFormat pf = PixelFormat.create_24bpp();
        pf.encode(pkt, 4);
        this.write(pkt);
    }

    public void writeEncodings(int[] encodings) {
        if (debug) {
            JFLog.log(log, "RFB:write Encodings");
        }
        int count = encodings.length;
        byte[] pkt = new byte[4 + count * 4];
        pkt[0] = 2;
        BE.setuint16(pkt, 2, count);
        for (int a = 0; a < count; ++a) {
            BE.setuint32(pkt, 4 + a * 4, encodings[a]);
        }
        this.write(pkt);
    }

    public void writeEncodingsFast() {
        this.writeEncodings(new int[]{5, 1, 4, 2, 0, 6, 7, -23, -223, -224, -232, -239});
    }

    public void writeEncodingsLean() {
        this.writeEncodings(new int[]{7, 6, 5, 1, 4, 2, 0, -23, -223, -224, -232, -239});
    }

    public void writeBufferUpdateRequest(int x, int y, int width, int height, boolean incremental) {
        if (debug) {
            JFLog.log(log, "RFB:write BufferUpdateRequest");
        }
        byte[] pkt = new byte[10];
        pkt[0] = 3;
        pkt[1] = (byte)(incremental ? 1 : 0);
        BE.setuint16(pkt, 2, x);
        BE.setuint16(pkt, 4, y);
        BE.setuint16(pkt, 6, width);
        BE.setuint16(pkt, 8, height);
        this.write(pkt);
    }

    public static int convertKeyCode(int key) {
        switch (key) {
            case 8: {
                key = 65288;
                break;
            }
            case 9: {
                key = 65289;
                break;
            }
            case 10: {
                key = 65293;
                break;
            }
            case 27: {
                key = 65307;
                break;
            }
            case 36: {
                key = 65360;
                break;
            }
            case 37: {
                key = 65361;
                break;
            }
            case 38: {
                key = 65362;
                break;
            }
            case 39: {
                key = 65363;
                break;
            }
            case 40: {
                key = 65364;
                break;
            }
            case 33: {
                key = 65365;
                break;
            }
            case 34: {
                key = 65366;
                break;
            }
            case 35: {
                key = 65367;
                break;
            }
            case 155: {
                key = 65379;
                break;
            }
            case 112: {
                key = 65470;
                break;
            }
            case 113: {
                key = 65471;
                break;
            }
            case 114: {
                key = 65472;
                break;
            }
            case 115: {
                key = 65473;
                break;
            }
            case 116: {
                key = 65474;
                break;
            }
            case 117: {
                key = 65475;
                break;
            }
            case 118: {
                key = 65476;
                break;
            }
            case 119: {
                key = 65477;
                break;
            }
            case 120: {
                key = 65478;
                break;
            }
            case 121: {
                key = 65479;
                break;
            }
            case 122: {
                key = 65480;
                break;
            }
            case 123: {
                key = 65481;
                break;
            }
            case 16: {
                key = 65505;
                break;
            }
            case 17: {
                key = 65507;
                break;
            }
            case 157: {
                key = 65511;
                break;
            }
            case 18: {
                key = 65513;
                break;
            }
            case 127: {
                key = 65535;
            }
        }
        return key;
    }

    public void writeKeyEvent(int code, boolean down) {
        if (debug) {
            JFLog.log(log, "RFB:write KeyEvent");
        }
        byte[] pkt = new byte[8];
        pkt[0] = 4;
        pkt[1] = (byte)(down ? 1 : 0);
        BE.setuint32(pkt, 4, code);
        this.write(pkt);
    }

    public void writeMouseEvent(int x, int y, int buttons) {
        if (debug) {
            JFLog.log(log, "RFB:write MouseEvent");
        }
        byte[] pkt = new byte[6];
        pkt[0] = 5;
        pkt[1] = (byte)buttons;
        BE.setuint16(pkt, 2, x);
        BE.setuint16(pkt, 4, y);
        this.write(pkt);
    }

    public void writeCutText(String txt) {
        if (debug) {
            JFLog.log(log, "RFB:write CutText");
        }
        byte[] bytes = txt.getBytes();
        int len = 8 + bytes.length;
        byte[] pkt = new byte[len];
        pkt[0] = 6;
        BE.setuint32(pkt, 4, len);
        System.arraycopy(bytes, 0, pkt, 4, bytes.length);
        this.write(pkt);
    }

    public int readMessageType() {
        if (!this.connected) {
            JFLog.log(log, "RFB:connection is closed");
            return -1;
        }
        if (debug) {
            JFLog.log(log, "Reading Message Type");
        }
        int msg = this.readByte();
        if (debug) {
            JFLog.log(log, "RFB:read msg=" + msg);
        }
        return msg;
    }

    public Rectangle readBufferUpdate() {
        byte[] pkt = this.read(3);
        int count = BE.getuint16(pkt, 1);
        if (debug) {
            JFLog.log("RFB:read UpdateBufferCount=" + count);
        }
        Rectangle rect = new Rectangle();
        for (int a = 0; a < count; ++a) {
            this.readRectangle(rect);
        }
        return rect;
    }

    private void readRectangle(Rectangle full) {
        byte[] pkt = this.read(12);
        Rectangle rect = new Rectangle();
        rect.x = BE.getuint16(pkt, 0);
        rect.y = BE.getuint16(pkt, 2);
        rect.width = BE.getuint16(pkt, 4);
        rect.height = BE.getuint16(pkt, 6);
        full.add(rect);
        int encoding = BE.getuint32(pkt, 8);
        if (debug) {
            JFLog.log(log, "RFB:read RectType[]=" + encoding + ":rect=" + String.valueOf(rect));
        }
        switch (encoding) {
            case 0: {
                this.readRectRaw(rect);
                break;
            }
            case 1: {
                this.readRectRect(rect);
                break;
            }
            case 2: {
                this.readRectRRE(rect);
                break;
            }
            case 4: {
                this.readRectCoRRE(rect);
                break;
            }
            case 5: {
                this.readRectHexTile(rect);
                break;
            }
            case 6: {
                this.readRectZlib(rect);
                break;
            }
            case 7: {
                this.readRectTight(rect);
                break;
            }
            case 8: {
                this.unsupported(encoding);
                break;
            }
            case 15: {
                this.unsupported(encoding);
                break;
            }
            case 16: {
                this.unsupported(encoding);
                break;
            }
            case 17: {
                this.unsupported(encoding);
                break;
            }
            case -239: {
                this.readRectCursor(rect);
                break;
            }
            case -223: {
                this.readRectDesktopSize(rect);
                full.newSize = true;
                break;
            }
            case -232: {
                this.readPointerPos(rect);
                full.ptrPos = true;
                break;
            }
            default: {
                this.unsupported(encoding);
            }
        }
    }

    private void unsupported(int type) {
        JFLog.log("Unsupported encoding:" + type);
    }

    private void readRectRaw(Rectangle rect) {
        byte[] data = this.read(rect.width * rect.height * 4);
        int src = 0;
        int x1 = rect.x;
        int x2 = x1 + rect.width - 1;
        int y1 = rect.y;
        int y2 = y1 + rect.height - 1;
        for (int y = y1; y <= y2; ++y) {
            for (int x = x1; x <= x2; ++x) {
                int px;
                this.buffer[y * this.width + x] = px = RFB.getPixel(data, src) | 0xFF000000;
                src += 4;
            }
        }
    }

    private void readRectRect(Rectangle rect) {
        byte[] pkt = this.read(4);
        int srcx = BE.getuint16(pkt, 0);
        int srcy = BE.getuint16(pkt, 2);
        int x1 = rect.x;
        int x2 = x1 + rect.width - 1;
        int y1 = rect.y;
        int y2 = y1 + rect.height - 1;
        int sx = srcx;
        int sy = srcy;
        for (int y = y1; y <= y2; ++y) {
            sx = srcx;
            for (int x = x1; x <= x2; ++x) {
                this.buffer[y * this.width + x] = this.buffer[sy * this.width + sx];
                ++sx;
            }
            ++sy;
        }
    }

    private void readRectRRE(Rectangle rect) {
        byte[] pkt = this.read(8);
        int cnt = BE.getuint32(pkt, 0);
        int clr = RFB.getPixel(pkt, 4);
        this.fill(rect, clr);
        Rectangle subrect = new Rectangle();
        for (int a = 0; a < cnt; ++a) {
            pkt = this.read(12);
            clr = RFB.getPixel(pkt, 0);
            subrect.x = rect.x + BE.getuint16(pkt, 4);
            subrect.y = rect.y + BE.getuint16(pkt, 6);
            subrect.width = BE.getuint16(pkt, 8);
            subrect.height = BE.getuint16(pkt, 10);
            this.fill(subrect, clr);
        }
    }

    private void readRectCoRRE(Rectangle rect) {
        byte[] pkt = this.read(8);
        int cnt = BE.getuint32(pkt, 0);
        int clr = RFB.getPixel(pkt, 4);
        this.fill(rect, clr);
        Rectangle subrect = new Rectangle();
        for (int a = 0; a < cnt; ++a) {
            pkt = this.read(8);
            clr = RFB.getPixel(pkt, 0);
            subrect.x = rect.x + pkt[4] & 0xFF;
            subrect.y = rect.y + pkt[5] & 0xFF;
            subrect.width = pkt[6] & 0xFF;
            subrect.height = pkt[7] & 0xFF;
            this.fill(subrect, clr);
        }
    }

    private void readRectHexTile(Rectangle r) {
        this.hextile_bg = 0;
        this.hextile_fg = 0;
        for (int ty = r.y; ty < r.y + r.height; ty += 16) {
            int th = 16;
            if (r.y + r.height - ty < 16) {
                th = r.y + r.height - ty;
            }
            for (int tx = r.x; tx < r.x + r.width; tx += 16) {
                int tw = 16;
                if (r.x + r.width - tx < 16) {
                    tw = r.x + r.width - tx;
                }
                this.hextileSubrect(new Rectangle(tx, ty, tw, th));
            }
        }
    }

    private void hextileSubrect(Rectangle sr) {
        byte[] cbuf;
        int subencoding = this.readByte();
        if (debug) {
            JFLog.log(log, "RFB:HexTile:subType=0x" + Integer.toString(subencoding, 16));
        }
        if ((subencoding & 1) != 0) {
            this.readRectRaw(sr);
            return;
        }
        if ((subencoding & 2) != 0) {
            if (this.bytesPixel == 1) {
                cbuf = this.read(1);
                this.hextile_bg = this.colors[cbuf[0] & 0xFF];
            } else {
                cbuf = this.read(4);
                this.hextile_bg = RFB.getPixel(cbuf, 0);
            }
            if (debug) {
                JFLog.log("RFB:HexTile:bg=0x" + Integer.toString(this.hextile_bg, 16));
            }
        }
        this.fill(sr, this.hextile_bg);
        if ((subencoding & 4) != 0) {
            if (this.bytesPixel == 1) {
                cbuf = this.read(1);
                this.hextile_fg = this.colors[cbuf[0] & 0xFF];
            } else {
                cbuf = this.read(4);
                this.hextile_fg = RFB.getPixel(cbuf, 0);
            }
            if (debug) {
                JFLog.log("RFB:HexTile:fg=0x" + Integer.toString(this.hextile_bg, 16));
            }
        }
        if ((subencoding & 8) == 0) {
            return;
        }
        int nSubRects = this.readByte();
        if (debug) {
            JFLog.log("RFB:HexTile:SubRects=" + nSubRects);
        }
        int bufsize = nSubRects * 2;
        if ((subencoding & 0x10) != 0) {
            bufsize += nSubRects * this.bytesPixel;
        }
        byte[] buf = this.read(bufsize);
        int i = 0;
        if ((subencoding & 0x10) == 0) {
            for (int j = 0; j < nSubRects; ++j) {
                int b1 = buf[i++] & 0xFF;
                int b2 = buf[i++] & 0xFF;
                int sx = sr.x + (b1 >> 4);
                int sy = sr.y + (b1 & 0xF);
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.fill(new Rectangle(sx, sy, sw, sh), this.hextile_fg);
            }
        } else if (this.bytesPixel == 1) {
            for (int j = 0; j < nSubRects; ++j) {
                this.hextile_fg = this.colors[buf[i++] & 0xFF];
                int b1 = buf[i++] & 0xFF;
                int b2 = buf[i++] & 0xFF;
                int sx = sr.x + (b1 >> 4);
                int sy = sr.y + (b1 & 0xF);
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.fill(new Rectangle(sx, sy, sw, sh), this.hextile_fg);
            }
        } else {
            for (int j = 0; j < nSubRects; ++j) {
                this.hextile_fg = RFB.getPixel(buf, i);
                i += 4;
                int b1 = buf[i++] & 0xFF;
                int b2 = buf[i++] & 0xFF;
                int sx = sr.x + (b1 >> 4);
                int sy = sr.y + (b1 & 0xF);
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.fill(new Rectangle(sx, sy, sw, sh), this.hextile_fg);
            }
        }
    }

    void readRectZlib(Rectangle r) {
        int nBytes = this.readInt();
        if (this.zlibBuf == null || this.zlibBufLen < nBytes) {
            this.zlibBufLen = nBytes * 2;
            this.zlibBuf = this.read(this.zlibBufLen);
        }
        if (this.zlibInflater == null) {
            this.zlibInflater = new Inflater();
        }
        this.zlibInflater.setInput(this.zlibBuf, 0, nBytes);
        if (this.bytesPixel == 1) {
            byte[] pixels8 = null;
            for (int dy = r.y; dy < r.y + r.height; ++dy) {
                try {
                    this.zlibInflater.inflate(pixels8, dy * this.width + r.x, r.width);
                    continue;
                }
                catch (Exception e) {
                    JFLog.log(log, (Throwable)e);
                }
            }
        } else {
            byte[] buf = new byte[r.width * 4];
            for (int dy = r.y; dy < r.y + r.height; ++dy) {
                try {
                    this.zlibInflater.inflate(buf);
                }
                catch (Exception e) {
                    JFLog.log(log, (Throwable)e);
                }
                int offset = dy * this.width + r.x;
                for (int i = 0; i < r.width; ++i) {
                    this.buffer[offset + i] = RFB.getPixel(buf, i * 4) | 0xFF000000;
                }
            }
        }
    }

    private void readRectCursor(Rectangle r) {
        int cursorLen = r.width * r.height * this.bytesPixel;
        byte[] cursor = this.read(cursorLen);
        int bitmaskLen = (r.width + 7) / 8 * r.height;
        byte[] bitmask = this.read(bitmaskLen);
    }

    private void readRectTight(Rectangle r) {
        int dataSize;
        int i;
        byte[] buf;
        int comp_ctl = this.readByte();
        for (int stream_id = 0; stream_id < 4; ++stream_id) {
            if ((comp_ctl & 1) != 0 && this.tightInflaters[stream_id] != null) {
                this.tightInflaters[stream_id] = null;
            }
            comp_ctl >>= 1;
        }
        if (comp_ctl > 9) {
            JFLog.log(log, "RFB:Incorrect tight subencoding: " + comp_ctl);
            this.connected = false;
            return;
        }
        if (debug) {
            JFLog.log(log, "RFB:Tight:SubType=" + comp_ctl);
        }
        if (comp_ctl == 8) {
            if (this.bytesPixel == 1) {
                int idx = this.readByte();
                this.clr = this.colors[idx];
            } else {
                byte[] buf2 = this.read(4);
                this.clr = RFB.getPixel(buf2, 0);
            }
            this.fill(r, this.clr);
            return;
        }
        if (comp_ctl == 9) {
            JFImage tmp = new JFImage();
            byte[] jpegData = this.read(this.readCompactLen());
            if (!tmp.loadJPG(new ByteArrayInputStream(jpegData))) {
                JFLog.log(log, "RFB:Error:Unable to load JPEG image");
                return;
            }
            this.image.putJFImage(tmp, r.x, r.y);
            return;
        }
        int numColors = 0;
        int rowSize = r.width;
        byte[] palette8 = new byte[2];
        int[] palette24 = new int[256];
        boolean useGradient = false;
        if ((comp_ctl & 4) != 0) {
            int filter_id = this.readByte();
            if (filter_id == 1) {
                numColors = this.readByte() + 1;
                if (this.bytesPixel == 1) {
                    if (numColors != 2) {
                        JFLog.log(log, "RFB:Incorrect tight palette size: " + numColors);
                        return;
                    }
                    palette8 = this.read(2);
                } else {
                    buf = this.read(numColors * 3);
                    for (i = 0; i < numColors; ++i) {
                        palette24[i] = RFB.getPixel(buf, i * 3) | 0xFF000000;
                    }
                }
                if (numColors == 2) {
                    rowSize = (r.width + 7) / 8;
                }
            } else if (filter_id == 2) {
                useGradient = true;
            } else if (filter_id != 0) {
                JFLog.log(log, "RFB:Incorrect tight filter id: " + filter_id);
                return;
            }
        }
        if (numColors == 0 && this.bytesPixel == 4) {
            rowSize *= 3;
        }
        if ((dataSize = r.height * rowSize) < 12) {
            if (numColors != 0) {
                byte[] indexedData = this.read(dataSize);
                if (numColors == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(r, indexedData, palette8);
                    } else {
                        this.decodeMonoData(r, indexedData, palette24);
                    }
                } else {
                    i = 0;
                    for (int dy = r.y; dy < r.y + r.height; ++dy) {
                        for (int dx = r.x; dx < r.x + r.width; ++dx) {
                            this.buffer[dy * this.width + dx] = palette24[indexedData[i++] & 0xFF];
                        }
                    }
                }
            } else if (useGradient) {
                buf = this.read(r.width * r.height * 3);
                this.decodeGradientData(r, buf);
            } else if (this.bytesPixel == 1) {
                for (int dy = r.y; dy < r.y + r.height; ++dy) {
                    byte[] pixels8 = this.read(r.width);
                    for (int a = 0; a < pixels8.length; ++a) {
                        this.buffer[a] = pixels8[dy * this.width + r.x] | 0xFF000000;
                    }
                }
            } else {
                for (int dy = r.y; dy < r.y + r.height; ++dy) {
                    buf = this.read(r.width * 3);
                    int offset = dy * this.width + r.x;
                    for (i = 0; i < r.width; ++i) {
                        this.buffer[offset + i] = RFB.getPixel(buf, i * 3) | 0xFF000000;
                    }
                }
            }
        } else {
            int zlibDataLen = this.readCompactLen();
            byte[] zlibData = this.read(zlibDataLen);
            int stream_id = comp_ctl & 3;
            if (this.tightInflaters[stream_id] == null) {
                this.tightInflaters[stream_id] = new Inflater();
            }
            Inflater myInflater = this.tightInflaters[stream_id];
            myInflater.setInput(zlibData);
            byte[] buf3 = new byte[dataSize];
            try {
                myInflater.inflate(buf3);
            }
            catch (Exception e) {
                JFLog.log(log, (Throwable)e);
                return;
            }
            if (numColors != 0) {
                if (numColors == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(r, buf3, palette8);
                    } else {
                        this.decodeMonoData(r, buf3, palette24);
                    }
                } else {
                    int i2 = 0;
                    for (int dy = r.y; dy < r.y + r.height; ++dy) {
                        for (int dx = r.x; dx < r.x + r.width; ++dx) {
                            this.buffer[dy * this.width + dx] = palette24[buf3[i2++] & 0xFF];
                        }
                    }
                }
            } else if (useGradient) {
                this.decodeGradientData(r, buf3);
            } else if (this.bytesPixel == 1) {
                int destOffset = r.y * this.width + r.x;
                for (int dy = 0; dy < r.height; ++dy) {
                    for (int x = 0; x < r.width; ++x) {
                        this.buffer[destOffset] = buf3[dy * r.width + x] | 0xFF000000;
                    }
                    destOffset += this.width;
                }
            } else {
                int srcOffset = 0;
                for (int dy = 0; dy < r.height; ++dy) {
                    try {
                        myInflater.inflate(buf3);
                    }
                    catch (Exception e) {
                        JFLog.log(log, (Throwable)e);
                        return;
                    }
                    int destOffset = (r.y + dy) * this.width + r.x;
                    for (int i3 = 0; i3 < r.width; ++i3) {
                        this.buffer[destOffset + i3] = RFB.getPixel(buf3, srcOffset) | 0xFF000000;
                        srcOffset += 3;
                    }
                }
            }
        }
    }

    void decodeMonoData(Rectangle r, byte[] src, byte[] palette) {
        int i = r.y * this.width + r.x;
        int rowBytes = (r.width + 7) / 8;
        for (int dy = 0; dy < r.height; ++dy) {
            int n;
            int dx;
            for (dx = 0; dx < r.width / 8; ++dx) {
                byte b = src[dy * rowBytes + dx];
                for (n = 7; n >= 0; --n) {
                    this.buffer[i++] = palette[b >> n & 1] | 0xFF000000;
                }
            }
            for (n = 7; n >= 8 - r.width % 8; --n) {
                this.buffer[i++] = palette[src[dy * rowBytes + dx] >> n & 1] | 0xFF000000;
            }
            i += this.width - r.width;
        }
    }

    void decodeMonoData(Rectangle r, byte[] src, int[] palette) {
        int i = r.y * this.width + r.x;
        int rowBytes = (r.width + 7) / 8;
        for (int dy = 0; dy < r.height; ++dy) {
            int n;
            int dx;
            for (dx = 0; dx < r.width / 8; ++dx) {
                byte b = src[dy * rowBytes + dx];
                for (n = 7; n >= 0; --n) {
                    this.buffer[i++] = palette[b >> n & 1];
                }
            }
            for (n = 7; n >= 8 - r.width % 8; --n) {
                this.buffer[i++] = palette[src[dy * rowBytes + dx] >> n & 1];
            }
            i += this.width - r.width;
        }
    }

    void decodeGradientData(Rectangle r, byte[] buf) {
        byte[] prevRow = new byte[r.width * 3];
        byte[] thisRow = new byte[r.width * 3];
        byte[] pix = new byte[3];
        int[] est = new int[3];
        int offset = r.y * this.width + r.x;
        for (int dy = 0; dy < r.height; ++dy) {
            int c;
            for (c = 0; c < 3; ++c) {
                pix[c] = (byte)(prevRow[c] + buf[dy * r.width * 3 + c]);
                thisRow[c] = pix[c];
            }
            this.buffer[offset++] = RFB.getPixel(pix, 0);
            for (int dx = 1; dx < r.width; ++dx) {
                for (c = 0; c < 3; ++c) {
                    est[c] = (prevRow[dx * 3 + c] & 0xFF) + (pix[c] & 0xFF) - (prevRow[(dx - 1) * 3 + c] & 0xFF);
                    if (est[c] > 255) {
                        est[c] = 255;
                    } else if (est[c] < 0) {
                        est[c] = 0;
                    }
                    pix[c] = (byte)(est[c] + buf[(dy * r.width + dx) * 3 + c]);
                    thisRow[dx * 3 + c] = pix[c];
                }
                this.buffer[offset++] = RFB.getPixel(pix, 0);
            }
            System.arraycopy(thisRow, 0, prevRow, 0, r.width * 3);
            offset += this.width - r.width;
        }
    }

    private void readRectDesktopSize(Rectangle r) {
        this.width = r.width;
        this.height = r.height;
        this.setSize();
    }

    private void readPointerPos(Rectangle r) {
        this.mx = r.x;
        this.my = r.y;
        if (debug) {
            JFLog.log("Pointer Pos:" + this.mx + "," + this.my);
        }
    }

    public byte[] readColorMap() {
        byte[] pkt = this.read(5);
        int first = BE.getuint16(pkt, 1);
        int count = BE.getuint16(pkt, 3);
        if (debug) {
            JFLog.log(log, "RFB:read ColorMap:first=" + first + ",count=" + count);
        }
        byte[] clrs = this.read(count * 6);
        if (debug) {
            JFLog.log(log, "RFB:read ColorMap:array=" + String.valueOf(clrs));
        }
        return clrs;
    }

    public void readBell() {
    }

    public String readCutText() {
        byte[] pkt = this.read(7);
        int strlen = BE.getuint32(pkt, 3);
        if (strlen > 0x100000) {
            this.connected = false;
            return null;
        }
        byte[] bytes = this.read(strlen);
        return new String(bytes);
    }

    static {
        VERSION_3_3 = 3.3f;
        VERSION_3_7 = 3.7f;
        VERSION_3_8 = 3.8f;
    }

    public static class Rectangle {
        public int x;
        public int y;
        public int width;
        public int height;
        public boolean newSize;
        public boolean ptrPos;

        public Rectangle() {
        }

        public Rectangle(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public Rectangle(Rectangle o) {
            this.x = o.x;
            this.y = o.y;
            this.width = o.width;
            this.height = o.height;
        }

        public void add(Rectangle rect) {
            if (this.width == 0 || this.height == 0) {
                this.x = rect.x;
                this.y = rect.y;
                this.width = rect.width;
                this.height = rect.height;
                return;
            }
            int rx1 = rect.x;
            int rx2 = rx1 + rect.width - 1;
            int ry1 = rect.y;
            int ry2 = ry1 + rect.height - 1;
            int tx1 = this.x;
            int tx2 = tx1 + this.width - 1;
            int ty1 = this.y;
            int ty2 = ty1 + this.height - 1;
            if (rx1 < tx1) {
                tx1 = rx1;
            }
            if (ry1 < ty1) {
                ty1 = ry1;
            }
            if (rx2 > tx2) {
                tx2 = rx2;
            }
            if (ry2 > ty2) {
                ty2 = ry2;
            }
            this.x = tx1;
            this.y = ty1;
            this.width = tx2 - tx1 + 1;
            this.height = ty2 - ty1 + 1;
        }

        public String toString() {
            return "Rectangle:" + this.x + "," + this.y + ":" + this.width + "x" + this.height;
        }
    }

    private static class PixelFormat {
        public int bpp;
        public int depth;
        public boolean be;
        public boolean tc;
        public int r_max;
        public int g_max;
        public int b_max;
        public int r_shift;
        public int g_shift;
        public int b_shift;

        private PixelFormat() {
        }

        public int bytesPixel() {
            switch (this.bpp) {
                case 8: {
                    return 1;
                }
                case 16: {
                    return 2;
                }
                case 32: {
                    return 4;
                }
            }
            return 0;
        }

        public void decode(byte[] pkt, int offset) {
            this.bpp = pkt[offset++] & 0xFF;
            this.depth = pkt[offset++];
            this.be = pkt[offset++] == 1;
            this.tc = pkt[offset++] == 1;
            this.r_max = BE.getuint16(pkt, offset);
            this.g_max = BE.getuint16(pkt, offset += 2);
            this.b_max = BE.getuint16(pkt, offset += 2);
            offset += 2;
            this.r_shift = pkt[offset++];
            this.g_shift = pkt[offset++];
            this.b_shift = pkt[offset++];
        }

        public void encode(byte[] pkt, int offset) {
            pkt[offset++] = (byte)this.bpp;
            pkt[offset++] = (byte)this.depth;
            pkt[offset++] = (byte)(this.be ? 1 : 0);
            pkt[offset++] = (byte)(this.tc ? 1 : 0);
            BE.setuint16(pkt, offset, this.r_max);
            BE.setuint16(pkt, offset += 2, this.g_max);
            BE.setuint16(pkt, offset += 2, this.b_max);
            offset += 2;
            pkt[offset++] = (byte)this.r_shift;
            pkt[offset++] = (byte)this.g_shift;
            pkt[offset++] = (byte)this.b_shift;
        }

        public static PixelFormat create_24bpp() {
            PixelFormat pf = new PixelFormat();
            pf.bpp = 32;
            pf.depth = 24;
            pf.be = false;
            pf.tc = true;
            pf.r_max = 255;
            pf.g_max = 255;
            pf.b_max = 255;
            pf.r_shift = 16;
            pf.g_shift = 8;
            pf.b_shift = 0;
            return pf;
        }

        public String toString() {
            return "PixelFormat:" + this.bpp + "," + this.depth + ",be=" + this.be + ",tc=" + this.tc;
        }
    }
}

