/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.util.Arrays;
import java.util.Calendar;
import javaforce.JF;
import javaforce.JFLog;

public class GitRepo {
    private static char d1 = (char)45;
    private static char d2 = (char)45;

    public static void main(String[] args) {
        if (args.length != 1) {
            JFLog.log("Usage: GitRepo package_ext");
            System.exit(1);
        }
        String ext = args[0];
        if (args[0].equals("deb")) {
            d2 = (char)95;
        }
        JF.exec(new String[]{"git", "add", "*." + ext});
        Object[] files = new File(".").list();
        Arrays.sort(files);
        Object last = null;
        for (Object file : files) {
            if (!((String)file).endsWith(ext)) continue;
            if (last == null) {
                last = file;
                continue;
            }
            if (GitRepo.same((String)last, (String)file)) {
                if (GitRepo.older((String)last, (String)file)) {
                    GitRepo.delete((String)last);
                }
                if (GitRepo.older((String)file, (String)last)) {
                    GitRepo.delete((String)file);
                }
            }
            last = file;
        }
        JF.exec(new String[]{"git", "commit", "-m", GitRepo.getDate()});
        JF.exec(new String[]{"git", "reflog", "expire", "--expire=now", "--all"});
        JF.exec(new String[]{"git", "gc", "--prune=now", "--aggressive"});
        JF.exec(new String[]{"bash", "update.sh"});
    }

    private static String getDate() {
        Calendar c = Calendar.getInstance();
        return String.format("\"%04d/%02d/%02d\"", c.get(1), c.get(2) + 1, c.get(5));
    }

    private static boolean same(String p1, String p2) {
        int i1 = p1.indexOf(d1);
        if (i1 == -1) {
            return false;
        }
        int i2 = p2.indexOf(d1);
        if (i2 == -1) {
            return false;
        }
        return p1.substring(0, i1).equals(p2.substring(0, i2));
    }

    private static int[] getVersion(String p) {
        int i1 = p.indexOf(d1);
        int i2 = p.indexOf(d2);
        String[] ps = p.substring(i1 + 1, i2).split("[.]");
        int[] ver = new int[ps.length];
        for (int a = 0; a < ver.length; ++a) {
            ver[a] = Integer.valueOf(ps[a]);
        }
        return ver;
    }

    private static boolean older(String p1, String p2) {
        int len1;
        int len;
        int[] ver1 = GitRepo.getVersion(p1);
        int[] ver2 = GitRepo.getVersion(p2);
        int len2 = ver2.length;
        if (len2 > (len = (len1 = ver1.length))) {
            len = len2;
        }
        for (int i = 0; i < len; ++i) {
            if (len1 == i) {
                return true;
            }
            if (len2 == i) {
                return false;
            }
            if (ver1[i] >= ver2[i]) continue;
            return true;
        }
        return false;
    }

    private static void delete(String p) {
        new File(p).delete();
        JF.exec(new String[]{"java", "-jar", "bfg.jar", "-D", p});
    }
}

