/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.FileInputStream;
import java.io.InputStream;

public class list3ds {
    static FileInputStream fi;
    static String str;
    private static final int _3DS_FLG_TENSION = 1;
    private static final int _3DS_FLG_CONTINUITY = 2;
    private static final int _3DS_FLG_BIAS = 4;
    private static final int _3DS_FLG_EASE_TO = 8;
    private static final int _3DS_FLG_EASE_FROM = 16;

    static void readstr() throws Exception {
        str = "";
        while (fi.available() > 0) {
            char ch = (char)fi.read();
            if (ch == '\u0000') {
                return;
            }
            str = str + ch;
        }
        str = "";
    }

    static void readx(boolean four) throws Exception {
        float[] f4 = new float[4];
        int u16 = list3ds.readuint16(fi);
        System.out.format("  flgs = %d\n", u16);
        int u32 = list3ds.readuint32(fi);
        System.out.format("  res1 = %d\n", u32);
        u32 = list3ds.readuint32(fi);
        System.out.format("  res2 = %d\n", u32);
        int cnt = list3ds.readuint32(fi);
        System.out.format("  keys = %d\n", cnt);
        while (cnt-- > 0) {
            float f;
            System.out.format("  tcb {\n", new Object[0]);
            u32 = list3ds.readuint32(fi);
            System.out.format("    frame = %d\n", u32);
            u16 = list3ds.readuint16(fi);
            System.out.format("    flgs = %d\n", u16);
            if ((u16 & 1) != 0) {
                f = list3ds.readfloat(fi);
                System.out.format("    tension = %f\n", Float.valueOf(f));
            }
            if ((u16 & 2) != 0) {
                f = list3ds.readfloat(fi);
                System.out.format("    continuity = %f\n", Float.valueOf(f));
            }
            if ((u16 & 4) != 0) {
                f = list3ds.readfloat(fi);
                System.out.format("    bias = %f\n", Float.valueOf(f));
            }
            if ((u16 & 8) != 0) {
                f = list3ds.readfloat(fi);
                System.out.format("    ease to = %f\n", Float.valueOf(f));
            }
            if ((u16 & 0x10) != 0) {
                f = list3ds.readfloat(fi);
                System.out.format("    ease from = %f\n", Float.valueOf(f));
            }
            System.out.format("  };\n", new Object[0]);
            if (four) {
                f4[0] = list3ds.readfloat(fi);
                f4[1] = list3ds.readfloat(fi);
                f4[2] = list3ds.readfloat(fi);
                f4[3] = list3ds.readfloat(fi);
                System.out.format("  angle : %f : axis : %f : %f : %f\n", Float.valueOf(f4[0]), Float.valueOf(f4[1]), Float.valueOf(f4[2]), Float.valueOf(f4[4]));
                continue;
            }
            f4[0] = list3ds.readfloat(fi);
            f4[1] = list3ds.readfloat(fi);
            f4[2] = list3ds.readfloat(fi);
            System.out.format("  coords : %f : %f : %f\n", Float.valueOf(f4[0]), Float.valueOf(f4[1]), Float.valueOf(f4[2]));
        }
    }

    public static void main(String[] args) {
        int pos = 0;
        float[] f = new float[4];
        int[] i16 = new int[4];
        if (args.length != 1) {
            System.out.println("Usage : list3ds filein.3ds");
            System.exit(0);
        }
        try {
            fi = new FileInputStream(args[0]);
            int fs = fi.available();
            System.out.format("list3ds : %s : filesize=%08x\n", args[0], fs);
            while (fi.available() > 0) {
                int id = list3ds.readuint16(fi);
                int len = list3ds.readuint32(fi);
                int skip = 0;
                switch (id) {
                    case 0: {
                        System.out.format("%08x:%08x:%04x : EOF Chunk\n", pos, len, id);
                        pos += 6;
                        return;
                    }
                    case 19789: {
                        System.out.format("%08x:%08x:%04x : Main Chunk\n", pos, len, id);
                        pos += 6;
                        break;
                    }
                    case 15677: {
                        System.out.format("%08x:%08x:%04x : Mesh Chunk\n", pos, len, id);
                        pos += 6;
                        break;
                    }
                    case 45055: {
                        System.out.format("%08x:%08x:%04x : Material Chunk\n", pos, len, id);
                        pos += 6;
                        break;
                    }
                    case 40960: {
                        System.out.format("%08x:%08x:%04x : Material : Name Chunk\n", pos, len, id);
                        list3ds.readstr();
                        System.out.format("  Name = %s\n", str);
                        pos += len;
                        break;
                    }
                    case 41472: {
                        System.out.format("%08x:%08x:%04x : Texture Chunk\n", pos, len, id);
                        pos += 6;
                        break;
                    }
                    case 41728: {
                        list3ds.readstr();
                        System.out.format("%08x:%08x:%04x : Texture Filename Chunk\n  FileName = %s\n", pos, len, id, str);
                        pos += 6 + str.length() + 1;
                        break;
                    }
                    case 45056: {
                        System.out.format("%08x:%08x:%04x : KeyFrame Chunk\n", pos, len, id);
                        pos += 6;
                        break;
                    }
                    case 45066: {
                        System.out.format("%08x:%08x:%04x : KeyFrame Header Chunk\n", pos, len, id);
                        int u16 = list3ds.readuint16(fi);
                        System.out.format("  revision = %d\n", u16);
                        list3ds.readstr();
                        System.out.format("      name = %s\n", str);
                        int u32 = list3ds.readuint32(fi);
                        System.out.format("    frames = %d\n", u32);
                        pos += 8 + str.length() + 1 + 4;
                        break;
                    }
                    case 45064: {
                        System.out.format("%08x:%08x:%04x : KeyFrame Segment Chunk\n", pos, len, id);
                        int u32 = list3ds.readuint32(fi);
                        System.out.format("     start = %d\n", u32);
                        u32 = list3ds.readuint32(fi);
                        System.out.format("      stop = %d\n", u32);
                        pos += 14;
                        break;
                    }
                    case 45065: {
                        System.out.format("%08x:%08x:%04x : KeyFrame Current Time Chunk\n", pos, len, id);
                        int u32 = list3ds.readuint32(fi);
                        System.out.format("   curtime = %d\n", u32);
                        pos += 10;
                        break;
                    }
                    case 45058: {
                        System.out.format("%08x:%08x:%04x : KeyFrame Object Node Tag Chunk\n", pos, len, id);
                        pos += 6;
                        break;
                    }
                    case 45072: {
                        System.out.format("%08x:%08x:%04x : KeyFrame Object Node Tag : Node Header Chunk\n", pos, len, id);
                        list3ds.readstr();
                        System.out.format("  name = %s\n", str);
                        int u16 = list3ds.readuint16(fi);
                        System.out.format("  flgs1 = %d\n", u16);
                        u16 = list3ds.readuint16(fi);
                        System.out.format("  flgs2 = %d\n", u16);
                        u16 = list3ds.readuint16(fi);
                        System.out.format("  parent id = %d\n", u16);
                        pos += len;
                        skip = len - (6 + str.length() + 1 + 2 + 2 + 2);
                        break;
                    }
                    case 45075: {
                        System.out.format("%08x:%08x:%04x : KeyFrame Object Node Tag : Pivot Chunk\n", pos, len, id);
                        f[0] = list3ds.readfloat(fi);
                        f[1] = list3ds.readfloat(fi);
                        f[2] = list3ds.readfloat(fi);
                        System.out.format("  Pivot = %f : %f : %f\n", Float.valueOf(f[0]), Float.valueOf(f[1]), Float.valueOf(f[2]));
                        pos += 18;
                        break;
                    }
                    case 45088: {
                        System.out.format("%08x:%08x:%04x : KeyFrame Object Node Tag : Pos Track Chunk\n", pos, len, id);
                        list3ds.readx(false);
                        pos += len;
                        break;
                    }
                    case 45089: {
                        System.out.format("%08x:%08x:%04x : KeyFrame Object Node Tag : Rotate Track Chunk\n", pos, len, id);
                        list3ds.readx(true);
                        pos += len;
                        break;
                    }
                    case 45090: {
                        System.out.format("%08x:%08x:%04x : KeyFrame Object Node Tag : Scale Track Chunk\n", pos, len, id);
                        list3ds.readx(false);
                        pos += len;
                        break;
                    }
                    case 45104: {
                        System.out.format("%08x:%08x:%04x : KeyFrame Object Node Tag : Node ID Chunk\n", pos, len, id);
                        int u16 = list3ds.readuint16(fi);
                        System.out.format("  node id = %d\n", u16);
                        pos += len;
                        skip = len - 8;
                        break;
                    }
                    case 16384: {
                        list3ds.readstr();
                        System.out.format("%08x:%08x:%04x : Object Chunk\n  Name = %s\n", pos, len, id, str);
                        pos += 6 + str.length() + 1;
                        break;
                    }
                    case 16640: {
                        System.out.format("%08x:%08x:%04x : Triangular Chunk\n", pos, len, id);
                        pos += 6;
                        break;
                    }
                    case 16656: {
                        int u16 = list3ds.readuint16(fi);
                        System.out.format("%08x:%08x:%04x : Vertex Chunk\n  Count = %d\n", pos, len, id, u16);
                        pos += len;
                        int cnt = 0;
                        while (u16-- > 0) {
                            f[0] = list3ds.readfloat(fi);
                            f[1] = list3ds.readfloat(fi);
                            f[2] = list3ds.readfloat(fi);
                            System.out.format("  %3d : %f : %f : %f\n", cnt++, Float.valueOf(f[0]), Float.valueOf(f[1]), Float.valueOf(f[2]));
                        }
                        break;
                    }
                    case 16672: {
                        int u16 = list3ds.readuint16(fi);
                        System.out.format("%08x:%08x:%04x : Points Chunk\n  Count = %d\n", pos, len, id, u16);
                        pos += 8 + u16 * 2 * 4;
                        int cnt = 0;
                        while (u16-- > 0) {
                            i16[0] = list3ds.readuint16(fi);
                            i16[1] = list3ds.readuint16(fi);
                            i16[2] = list3ds.readuint16(fi);
                            i16[3] = list3ds.readuint16(fi);
                            System.out.format("  %3d : %d : %d : %d : flgs = x%x\n", cnt++, i16[0], i16[1], i16[2], i16[3]);
                        }
                        break;
                    }
                    case 16688: {
                        System.out.format("%08x:%08x:%04x : Object Material Name Chunk\n", pos, len, id);
                        list3ds.readstr();
                        System.out.format("  Name = %s\n", str);
                        pos += len;
                        skip = len - (6 + str.length() + 1);
                        break;
                    }
                    case 16704: {
                        int u16 = list3ds.readuint16(fi);
                        System.out.format("%08x:%08x:%04x : Texture Vertex Chunk\n  Count = %d\n", pos, len, id, u16);
                        pos += len;
                        int cnt = 0;
                        while (u16-- > 0) {
                            f[0] = list3ds.readfloat(fi);
                            f[1] = list3ds.readfloat(fi);
                            System.out.format("  %3d : %f : %f\n", cnt++, Float.valueOf(f[0]), Float.valueOf(f[1]));
                        }
                        break;
                    }
                    default: {
                        System.out.format("%08x:%08x:%04x : Unknown Chunk\n", pos, len, id);
                        pos += len;
                        skip = len - 6;
                    }
                }
                if (skip <= 0) continue;
                fi.skip(skip);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int readuint16(InputStream in) {
        byte[] data = new byte[2];
        try {
            if (in.read(data) != 2) {
                return -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        int ret = data[0] & 0xFF;
        return ret += (data[1] & 0xFF) << 8;
    }

    public static int readuint32(InputStream in) {
        byte[] data = new byte[4];
        try {
            if (in.read(data) != 4) {
                return -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        int ret = data[0] & 0xFF;
        ret += (data[1] & 0xFF) << 8;
        ret += (data[2] & 0xFF) << 16;
        return ret += (data[3] & 0xFF) << 24;
    }

    public static float readfloat(InputStream in) {
        int bits = list3ds.readuint32(in);
        return Float.intBitsToFloat(bits);
    }
}

