/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.FileInputStream;
import java.io.InputStream;

public class listblend {
    static FileInputStream fi;
    static int bits;
    static int endian;
    static final int LITTLE = 1;
    static final int BIG = 2;

    static String readstr() throws Exception {
        Object str = "";
        while (fi.available() > 0) {
            char ch = (char)fi.read();
            if (ch == '\u0000') {
                return str;
            }
            str = (String)str + ch;
        }
        return str;
    }

    static String readstr(int max) throws Exception {
        Object str = "";
        while (fi.available() > 0 && max != 0) {
            char ch = (char)fi.read();
            if (ch == '\u0000') {
                return str;
            }
            str = (String)str + ch;
            if (max <= 0) continue;
            --max;
        }
        return str;
    }

    public static void main(String[] args) {
        boolean pos = false;
        float[] f = new float[4];
        int[] i16 = new int[4];
        if (args.length != 1) {
            System.out.println("Usage : listblend filein.blend");
            System.exit(0);
        }
        try {
            fi = new FileInputStream(args[0]);
            int fs = fi.available();
            System.out.format("listblend : %s : filesize=%08x\n", args[0], fs);
            String magic = listblend.readstr(7);
            if (!magic.equals("BLENDER")) {
                System.err.println("Error:Not a Blender file, magic=" + magic);
                return;
            }
            char ch = (char)fi.read();
            switch (ch) {
                case '-': {
                    bits = 64;
                    System.out.println("Pointer size:64bits");
                    break;
                }
                case '_': {
                    bits = 32;
                    System.out.println("Pointer size:32bits");
                    break;
                }
                default: {
                    System.err.println("Pointer size:unknown");
                    return;
                }
            }
            ch = (char)fi.read();
            switch (ch) {
                case 'v': {
                    endian = 1;
                    System.out.println("Little Endianness");
                    break;
                }
                case 'V': {
                    endian = 2;
                    System.err.println("Big Endianness is not supported");
                    return;
                }
                default: {
                    System.err.println("Endianness unknown");
                    return;
                }
            }
            String ver = listblend.readstr(3);
            System.out.println("Version=" + ver);
            while (fi.available() > 0) {
                int id = listblend.readuint32(fi);
                int size = listblend.readuint32(fi);
                long ptr = listblend.readuint64(fi);
                int idx = listblend.readuint32(fi);
                int cnt = listblend.readuint32(fi);
                int skip = size;
                switch (id) {
                    case 826363460: {
                        System.out.format("%04x:%04x : DNA1\n", id, size);
                        break;
                    }
                    case 0x41544144: {
                        System.out.format("%04x:%04x : DATA\n", id, size);
                        break;
                    }
                    case 1111772741: {
                        System.out.format("%04x:%04x : ENDB\n", id, size);
                        return;
                    }
                    case 1112493127: {
                        System.out.format("%04x:%04x : GLOB\n", id, size);
                        break;
                    }
                    case 1145980242: {
                        System.out.format("%04x:%04x : REND\n", id, size);
                        break;
                    }
                    case 0x54534554: {
                        System.out.format("%04x:%04x : TEST\n", id, size);
                        break;
                    }
                    case 20051: {
                        System.out.format("%04x:%04x : SN..\n", id, size);
                        break;
                    }
                    case 21058: {
                        System.out.format("%04x:%04x : BR..\n", id, size);
                        break;
                    }
                    case 19799: {
                        System.out.format("%04x:%04x : WM..\n", id, size);
                        break;
                    }
                    case 17235: {
                        System.out.format("%04x:%04x : SC..\n", id, size);
                        break;
                    }
                    case 16707: {
                        System.out.format("%04x:%04x : CA..\n", id, size);
                        break;
                    }
                    case 16716: {
                        System.out.format("%04x:%04x : LA..\n", id, size);
                        break;
                    }
                    case 20311: {
                        System.out.format("%04x:%04x : WO..\n", id, size);
                        break;
                    }
                    case 16975: {
                        System.out.format("%04x:%04x : OB..\n", id, size);
                        break;
                    }
                    case 16717: {
                        System.out.format("%04x:%04x : MA..\n", id, size);
                        break;
                    }
                    case 17748: {
                        System.out.format("%04x:%04x : UE..\n", id, size);
                        break;
                    }
                    case 17741: {
                        System.out.format("%04x:%04x : KE..\n", id, size);
                        break;
                    }
                    default: {
                        System.out.format("%04x:%04x : Unknown Chunk\n", id, size);
                    }
                }
                if (skip <= 0) continue;
                fi.skip(skip);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int readuint16(InputStream in) {
        byte[] data = new byte[2];
        try {
            if (in.read(data) != 2) {
                return -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        int ret = data[0] & 0xFF;
        return ret += (data[1] & 0xFF) << 8;
    }

    public static int readuint32(InputStream in) {
        byte[] data = new byte[4];
        try {
            if (in.read(data) != 4) {
                return -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        int ret = data[0] & 0xFF;
        ret += (data[1] & 0xFF) << 8;
        ret += (data[2] & 0xFF) << 16;
        return ret += (data[3] & 0xFF) << 24;
    }

    public static long readuint64(InputStream in) {
        byte[] data = new byte[8];
        try {
            if (in.read(data) != 8) {
                return -1L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
        long ret = (long)data[0] & 0xFFL;
        ret += ((long)data[1] & 0xFFL) << 8;
        ret += ((long)data[2] & 0xFFL) << 16;
        ret += ((long)data[3] & 0xFFL) << 24;
        ret += ((long)data[4] & 0xFFL) << 32;
        ret += ((long)data[5] & 0xFFL) << 40;
        ret += ((long)data[6] & 0xFFL) << 48;
        return ret += ((long)data[7] & 0xFFL) << 56;
    }

    public static float readfloat(InputStream in) {
        int bits = listblend.readuint32(in);
        return Float.intBitsToFloat(bits);
    }
}

