/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Random;
import javaforce.HTTP;
import javaforce.JFLog;
import javaforce.STUN;
import javaforce.voip.RTP;
import javaforce.voip.RTSP;
import javaforce.voip.RTSPClientInterface;
import javaforce.voip.RTSPInterface;
import javaforce.voip.RTSPSession;
import javaforce.voip.RTSPURL;
import javaforce.voip.TransportType;

public class RTSPClient
extends RTSP
implements RTSPInterface,
STUN.Listener {
    private String remotehost;
    private String remoteip;
    private InetAddress remoteaddr;
    private int remoteport;
    private String user;
    private String pass;
    private RTSPClientInterface iface;
    private static NAT nat = NAT.None;
    private static boolean useNATOnPrivateNetwork = false;
    private static String stunHost;
    private static String stunUser;
    private static String stunPass;
    private RTSPSession sess;
    public Object userobj;
    public int expires;
    private STUN stun;
    private final Object stunLock = new Object();
    private volatile boolean stunWaiting = false;
    private volatile boolean stunResponse = false;

    public String getUser() {
        return this.user;
    }

    public String getRemoteHost() {
        return this.remotehost;
    }

    public String getRemoteIP() {
        return this.remoteip;
    }

    public boolean init(String remotehost, int remoteport, int localport, RTSPClientInterface iface, TransportType type) {
        this.iface = iface;
        this.localport = localport;
        this.remoteport = remoteport;
        this.remotehost = remotehost;
        this.remoteip = this.resolve(remotehost);
        try {
            this.remoteaddr = InetAddress.getByName(this.remoteip);
            if (!(nat != NAT.STUN && nat != NAT.ICE || this.startSTUN())) {
                return false;
            }
            this.findlocalhost();
            JFLog.log(this.log, "localhost = " + this.localhost + " for remotehost = " + remotehost);
            if (this.remotehost.equals("127.0.0.1")) {
                this.remotehost = this.localhost;
                this.remoteip = this.resolve(this.remotehost);
                JFLog.log(this.log, "changed 127.0.0.1 to " + this.remotehost + " " + this.remoteip);
            }
            if (nat == NAT.STUN || nat == NAT.ICE) {
                this.stopSTUN();
            }
            this.sess = new RTSPSession(this.localhost, localport);
            return super.init(this.localhost, localport, this, false, type);
        }
        catch (Exception e) {
            if (this.stun != null) {
                this.stopSTUN();
            }
            JFLog.log(this.log, (Throwable)e);
            return false;
        }
    }

    @Override
    public void uninit() {
        super.uninit();
    }

    public static void setNAT(NAT nat, String host, String user, String pass) {
        RTSPClient.nat = nat;
        stunHost = host;
        stunUser = user;
        stunPass = pass;
    }

    public static void useNATOnPrivateNetwork(boolean state) {
        useNATOnPrivateNetwork = state;
    }

    private String cleanString(String in) {
        return in.replaceAll("\"", "");
    }

    public void keepalive(String url) {
        this.get_parameter(RTSPURL.cleanURL(url), null);
    }

    public static boolean isPrivateNetwork(String ip) {
        if (ip.startsWith("192.168.")) {
            return true;
        }
        if (ip.startsWith("10.")) {
            return true;
        }
        if (ip.startsWith("169.254.")) {
            return true;
        }
        for (int a = 16; a <= 31; ++a) {
            if (!ip.startsWith("172." + a + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getlocalRTPhost(RTSPSession sess) {
        if (RTP.useTURN) {
            return RTP.getTurnIP();
        }
        return sess.localhost;
    }

    private boolean findlocalhost_webserver(String host) {
        try {
            Socket s = new Socket();
            s.connect(new InetSocketAddress(host, 80), 1000);
            this.localhost = s.getLocalAddress().getHostAddress();
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            JFLog.log(this.log, "Detected IP connecting to WebServer at " + host);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean startSTUN() {
        this.stun = new STUN();
        return this.stun.start(this.localport, stunHost, stunUser, stunPass, this);
    }

    private void stopSTUN() {
        if (this.stun == null) {
            return;
        }
        this.stun.close();
        this.stun = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stunPublicIP(STUN stun, String ip, int port) {
        Object object = this.stunLock;
        synchronized (object) {
            if (this.stunWaiting) {
                this.stunResponse = true;
                this.stunLock.notify();
            }
        }
    }

    @Override
    public void turnAlloc(STUN stun, String ip, int port, byte[] token, int lifetime) {
    }

    @Override
    public void turnBind(STUN stun) {
    }

    @Override
    public void turnRefresh(STUN stun, int lifetime) {
    }

    @Override
    public void turnFailed(STUN stun) {
    }

    @Override
    public void turnData(STUN stun, byte[] data, int offset, int length, short channel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findlocalhost_stun() {
        this.stunResponse = false;
        this.stunWaiting = true;
        Object object = this.stunLock;
        synchronized (object) {
            this.stun.requestPublicIP();
            try {
                this.stunLock.wait(1000L);
            }
            catch (Exception e) {
                JFLog.log(this.log, (Throwable)e);
            }
            this.stunWaiting = false;
        }
        if (this.stunResponse) {
            JFLog.log(this.log, "Detected IP using STUN");
        }
        return this.stunResponse;
    }

    private boolean findlocalhost_java() {
        try {
            InetAddress local = InetAddress.getLocalHost();
            this.localhost = local.getHostAddress();
            JFLog.log(this.log, "Detected IP using Java:" + this.localhost);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void findlocalhost() {
        JFLog.log(this.log, "Detecting localhost for remotehost = " + this.remotehost);
        if (!(!useNATOnPrivateNetwork && RTSPClient.isPrivateNetwork(this.remoteip) || nat != NAT.STUN && nat != NAT.ICE)) {
            if (this.findlocalhost_stun()) {
                return;
            }
            JFLog.log(this.log, "RTSP:STUN:Failed");
        }
        if (this.findlocalhost_webserver(this.remotehost)) {
            return;
        }
        if (this.findlocalhost_java()) {
            return;
        }
        Random r = new Random();
        this.localhost = "169.254." + r.nextInt(256) + "." + r.nextInt(256);
    }

    private boolean issue(RTSPSession sess, String cmd) {
        JFLog.log(this.log, "issue command : " + cmd + " from : " + this.user + " to : " + this.remotehost + ":" + String.valueOf(sess));
        sess.remotehost = this.remoteip;
        sess.remoteport = this.remoteport;
        sess.cmd = cmd;
        StringBuilder req = new StringBuilder();
        StringBuilder post = new StringBuilder();
        req.append(cmd + " " + sess.uri + sess.extra + " RTSP/1.0\r\n");
        req.append("CSeq: " + sess.cseq++ + "\r\n");
        if (sess.authstr != null) {
            sess.epass = this.getAuthResponse(sess, this.user, this.pass, this.remotehost, sess.cmd, sess.authtype);
            req.append(sess.epass);
        }
        req.append("User-Agent: " + useragent + "\r\n");
        if (sess.transport != null) {
            req.append(sess.transport);
        }
        if (sess.accept != null) {
            req.append("Accept: " + sess.accept + "\r\n");
        }
        if (sess.id != null) {
            req.append("Session: " + sess.id + "\r\n");
        }
        if (sess.params != null) {
            for (String param : sess.params) {
                post.append(param);
                post.append("\r\n");
            }
            req.append("Content-Type: text/parameters\r\n");
            req.append("Content-Length: " + post.length() + "\r\n");
        }
        req.append("\r\n");
        if (sess.params != null) {
            req.append((CharSequence)post);
        }
        return this.send(this.remoteaddr, this.remoteport, req.toString());
    }

    public void setUserPass(String user, String pass) {
        this.user = user;
        this.pass = pass;
    }

    public boolean options(String url) {
        if (debug) {
            JFLog.log(this.log, "options:" + url);
        }
        this.sess.uri = RTSPURL.cleanURL(url);
        this.sess.extra = "";
        return this.issue(this.sess, "OPTIONS");
    }

    public boolean describe(String url) {
        if (debug) {
            JFLog.log(this.log, "describe:" + url);
        }
        this.sess.uri = RTSPURL.cleanURL(url);
        this.sess.extra = "";
        this.sess.accept = "application/sdp";
        boolean result = this.issue(this.sess, "DESCRIBE");
        this.sess.accept = null;
        return result;
    }

    public boolean setup(String url, int localrtpport, String control) {
        if (debug) {
            JFLog.log(this.log, "setup:" + url);
        }
        this.sess.transport = "Transport: RTP/AVP;unicast;client_port=" + localrtpport + "-" + (localrtpport + 1) + "\r\n";
        this.sess.uri = this.sess.base;
        if (control != null && control.length() > 0) {
            this.sess.extra = this.sess.uri.endsWith("/") ? control : "/" + control;
        }
        boolean result = this.issue(this.sess, "SETUP");
        this.sess.transport = null;
        return result;
    }

    public boolean play(String url) {
        this.sess.uri = this.sess.base;
        this.sess.extra = "";
        return this.issue(this.sess, "PLAY");
    }

    public boolean teardown(String url) {
        if (this.sess == null) {
            return false;
        }
        this.sess.uri = this.sess.base;
        this.sess.extra = "";
        return this.issue(this.sess, "TEARDOWN");
    }

    public boolean get_parameter(String url, String[] params) {
        this.sess.uri = RTSPURL.cleanURL(url);
        this.sess.extra = "";
        this.sess.params = params;
        boolean result = this.issue(this.sess, "GET_PARAMETER");
        this.sess.params = null;
        return result;
    }

    @Override
    public void onPacket(RTSP rtsp, String[] msg, String remoteip, int remoteport) {
        try {
            int type;
            int idx;
            if (!remoteip.equals(this.remoteip) || remoteport != this.remoteport) {
                JFLog.log(this.log, "Ignoring packet from unknown host:" + remoteip + ":" + remoteport);
                return;
            }
            String req = null;
            if (remoteip.equals("127.0.0.1")) {
                remoteip = this.sess.localhost;
            }
            this.sess.remotehost = remoteip;
            this.sess.remoteport = remoteport;
            this.sess.remotecseq = this.getcseq(msg);
            this.sess.id = HTTP.getParameter(msg, "Session");
            if (this.sess.id != null && (idx = this.sess.id.indexOf(59)) != -1) {
                this.sess.id = this.sess.id.substring(0, idx);
            }
            if ((type = this.getResponseType(msg)) != -1) {
                JFLog.log(this.log, "reply=" + type + ":" + String.valueOf(this.sess));
            } else {
                req = this.getRequest(msg);
                this.sess.uri = this.getURI(msg);
                JFLog.log(this.log, "request=" + req + ":" + String.valueOf(this.sess));
            }
            switch (type) {
                case 200: {
                    if (this.sess.cmd.equals("OPTIONS")) {
                        this.iface.onOptions(this);
                        break;
                    }
                    if (this.sess.cmd.equals("DESCRIBE")) {
                        this.sess.base = HTTP.getParameter(msg, "Content-Base");
                        if (this.sess.base == null) {
                            this.sess.base = this.sess.uri;
                        }
                        this.iface.onDescribe(this, this.getSDP(msg));
                        break;
                    }
                    if (this.sess.cmd.equals("SETUP")) {
                        this.iface.onSetup(this);
                        break;
                    }
                    if (this.sess.cmd.equals("PLAY")) {
                        this.iface.onPlay(this);
                        break;
                    }
                    if (this.sess.cmd.equals("TEARDOWN")) {
                        this.iface.onTeardown(this);
                        break;
                    }
                    if (this.sess.cmd.equals("GET_PARAMETER")) {
                        this.iface.onGetParameter(this, HTTP.getContent(msg));
                    }
                    break;
                }
                case 401: 
                case 407: {
                    if (this.sess.authsent) {
                        JFLog.log(this.log, "Server Error : Double " + type);
                        break;
                    }
                    this.sess.authstr = HTTP.getParameter(msg, "WWW-Authenticate");
                    this.sess.authtype = "Authorization";
                    if (this.sess.authstr == null) {
                        this.sess.authstr = HTTP.getParameter(msg, "Proxy-Authenticate");
                        this.sess.authtype = "Proxy-Authorization";
                    }
                    if (this.sess.authstr == null) {
                        JFLog.log(this.log, "err:401/407 without Authenticate tag");
                        break;
                    }
                    this.issue(this.sess, this.sess.cmd);
                    this.sess.authsent = true;
                    break;
                }
                default: {
                    this.sess.epass = null;
                    break;
                }
            }
        }
        catch (Exception e) {
            JFLog.log(this.log, (Throwable)e);
        }
    }

    @Override
    public void onConnect(RTSP rtsp, String remoteip, int remoteport) {
    }

    @Override
    public void onDisconnect(RTSP rtsp, String remoteip, int remoteport) {
    }

    public String toString() {
        return "RTSPClient:{" + String.valueOf(this.sess) + "}";
    }

    public static enum NAT {
        None,
        STUN,
        TURN,
        ICE;

    }
}

